/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaTabDebugPanel;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabHistory;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfo;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabListTrans;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabListVar;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabSheduler;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabTree;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.TabSequences;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.CDesktopPane;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AltaDebugFrame
extends CInternalFrame {
    private static Logger _LOG = Logger.getLogger(AltaDebugFrame.class.getPackage().getName());
    private boolean _firstDisplay = true;
    private CentralizedStepper _centralized;
    private Map<String, TabInfo> _tabInfos;
    private CeciliaAppl _appl;
    AltaTabDebugPanel _topLeft;
    AltaTabDebugPanel _topRight;
    AltaTabDebugPanel _bottomLeft;
    AltaTabDebugPanel _bottomRight;
    JSplitPane _top;
    JSplitPane _bottom;
    JSplitPane _root;
    int _widthMemo = 450;
    int _heightMemo = 450;

    @Override
    public DBFolder getDBFolder() {
        if (this._centralized == null) {
            return null;
        }
        AltaSystem system = this._centralized.getModel();
        if (system == null) {
            return null;
        }
        return system.getDBFolder();
    }

    public AltaDebugFrame(CeciliaAppl appl, CentralizedStepper stepper) {
        super(ResIcoSimul.getImageIcon("GO_DEBUG"), ResMsgSimul.getString("DLG_DEBUG_TITLE"), ResMsgSimul.getString("DLG_DEBUG_TITLE"));
        this._appl = appl;
        this._centralized = stepper;
        this.setFrameIcon(ResIcoSimul.getImageIcon("GO_DEBUG"));
        this.makeTabInfos();
        this.makePanel();
        this.setDefaultCloseOperation(1);
    }

    private void makeTabInfos() {
        this._tabInfos = new HashMap<String, TabInfo>();
        TabInfo tinf = new TabListTrans();
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabListVar("ListState", "State");
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabListVar("ListFlow", "Flow");
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabTree("TreeNode", ResMsgSimul.getString("PAN_TITLE_TREENODE"), ViewData.class, false);
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabTree("TreeTrans", ResMsgSimul.getString("PAN_TITLE_TREETRANS"), ViewTransition.class, false);
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabTree("TreeSelect", ResMsgSimul.getString("PAN_TITLE_TREESELECT"), ViewData.class, true);
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabHistory();
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabSheduler();
        this._tabInfos.put(tinf.getCode(), tinf);
        tinf = new TabSequences();
        this._tabInfos.put(tinf.getCode(), tinf);
    }

    private AltaTabDebugPanel makeTab() {
        AltaTabDebugPanel result = new AltaTabDebugPanel();
        JPopupMenu menu = new JPopupMenu();
        TabInfo tinf = this._tabInfos.get("ListTrans");
        if (tinf != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        if ((tinf = this._tabInfos.get("ListState")) != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        if ((tinf = this._tabInfos.get("ListFlow")) != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        menu.addSeparator();
        tinf = this._tabInfos.get("TreeNode");
        if (tinf != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        if ((tinf = this._tabInfos.get("TreeTrans")) != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        if ((tinf = this._tabInfos.get("TreeSelect")) != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        menu.addSeparator();
        tinf = this._tabInfos.get("History");
        if (tinf != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        if ((tinf = this._tabInfos.get("Sheduler")) != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        menu.addSeparator();
        tinf = this._tabInfos.get("Sequences");
        if (tinf != null) {
            menu.add(new JMenuItem(tinf.createAction(result, this._centralized)));
        }
        result.setPopupMenu(menu);
        return result;
    }

    private void makePanel() {
        this._topLeft = this.makeTab();
        this._topRight = this.makeTab();
        this._bottomLeft = this.makeTab();
        this._bottomRight = this.makeTab();
        this._top = new JSplitPane(1, this._topLeft, this._topRight);
        this._top.setOneTouchExpandable(true);
        this._top.setResizeWeight(0.0);
        this._top.getLeftComponent().setMinimumSize(new Dimension(0, 0));
        this._bottom = new JSplitPane(1, this._bottomLeft, this._bottomRight);
        this._bottom.setOneTouchExpandable(true);
        this._bottom.setResizeWeight(0.0);
        this._bottom.getLeftComponent().setMinimumSize(new Dimension(0, 0));
        this._root = new JSplitPane(0, this._top, this._bottom);
        this._root.setOneTouchExpandable(true);
        this._root.setResizeWeight(0.5);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._root, "Center");
        this.setSize(this._widthMemo, this._heightMemo);
        AbstractAction close = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaDebugFrame.this.doDefaultCloseAction();
            }
        };
        this._root.getActionMap().put("CLOSE", close);
        this._root.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
    }

    @Override
    public boolean toDoWhenClosing() {
        this.saveConfig();
        return super.toDoWhenClosing();
    }

    Map<String, String> loadConfig() {
        String config = this._appl.getPlugable().getOption(this.getClass().getName() + "#Config");
        if (config == null || config.length() == 0) {
            return null;
        }
        StringReader reader = new StringReader(config);
        Exception exc = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            fabrique.setNamespaceAware(true);
            class ConfigPropertyHandle
            extends DefaultHandler {
                Map<String, String> _configMap = new HashMap<String, String>();

                ConfigPropertyHandle() {
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String ename = localName;
                    if ("".equals(ename)) {
                        ename = qName;
                    }
                    if (!ename.equals("property")) {
                        return;
                    }
                    if (attributes == null) {
                        throw new SAXException("Element 'property' without attributes");
                    }
                    String pkey = null;
                    String pval = null;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String aName = attributes.getLocalName(i);
                        if ("".equals(aName)) {
                            aName = attributes.getQName(i);
                        }
                        if (aName.equals("name")) {
                            pkey = attributes.getValue(i);
                            continue;
                        }
                        if (!aName.equals("value")) continue;
                        pval = attributes.getValue(i);
                    }
                    if (pkey == null) {
                        throw new SAXException("Element 'property' without attribute 'name'");
                    }
                    if (pval == null) {
                        throw new SAXException("Element 'property' without attribute 'value'");
                    }
                    this._configMap.put(pkey, pval);
                }
            }
            ConfigPropertyHandle handler = new ConfigPropertyHandle();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(new InputSource(reader), (DefaultHandler)handler);
            return handler._configMap;
        }
        catch (IOException e) {
            exc = e;
        }
        catch (ParserConfigurationException e) {
            exc = e;
        }
        catch (SAXParseException e) {
            exc = e;
        }
        catch (SAXException e) {
            exc = e;
        }
        _LOG.log(Level.WARNING, "Exception during reading debug view config", exc);
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgSimul.getString("ERR_DEBUG_CONFIG") + "\n" + exc.getMessage());
        return null;
    }

    void saveConfig() {
        HashMap<String, String> saveMap = new HashMap<String, String>();
        Dimension size = this.getSize();
        saveMap.put("this.width", Integer.toString(size.width));
        saveMap.put("this.height", Integer.toString(size.height));
        saveMap.put("root.divider.location", Integer.toString(this._root.getDividerLocation()));
        saveMap.put("root.resize.weight", Double.toString(this._root.getResizeWeight()));
        saveMap.put("top.divider.location", Integer.toString(this._top.getDividerLocation()));
        saveMap.put("top.resize.weight", Double.toString(this._top.getResizeWeight()));
        saveMap.put("bottom.divider.location", Integer.toString(this._bottom.getDividerLocation()));
        saveMap.put("bottom.resize.weight", Double.toString(this._bottom.getResizeWeight()));
        this._topLeft.saveInfo(saveMap, "top.left");
        this._topRight.saveInfo(saveMap, "top.right");
        this._bottomLeft.saveInfo(saveMap, "bottom.left");
        this._bottomRight.saveInfo(saveMap, "bottom.right");
        StringBuffer sb = new StringBuffer(256);
        sb.append("<?xml version='1.0'?>\n<properties>\n");
        for (Map.Entry entry : saveMap.entrySet()) {
            sb.append("  <property name='").append((String)entry.getKey()).append("'");
            sb.append(" value='").append((String)entry.getValue()).append("' />\n");
        }
        sb.append("</properties>\n");
        this._appl.getPlugable().setOption(this.getClass().getName() + "#Config", sb.toString());
    }

    Integer readInteger(Map<String, String> config, String key) {
        String value = config.get(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException exc) {
                _LOG.log(Level.WARNING, "Exception during reading debug view config (key=" + key + ")", exc);
            }
        }
        return null;
    }

    Double readDouble(Map<String, String> config, String key) {
        String value = config.get(key);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException exc) {
                _LOG.log(Level.WARNING, "Exception during reading debug view config (key=" + key + ")", exc);
            }
        }
        return null;
    }

    void readConfig(Map<String, String> config) {
        Double dval;
        Dimension size = this.getSize();
        Integer ival = this.readInteger(config, "this.width");
        if (ival != null && ival >= 100) {
            size.width = ival;
        }
        if ((ival = this.readInteger(config, "this.height")) != null && ival >= 100) {
            size.height = ival;
        }
        this.setSize(size);
        this._widthMemo = size.width;
        this._heightMemo = size.height;
        ival = this.readInteger(config, "root.divider.location");
        if (ival != null && ival >= 0) {
            this._root.setDividerLocation(ival);
        }
        if ((dval = this.readDouble(config, "root.resize.weight")) != null && dval >= 0.0 && dval <= 1.0) {
            this._root.setResizeWeight(dval);
        }
        if ((ival = this.readInteger(config, "top.divider.location")) != null && ival >= 0) {
            this._top.setDividerLocation(ival);
        }
        if ((dval = this.readDouble(config, "top.resize.weight")) != null && dval >= 0.0 && dval <= 1.0) {
            this._top.setResizeWeight(dval);
        }
        if ((ival = this.readInteger(config, "bottom.divider.location")) != null && ival >= 0) {
            this._bottom.setDividerLocation(ival);
        }
        if ((dval = this.readDouble(config, "bottom.resize.weight")) != null && dval >= 0.0 && dval <= 1.0) {
            this._bottom.setResizeWeight(dval);
        }
        this._topLeft.readInfo(config, "top.left", this);
        this._topRight.readInfo(config, "top.right", this);
        this._bottomLeft.readInfo(config, "bottom.left", this);
        this._bottomRight.readInfo(config, "bottom.right", this);
    }

    boolean createComponent(Map<String, String> config, String prefix, String code, AltaTabDebugPanel parent) {
        try {
            Component c;
            TabInfo tinf = this._tabInfos.get(code);
            if (tinf != null && (c = tinf.createComponent(this._centralized, config, prefix)) != null) {
                parent.addTab(tinf, c);
                return true;
            }
            _LOG.warning("Code unknow during create config component : " + code);
            return false;
        }
        catch (Exception exc) {
            _LOG.log(Level.WARNING, "Exception during create config component", exc);
            return false;
        }
    }

    private void createDefaultTab() {
        Component c;
        int nbrTab = 0;
        nbrTab += this._topLeft.getTabCount();
        nbrTab += this._topRight.getTabCount();
        nbrTab += this._bottomLeft.getTabCount();
        if ((nbrTab += this._bottomRight.getTabCount()) > 0) {
            return;
        }
        this._top.setDividerLocation(0);
        this._bottom.setDividerLocation(0);
        TabInfo tinf = this._tabInfos.get("ListTrans");
        if (tinf != null) {
            c = tinf.createComponent(this._centralized, null, null);
            this._topRight.addTab(tinf, c);
            this._topRight.setSelectedComponent(c);
        }
        if ((tinf = this._tabInfos.get("ListState")) != null) {
            c = tinf.createComponent(this._centralized, null, null);
            this._bottomRight.addTab(tinf, c);
            this._bottomRight.setSelectedComponent(c);
        }
        if ((tinf = this._tabInfos.get("ListFlow")) != null) {
            c = tinf.createComponent(this._centralized, null, null);
            this._bottomRight.addTab(tinf, c);
        }
    }

    @Override
    public void showView(CDesktopPane desktop) {
        this._desktop = desktop;
        if (!this.isVisible()) {
            desktop.getDesktop().add((Component)this, JLayeredPane.POPUP_LAYER);
            if (desktop.getDesktop().getComponentZOrder(this) != -1) {
                this.moveToBack();
            }
            if (this._firstDisplay) {
                this._firstDisplay = false;
                Map<String, String> config = this.loadConfig();
                if (config != null && config.size() > 0) {
                    this.readConfig(config);
                }
                this.createDefaultTab();
            }
            this.setVisible(true);
        }
        try {
            if (this.isIcon()) {
                this.doRestoreAction();
            }
            this.setSelected(true);
            this.toFront();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setClosed(boolean close) throws PropertyVetoException {
        super.setClosed(close);
        if (close && this.isVisible()) {
            this.doDefaultCloseAction();
        }
    }
}

