/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.seq;

import com.dassault.cecilia.core.cecilia.stepper.ViewEvent;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class SeqNode
implements Comparable<SeqNode> {
    String _name = null;
    int _idx = -1;
    int _number = 0;
    int _filter = 0;
    int _erreur = 0;
    ArrayList<SeqNode> _nexts = null;
    SeqNode _parent = null;
    int _nbrFireable;

    protected SeqNode(String name) {
        this();
        this._name = name;
    }

    SeqNode() {
    }

    List<SeqNode> nexts() {
        if (this._nexts == null) {
            this._nexts = new ArrayList();
        }
        return this._nexts;
    }

    SeqNode getNext(String name) {
        for (int i = this.nexts().size() - 1; i >= 0; --i) {
            SeqNode next = this._nexts.get(i);
            if (!next._name.equals(name)) continue;
            return next;
        }
        return null;
    }

    void finnish(Counter count) {
        if (this._idx >= 0) {
            this._idx = count._cpt++;
        }
        if (this._nexts == null) {
            return;
        }
        Collections.sort(this._nexts);
        this._nexts.trimToSize();
        int size = this._nexts.size();
        for (int i = 0; i < size; ++i) {
            this._nexts.get(i).finnish(count);
        }
    }

    void finnish() {
        this.finnish(new Counter());
    }

    SeqNode getSeqAt(int idx) {
        if (this._idx >= 0 && --idx < 0) {
            return this;
        }
        assert (idx >= 0 && idx < this._number);
        for (int i = 0; i < this._nexts.size(); ++i) {
            SeqNode cur = this._nexts.get(i);
            if (idx < cur._number) {
                return cur.getSeqAt(idx);
            }
            idx -= cur._number;
        }
        assert (false);
        return null;
    }

    SeqNode getNextAt(int idx) {
        if (this._idx >= 0 && --idx < 0) {
            return this;
        }
        assert (idx >= 0 && idx < this._number);
        SeqNode cur = null;
        for (int i = 0; i < this._nexts.size(); ++i) {
            cur = this._nexts.get(i);
            if (idx < cur._number) {
                return cur;
            }
            idx -= cur._number;
        }
        return cur;
    }

    void propagateErrorToEnd(boolean error) {
        this._erreur = this._idx >= 0 ? (error ? 1 : 0) : 0;
        if (this._nexts != null) {
            for (int i = 0; i < this._nexts.size(); ++i) {
                SeqNode cur = this._nexts.get(i);
                cur.propagateErrorToEnd(error);
                this._erreur += cur._erreur;
            }
        }
    }

    void propagateError(boolean error) {
        int prevErreur = this._erreur;
        this.propagateErrorToEnd(error);
        if (prevErreur != this._erreur) {
            SeqNode current = this._parent;
            while (current != null) {
                current._erreur += this._erreur - prevErreur;
                current = current._parent;
            }
        }
    }

    boolean validWithStepper(ViewStepper stepper, Set<String> unknowEvts) {
        ViewEvent evt;
        if (this._name != null && (evt = stepper.getEvent(this._name)) == null) {
            this.propagateError(true);
            if (unknowEvts.size() < 5000) {
                unknowEvts.add(this._name);
            }
            return false;
        }
        boolean result = true;
        if (this._nexts != null) {
            for (int i = 0; i < this._nexts.size(); ++i) {
                SeqNode cur = this._nexts.get(i);
                result &= cur.validWithStepper(stepper, unknowEvts);
            }
        }
        return result;
    }

    String getName() {
        return this._name;
    }

    void setFireable(ViewStepper stepper) {
        this._nbrFireable = 0;
        ViewEvent evt = stepper.getEvent(this._name);
        if (evt == null) {
            this._nbrFireable = -1;
        } else {
            for (ViewTransition trans : evt.getTrans()) {
                if (!trans.isValid()) continue;
                ++this._nbrFireable;
            }
        }
    }

    public int getNbrFireable() {
        return this._nbrFireable;
    }

    boolean constructToString(StringBuffer sb, SeqNode until) {
        if (this == until) {
            return false;
        }
        if (this._name == null) {
            return false;
        }
        if (this._parent != null && this._parent.constructToString(sb, until)) {
            sb.append(" , ");
        }
        sb.append(this._name);
        return true;
    }

    public String toString(SeqNode until) {
        StringBuffer sb = new StringBuffer(128);
        this.constructToString(sb, until);
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public int compareTo(SeqNode o) {
        return this._name.compareTo(o._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SeqNode)) {
            return false;
        }
        return this._name.equals(((SeqNode)obj)._name);
    }

    public int getIdx() {
        return this._idx;
    }

    public boolean isError() {
        return this._erreur > 0;
    }

    public SeqNode[] getSequence() {
        int nbr = 0;
        SeqNode current = this;
        while (current != null && current._name != null) {
            ++nbr;
            current = current._parent;
        }
        SeqNode[] result = new SeqNode[nbr];
        current = this;
        while (current != null && current._name != null) {
            result[--nbr] = current;
            current = current._parent;
        }
        return result;
    }

    public boolean beginWith(String[] node) {
        SeqNode[] seq = this.getSequence();
        if (node.length > seq.length) {
            return false;
        }
        for (int i = 0; i < node.length; ++i) {
            if (seq[i].getName().equals(node[i])) continue;
            return false;
        }
        return true;
    }

    class Counter {
        int _cpt = 1;

        Counter() {
        }
    }
}

