/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AltaTypeParser {
    private static Logger _LOG = Logger.getLogger(AltaTypeParser.class.getPackage().getName());

    public static AltaType getType(String value) {
        if (value.equals("bool")) {
            AltaTypeBool type = AltaTypeBool.getInstance();
            return type;
        }
        if (value.equals("int")) {
            AltaTypeInt type = AltaTypeInt.getInstance();
            return type;
        }
        if (value.equals("float")) {
            AltaTypeFloat type = AltaTypeFloat.getInstance();
            return type;
        }
        if (value.indexOf("{") == 0) {
            AltaTypeEnum type = new AltaTypeEnum(value);
            return type;
        }
        if (value.indexOf("[") == 0) {
            AltaTypeBound type = new AltaTypeBound(value);
            return type;
        }
        return null;
    }

    public static AltaType getType(String value, CECFactory daoFactory) {
        AltaType result = AltaTypeParser.getType(value);
        if (result != null) {
            return result;
        }
        return AltaTypeParser.getDBType(value, -1L, daoFactory);
    }

    protected static AltaType logReadMsg(String msg, Level lvl, DBFolder dbFolder) {
        _LOG.log(lvl, dbFolder.getPathUntilSystem(new StringBuilder(msg).append(" : ")).toString());
        return null;
    }

    public static AltaType getDBType(String refPath, long id, CECFactory daoFactory) {
        DAOFolder daoFolder = daoFactory.createFolderDAO();
        DBFolder dbFolder = null;
        dbFolder = daoFolder.findFolder(id, refPath, "TYPE_FAMILIES");
        if (dbFolder == null) {
            return null;
        }
        if (dbFolder.getFamily() != DBFolder.Family.TYPE) {
            return AltaTypeParser.logReadMsg("Le DBFolder n'est pas de la famille 'TYPE'", Level.INFO, dbFolder);
        }
        if (!dbFolder.isVersion()) {
            return AltaTypeParser.logReadMsg("Le DBFolder n'est pas une version", Level.INFO, dbFolder);
        }
        if (dbFolder.getObject() == null) {
            return AltaTypeParser.logReadMsg("Le DBFolder n'a pas d'objet", Level.INFO, dbFolder);
        }
        if (dbFolder.getFamilyFlag() == 1) {
            DBWrap dbWrap = daoFactory.findOrCreateWrap(dbFolder);
            if (dbWrap != null) {
                return (DBType)dbWrap;
            }
        } else if (dbFolder.getFamilyFlag() == 2) {
            DBWrap dbWrap = daoFactory.findOrCreateWrap(dbFolder);
            if (dbWrap != null) {
                return (DBType)dbWrap;
            }
        } else {
            return AltaTypeParser.logReadMsg("familyFlag inconnu " + dbFolder.getFamilyFlag(), Level.SEVERE, dbFolder);
        }
        return null;
    }
}

