/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.modellaw;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.io.DBModelLawHandlerXml;
import com.dassault.cecilia.dbobj.modellaw.io.DBModelLawReaderRaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DBModelLaw
extends DBWrap {
    private static Logger _LOG = Logger.getLogger(DBModelLaw.class.getPackage().getName());
    DBFolder _dbApplication;
    DBFolder _dbAuthor;
    DBFolder _dbSubstantiation;
    Law _law;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBModelLaw(DBFolder folder) {
        super(folder);
    }

    @Override
    public DBModelLaw getCopy() {
        DBModelLaw dest = new DBModelLaw(this._dbFolder);
        dest.copy(this);
        dest._dbApplication = this._dbApplication;
        dest._dbAuthor = this._dbAuthor;
        dest._dbSubstantiation = this._dbSubstantiation;
        if (this._law != null) {
            dest._law = this._law.getCopy();
        }
        return dest;
    }

    public DBFolder getApplication() {
        return this._dbApplication;
    }

    public DBFolder getAuthor() {
        return this._dbAuthor;
    }

    public DBFolder getSubstantiation() {
        return this._dbSubstantiation;
    }

    public DBModelLaw setApplication(DBFolder dbFolder) {
        this._dbApplication = dbFolder;
        return this;
    }

    public DBModelLaw setAuthor(DBFolder dbFolder) {
        this._dbAuthor = dbFolder;
        return this;
    }

    public DBModelLaw setSubstantiation(DBFolder dbFolder) {
        this._dbSubstantiation = dbFolder;
        return this;
    }

    public Law getLaw() {
        return this._law;
    }

    public DBModelLaw setLaw(Law value) {
        this._law = value;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBModelLaw)) {
            return false;
        }
        DBModelLaw dbMLaw = (DBModelLaw)obj;
        if (this.getLaw() != null ? !this.getLaw().equals(dbMLaw.getLaw()) : dbMLaw.getLaw() != null) {
            return false;
        }
        if (this.getApplication() != null ? !this.getApplication().equals(dbMLaw.getApplication()) : dbMLaw.getApplication() != null) {
            return false;
        }
        if (this.getAuthor() != null ? !this.getAuthor().equals(dbMLaw.getAuthor()) : dbMLaw.getAuthor() != null) {
            return false;
        }
        return !(this.getSubstantiation() != null ? !this.getSubstantiation().equals(dbMLaw.getSubstantiation()) : dbMLaw.getSubstantiation() != null);
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String law1 = DBModelLaw.this.getLaw().toString();
                String law2 = ((DBModelLaw)wrap).getLaw().toString();
                return new CompareResultString(ResMsgVoc.getString("VOC_LAW"), law1, law2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                DBFolder folder1 = DBModelLaw.this.getApplication();
                DBFolder folder2 = ((DBModelLaw)wrap).getApplication();
                return CompareUtils.getRefPathCompare(ResMsgVoc.getString("VOC_APPLICATION"), folder1, folder2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                DBFolder folder1 = DBModelLaw.this.getAuthor();
                DBFolder folder2 = ((DBModelLaw)wrap).getAuthor();
                return CompareUtils.getRefPathCompare(ResMsgVoc.getString("VOC_AUTHOR"), folder1, folder2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                DBFolder folder1 = DBModelLaw.this.getSubstantiation();
                DBFolder folder2 = ((DBModelLaw)wrap).getSubstantiation();
                return CompareUtils.getRefPathCompare(ResMsgVoc.getString("VOC_SUBSTANTIATION"), folder1, folder2);
            }
        });
        return list;
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.BTP_MODEL;
    }

    @Override
    protected String getNature() {
        return "frb.def";
    }

    public String getAbstract() {
        String description;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRefPath()).append("\n\n");
        sb.append(ResMsgVoc.getString("VOC_LAW")).append(": ").append(this._law.toString()).append("\n");
        if (this._dbAuthor != null) {
            sb.append(ResMsgVoc.getString("VOC_AUTHOR")).append(": ").append(this._dbAuthor.getName()).append("\n");
        }
        if (this._dbApplication != null) {
            sb.append(ResMsgVoc.getString("VOC_APPLICATION")).append(": ").append(this._dbApplication.getName()).append("\n");
        }
        if (this._dbSubstantiation != null) {
            sb.append(ResMsgVoc.getString("VOC_SUBSTANTIATION")).append(": ").append(this._dbSubstantiation.getName()).append("\n");
        }
        if ((description = this._dbFolder.getDescription()) != null && !description.isEmpty()) {
            sb.append("\n");
            sb.append(this._dbFolder.getDescription());
        }
        return sb.toString();
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("RAWTOHEX".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            String istr = DAOObjModel.convertWithFromRAWTOHEX(istream);
            if (istr == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            return this.readRaw(istr, cecFactory, logMng);
        }
        if ("RAW".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            byte[] ibyte = DAOObjModel.convertAsByte(istream);
            if (ibyte == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            return this.readRaw(new String(ibyte), cecFactory, logMng);
        }
        if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
            if (istream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(istream, cecFactory, logMng);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    private boolean readRaw(String data, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        DBModelLawReaderRaw reader = new DBModelLawReaderRaw(this._dbFolder, logMng);
        boolean result = reader.readRaw(data, cecFactory);
        if (result) {
            this._dbApplication = reader.getApplication();
            this._dbAuthor = reader.getAuthor();
            this._dbSubstantiation = reader.getSubstantiation();
            this._law = reader.getLaw();
        }
        return result;
    }

    private boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        DBModelLawHandlerXml saxHanlder = new DBModelLawHandlerXml(logMng, null, cecFactory);
        try {
            this.readXml(input, saxHanlder);
            this._dbApplication = saxHanlder.getApplication();
            this._dbAuthor = saxHanlder.getAuthor();
            this._dbSubstantiation = saxHanlder.getSubstantiation();
            this._law = saxHanlder.getLaw();
            result = true;
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.event").append(">\n");
        if (this._dbApplication != null) {
            out.append(indent).append("  ");
            DBObjectXmlUtility.writeDBFolder(out, this._dbApplication, "application");
        }
        if (this._dbAuthor != null) {
            out.append(indent).append("  ");
            DBObjectXmlUtility.writeDBFolder(out, this._dbAuthor, "author");
        }
        if (this._dbSubstantiation != null) {
            out.append(indent).append("  ");
            DBObjectXmlUtility.writeDBFolder(out, this._dbSubstantiation, "subtantiation");
        }
        if (this._law != null) {
            this._law.toXML("law", out, indent + "  ", true);
        }
        out.append(indent).append("</").append("cec.event").append(">\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        if (this._dbApplication != null) {
            relations.add(new DBRelation(this._dbFolder, "LAW_MODEL", this._dbApplication, "FRB_APPL"));
        }
        if (this._dbAuthor != null) {
            relations.add(new DBRelation(this._dbFolder, "LAW_MODEL", this._dbAuthor, "FRB_AUTHOR"));
        }
        if (this._dbSubstantiation != null) {
            relations.add(new DBRelation(this._dbFolder, "LAW_MODEL", this._dbSubstantiation, "FRB_SUBST"));
        }
        this._law.addRelation(this.getDBFolder(), "LAW_MODEL", relations);
        return relations;
    }
}

