/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.modellaw.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgSelect;
import com.dassault.cecilia.core.swing.other.CTextFieldWithCallback;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DBModelLawPanelSelect
extends JPanel {
    CeciliaAppl _appl;
    boolean _bReduced;
    DBModelLaw _select;
    JTextField _ctrlInput;
    JLabel _labelLaw;
    private static final String _EMPTY_LABEL = "                  ";
    private static DBFolderDlgSelect _dbEventChooser = null;
    private static Object _LockerDlgChooser = new Object();
    boolean _bModified = false;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public DBModelLawPanelSelect(CeciliaAppl appl, boolean reduced) {
        super(new GridBagLayout());
        this._appl = appl;
        this._bReduced = reduced;
        this.make();
    }

    public void setModelLaw(DBModelLaw dbEvent) {
        this._bModified = false;
        this._select = dbEvent;
        if (dbEvent != null) {
            this._ctrlInput.setText(dbEvent.getDBFolder().getRefPath());
            this._labelLaw.setText(dbEvent.getLaw().toString());
        } else {
            this._ctrlInput.setText("");
            this._labelLaw.setText(_EMPTY_LABEL);
        }
    }

    public DBModelLaw getModelLaw() {
        DBFolder dbSelect = this.getSelectFolder();
        return this.getDBEvent(dbSelect);
    }

    private void make() {
        this._ctrlInput = new CTextFieldWithCallback(35){

            @Override
            protected void notifyChange() {
                DBModelLawPanelSelect.this.setModified(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                DBModelLaw dbEvent = DBModelLawPanelSelect.this.getModelLaw();
                if (dbEvent != null) {
                    DBModelLawPanelSelect.this._labelLaw.setText(dbEvent.getLaw().toString());
                } else {
                    DBModelLawPanelSelect.this._labelLaw.setText(DBModelLawPanelSelect._EMPTY_LABEL);
                }
            }
        };
        JButton butEdit = new JButton("...");
        this._labelLaw = new JLabel(_EMPTY_LABEL);
        this._labelLaw.setHorizontalAlignment(0);
        if (this._bReduced) {
            this.add((Component)this._ctrlInput, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this.add((Component)butEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 2, 5), 0, 0));
            this.add((Component)this._labelLaw, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        } else {
            this.add((Component)new JLabel(ResMsgVoc.getString("VOC_PATH")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 2), 0, 0));
            this.add((Component)butEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 2, 5), 0, 0));
            this.add((Component)this._ctrlInput, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this.add((Component)this._labelLaw, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        }
        butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBModelLawPanelSelect.this.doClicAction();
            }
        });
    }

    protected DBFolder getSelectFolder() {
        String path = this._ctrlInput.getText();
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return null;
        }
        DAOFolder daoFolder = this._appl.getDAOFactory().createFolderDAO();
        DBFolder rootPath = daoFolder.getRootID(DBFolder.Family.BTP_MODEL.getRootName());
        return daoFolder.findFolder(rootPath, path, true);
    }

    protected DBModelLaw getDBEvent(DBFolder dbSelect) {
        if (dbSelect == null) {
            return null;
        }
        if (dbSelect.getFamily() != DBFolder.Family.BTP_MODEL) {
            return null;
        }
        DBWrap dbWrap = this._appl.getDAOFactory().findOrCreateWrap(dbSelect);
        if (dbWrap == null) {
            return null;
        }
        return (DBModelLaw)dbWrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DBFolderDlgSelect getDlgChooser(Window win, CeciliaAppl appl) {
        if (_dbEventChooser == null) {
            DBFolderDlgSelect dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_dbEventChooser == null) {
                    dlg = new DBFolderDlgSelect(win, appl, ResMsgObj.getString("DLG_EVTMODEL_CHOOSE_TITLE"), DBFolder.Family.BTP_MODEL);
                }
                if (_dbEventChooser == null) {
                    _dbEventChooser = dlg;
                }
            }
        }
        return _dbEventChooser;
    }

    protected void doClicAction() {
        DBFolderDlgSelect dlg = DBModelLawPanelSelect.getDlgChooser(SwingUtilities.getWindowAncestor(this), this._appl);
        DBFolder dbSelect = this.getSelectFolder();
        dlg.setSelectFolder(dbSelect);
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        dbSelect = dlg.getSelectFolder();
        if (dbSelect == null) {
            this._labelLaw.setText(_EMPTY_LABEL);
        } else {
            this._ctrlInput.setText(dbSelect.getRefPath());
            DBModelLaw dbEvent = this.getDBEvent(dbSelect);
            if (dbEvent == null) {
                this._labelLaw.setText(_EMPTY_LABEL);
            } else {
                this._labelLaw.setText(dbEvent.getLaw().toString());
            }
        }
        this.setModified(true);
        this.fireChangeDepends();
    }

    public JComponent getFocusableComponent() {
        return this._ctrlInput;
    }

    public void setModified(boolean bModified) {
        this._bModified = bModified;
    }

    public boolean isModified() {
        return this._bModified;
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }
}

