/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.modellaw.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.io.LawParserRaw;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBModelLawReaderRaw {
    private static Logger _LOG = Logger.getLogger(DBModelLawReaderRaw.class.getPackage().getName());
    protected DBFolder _dbFolder;
    DBLogs.DBLogsManager _logManager;
    DBFolder _dbApplication;
    DBFolder _dbAuthor;
    DBFolder _dbSubstantiation;
    Law _law;
    private static final String _FORMAT_RAW = "refApp=([0-9]+);refAut=([0-9]+);refSub=([0-9]+)?;law=(.+)";
    private static final Pattern _PATTERN_RAW = Pattern.compile("refApp=([0-9]+);refAut=([0-9]+);refSub=([0-9]+)?;law=(.+)");

    public DBModelLawReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        this._dbFolder = dbFolder;
        this._logManager = logMng;
    }

    public DBFolder getApplication() {
        return this._dbApplication;
    }

    public DBFolder getAuthor() {
        return this._dbAuthor;
    }

    public DBFolder getSubstantiation() {
        return this._dbSubstantiation;
    }

    public Law getLaw() {
        return this._law;
    }

    public boolean readRaw(String data, CECFactory cecFactory) {
        String refSub;
        Matcher matcher = _PATTERN_RAW.matcher(data);
        if (!matcher.matches()) {
            this._logManager.addLog(DBLogs.DBLevel.ERROR, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_FORMAT", data, _FORMAT_RAW));
            return false;
        }
        DAOFolder daoFolder = cecFactory.createFolderDAO();
        long id = Long.parseLong(matcher.group(1));
        this._dbApplication = (DBFolder)daoFolder.find(id);
        if (this._dbApplication == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_ID_UNKNOWN", new Object[]{id, DBFolder.Family.BTP_APPLICATION}));
        } else if (this._dbApplication.getFamily() != DBFolder.Family.BTP_APPLICATION) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_ID_FAMILY", new Object[]{id, DBFolder.Family.BTP_APPLICATION}));
        }
        id = Long.parseLong(matcher.group(2));
        this._dbAuthor = (DBFolder)daoFolder.find(id);
        if (this._dbAuthor == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_ID_UNKNOWN", new Object[]{id, DBFolder.Family.BTP_AUTHOR}));
        }
        if (this._dbAuthor.getFamily() != DBFolder.Family.BTP_AUTHOR) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_ID_FAMILY", new Object[]{id, DBFolder.Family.BTP_AUTHOR}));
        }
        if ((refSub = matcher.group(3)) != null && !refSub.isEmpty()) {
            long id2 = Long.parseLong(refSub);
            this._dbSubstantiation = (DBFolder)daoFolder.find(id2);
            if (this._dbSubstantiation == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_ID_UNKNOWN", new Object[]{id2, DBFolder.Family.BTP_SUBSTANTIATION}));
            }
            if (this._dbSubstantiation.getFamily() != DBFolder.Family.BTP_SUBSTANTIATION) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_ID_FAMILY", new Object[]{id2, DBFolder.Family.BTP_SUBSTANTIATION}));
            }
        }
        String refLaw = matcher.group(4);
        LawParserRaw lawParser = new LawParserRaw(cecFactory.getLawManager(), cecFactory);
        this._law = lawParser.parseLaw(refLaw);
        if (this._law == null) {
            lawParser.traceError(this._logManager, refLaw, _LOG);
            this._law = cecFactory.getLawManager().createLaw(-1);
        }
        return true;
    }
}

