/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.io.AverageAttributeHandlerRaw;
import com.dassault.cecilia.dbobj.project.io.CriticityCriteriumsReaderRaw;
import com.dassault.cecilia.dbobj.project.io.DBProjectHandlerXml;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DBProject
extends DBWrap {
    private static Logger _LOG = Logger.getLogger(DBProject.class.getPackage().getName());
    double _avgFlightDuration = Double.NaN;
    TypeProbability _defaultTypeCompute = TypeProbability.BDD;
    List<AverageAttributeDriver> _avgAttributeDrivers;
    List<CriticityCriterion> _criticityCriterium = new ArrayList<CriticityCriterion>();
    public static final String OBJPROP_FLIGHT_DURATION = "project.flightduration.averagevalue";
    public static final String OBJPROP_TYPE_PROBABILITY = "project.latentprobability.defaultvalue";

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBProject(DBFolder folder) {
        super(folder);
        this._avgAttributeDrivers = new ArrayList<AverageAttributeDriver>();
    }

    @Override
    public DBProject getCopy() {
        DBProject dest = new DBProject(this._dbFolder);
        dest.copy(this);
        return dest;
    }

    @Override
    protected void copy(DBLogsWrap dbWrap) {
        super.copy(dbWrap);
        if (dbWrap instanceof DBProject) {
            DBProject src = (DBProject)dbWrap;
            this.setTypeCompute(src.getTypeCompute());
            this.setFlightDuration(src.getFlightDuration());
            this._avgAttributeDrivers = new ArrayList<AverageAttributeDriver>();
            for (AverageAttributeDriver aad : src.getAttributeDrivers()) {
                this._avgAttributeDrivers.add(aad.getCopy());
            }
            this._criticityCriterium = new ArrayList<CriticityCriterion>();
            for (CriticityCriterion cc : src.getCriticityCriterium()) {
                this._criticityCriterium.add(cc.getCopy());
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBProject)) {
            return false;
        }
        DBProject dbProj = (DBProject)obj;
        if (Double.isNaN(this.getFlightDuration()) ? !Double.isNaN(dbProj.getFlightDuration()) : this.getFlightDuration() != dbProj.getFlightDuration()) {
            return false;
        }
        if (this.getTypeCompute() != dbProj.getTypeCompute()) {
            return false;
        }
        if (this.getAttributeDrivers().size() != dbProj.getAttributeDrivers().size()) {
            return false;
        }
        return this.getCriticityCriterium().size() == dbProj.getCriticityCriterium().size();
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.PROJECT;
    }

    @Override
    protected String getNature() {
        return "project.def";
    }

    public double getFlightDuration() {
        return this._avgFlightDuration;
    }

    public TypeProbability getTypeCompute() {
        return this._defaultTypeCompute;
    }

    public List<AverageAttributeDriver> getAttributeDrivers() {
        return this._avgAttributeDrivers;
    }

    public List<CriticityCriterion> getCriticityCriterium() {
        return this._criticityCriterium;
    }

    public DBProject setFlightDuration(double g) {
        this._avgFlightDuration = g;
        return this;
    }

    public DBProject setTypeCompute(TypeProbability g) {
        this._defaultTypeCompute = g;
        return this;
    }

    public DBProject setAttributeDrivers(Collection<AverageAttributeDriver> g) {
        this._avgAttributeDrivers = new ArrayList<AverageAttributeDriver>(g);
        return this;
    }

    public DBProject setCriticityCriterium(Collection<CriticityCriterion> g) {
        this._criticityCriterium = new ArrayList<CriticityCriterion>(g);
        return this;
    }

    @Override
    protected boolean verifyFolder() {
        return this.verifyLegacyFolder();
    }

    @Override
    protected DBObjModel getDefaultObjModel(DAOFactory cecFactory) {
        if (!(cecFactory instanceof CECFactory)) {
            this.logMsg("Le DAOFactory n'est pas un CECFactory", Level.SEVERE);
            return null;
        }
        return this._dbFolder.getObject().getModel(this.getNature());
    }

    @Override
    public boolean readFromDAO(DAOFactory cecFactory) {
        if (!(cecFactory instanceof CECFactory)) {
            _LOG.severe("Le DAOFactory n'est pas un CECFactory");
            return false;
        }
        DBLogs.DBLogsManager logMng = this.createReadLogsManager(cecFactory.getUserLogin());
        if (!this.readLogs(cecFactory)) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_STRUCTURAL"));
            return false;
        }
        DBObjModel model = this.getDefaultObjModel(cecFactory);
        if (model != null) {
            if (!this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng)) {
                return false;
            }
        } else {
            model = this._dbFolder.getObject().getModel("project.attribute.drive.average.approach");
            if (model != null && !this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng)) {
                return false;
            }
            model = this._dbFolder.getObject().getModel("criticity.def");
            if (model != null && !this.readFromDBObjModel(model, (CECFactory)cecFactory, logMng)) {
                return false;
            }
        }
        this.prepareDependTimeUpdt(cecFactory, null);
        return true;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String nature = model.getNature();
        if ("project.attribute.drive.average.approach".equals(nature)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            AverageAttributeHandlerRaw handler = new AverageAttributeHandlerRaw(cecFactory, logMng);
            try {
                Collection<AverageAttributeDriver> drivers = handler.loadFromXML(istream, AverageAttributeHandlerRaw.IOType.DB);
                this.setAttributeDrivers(drivers);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if ("criticity.def".equals(nature)) {
            String format = model.getFormat();
            if ("RAWTOHEX".equals(format)) {
                InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
                if (istream == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                    return false;
                }
                String istr = DAOObjModel.convertWithFromRAWTOHEX(istream);
                if (istr == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                    return false;
                }
                return this.readCriticityRaw(istr, cecFactory, logMng);
            }
            if ("RAW".equals(format)) {
                InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
                if (istream == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                    return false;
                }
                byte[] ibyte = DAOObjModel.convertAsByte(istream);
                if (ibyte == null) {
                    logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                    return false;
                }
                return this.readCriticityRaw(new String(ibyte), cecFactory, logMng);
            }
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", nature, format));
        } else {
            String format = model.getFormat();
            if ("ZML".equals(format) || "XML".equals(format)) {
                InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
                if (istream == null) {
                    return false;
                }
                if ("ZML".equals(format)) {
                    istream = new InflaterInputStream(istream, new Inflater());
                }
                return this.readXml(istream, cecFactory, logMng);
            }
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        }
        return false;
    }

    private boolean readCriticityRaw(String istr, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        CriticityCriteriumsReaderRaw raw = new CriticityCriteriumsReaderRaw();
        List<CriticityCriterion> cclist = raw.read(istr);
        if (cclist == null) {
            logMng.addLog(DBLogs.DBLevel.WARNING, "Erreur lors de la lecture des criticit\u00e9s du projet:\n" + istr);
        } else {
            this.setCriticityCriterium(cclist);
        }
        return true;
    }

    private boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        DBProjectHandlerXml saxHanlder = new DBProjectHandlerXml(logMng, null, cecFactory);
        try {
            this.readXml(input, saxHanlder);
            this.setAttributeDrivers(saxHanlder.getAAD());
            this.setCriticityCriterium(saxHanlder.getCC());
            result = true;
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.project").append(">\n");
        String indent1 = indent + "  ";
        for (AverageAttributeDriver averageAttributeDriver : this._avgAttributeDrivers) {
            averageAttributeDriver.toXML(out, indent1, true);
        }
        if (!this._criticityCriterium.isEmpty()) {
            String indent2 = indent1 + "  ";
            out.append(indent1).append("<").append("cec.params.criticities.compute").append(">\n");
            for (CriticityCriterion criticityCriterion : this._criticityCriterium) {
                criticityCriterion.toXML(out, indent2);
            }
            out.append(indent1).append("</").append("cec.params.criticities.compute").append(">\n");
        }
        out.append(indent).append("</").append("cec.project").append(">\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        for (AverageAttributeDriver averageAttributeDriver : this._avgAttributeDrivers) {
            averageAttributeDriver.addRelation(this.getDBFolder(), "PROJECT", relations);
        }
        return relations;
    }

    public void update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        for (AverageAttributeDriver averageAttributeDriver : this._avgAttributeDrivers) {
            averageAttributeDriver.update(daoFactory, logMng);
        }
    }
}

