/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SA51Utils
implements SA51Constant {
    static Logger _LOG = Logger.getLogger(SA51Utils.class.getPackage().getName());
    public static final String REGEX_VERSION = "\\(\\d+\\.\\d+\\)";
    public static Map<String, Integer> INDEX_LAWS = new LinkedHashMap<String, Integer>();
    public static Map<String, String> INDEX_DATES;
    private static final long unitSec = 1000L;
    private static final long unitMin = 60000L;
    private static final long unitHour = 3600000L;

    public static Pair createVarWithVer(String s) {
        Pattern p = Pattern.compile("[^/]+/[0-9]+");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            String attr = s.substring(0, s.indexOf(47));
            String version = s.substring(s.indexOf(47) + 1, s.length());
            return new Pair(version, attr);
        }
        p = Pattern.compile("[A-Za-z]+\\[[0-9]+\\]");
        m = p.matcher(s);
        if (m.matches()) {
            String attr = s.substring(0, s.lastIndexOf(91));
            String version = s.substring(s.lastIndexOf(91) + 1, s.lastIndexOf(93));
            return new Pair(version, attr);
        }
        Pair pair = SA51Utils.createVarWithVer(s + "/1");
        if (pair == null) {
            _LOG.fine("Le texte permettant de reconnaitre une variable avec sa version n'a pas ete reconnu : " + s);
            return null;
        }
        return pair;
    }

    public static String checkValue(String str, AttrType type) {
        if (type == AttrType.ALIAS && str.equals("0.0")) {
            str = "";
        } else if (type == AttrType.ALIAS && str.equals("1.0")) {
            str = "true";
        }
        return str;
    }

    public static Date convertDate(String s) {
        String day = s.substring(0, s.indexOf(45));
        String month = INDEX_DATES.get(s.substring(s.indexOf(45) + 1, s.lastIndexOf(45)));
        String year = null;
        year = s.contains(" ") ? s.substring(s.lastIndexOf(45) + 1, s.indexOf(32)) : s.substring(s.lastIndexOf(45) + 1, s.length());
        Date d = null;
        try {
            d = new SimpleDateFormat("dd-MM-yy").parse(day + '-' + month + '-' + year);
        }
        catch (ParseException e) {
            _LOG.warning(e.getMessage());
            return null;
        }
        if (!s.contains(" ")) {
            return d;
        }
        long milSeconds = d.getTime();
        String stringHours = s.substring(s.indexOf(32) + 1, s.length());
        String[] data = stringHours.split(":");
        milSeconds = milSeconds + Long.parseLong(data[0]) * 3600000L + Long.parseLong(data[1]) * 60000L + Long.parseLong(data[2]) * 1000L;
        return new Date(milSeconds);
    }

    public static void linkDBFolder(DBFolder father, DBFolder son) {
        assert (father != null && son != null);
        if (father.equals(son)) {
            return;
        }
        if (father.findChild(son.getName()) != null && son.getParent() == father) {
            return;
        }
        List<DBFolder> children = father.getChildren();
        if (children == null) {
            children = new ArrayList<DBFolder>();
        }
        children.add(son);
        father.setChildren(children);
        son.setParent(father);
    }

    public static DBFolder goToChild(DBFolder root, String ... namechildren) {
        DBFolder current = root;
        for (int i = 0; i < namechildren.length; ++i) {
            if (current == null) {
                return null;
            }
            current = current.findChild(namechildren[i]);
        }
        return current;
    }

    public static String getFullPath(DBFolder folder, String limitFolderID) {
        int cpt = 1;
        DBFolder fold = folder;
        while (!fold.getParent().isSystem()) {
            fold = fold.getParent();
            ++cpt;
        }
        String[] folders = new String[cpt];
        fold = folder;
        cpt = 0;
        while (!fold.isSystem()) {
            folders[cpt++] = fold.getName();
            fold = fold.getParent();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = folders.length - 1; i >= 0; --i) {
            sb.append('/').append(folders[i]);
        }
        return sb.toString();
    }

    public static void createProperty(DBObject obj, String data, String key) {
        DBObjProperty objProperty = new DBObjProperty().setObject(obj).setValue(data);
        objProperty.setID(obj.getID());
        if (key.equals("object.release")) {
            objProperty.setName("object.release").setType("Long");
        } else if (key.equals("object.creator")) {
            objProperty.setName("object.creator").setType("String");
        } else if (key.equals("fmea.model.id")) {
            objProperty.setName("fmea.model.id").setType("Long");
        } else if (key.equals("external.field")) {
            objProperty.setName("external.field").setType("String");
        } else if (key.equals("btp.substantiation.date")) {
            objProperty.setName("btp.substantiation.date").setType("Date");
        } else assert (false) : "Key not recognized";
        obj.addProperty(objProperty);
    }

    public static void addLogsToObj(DBObject obj, DBLogs logs) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version='1.0'?>\n");
            logs.toXML(sb, "");
            byte[] bytesLogs = sb.toString().getBytes(StandardCharsets.UTF_8);
            DBObjModelBytes dbObjLogs = new DBObjModelBytes(bytesLogs);
            dbObjLogs.setNature("logs");
            dbObjLogs.setFormat("XML");
            dbObjLogs.setEncoding("UTF-8");
            obj.addModel(dbObjLogs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        INDEX_LAWS.put("EXPONENTIAL", 0);
        INDEX_LAWS.put("CONSTANT", 1);
        INDEX_LAWS.put("GLM", 2);
        INDEX_LAWS.put("GLM_ASYMP", 3);
        INDEX_LAWS.put("WEIBULL", 4);
        INDEX_LAWS.put("PERIODIC", 5);
        INDEX_LAWS.put("PERIODIC_C", 6);
        INDEX_LAWS.put("NRD", 7);
        INDEX_LAWS.put("CMT", 8);
        INDEX_LAWS.put("DORMANT", 9);
        INDEX_DATES = new LinkedHashMap<String, String>();
        INDEX_DATES.put("Jan", "01");
        INDEX_DATES.put("Feb", "02");
        INDEX_DATES.put("Mar", "03");
        INDEX_DATES.put("Apr", "04");
        INDEX_DATES.put("May", "05");
        INDEX_DATES.put("Jun", "06");
        INDEX_DATES.put("Jul", "07");
        INDEX_DATES.put("Aug", "08");
        INDEX_DATES.put("Sep", "09");
        INDEX_DATES.put("Oct", "10");
        INDEX_DATES.put("Nov", "11");
        INDEX_DATES.put("Dec", "12");
    }

    public static class Pair {
        private String _version;
        private String _name;
        private String _release;

        public Pair(String version, String name) {
            this(version, name, "");
        }

        public Pair(String version, String name, String release) {
            this._version = version;
            this._name = name;
            this._release = release;
        }

        public String getVersion() {
            return this._version;
        }

        public String getName() {
            return this._name;
        }

        public String getRelease() {
            return this._release;
        }

        public void setRelease(String r) {
            this._release = r;
        }

        public String toString() {
            return this._name + '/' + this._version + this._release;
        }
    }
}

