/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ocas51.OCas51Constant;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Linker;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractOcas51Handler
extends SAXExtendedHandler
implements OCas51Constant {
    private final CECFactory _cecFactory;
    private final OCas51Handler _handler;
    public static final String DEFAULT_NAME_FOLDER = "Default";
    public static final short FLAG_USER_CREATE = 2;
    private final SimpleDateFormat _dateFirstFormat = new SimpleDateFormat("MM/dd/yy hh:mm a");
    private final SimpleDateFormat _dateSecondFormat = new SimpleDateFormat("MM/dd/yy hh:mm");
    private static Date _dateLastUpdate;
    private DBLogs _logs;
    private static final String DEFAULT_RELEASE = "0";

    public AbstractOcas51Handler(OCas51Handler handler, CECFactory factory) {
        this._cecFactory = factory;
        this._handler = handler;
    }

    protected final Date getLastUpdateDate() {
        return _dateLastUpdate;
    }

    protected final int getCpt() {
        return this._handler.getCptAndIncrement();
    }

    protected final CECFactory getCECFactory() {
        return this._cecFactory;
    }

    protected final OCas51Linker getLinker() {
        return this._handler.getLinker();
    }

    protected final OCas51Handler getHandler() {
        return this._handler;
    }

    @Deprecated
    public final Locator getLocator() {
        assert (false) : "Il faut utiliser le Locator du Handler";
        return null;
    }

    public DBFolder createNewFolder(String name, int flags, boolean withDate, DBFolder parent) {
        return this.createNewFolder(name, flags, withDate, null, parent);
    }

    public DBLogs getLogs() {
        if (this._logs == null) {
            this._logs = new DBLogs();
        }
        return this._logs;
    }

    public void clearLogs() {
        this._logs = null;
    }

    public DBFolder createNewFolder(String name, int flags, boolean withDate, String desc, DBFolder parent) {
        DBFolder folder = new DBFolder(this.getCpt());
        folder.setName(name);
        folder.setFlags(flags);
        if (withDate) {
            folder.setDateCreate(this.getLastUpdateDate());
            folder.setDateModify(this.getLastUpdateDate());
        }
        folder.setDescription(desc == null ? "" : desc);
        OCas51Utils.linkDBFolder(parent, folder);
        return folder;
    }

    public DBFolder createNewFolder(String name, int flags, Date createDate, Date modifyDate, String desc, DBFolder parent) {
        DBFolder folder = this.createNewFolder(name, flags, false, desc, parent);
        folder.setDateCreate(createDate);
        folder.setDateModify(modifyDate);
        return folder;
    }

    protected final String getStrFromAttributes(Map<String, String> attrs, String attr, boolean isRequired) throws SAXException {
        String val = attrs.get(attr);
        if (val == null) {
            if (isRequired) {
                this.error(new SAXParseException(ResMsgOcas51.msgFormat("MSG_ERROR_REQUIRED_ATTR_MISSING", attr), this.getHandler().getLocator()));
            }
            return null;
        }
        return val;
    }

    protected final int getIntValFromAttributes(Map<String, String> attrs, String attr, boolean isRequired) throws SAXException {
        String val = this.getStrFromAttributes(attrs, attr, isRequired);
        if (val == null) {
            return -1;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException err) {
            return -1;
        }
    }

    protected final double getDoubleValFromAttributes(Map<String, String> attrs, String attr, boolean isRequired) throws SAXException {
        String val = this.getStrFromAttributes(attrs, attr, isRequired);
        if (val == null) {
            return -1.0;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException err) {
            return -1.0;
        }
    }

    protected final Date getDateFromAttributes(Map<String, String> attrs, String attr, boolean isRequired) throws SAXException {
        String dateStr = this.getStrFromAttributes(attrs, attr, isRequired);
        if (dateStr == null) {
            return null;
        }
        try {
            return this._dateFirstFormat.parse(dateStr);
        }
        catch (ParseException error) {
            try {
                return this._dateSecondFormat.parse(dateStr);
            }
            catch (ParseException err) {
                return null;
            }
        }
    }

    protected final Boolean getBooleanFromAttributes(Map<String, String> attrs, String attr, boolean isRequired) throws SAXException {
        String boolStr = this.getStrFromAttributes(attrs, attr, isRequired);
        return Boolean.valueOf(boolStr);
    }

    protected DBIcon getIcon(String iconName) {
        DBFolder rootIcon = this.getCECFactory().createFolderDAO().getRootID("IMAGE_FAMILIES");
        if (!iconName.contains("/")) {
            return null;
        }
        String[] paths = iconName.split("/");
        DBFolder iconFamilyfolder = rootIcon.findChild(DBFactory.convertName(paths[0], DBFolder.Family.IMAG));
        assert (iconFamilyfolder != null);
        DBFolder iconFolder = iconFamilyfolder.findChild(DBFactory.convertName(paths[1], DBFolder.Family.IMAG));
        assert (iconFolder != null);
        iconFolder = iconFolder.findChild("1");
        DBObject obj = iconFolder.getObject();
        DBIcon icon = (DBIcon)this.getCECFactory().createObjectDAO().getWrap(obj);
        assert (icon != null) : "Il y a aucune raison que notre icon soit null, on les charge avant de rentrer dans le XML";
        return icon;
    }

    protected final DBFolder createFolderFromPath(DBFolder.Family family, DBFolder rootFolder, String path) {
        DBFolder tmpFolder = rootFolder;
        assert (path.contains("/"));
        String[] splited = path.split("/");
        for (int i = 0; i < splited.length; ++i) {
            String nameFolder = splited[i];
            tmpFolder = tmpFolder.findChild(nameFolder) == null ? this.createNewFolder(nameFolder, i == splited.length - 1 ? DBFolder.createFlagsVersion(family, (short)0, (short)0) : (i == splited.length - 2 ? DBFolder.createFlagsModel(family, (short)0, (short)0) : DBFolder.createFlagsFolder(family, (short)0, (short)0)), true, tmpFolder) : tmpFolder.findChild(nameFolder);
        }
        return tmpFolder;
    }

    protected final Law getlawFromStrValue(CECFactory cecFactory, String lawStr) {
        assert (cecFactory != null);
        LawParser lawParser = this.getHandler().getLawParser();
        Law law = lawParser.parseLaw(lawStr);
        return law;
    }

    protected final Param getParamFromStrValue(CECFactory cecFactory, String paramStr) {
        if (paramStr == null || paramStr.isEmpty()) {
            return null;
        }
        try {
            return new ParamValue(null, Double.parseDouble(paramStr));
        }
        catch (NumberFormatException numberFormatException) {
            if (paramStr.contains("[") && paramStr.contains("]")) {
                DBParam dbParam;
                String param = paramStr.substring(0, paramStr.indexOf(91));
                String vers = paramStr.substring(paramStr.indexOf(91) + 1, paramStr.indexOf(93));
                DBFolder folder = cecFactory.createFolderDAO().getRootID("LAW_PARAMETERS");
                if ((folder = folder.findChild(DEFAULT_NAME_FOLDER)) != null && (folder = folder.findChild(param)) != null) {
                    folder = folder.findChild(vers);
                }
                if (folder == null) {
                    StringBuilder sb;
                    DBFolder dbRoot = cecFactory.createFolderDAO().getRootID("LAW_PARAMETERS");
                    folder = this.createFolderFromPath(DBFolder.Family.PARAMETER, dbRoot, (sb = new StringBuilder().append(DEFAULT_NAME_FOLDER).append('/').append(param).append('/').append(vers)).toString());
                    dbParam = this.getDefaultParameter(folder);
                    if (dbParam == null) {
                        return null;
                    }
                } else {
                    DBObject obj = folder.getObject();
                    dbParam = (DBParam)cecFactory.createObjectDAO().getWrap(obj);
                }
                ParamRef paramRef = new ParamRef(dbParam.getType(), folder);
                return paramRef;
            }
            return null;
        }
    }

    protected final DBAttrib getAttributeFromPath(CECFactory cecFactory, String path) {
        String version = "1";
        String name = path;
        int pos = path.indexOf("/");
        if (pos != -1) {
            name = path.substring(0, pos);
            if (pos != path.length()) {
                version = path.substring(pos + 1);
            }
        }
        DBFolder folder = this.getCECFactory().createFolderDAO().getRootID("ATTRIBUTES");
        if ((folder = folder.findChild(DEFAULT_NAME_FOLDER)) != null && (folder = folder.findChild(name)) != null) {
            folder = folder.findChild(version);
        }
        if (folder != null) {
            DBObject obj = folder.getObject();
            return (DBAttrib)cecFactory.createObjectDAO().getWrap(obj);
        }
        DBFolder dbRoot = cecFactory.createFolderDAO().getRootID("ATTRIBUTES");
        StringBuilder sb = new StringBuilder().append(DEFAULT_NAME_FOLDER).append('/').append(name).append('/').append(version);
        folder = this.createFolderFromPath(DBFolder.Family.ATTRIBUTE, dbRoot, sb.toString());
        folder.setUserFlag((short)2);
        return this.getDefaultAttribute(folder);
    }

    public final DBModelLaw getDefaultModelLaw(DBFolder folder) {
        DBObject dbObject = new DBObject(folder.getID()).setFolder(folder);
        folder.setObject(dbObject);
        this.addDefaultProperty(dbObject, DEFAULT_RELEASE, this.getHandler().getLogin(), "");
        DBModelLaw dbModelLaw = new DBModelLaw(folder);
        Law law = this.getCECFactory().getLawManager().createLaw(1);
        law.setParamAt(0, new ParamValue(law.getParamAt(0).getType(), 1.0));
        dbModelLaw.setLaw(law);
        this.addDefaultLogsWithErrorInstanciation(dbModelLaw);
        DBObjModel dbObjModel = dbModelLaw.writeDBObjModel(false);
        dbObject.addModel(new DBObjModelBytes(dbObjModel));
        DBObjModel dbObjLogs = dbModelLaw.writeDBObjLogs(false);
        dbObject.addModel(new DBObjModelBytes(dbObjLogs));
        this.getCECFactory().createObjectDAO().putWrap(dbObject, dbModelLaw);
        return dbModelLaw;
    }

    private final DBParam getDefaultParameter(DBFolder folder) {
        DBObject dbObject = new DBObject(folder.getID()).setFolder(folder);
        folder.setObject(dbObject);
        this.addDefaultProperty(dbObject, DEFAULT_RELEASE, this.getHandler().getLogin(), "");
        DBParam parameter = new DBParam(folder);
        ParamValue param = new ParamValue(TypeParam.RATE, 1.0);
        parameter.setType(param.getType());
        parameter.setValue(param);
        this.addDefaultLogsWithErrorInstanciation(parameter);
        DBObjModel dbObjModel = parameter.writeDBObjModel(false);
        dbObject.addModel(new DBObjModelBytes(dbObjModel));
        DBObjModel dbObjLogs = parameter.writeDBObjLogs(false);
        dbObject.addModel(new DBObjModelBytes(dbObjLogs));
        this.getCECFactory().createObjectDAO().putWrap(dbObject, parameter);
        return parameter;
    }

    private final DBAttrib getDefaultAttribute(DBFolder folder) {
        DBObject dbObject = new DBObject(folder.getID()).setFolder(folder);
        folder.setObject(dbObject);
        this.addDefaultProperty(dbObject, DEFAULT_RELEASE, this.getHandler().getLogin(), "");
        DBAttrib dbAttrib = new DBAttrib(folder);
        dbAttrib.setType(AttrType.STRING);
        this.addDefaultLogsWithErrorInstanciation(dbAttrib);
        DBObjModel dbObjModel = dbAttrib.writeDBObjModel(false);
        dbObject.addModel(new DBObjModelBytes(dbObjModel));
        DBObjModel dbObjLogs = dbAttrib.writeDBObjLogs(false);
        dbObject.addModel(new DBObjModelBytes(dbObjLogs));
        this.getCECFactory().createObjectDAO().putWrap(dbObject, dbAttrib);
        return dbAttrib;
    }

    protected void addDefaultProperty(DBObject dbObject, String release, String owner, String idExternLaeticia) {
        DBObjProperty dbProperty;
        if (release != null && !release.isEmpty()) {
            dbProperty = new DBObjProperty().setName("object.release").setType("Long").setValue(release);
            dbObject.addProperty(dbProperty);
        }
        if (owner != null && !owner.isEmpty()) {
            dbProperty = new DBObjProperty().setName("object.creator").setType("String").setValue(owner);
            dbObject.addProperty(dbProperty);
        }
        if (idExternLaeticia != null && !idExternLaeticia.isEmpty()) {
            dbProperty = new DBObjProperty().setName("laetitia.id").setType("String").setValue(idExternLaeticia);
            dbObject.addProperty(dbProperty);
        }
    }

    protected void addDefaultLogs(DBLogsWrap dbWrap) {
        dbWrap.getLogs().addLog(this.getHandler().getCurrentDate(), this.getHandler().getLogin(), DBLogs.DBLevel.FINE, ResMsgOcas51.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getHandler().getFilePathForLog()));
    }

    protected void addLogs(DBLogsWrap dbWrap) {
        for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
            dbWrap.getLogs().addLog(log);
        }
        this.addDefaultLogs(dbWrap);
    }

    protected void addDefaultLogsWithErrorInstanciation(DBLogsWrap dbWrap) {
        this.addDefaultLogs(dbWrap);
        Date date = Boolean.getBoolean("cecilia.junit.ocas51") ? new Date(1472594500000L) : this.getHandler().getCurrentDate();
        dbWrap.getLogs().addLog(date, this.getHandler().getLogin(), DBLogs.DBLevel.INIT, ResMsgObj.getString("MSG_ERR_OBJ_NOT_INITIALIZED")).setPrivate(true);
    }

    protected final String getValidName(String originalName, DBFolder.Family familyName, String tagName, String attrName) throws SAXException {
        String result = originalName;
        if (!DBFactory.verifyName(result, familyName)) {
            if (Boolean.getBoolean("cecilia.import.Xml6AutoCorrectName")) {
                if (!DBFactory.verifyName(result = DBFactory.convertName(result, familyName), familyName)) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", tagName, attrName, result), this.getHandler().getLocator()));
                }
            } else {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", tagName, attrName, result), this.getHandler().getLocator()));
            }
        }
        return result;
    }

    protected final String getValidDesc(String originalDesc, boolean withLogs) {
        String result = originalDesc;
        if (result != null && !DBFactory.verifyDescription(result = result.trim())) {
            this.displayLogs(ResMsgOcas51.msgFormat("MSG_WARNING_COMMENT_TOO_LONG", result));
            result = result.substring(0, 1023);
            if (withLogs) {
                this.addWarningToLogs(ResMsgOcas51.getString("MSG_LOG_COMMENT_TOO_LONG"));
            }
        }
        return result;
    }

    protected final String checkValidVers(String version, String tagName, String attrName) throws SAXException {
        if (version == null) {
            return null;
        }
        if (!DBFactory.verifyVersion(version)) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", tagName, attrName, version), this.getLocator()));
        }
        return version;
    }

    protected void addObjectFromFolder(DBFolder folder, DBWrap wrap, String releaseStr, String ownerStr, String idExternLaeticia, boolean isFrozen) {
        DBObject obj = new DBObject(folder.getID()).setFolder(folder);
        folder.setObject(obj);
        wrap.setFolder(folder);
        this.addDefaultProperty(obj, releaseStr, ownerStr, idExternLaeticia);
        this.addLogs(wrap);
        DBObjModel dbObjModel = wrap.writeDBObjModel(false);
        obj.addModel(new DBObjModelBytes(dbObjModel));
        DBObjModel dbObjLogsModel = wrap.writeDBObjLogs(false);
        obj.addModel(new DBObjModelBytes(dbObjLogsModel));
        obj.setBinFlag(isFrozen ? 2 : 0);
        this.getCECFactory().createObjectDAO().putWrap(obj, wrap.getCopy());
        this.clearLogs();
    }

    public final AltaType getTypeFromStr(String value, CECFactory factory, boolean isInVersion4) {
        if (value.indexOf(123) == 0 && value.indexOf(125) == value.length() - 1) {
            return new AltaTypeEnum(value);
        }
        if (value.indexOf(91) == 0 && value.indexOf(93) == value.length() - 1) {
            return new AltaTypeBound(value);
        }
        if (value.equals("bool")) {
            return AltaTypeBool.getInstance();
        }
        if (value.equals("int")) {
            return AltaTypeInt.getInstance();
        }
        if (value.equals("float")) {
            return AltaTypeFloat.getInstance();
        }
        if (value.contains("/")) {
            String[] pathsToFolder = new String[4];
            try {
                String[] paths;
                String object = null;
                if (!isInVersion4) {
                    paths = value.split("/");
                    object = paths[2];
                    pathsToFolder[0] = paths[0];
                    pathsToFolder[1] = paths[1];
                } else {
                    paths = value.split("/");
                    object = paths[1];
                    pathsToFolder[0] = paths[0];
                    pathsToFolder[1] = paths[0];
                }
                if (object.contains(";")) {
                    pathsToFolder[2] = object.substring(0, object.indexOf(59));
                    pathsToFolder[3] = object.substring(object.indexOf(59) + 1, object.length());
                } else {
                    pathsToFolder[2] = object;
                    pathsToFolder[3] = "null";
                }
            }
            catch (ArrayIndexOutOfBoundsException error) {
                this.displayLogs("Error IndexOutOfBounds, Unknown path type:" + value);
                return null;
            }
            DBFolder tmpFolder = factory.createFolderDAO().getRootID("TYPE_FAMILIES");
            for (String path : pathsToFolder) {
                DBFolder folder = tmpFolder.findChild(path);
                if (folder == null && tmpFolder.isModel() && (folder = DBFactory.findLastVersion(tmpFolder)) != null) {
                    this.addWarningToLogs(ResMsgOcas51.msgFormat("MSG_WARNING_LAST_VERSION_TYPE", value, folder.getName()));
                }
                if (folder == null) {
                    return null;
                }
                tmpFolder = folder;
            }
            DBObject obj = tmpFolder.getObject();
            return (AltaType)((Object)factory.createObjectDAO().getWrap(obj));
        }
        return null;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    protected void addWarningToLogs(String warnMess) {
        this.getLogs().addLog(this.getHandler().getCurrentDate(), this.getHandler().getLogin(), DBLogs.DBLevel.WARNING, warnMess);
    }

    protected void displayLogs(String warnMess) {
        OCas51Utils._LOG.log(Level.WARNING, ResMsgOcas51.msgFormat("MSG_WARNING_DISPLAY_LINE", warnMess, this.getHandler().getLocator().getLineNumber()));
    }

    protected final boolean isInInstanciationMode() {
        return this.getHandler().getCurrentMode() == OCas51Handler.Mode.INSTANCIATION;
    }

    static {
        try {
            _dateLastUpdate = new SimpleDateFormat("DD/MM/YYYY", Locale.FRANCE).parse("31/08/2016");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

