/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaText;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51EquipmentHandler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Utils;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class OCas51ContentHandler
extends AbstractOcas51Handler {
    private final OCas51EquipmentHandler _equipmentHandler;
    private AlgaContent _currentContent;
    private AlgaGraph _currentGraph;
    private List<AlgaGroup> _listCurrentGroups;
    private List<Integer> _listIdxSheetGroups;
    private List<AlgaWithPorts> _listAlgaPorts;
    private AlgaTransform _currentTransform;
    private boolean _noImag = false;
    private List<String> _absentNode = new ArrayList<String>();
    private int _x = -1;
    private int _y = -1;
    private AltaSubWithPort _fromSub;
    private AltaSubWithPort _toSub;
    private int _currentSheetIdx;
    private static final int IDX_TYPENAME_FORM_IMG = 0;
    private static final int IDX_TYPENAME_FORM_LINE = 1;
    private static final int IDX_TYPENAME_FORM_POLY = 2;
    private static final int IDX_TYPENAME_FORM_TEXT = 3;
    private static final int IDX_TYPENAME_FORM_CIRCL = 4;
    private static final int IDX_TYPENAME_FORM_RECT = 5;
    private static final int IDX_TYPENAME_FORM_ARECT = 6;
    private static final int IDX_TYPENAME_FORM_NORMARROW = 9;
    private static final int IDX_TYPENAME_FORM_DOUBLEARROW = 13;
    private static final int IDX_TYPENAME_FORM_ARROWRIGHTTOP = 15;
    private static final int IDX_TYPENAME_FORM_DOUBLEARROWRIGHTTOP = 19;
    private static final int IDX_TYPENAME_FORM_TRIPLEARROW = 23;
    private static final int ID_TYPE_TRANSFORM_MVERT = 1;
    private static final int ID_TYPE_TRANSFORM_MHORI = 2;
    private static final int ID_TYPE_TRANSFORM_ROTAT = 3;
    private static final Map<Integer, AlgaForm.Type> MAPIDTOFORM = new LinkedHashMap<Integer, AlgaForm.Type>();
    private static final int ID_HALIGN_LEFT = 0;
    private static final int ID_HALIGN_CENTER = 1;
    private static final int ID_HALIGN_RIGHT = 2;
    private static final int ID_VALIGN_TOP = 3;
    private static final int ID_VALIGN_MIDDLE = 4;
    private static final int ID_VALIGN_BOTTOM = 5;
    private static final Map<Integer, AlgaText.HAlignement> MAPIDTOHALIGN;
    private static final Map<Integer, AlgaText.VAlignement> MAPIDTOVALIGN;

    public OCas51ContentHandler(OCas51Handler handler, CECFactory factory, OCas51EquipmentHandler equipmentHandler) {
        super(handler, factory);
        this._equipmentHandler = equipmentHandler;
        this._currentContent = this.getEquipment().getContent();
        this._listAlgaPorts = new ArrayList<AlgaWithPorts>();
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        switch (name) {
            case "CONTENT": {
                String assertion = this.getStrFromAttributes(attrs, "ASSERTION", false);
                if (assertion == null || assertion.isEmpty()) break;
                this.getEquipment().setCode(assertion);
                break;
            }
            case "PORT": {
                String namePort = this.getStrFromAttributes(attrs, "NAME", true);
                this._x = this.getIntValFromAttributes(attrs, "X", true) + 3;
                this._y = this.getIntValFromAttributes(attrs, "Y", true) + 3;
                boolean isLocked = this.getBooleanFromAttributes(attrs, "LOCKED", true);
                int currentSheetIdx = this.getIntValFromAttributes(attrs, "SHEET", true);
                NamePosition namePosition = this.getNamePositionFromID(this.getIntValFromAttributes(attrs, "TEXT_LOC", true));
                this._currentGraph = new AlgaPort();
                this._currentGraph.setLocked(isLocked);
                ((AlgaPort)this._currentGraph).setNamePosition(namePosition);
                if (namePort.contains("#")) {
                    for (AltaFlow flow : this.getEquipment().getFlows()) {
                        if (!flow.getName().equals(namePort.substring(1, namePort.length()))) continue;
                        ((AlgaPort)this._currentGraph).setFlow(flow);
                    }
                } else assert (false) : "Op\u00e9ration normalement impossible \u00e0 effectuer.";
                this.insertCurrentGraph(this._currentGraph, currentSheetIdx);
                this._listAlgaPorts.add((AlgaPort)this._currentGraph);
                this.getEquipment().addPort((AlgaPort)this._currentGraph);
                break;
            }
            case "COMPONENT": 
            case "EQUIPMENT": {
                String nameComp = this.getStrFromAttributes(attrs, "NAME", true);
                String nameRoot = name.equals("COMPONENT") ? "COMPONENT_FAMILIES" : "EQUIPMENT_FAMILIES";
                String nameFamily = this.getStrFromAttributes(attrs, "FAMILY", true);
                String nameSubFamily = this.getStrFromAttributes(attrs, "SUB_FAMILY", !this.isVersion4());
                String nameModel = this.getStrFromAttributes(attrs, "MODEL", true);
                String nameVers = this.getStrFromAttributes(attrs, "VERSION", false);
                this._x = this.getIntValFromAttributes(attrs, "X", true) + 3;
                this._y = this.getIntValFromAttributes(attrs, "Y", true) + 3;
                NamePosition namePosition = this.getNamePositionFromID(this.getIntValFromAttributes(attrs, "TEXT_LOC", true));
                int currentSheetIdx = this.getIntValFromAttributes(attrs, "SHEET", true);
                if (nameSubFamily == null) {
                    nameSubFamily = nameFamily;
                }
                AltaComponent component = (AltaComponent)OCas51Utils.getWrapFromStrFolder(this.getCECFactory(), nameRoot, this.getHandler().getLocator(), nameFamily, nameSubFamily, nameModel, nameVers);
                this._currentGraph = new AlgaNode();
                if (component == null) {
                    String path = OCas51Utils.createPath(nameFamily, nameSubFamily, nameModel, nameVers);
                    this._absentNode.add(nameComp);
                    String messWarn = ResMsgOcas51.msgFormat("MSG_WARNING_UNKNOWN_NODE", path);
                    this.getEquipmentHandler().addWarningToLogs(messWarn);
                    this.displayLogs(messWarn);
                    this._currentGraph = null;
                    return;
                }
                AltaSub sub = new AltaSub(component, nameComp);
                ((AlgaNode)this._currentGraph).setLogical(sub);
                ((AlgaNode)this._currentGraph).setNamePosition(namePosition);
                this._currentGraph.computeControlPoints();
                this.insertCurrentGraph(this._currentGraph, currentSheetIdx);
                this.getEquipment().addSub(sub);
                this._listAlgaPorts.add((AlgaNode)this._currentGraph);
                break;
            }
            case "LINK": {
                String fromPort = this.getStrFromAttributes(attrs, "FROM", true);
                String toPort = this.getStrFromAttributes(attrs, "TO", true);
                boolean withArrow = this.getBooleanFromAttributes(attrs, "ARROW", true);
                boolean withPipe = this.getBooleanFromAttributes(attrs, "PIPE", true);
                boolean isLocked = this.getBooleanFromAttributes(attrs, "LOCKED", true);
                this._currentSheetIdx = this.getIntValFromAttributes(attrs, "SHEET", true);
                this._fromSub = this.getAltaSubWithPortFromStrValue(fromPort);
                this._toSub = this.getAltaSubWithPortFromStrValue(toPort);
                if (this._fromSub == null || this._toSub == null) {
                    StringBuilder sb = new StringBuilder().append('\'').append(fromPort).append("=>").append(toPort).append('\'');
                    String messError = ResMsgOcas51.msgFormat("MSG_WARNING_NULL_LINK", sb.toString());
                    this.displayLogs(messError);
                    this.getEquipmentHandler().addWarningToLogs(messError);
                    return;
                }
                AltaSub fromSubNode = this._fromSub.getSub();
                AltaSub toSubNode = this._toSub.getSub();
                if (fromSubNode != null && this._absentNode.contains(fromSubNode.getName()) || toSubNode != null && this._absentNode.contains(toSubNode.getName())) {
                    return;
                }
                AltaLink link = new AltaLink(this._fromSub.getSub(), this._fromSub.getPort(), this._toSub.getSub(), this._toSub.getPort());
                if (this._fromSub.getField() != null) {
                    link.setFromField(this._fromSub.getField());
                }
                if (this._toSub.getField() != null) {
                    link.setToField(this._toSub.getField());
                }
                AlgaLink gLink = new AlgaLink();
                gLink.setDrawArrow(withArrow);
                gLink.setPipeStyle(withPipe);
                gLink.setLocked(isLocked);
                gLink.setLogical(link);
                this._currentGraph = gLink;
                break;
            }
            case "GRAPHIC_FORM": {
                int typeNameForm = this.getIntValFromAttributes(attrs, "TYPENAME", true);
                this._x = this.getIntValFromAttributes(attrs, "X", true) + 3;
                this._y = this.getIntValFromAttributes(attrs, "Y", true) + 3;
                int w = this.getIntValFromAttributes(attrs, "W", true) - 5;
                int h = this.getIntValFromAttributes(attrs, "H", true) - 5;
                int rForg = this.getIntValFromAttributes(attrs, "FRED", true);
                int bForg = this.getIntValFromAttributes(attrs, "FBLUE", true);
                int gForg = this.getIntValFromAttributes(attrs, "FGREEN", true);
                Color foregroundColor = new Color(rForg, gForg, bForg);
                int rBack = this.getIntValFromAttributes(attrs, "BRED", true);
                int bBack = this.getIntValFromAttributes(attrs, "BBLUE", true);
                int gBack = this.getIntValFromAttributes(attrs, "BGREEN", true);
                Color backgroundColor = new Color(rBack, gBack, bBack);
                boolean isOpaque = this.getBooleanFromAttributes(attrs, "OPAQUE", true);
                boolean isLocked = this.getBooleanFromAttributes(attrs, "LOCKED", true);
                int currentSheetIdx = this.getIntValFromAttributes(attrs, "SHEET", true);
                if (this._currentGraph == null || this._noImag) {
                    if (this._noImag) {
                        typeNameForm = 5;
                    }
                    this._currentGraph = new AlgaForm(MAPIDTOFORM.get(typeNameForm));
                }
                if (this._currentGraph == null) break;
                this._currentGraph.setBackground(backgroundColor);
                this._currentGraph.setForeground(foregroundColor);
                this._currentGraph.setOpaque(isOpaque);
                this._currentGraph.setLocked(isLocked);
                if (this._currentGraph instanceof AlgaDraw) {
                    ((AlgaDraw)this._currentGraph).setH(h);
                    ((AlgaDraw)this._currentGraph).setW(w);
                }
                if (this._currentGraph instanceof AlgaImage) {
                    ((AlgaImage)this._currentGraph).setCX(this._x);
                    ((AlgaImage)this._currentGraph).setCX(this._y);
                }
                this.insertCurrentGraph(this._currentGraph, currentSheetIdx);
                break;
            }
            case "GRAPHIC_IMAGE": {
                String pathImage = this.getStrFromAttributes(attrs, "PARAM", true);
                String warnMess = ResMsgOcas51.msgFormat("MSG_WARNING_NO_ICON_FOUND", pathImage);
                if (pathImage == null || pathImage.isEmpty()) {
                    this.displayLogs(warnMess);
                    this.getEquipmentHandler().getLogs().addLog(this.getHandler().getCurrentDate(), this.getHandler().getLogin(), DBLogs.DBLevel.WARNING, warnMess);
                    this._noImag = false;
                    break;
                }
                AlgaImage image = new AlgaImage();
                DBIcon icon = this.getIcon(pathImage);
                if (icon == null) {
                    this.displayLogs(warnMess);
                    this.getEquipmentHandler().getLogs().addLog(this.getHandler().getCurrentDate(), this.getHandler().getLogin(), DBLogs.DBLevel.WARNING, warnMess);
                    this._noImag = false;
                    break;
                }
                if (!icon.readFromDAO(this.getCECFactory())) {
                    this.displayLogs(warnMess);
                    this.getEquipmentHandler().getLogs().addLog(this.getHandler().getCurrentDate(), this.getHandler().getLogin(), DBLogs.DBLevel.WARNING, warnMess);
                } else {
                    image.setDBIcon(icon);
                }
                image.computeControlPoints();
                this._currentGraph = image;
                break;
            }
            case "GRAPHIC_LINE": {
                if (this._currentGraph != null) {
                    return;
                }
                boolean startArrowLine = this.getBooleanFromAttributes(attrs, "START_ARROW", true);
                boolean endArrowLine = this.getBooleanFromAttributes(attrs, "END_ARROW", true);
                AlgaLine line = new AlgaLine();
                line.setArrowBegin(startArrowLine);
                line.setArrowEnd(endArrowLine);
                line.computeControlPoints();
                this._currentGraph = line;
                break;
            }
            case "GRAPHIC_POLYGONE": {
                AlgaPolygone polygone = new AlgaPolygone();
                this._currentGraph = polygone;
                break;
            }
            case "GRAPHIC_TEXT": {
                String texte = this.getStrFromAttributes(attrs, "TEXT", true);
                int sizeText = this.getIntValFromAttributes(attrs, "SIZE", true);
                int sizeHorAlignText = this.getIntValFromAttributes(attrs, "HORALIGNMENT", true);
                int vAlignText = this.getIntValFromAttributes(attrs, "VERALIGNMENT", true);
                boolean boldText = this.getBooleanFromAttributes(attrs, "BOLD", true);
                boolean italicText = this.getBooleanFromAttributes(attrs, "ITALIC", true);
                AlgaText algaText = new AlgaText();
                algaText.setText(texte);
                algaText.setFont(sizeText, boldText, italicText);
                algaText.setHorizontalAlignement(MAPIDTOHALIGN.get(sizeHorAlignText));
                algaText.setVerticalAlignement(MAPIDTOVALIGN.get(vAlignText));
                this._currentGraph = algaText;
                break;
            }
            case "GRAPHIC_GROUP": {
                if (this._listCurrentGroups == null) {
                    this._listCurrentGroups = new ArrayList<AlgaGroup>();
                    this._listIdxSheetGroups = new ArrayList<Integer>();
                }
                boolean isLocked = this.getBooleanFromAttributes(attrs, "LOCKED", true);
                int sheetID = this.getIntValFromAttributes(attrs, "SHEET", true);
                AlgaGroup group = new AlgaGroup();
                group.setLocked(isLocked);
                this._listCurrentGroups.add(group);
                this._listIdxSheetGroups.add(sheetID);
                break;
            }
            case "BREAK": {
                if (this._currentGraph == null) {
                    return;
                }
                int x = this.getIntValFromAttributes(attrs, "X", true);
                int y = this.getIntValFromAttributes(attrs, "Y", true);
                boolean withpoint = this.getBooleanFromAttributes(attrs, "POINT", true);
                Pt point = new Pt(x, y);
                point.setStyle(withpoint ? Pt.Style.RECT : Pt.Style.NONE);
                ((AlgaPoints)this._currentGraph).addPoint(point);
                break;
            }
            case "TRANSFORM": {
                int valueTransform = this.getIntValFromAttributes(attrs, "VALUE", true);
                if (this._currentTransform == null) {
                    this._currentTransform = new AlgaTransform();
                }
                this._currentTransform.add(this.getTypeTransformFromID(valueTransform));
                break;
            }
        }
    }

    private void insertCurrentGraph(AlgaGraph currentGraph, int currentSheetIdx) {
        if (this._listCurrentGroups != null && !this._listCurrentGroups.isEmpty()) {
            AlgaGroup group = this._listCurrentGroups.get(this._listCurrentGroups.size() - 1);
            currentGraph.setParent(group);
            group.add(currentGraph, Integer.MAX_VALUE);
        } else {
            AlgaSheet sheet = this._currentContent.getSheets().get(currentSheetIdx - 1);
            currentGraph.setParent(sheet);
            sheet.add(currentGraph, -1);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        switch (name) {
            case "CONTENT": {
                return true;
            }
            case "GRAPHIC_TEXT": 
            case "GRAPHIC_IMAGE": 
            case "GRAPHIC_POLYGONE": {
                this._currentGraph = null;
                break;
            }
            case "GRAPHIC_LINE": 
            case "LINK": {
                if (!(this._currentGraph instanceof AlgaPoints)) break;
                if (this._currentGraph instanceof AlgaLink) {
                    AlgaLink gLink = (AlgaLink)this._currentGraph;
                    AltaLink link = gLink.getLogical();
                    if (link.getFromFlow() != this._fromSub.getPort()) {
                        Collections.reverse(gLink.getPoints());
                    }
                    if (!link.verify()) {
                        if (this._fromSub.getField() == null ^ this._toSub.getField() == null) {
                            link.setFromField(null);
                            link.setToField(null);
                        }
                        if (!link.verify()) {
                            String messError = ResMsgOcas51.msgFormat("MSG_WARNING_LINK", link.getID(), link.getFromFlow(), link.getToFlow());
                            this.getEquipmentHandler().addWarningToLogs(messError);
                            this.displayLogs(messError);
                        }
                    }
                    assert (this._currentSheetIdx != -1);
                    this.insertCurrentGraph(gLink, this._currentSheetIdx);
                    this._currentSheetIdx = -1;
                    this.getEquipment().addLink(link);
                }
                ((AlgaPoints)this._currentGraph).computeControlPoints();
                this._currentGraph = null;
                break;
            }
            case "GRAPHIC_GROUP": {
                assert (this._listCurrentGroups != null && !this._listCurrentGroups.isEmpty());
                AlgaGroup group = this._listCurrentGroups.remove(this._listCurrentGroups.size() - 1);
                int idxSheet = this._listIdxSheetGroups.remove(this._listIdxSheetGroups.size() - 1);
                this.insertCurrentGraph(group, idxSheet);
                break;
            }
            case "GRAPHIC_FORM": 
            case "PORT": 
            case "COMPONENT": 
            case "EQUIPMENT": {
                if (this._currentGraph == null) break;
                if (this._currentTransform != null) {
                    ((AlgaDraw)this._currentGraph).setTransform(this._currentTransform);
                    this._currentTransform = null;
                }
                if (this._x != -1 && this._y != -1 && this._currentGraph instanceof AlgaDraw) {
                    this._currentGraph.setX(this._x);
                    this._currentGraph.setY(this._y);
                }
                if (!(this._currentGraph instanceof AlgaDraw)) break;
                this._currentGraph = null;
            }
        }
        return false;
    }

    public final AlgaContent getContent() {
        return this._currentContent;
    }

    private final AlgaTransform.Type getTypeTransformFromID(int id) {
        switch (id) {
            case 1: {
                return AlgaTransform.Type.MIRRORV;
            }
            case 2: {
                return AlgaTransform.Type.MIRRORH;
            }
            case 3: {
                return AlgaTransform.Type.ROTATE;
            }
        }
        return null;
    }

    private final NamePosition getNamePositionFromID(int id) {
        switch (id) {
            case 0: {
                return NamePosition.TOP;
            }
            case 1: {
                return NamePosition.BOTTOM;
            }
            case 2: {
                return NamePosition.LEFT;
            }
            case 3: {
                return NamePosition.RIGHT;
            }
        }
        return NamePosition.CENTER;
    }

    private final AltaSubWithPort getAltaSubWithPortFromStrValue(String val) {
        if (!val.contains(".")) {
            return null;
        }
        String[] valSplit = val.split("\\.");
        String subStr = valSplit[0];
        String portStr = valSplit[1];
        for (AlgaWithPorts withPorts : this._listAlgaPorts) {
            AlgaPort port;
            if (withPorts instanceof AlgaNode) {
                AltaSub sub = ((AlgaNode)withPorts).getLogical();
                if (!sub.getName().equals(subStr)) continue;
                AltaComponent comp = sub.getNode();
                AltaFlow flow = comp.getFlow(portStr);
                if (flow != null && flow.getType() instanceof DBRecord && valSplit.length == 3) {
                    String recordField = valSplit[2];
                    DBRecord record = (DBRecord)flow.getType();
                    for (int i = 0; i < record.getValueCount(); ++i) {
                        DBRecordField field = record.getFieldAt(i);
                        if (!field.getName().equals(recordField)) continue;
                        return new AltaSubWithPort(sub, flow, field);
                    }
                    String ress = ResMsgOcas51.msgFormat("MSG_WARNING_NO_FIELD_FOUND", val, recordField);
                    this.getEquipmentHandler().addWarningToLogs(ress);
                    this.displayLogs(ress);
                    return new AltaSubWithPort(sub, flow, null);
                }
                if (flow == null) {
                    flow = new AltaFlow(portStr, AltaTypeBool.getInstance());
                }
                return new AltaSubWithPort(sub, flow, null);
            }
            if (!(withPorts instanceof AlgaPort) || !(port = (AlgaPort)withPorts).getFlow().getName().equals(subStr.substring(1, subStr.length()))) continue;
            AltaFlow flow = port.getFlow();
            if (flow.getType() instanceof DBRecord && valSplit.length == 3) {
                String recordField = valSplit[2];
                DBRecord record = (DBRecord)flow.getType();
                for (int i = 0; i < record.getValueCount(); ++i) {
                    DBRecordField field = record.getFieldAt(i);
                    if (!field.getName().equals(recordField)) continue;
                    return new AltaSubWithPort(null, flow, field);
                }
                continue;
            }
            return new AltaSubWithPort(null, flow, null);
        }
        return null;
    }

    public final AltaEquipment getEquipment() {
        return this._equipmentHandler.getCurrentEquipment();
    }

    public final OCas51EquipmentHandler getEquipmentHandler() {
        return this._equipmentHandler;
    }

    public final boolean isVersion4() {
        return this._equipmentHandler.isVersion4();
    }

    @Override
    @Deprecated
    protected void addWarningToLogs(String warnMess) {
        assert (false) : "Privil\u00e9giez getEquipmentHandler.addWarningToLogs(String). Inutile de mettre des logs \u00e0 un Contenu (qui n'a pas de repr\u00e9sentation DBFolder)";
    }

    static {
        MAPIDTOFORM.put(0, AlgaForm.Type.IMAGE);
        MAPIDTOFORM.put(1, AlgaForm.Type.LINE);
        MAPIDTOFORM.put(2, AlgaForm.Type.POLYGONE);
        MAPIDTOFORM.put(3, AlgaForm.Type.TEXT);
        MAPIDTOFORM.put(4, AlgaForm.Type.OVALE);
        MAPIDTOFORM.put(5, AlgaForm.Type.RECTANGLE);
        MAPIDTOFORM.put(6, AlgaForm.Type.ROUND_RECTANGLE);
        MAPIDTOFORM.put(9, AlgaForm.Type.ARROW_SIMPLE);
        MAPIDTOFORM.put(13, AlgaForm.Type.ARROW_DOUBLE);
        MAPIDTOFORM.put(15, AlgaForm.Type.ARROW_R_SIMPLE);
        MAPIDTOFORM.put(19, AlgaForm.Type.ARROW_R_DOUBLE);
        MAPIDTOFORM.put(23, AlgaForm.Type.ARROW_TRIPLE);
        MAPIDTOHALIGN = new LinkedHashMap<Integer, AlgaText.HAlignement>();
        MAPIDTOHALIGN.put(0, AlgaText.HAlignement.LEFT);
        MAPIDTOHALIGN.put(1, AlgaText.HAlignement.CENTER);
        MAPIDTOHALIGN.put(2, AlgaText.HAlignement.RIGHT);
        MAPIDTOVALIGN = new LinkedHashMap<Integer, AlgaText.VAlignement>();
        MAPIDTOVALIGN.put(3, AlgaText.VAlignement.TOP);
        MAPIDTOVALIGN.put(4, AlgaText.VAlignement.MIDDLE);
        MAPIDTOVALIGN.put(5, AlgaText.VAlignement.BOTTOM);
    }

    private static class AltaSubWithPort {
        private final AltaSub _sub;
        private final AltaFlow _port;
        private final DBRecordField _field;

        public AltaSubWithPort(AltaSub sub, AltaFlow port, DBRecordField field) {
            this._sub = sub;
            this._port = port;
            this._field = field;
        }

        public AltaSub getSub() {
            return this._sub;
        }

        public AltaFlow getPort() {
            return this._port;
        }

        public DBRecordField getField() {
            return this._field;
        }
    }
}

