/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralDlgDisplayError;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.LeftDotTableCellRenderer;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.dbobj.general.conflict.DBConflictChoice;
import com.dassault.cecilia.dbobj.general.conflict.DBConflictsChoiceDlg;
import com.dassault.cecilia.io.AbstractCmdImport;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public abstract class CmdImportTreeAbstract
extends AbstractCmdImport {
    private static Logger _LOG = Logger.getLogger(CmdImportTreeAbstract.class.getPackage().getName());
    protected DBFolderTreeEditable _ctrlTree;
    protected DBFolder _dstFolder;
    protected ArrayList<GeneralError<File>> _errors = new ArrayList();
    ArrayList<FileInfos> _filesAll;

    public CmdImportTreeAbstract(CeciliaAppl appl, DBFolderTreeEditable owner, DBFolder dbFolder) {
        super(appl, appl.getTopWindow());
        this._dstFolder = dbFolder;
        this._ctrlTree = owner;
    }

    public boolean withWarnning() {
        return !this._errors.isEmpty();
    }

    protected void addError(File folder, String msg) {
        this._errors.add(new GeneralError<File>(folder, msg));
    }

    protected void addError(File folder, MsgType type, String msg) {
        this._errors.add(new GeneralError<File>(folder, msg, type));
    }

    public List<GeneralError<File>> getErrors() {
        return this._errors;
    }

    protected void displayErrors(final List<GeneralError<File>> errors) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CmdImportTreeAbstract.this.doDisplayErrors(errors);
            }
        });
    }

    protected void doDisplayErrors(List<GeneralError<File>> errors) {
        GeneralDlgDisplayError<File> dlg = new GeneralDlgDisplayError<File>((Window)this.getAppl().getTopWindow()){

            @Override
            protected Class<?> getSourceClass() {
                return File.class;
            }

            @Override
            protected String getSourceName() {
                return ResMsgVoc.getString("VOC_FILE");
            }

            @Override
            protected TableCellRenderer getSourceRenderer() {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (value instanceof File) {
                            File file = (File)value;
                            this.setText(file.getName());
                            this.setToolTipText(file.getAbsolutePath());
                        }
                        return this;
                    }
                };
            }
        };
        dlg.setTitle(this.getTitle());
        dlg.setErrors(errors);
        dlg.setModal(false);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getSource()));
        dlg.setVisible(true);
    }

    @Override
    protected boolean withFiles() {
        return true;
    }

    protected String getImportName(File importFile) {
        String name = importFile.getName();
        int defLen = name.length();
        if (defLen > 4) {
            name = name.substring(0, defLen - 4);
        }
        return DBFactory.convertName(name);
    }

    @Override
    protected boolean prepareDo() {
        if (!this.verifyLimitNbrTree(1)) {
            return false;
        }
        if (this._dstFolder == null) {
            return false;
        }
        if (this._dstFolder.getChildren() == null) {
            this.getAppl().getDAOFactory().createFolderDAO().findChildren(this._dstFolder);
        }
        if (!super.prepareDo()) {
            return false;
        }
        if (this._importFiles == null) {
            return false;
        }
        if (this._importFiles.length > 1 && !this.verifyLimitNbrTree(this._importFiles.length)) {
            return false;
        }
        return this.prepareConflict();
    }

    protected void finishDo(List<DBFolder> dbVersions) {
        if (dbVersions.size() > 0) {
            this._dstFolder.setMustBeUpdated(true);
            this.getAppl().refreshDAOFolder(true);
            SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlTree, dbVersions));
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
        }
    }

    protected boolean prepareConflict() {
        DBConflict dagConflict = DBConflict.NOTIMPORT;
        PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(GeneralIOPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralIOPreferencies) {
            GeneralIOPreferencies gpref = (GeneralIOPreferencies)opts;
            dagConflict = gpref.getImportDagConflict();
        }
        this._filesAll = new ArrayList(this._importFiles.length);
        ArrayList<FileInfos> filesWithConflict = new ArrayList<FileInfos>(this._importFiles.length);
        HashSet<String> previousNames = new HashSet<String>();
        for (File file : this._importFiles) {
            FileInfos fInfos = new FileInfos(file);
            this._filesAll.add(fInfos);
            if (previousNames.contains(fInfos.getName().toLowerCase())) {
                this.addError(file, ResMsgCore.msgFormat("MSG_ERR_DAOTOOL_FOL_CHILDREN", this._dstFolder.getRefPath(), fInfos.getName()));
            } else {
                if (this._dstFolder.findChild(fInfos.getName()) != null) {
                    filesWithConflict.add(fInfos);
                }
                fInfos.setConflict(dagConflict);
            }
            previousNames.add(fInfos.getName().toLowerCase());
        }
        if (this.withWarnning()) {
            this.displayErrors(this.getErrors());
            return false;
        }
        if (!filesWithConflict.isEmpty()) {
            DBConflictsChoiceDlg<File> dlg = new DBConflictsChoiceDlg<File>((Component)this._ctrlTree, filesWithConflict){

                @Override
                protected String getNameOfItem() {
                    return ResMsgVoc.getString("VOC_FILE");
                }

                @Override
                protected TableCellRenderer getRendererOfItem() {
                    return new LeftDotTableCellRenderer();
                }
            };
            dlg.setVisible(true);
            if (!dlg.getResult()) {
                return false;
            }
        }
        return true;
    }

    protected boolean verifyLimitNbrTree(int nbr) {
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            DemoLimits appendLimits = new DemoLimits(DemoLimits.Limit.COUNT_PROJECT_TREE, nbr);
            try {
                ((DemoLimitedFactory)this.getAppl().getDAOFactory()).verifyAppendLimits(appendLimits);
            }
            catch (DemoLimitedException e) {
                _LOG.info("DemoLimited " + e.toString());
                String title = ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_IMPORT");
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.getString("DEMO_ERROR_IMPORT"), title, 0);
                return false;
            }
        }
        return true;
    }

    protected class FileInfos
    extends DBConflictChoice<File> {
        private String _name;

        protected FileInfos(File file) {
            super(file);
            this._name = CmdImportTreeAbstract.this.getImportName(file);
        }

        public String getName() {
            return this._name;
        }
    }
}

