/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.DAGImportChoice;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UtilityImportTreeAbstract {
    private static Logger _LOG = Logger.getLogger(UtilityImportTreeAbstract.class.getPackage().getName());
    DAOFactory _daoFactory;
    DBUser _dbUser;

    public UtilityImportTreeAbstract(DAOFactory daoFactory, DBUser dbUser) {
        this._daoFactory = daoFactory;
        this._dbUser = dbUser;
    }

    protected DAOFactory getDAOFactory() {
        return this._daoFactory;
    }

    protected DBUser getDBUser() {
        return this._dbUser;
    }

    protected void addError(File folder, String msg) {
        this.addError(folder, MsgType.ERROR, msg);
    }

    protected abstract void addError(File var1, MsgType var2, String var3);

    protected DBFolder createFolders(File file, DBFolder dbModel, DBFolder dbVersion) {
        DBFolder dbRealVersion = this.createFoldersInDatabase(file, dbModel, dbVersion);
        if (dbRealVersion == null) {
            this.addError(file, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
        }
        return dbRealVersion;
    }

    private DBFolder createFoldersInDatabase(File file, DBFolder dbModel, DBFolder dbVersion) {
        DBFolder dbResult = null;
        try {
            this._daoFactory.beginTransaction(true);
            DAOFolder daoFolder = this._daoFactory.createFolderDAO();
            try {
                dbModel = daoFolder.create(dbModel);
                if (dbModel != null) {
                    dbModel.setMustBeUpdated(true);
                    dbVersion.setParent(dbModel);
                    dbResult = daoFolder.create(dbVersion);
                    if (dbResult != null) {
                        dbResult.setMustBeUpdated(true);
                    }
                }
            }
            catch (Throwable th) {
                _LOG.log(Level.INFO, "ImportDag | Exception non gere lors de la creation des dossiers", th);
                this._daoFactory.abortTransaction();
                return null;
            }
            if (dbResult != null) {
                this._daoFactory.endTransaction();
            } else {
                this._daoFactory.abortTransaction();
            }
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "ImportDag | Processus de transition", e);
            this.addError(file, ResMsgObj.getString("MSG_ERR_DB_WARNING"));
        }
        return dbResult;
    }

    protected DBFolder verifyVersionTargetWhenConflict(File importFile, DBFolder dbModel, DBConflict dbConflict, DAGImportChoice choiceType) {
        CECFactory cecFactory = (CECFactory)this.getDAOFactory();
        if (dbConflict == DBConflict.NOTIMPORT) {
            this.addError(importFile, ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD", dbModel.getName()));
            return null;
        }
        block0 : switch (choiceType) {
            case FAULT_TREE: {
                if (dbModel.getFamilyFlag() == 2) break;
                this.addError(importFile, ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD_WITH_ANOTHER_FLAG", dbModel.getName()));
                return null;
            }
            case BOOL_FORMULA: {
                if (dbModel.getFamilyFlag() == 5) break;
                this.addError(importFile, ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD_WITH_ANOTHER_FLAG", dbModel.getName()));
                return null;
            }
            case FT_OR_BF: {
                switch (dbModel.getFamilyFlag()) {
                    case 2: 
                    case 5: {
                        break block0;
                    }
                }
                this.addError(importFile, ResMsgObj.msgFormat("MSG_FOL_ALREADY_CHILD_WITH_ANOTHER_FLAG", dbModel.getName()));
                return null;
            }
        }
        DAOFolder daoFolder = cecFactory.createFolderDAO();
        if (dbConflict == DBConflict.UPDATE) {
            DBFolder dbVersion;
            if (dbModel.getChildren() == null) {
                daoFolder.findChildren(dbModel);
            }
            if ((dbVersion = DBFactory.findLastVersion(dbModel)) == null) {
                this.addError(importFile, "Internal error during find last version of : " + dbModel.getRefPath());
                return null;
            }
            if (cecFactory.createObjectDAO().isFreeze(dbVersion.getObject())) {
                this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_ACCESS_FREEZE", dbModel.getRefPath()));
                return null;
            }
            if (dbVersion.getObject().isLocked()) {
                this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_ACCESS_LOCK", dbModel.getRefPath()));
                return null;
            }
            if (daoFolder.getAccessRight(dbVersion, this.getDBUser()) != DBAccess.Right.WRITE) {
                this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_ACCESS_WRITE", dbModel.getRefPath()));
                return null;
            }
            return dbVersion;
        }
        if (dbConflict == DBConflict.NEWVERSION) {
            DBFolder dbVersion;
            if (daoFolder.getAccessRight(dbModel, this.getDBUser()) != DBAccess.Right.WRITE) {
                this.addError(importFile, ResMsgCore.msgFormat("MSG_ERR_ACCESS_WRITE", dbModel.getRefPath()));
                return null;
            }
            if (dbModel.getChildren() == null) {
                daoFolder.findChildren(dbModel);
            }
            if ((dbVersion = DBFactory.findLastVersion(dbModel)) == null) {
                this.addError(importFile, "Internal error during find last version of : " + dbModel.getRefPath());
                return null;
            }
            return dbVersion;
        }
        this.addError(importFile, "Internal error : " + dbModel.getRefPath());
        return null;
    }

    protected DBFolder createWithConflict(DBConflict dbConflict, DBFolder dbModelOrigin, DBFolder dbVersionOrigin, boolean bBigTree) {
        if (dbConflict == DBConflict.UPDATE) {
            DBFolder dbVersion = new DBFolder(dbVersionOrigin);
            dbVersion.setDateCreate(new Date());
            dbVersion.setDateModify(new Date());
            dbVersion.setUserModify(this.getDBUser());
            return dbVersion;
        }
        if (dbConflict == DBConflict.NEWVERSION) {
            DBFolder dbVersion = new DBFolder(dbModelOrigin, this.getDBUser());
            dbVersion.setName(DBFactory.incrementNameVersion(dbVersionOrigin));
            dbVersion.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, bBigTree ? (short)5 : 2, (short)0));
            DBObject dbObject = new DBObject().setFolder(dbVersion);
            dbVersion.setObject(dbObject);
            return dbVersion;
        }
        return null;
    }

    protected DBFolder createWithoutConflict(DBFolder dstFolder, String strName, boolean bBigTree) {
        DBFolder dbModel = new DBFolder(dstFolder, this.getDBUser());
        dbModel.setName(strName);
        dbModel.setFlags(DBFolder.createFlagsModel(DBFolder.Family.PROJECT, bBigTree ? (short)5 : 2, (short)0));
        DBFolder dbVersion = new DBFolder(dbModel, this.getDBUser());
        dbVersion.setName("1.0");
        dbVersion.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, bBigTree ? (short)5 : 2, (short)0));
        DBObject dbObject = new DBObject().setFolder(dbVersion);
        dbVersion.setObject(dbObject);
        return dbVersion;
    }

    protected DBFolder finalizeImportFile(File importFile, DBFolder dbVersion, DBConflict dbConflict, FTEquation ftEquation) {
        DBFolder dbModel = dbVersion.getParent();
        DBObject dbObject = dbVersion.getObject();
        DBFolder dbResult = null;
        if (dbConflict != null) {
            if (dbConflict == DBConflict.UPDATE) {
                DBObjProperty releaseProperty;
                DBObjModel dbObjModel = ftEquation.writeDBObjLogs(true);
                if (dbObjModel.getID() < 0L) {
                    dbObject.addModel(dbObjModel);
                }
                if ((dbObjModel = ftEquation.writeDBObjModel(true)).getID() < 0L) {
                    dbObject.addModel(dbObjModel);
                }
                if ((releaseProperty = dbObject.getProperty("object.release")) == null) {
                    dbObject.addProperty(new DBObjProperty().setName("object.release").setType("Long").setValue("1"));
                } else {
                    long oldRelease = DBObjProperty.getObjectRelease(releaseProperty);
                    if (oldRelease >= 0L) {
                        releaseProperty.setType("Long").setValue(Long.toString(oldRelease + 1L));
                    }
                }
                DBObjProperty creatorProperty = dbObject.getProperty("object.creator");
                if (creatorProperty == null) {
                    dbObject.addProperty(new DBObjProperty().setName("object.creator").setType("String").setValue(this.getDBUser().getLogin()));
                } else {
                    creatorProperty.setType("String").setValue(this.getDBUser().getLogin());
                }
                dbVersion.setRelations(ftEquation.getUseRelations());
                if (this._daoFactory.createFolderDAO().update(dbVersion)) {
                    dbResult = dbVersion;
                    dbResult.setMustBeUpdated(true);
                } else {
                    this.addError(importFile, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                }
            } else if (dbConflict == DBConflict.NEWVERSION) {
                dbVersion.setParent(dbModel);
                dbObject.addModel(ftEquation.writeDBObjModel(false));
                dbObject.addModel(ftEquation.writeDBObjLogs(false));
                dbObject.addProperty(new DBObjProperty().setName("object.creator").setType("String").setValue(this.getDBUser().getLogin()));
                dbObject.addProperty(new DBObjProperty().setName("object.release").setType("Long").setValue("1"));
                dbVersion.setRelations(ftEquation.getUseRelations());
                dbResult = this._daoFactory.createFolderDAO().create(dbVersion);
                if (dbResult != null) {
                    dbResult.setMustBeUpdated(true);
                } else {
                    this.addError(importFile, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                }
            }
        } else {
            dbObject.addModel(ftEquation.writeDBObjModel(false));
            dbObject.addModel(ftEquation.writeDBObjLogs(false));
            dbObject.addProperty(new DBObjProperty().setName("object.creator").setType("String").setValue(this.getDBUser().getLogin()));
            dbObject.addProperty(new DBObjProperty().setName("object.release").setType("Long").setValue("1"));
            dbVersion.setRelations(ftEquation.getUseRelations());
            dbResult = this.createFolders(importFile, dbModel, dbVersion);
        }
        if (dbResult == null) {
            return null;
        }
        if (!Boolean.getBoolean("cecilia.ft.import.NoUpdateEGL")) {
            Collection<DBGlobEvent> events = ftEquation.createGlobalEvents(dbResult);
            if (!this.getDAOFactory().createGlobEventDAO().insertAll(dbResult, events)) {
                this.addError(importFile, MsgType.WARNING, ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"));
            }
        }
        return dbResult;
    }
}

