/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta.gui;

import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DlgCaftaChooseConflict
extends JDialogCecilia {
    private final String _nameTree;
    private final CeciliaAppl _cAppl;
    private JRadioButton _btnUpdate;
    private JRadioButton _btnNewVers;
    private JRadioButton _btnNotImport;

    public DlgCaftaChooseConflict(CeciliaAppl cAppl, String nameTree) {
        super((Window)cAppl.getTopWindow(), true);
        this._cAppl = cAppl;
        this._nameTree = nameTree;
        JPanel panel = this.createPanelChoiceConflict();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(cAppl.getTopWindow()));
    }

    private JPanel createPanelChoiceConflict() {
        JLabel treeExistsLbl = new JLabel(ResMsgCafta.msgFormat("DLG_CHOOSE_CONFLICT_LBL", this._nameTree));
        ButtonGroup grpBtns = new ButtonGroup();
        this._btnUpdate = new JRadioButton(ResMsgCafta.getString("DLG_CHOOSE_CONFLICT_UPDATE_TREE"));
        this._btnNewVers = new JRadioButton(ResMsgCafta.getString("DLG_CHOOSE_CONFLICT_CREATE_VERSION"));
        this._btnNotImport = new JRadioButton(ResMsgCafta.getString("DLG_CHOOSE_CONFLICT_NOT_IMPORT"));
        String value = PlugableUtility.getStrOpt(this._cAppl.getPlugable(), GeneralIOPreferencies.PREF_IMPORT_DAG_CONFLICT, "");
        DBConflict dbConflict = DBConflict.readFrom(value, DBConflict.NOTIMPORT);
        if (dbConflict == DBConflict.NEWVERSION) {
            this._btnNewVers.setSelected(true);
        } else if (dbConflict == DBConflict.UPDATE) {
            this._btnUpdate.setSelected(true);
        } else if (dbConflict == DBConflict.NOTIMPORT) {
            this._btnNotImport.setSelected(true);
        }
        grpBtns.add(this._btnUpdate);
        grpBtns.add(this._btnNewVers);
        grpBtns.add(this._btnNotImport);
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        int x = 0;
        panel.add((Component)treeExistsLbl, new GridBagConstraints(x, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._btnUpdate, new GridBagConstraints(x, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this._btnNewVers, new GridBagConstraints(x, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this._btnNotImport, new GridBagConstraints(x, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    public final DBConflict getDBConflict() {
        assert (this._btnUpdate != null && this._btnNewVers != null);
        assert (!(!this._btnUpdate.isSelected() && !this._btnNewVers.isSelected() || this._btnUpdate.isSelected() && this._btnNewVers.isSelected()));
        if (this._btnUpdate.isSelected()) {
            return DBConflict.UPDATE;
        }
        if (this._btnNewVers.isSelected()) {
            return DBConflict.NEWVERSION;
        }
        if (this._btnNotImport.isSelected()) {
            return DBConflict.NOTIMPORT;
        }
        assert (false);
        return null;
    }

    @Override
    protected boolean verifyParameters() {
        return this._btnNewVers.isSelected() || this._btnUpdate.isSelected() || this._btnNotImport.isSelected();
    }

    @Override
    public String getTitle() {
        return ResMsgCafta.getString("DLG_IMPORT_CAFTA_TITLE");
    }

    @Override
    protected JComponent createButPanel() {
        super.createButPanel();
        JPanel resultPanel = new JPanel(new GridBagLayout());
        resultPanel.add((Component)this._ctrlOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 15, 12, 15), 0, 0));
        return resultPanel;
    }
}

