/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.io.AbstractCmdExport;
import com.dassault.cecilia.io.GenerateExport;
import com.dassault.cecilia.io.xml6.AnonymizeExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CmdAnonymizeXML
extends AbstractCmdExport {
    public CmdAnonymizeXML(CeciliaAppl appl, Component owner, Collection<DBFolder> selFolders, DBUser user) {
        super(appl, owner, selFolders, user);
    }

    protected boolean doRecupForExport(DBFolder dbFolder, List<GeneralError<DBFolder>> errors) {
        if (!dbFolder.isVersion()) {
            return true;
        }
        switch (dbFolder.getFamily()) {
            case CCF_MODEL: 
            case FMEA_MODEL: {
                errors.add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.getString("MSG_ANONYMISE_ERR_TYPE_DATA"), MsgType.ERROR));
                return false;
            }
            case PROJECT: {
                switch (dbFolder.getFamilyFlag()) {
                    case 4: 
                    case 5: {
                        errors.add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.getString("MSG_ANONYMISE_ERR_TYPE_DATA"), MsgType.ERROR));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected boolean recupForExport(DBFolder dbFolder) {
        return this.doRecupForExport(dbFolder, this.getErrors());
    }

    @Override
    protected GenerateExport createGenerateExport() {
        return new GenerateExport(this.getAppl().getDAOFactory(), this._dbUser){

            @Override
            protected void folderIsValid(DBFolder dbFolder) {
                CmdAnonymizeXML.this.doRecupForExport(dbFolder, this.getErrors());
            }
        };
    }

    @Override
    protected void doExport(Set<DBFolder> foldersToExport, File file) {
        AnonymizeExportXML6 doExport = new AnonymizeExportXML6(this.getAppl().getDAOFactory(), foldersToExport);
        doExport.setExportLogs(false);
        doExport.setExportAccess(false);
        doExport.setZipLimit(0L);
        try {
            doExport.exportTo(file);
        }
        catch (IOException ioe) {
            this.addError(this._srcFolder, ResMsgCore.msgFormat("MSG_EXC_IOE", file.getAbsolutePath(), ioe.getMessage()));
        }
    }
}

