/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;

public interface DBFolderXmlConstant
extends DBObjectXmlConstant {
    public static final String ELT_CEC_ROOT = "cec.export";
    public static final String ELT_CEC_FOLDER = "cec.folder";
    public static final String ELT_CEC_ACCESS = "cec.access";
    public static final String ELT_CEC_PROPERTY = "cec.property";
    public static final String ELT_CEC_MODEL = "cec.model";
    public static final String ATT_NATURE = "nature";
    public static final String ATT_FORMAT = "format";
    public static final String ATT_ENCODING = "encoding";
    public static final String ATT_CRC = "crc";
    public static final String ATT_FAMILY = "family";
    public static final String ATT_FAMILY_FLAG = "familyFlag";
    public static final String ATT_OBJECT_FLAG = "objectFlag";
    public static final String ATT_DATE_CREATE = "dateCreate";
    public static final String ATT_DATE_MODIFY = "dateModify";
    public static final String ATT_USER = "user";
    public static final String ATT_GROUP = "group";
    public static final String ATT_ACCESS_GROUP = "accessGroup";
    public static final String ATT_ACCESS_OTHER = "accessOther";
    public static final String ATT_USER_MODIFIER = "lastModifier";

    public static enum AttrFolderType {
        FOLDER,
        MODEL,
        VERSION;


        public static AttrFolderType findFromDBFolder(DBFolder dbFolder) {
            if (dbFolder.isVersion()) {
                return VERSION;
            }
            if (dbFolder.isModel()) {
                return MODEL;
            }
            return FOLDER;
        }
    }

    public static enum AttrObjectFlag {
        FREEZE(2);

        private int _code;

        public int getCode() {
            return this._code;
        }

        private AttrObjectFlag(int code) {
            this._code = code;
        }

        public static String generateXMLCode(DBObject dbObject) {
            StringBuilder sb = new StringBuilder();
            if (dbObject.isBinFlag(2)) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(FREEZE.toString().toLowerCase());
            }
            return sb.toString();
        }
    }

    public static enum AttrFamilyFlag {
        NONE(0),
        PROJECT(8),
        TREE(2),
        BEQ(5),
        MODEL(1),
        DSF(3),
        FMEA(4),
        RECORD(2),
        ENUM(1);

        private short _code;

        public short getCode() {
            return this._code;
        }

        private AttrFamilyFlag(short code) {
            this._code = code;
        }

        public static AttrFamilyFlag findFromDBFolder(DBFolder dbFolder) {
            if (dbFolder.getFamily() == DBFolder.Family.PROJECT) {
                switch (dbFolder.getFamilyFlag()) {
                    case 8: {
                        return PROJECT;
                    }
                    case 2: {
                        return TREE;
                    }
                    case 1: {
                        return MODEL;
                    }
                    case 3: {
                        return DSF;
                    }
                    case 4: {
                        return FMEA;
                    }
                    case 5: {
                        return BEQ;
                    }
                }
            } else if (dbFolder.getFamily() == DBFolder.Family.TYPE) {
                switch (dbFolder.getFamilyFlag()) {
                    case 2: {
                        return RECORD;
                    }
                    case 1: {
                        return ENUM;
                    }
                }
            }
            return NONE;
        }
    }
}

