/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.xml6.DBRootHandlerXml;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class ImportUtility {
    DAOFactory _daoFactory;
    DBLogs _logs;
    DBLogs.DBLogsManager _logsManager;

    public ImportUtility(DAOFactory daoFactory) {
        this._daoFactory = daoFactory;
        this._logs = new DBLogs();
        this._logsManager = new DBLogs.DefaultManager("admin", this._logs);
    }

    public DBLogs getLogs() {
        return this._logs;
    }

    public void readXml(InputStream input) throws IOException {
        DBRootHandlerXml xmlHandler = new DBRootHandlerXml(this._logsManager, this._daoFactory);
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)((Object)xmlHandler));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC")).append("\n");
            Locator loc = xmlHandler.getLocator();
            if (loc != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }
}

