/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.io.xml6.DBFolderXmlConstant;
import com.dassault.cecilia.lib.util.io.Base64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PerformExportXML6 {
    private static Logger _LOG = Logger.getLogger(PerformExportXML6.class.getPackage().getName());
    boolean _bExportLogs = false;
    boolean _bExportAccess = false;
    long _lExportZipLimit = -1L;
    DAOObjModel _daoObjModel = null;
    Set<DBFolder> _foldersSorted;
    private static String[] INDENT = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              "};

    public PerformExportXML6(DAOFactory daoFactory, Set<DBFolder> foldersToExport) {
        this._daoObjModel = daoFactory.createObjModelDAO();
        this._foldersSorted = new TreeSet<DBFolder>(DBFolder.getComparatorWithFamily());
        this._foldersSorted.addAll(foldersToExport);
    }

    public PerformExportXML6(DAOFactory daoFactory) {
        this._daoObjModel = daoFactory.createObjModelDAO();
        this._foldersSorted = new TreeSet<DBFolder>(DBFolder.getComparatorWithFamily());
        this.recupAllFolders(daoFactory, this._foldersSorted);
    }

    private void recupAllFolders(DAOFactory daoFactory, Set<DBFolder> folders) {
        DAOFolder daoFolder = daoFactory.createFolderDAO();
        DBFolder dbFolder = daoFolder.getRootID("ROOT");
        this.recupAllFolders_rec(folders, dbFolder, daoFolder);
    }

    private void recupAllFolders_rec(Set<DBFolder> folders, DBFolder dbFolder, DAOFolder daoFolder) {
        if (!dbFolder.isVersion()) {
            List<DBFolder> dbChildren = dbFolder.getChildren();
            if (dbChildren == null) {
                dbChildren = daoFolder.findChildren(dbFolder);
            }
            for (int i = 0; i < dbChildren.size(); ++i) {
                this.recupAllFolders_rec(folders, dbChildren.get(i), daoFolder);
            }
        } else {
            folders.add(dbFolder);
        }
    }

    public boolean getExportLogs() {
        return this._bExportLogs;
    }

    public PerformExportXML6 setExportLogs(boolean value) {
        this._bExportLogs = value;
        return this;
    }

    public boolean getExportAccess() {
        return this._bExportAccess;
    }

    public PerformExportXML6 setExportAccess(boolean value) {
        this._bExportAccess = value;
        return this;
    }

    public long getZipLimit() {
        return this._lExportZipLimit;
    }

    public PerformExportXML6 setZipLimit(long value) {
        this._lExportZipLimit = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTo(File file) throws IOException {
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            this.exportTo(out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportTo(Writer out) throws IOException {
        out.append("<?xml version='1.0'?>\n");
        out.append("<cec.export>\n");
        DBFolder dbPrev = null;
        for (DBFolder dbFolder : this._foldersSorted) {
            if (dbFolder.isSystem()) continue;
            this.exportTo(out, dbFolder, dbPrev);
            dbPrev = dbFolder;
        }
        this.exportTo(out, null, dbPrev);
        out.append("</cec.export>\n");
    }

    private void exportTo(Writer out, DBFolder dbNext, DBFolder dbPrev) throws IOException {
        if (dbNext == null) {
            this.exportFooter_rec(out, dbPrev);
        } else if (dbPrev == null || !dbPrev.getFamily().equals((Object)dbNext.getFamily())) {
            if (dbPrev != null) {
                this.exportFooter_rec(out, dbPrev);
            }
            this.exportHeader_rec(out, dbNext, null);
        } else {
            DBFolder dbCurrNext = dbNext;
            DBFolder dbCurrPrev = dbPrev;
            do {
                this.exportFooter(out, dbCurrPrev);
                dbCurrNext = dbCurrNext.getParent();
                dbCurrPrev = dbCurrPrev.getParent();
            } while (!dbCurrNext.isSystem() && !dbCurrNext.equals(dbCurrPrev));
            this.exportHeader_rec(out, dbNext, dbCurrNext);
        }
    }

    private void exportHeader_rec(Writer out, DBFolder dbCurr, DBFolder dbStop) throws IOException {
        if (dbCurr.isSystem()) {
            return;
        }
        if (dbStop != null && dbCurr.equals(dbStop)) {
            return;
        }
        this.exportHeader_rec(out, dbCurr.getParent(), dbStop);
        this.exportHeader(out, dbCurr);
    }

    private void exportHeader(Writer out, DBFolder dbCurr) throws IOException {
        String fobj;
        out.append(INDENT[dbCurr.getDepthUntilSystem()]);
        out.append("<").append("cec.folder");
        out.append(" ").append("id").append("='").append(Long.toString(dbCurr.getID())).append("'");
        out.append(" ").append("name").append("='");
        this.exportFolder(out, dbCurr).append("'");
        out.append(" ").append("family").append("='").append(dbCurr.getFamily().toString().toLowerCase()).append("'");
        out.append(" ").append("type").append("='").append(DBFolderXmlConstant.AttrFolderType.findFromDBFolder(dbCurr).toString().toLowerCase()).append("'");
        DBFolderXmlConstant.AttrFamilyFlag fflag = DBFolderXmlConstant.AttrFamilyFlag.findFromDBFolder(dbCurr);
        if (fflag != DBFolderXmlConstant.AttrFamilyFlag.NONE) {
            out.append(" ").append("familyFlag").append("='").append(fflag.toString().toLowerCase()).append("'");
        }
        if (dbCurr.getObject() != null && !(fobj = DBFolderXmlConstant.AttrObjectFlag.generateXMLCode(dbCurr.getObject())).isEmpty()) {
            out.append(" ").append("objectFlag").append("='").append(fobj).append("'");
        }
        this.exportDate(out, dbCurr.getDateCreate(), "dateCreate");
        this.exportDate(out, dbCurr.getDateModify(), "dateModify");
        out.append(">\n");
        this.exportLabel(out, dbCurr);
        if (this._bExportAccess) {
            this.exportAccess(out, dbCurr);
        }
    }

    protected void exportDate(Writer out, Date date, String attrDate) throws IOException {
        if (date != null) {
            out.append(" ").append(attrDate).append("='").append(Long.toString(date.getTime())).append("'");
        }
    }

    protected Appendable exportFolder(Writer out, DBFolder dbFolder) throws IOException {
        return DBObjectXmlUtility.appendXML(out, dbFolder.getName());
    }

    protected void exportLabel(Writer out, DBFolder dbCurr) throws IOException {
        String label = dbCurr.getDescription();
        if (label == null) {
            return;
        }
        if (label.isEmpty()) {
            return;
        }
        out.append(INDENT[dbCurr.getDepthUntilSystem() + 1]);
        out.append("<").append("label").append(">");
        DBObjectXmlUtility.appendXML(out, label);
        out.append("</").append("label").append(">\n");
    }

    private void exportAccess(Writer out, DBFolder dbCurr) throws IOException {
        out.append(INDENT[dbCurr.getDepthUntilSystem() + 1]);
        out.append("<").append("cec.access");
        out.append(" ").append("user").append("='").append(dbCurr.getUserOwner().getLogin()).append("'");
        out.append(" ").append("group").append("='").append(dbCurr.getGroupOwner().getName()).append("'");
        out.append(" ").append("accessGroup").append("='").append(dbCurr.getRightGroup().toXML()).append("'");
        out.append(" ").append("accessOther").append("='").append(dbCurr.getRightOther().toXML()).append("'");
        if (dbCurr.getUserModify() != null) {
            out.append(" ").append("lastModifier").append("='").append(dbCurr.getUserModify().getLogin()).append("'");
        }
        out.append("/>\n");
    }

    private void exportFooter_rec(Writer out, DBFolder dbCurr) throws IOException {
        if (!dbCurr.isSystem()) {
            this.exportFooter(out, dbCurr);
            this.exportFooter_rec(out, dbCurr.getParent());
        }
    }

    protected void exportFooter(Writer out, DBFolder dbCurr) throws IOException {
        DBObject dbObject = dbCurr.getObject();
        if (dbObject != null) {
            this.exportObject(out, dbCurr, dbObject);
        }
        out.append(INDENT[dbCurr.getDepthUntilSystem()]);
        out.append("</").append("cec.folder").append(">\n");
    }

    protected void exportObject(Writer out, DBFolder dbCurr, DBObject dbObject) throws IOException {
        String indent = INDENT[dbCurr.getDepthUntilSystem() + 1];
        Collection<DBObjModel> dbModels = dbObject.getModels();
        if (dbModels.size() > 1) {
            dbModels = new ArrayList<DBObjModel>(dbModels);
            Collections.sort((List)dbModels);
        }
        for (DBObjModel dbModel : dbModels) {
            this.exportModel(out, dbModel, dbCurr, indent);
        }
        Collection<DBObjProperty> dbProps = dbObject.getProperties();
        if (dbProps.size() > 1) {
            dbProps = new ArrayList<DBObjProperty>(dbProps);
            Collections.sort((List)dbProps);
        }
        for (DBObjProperty dbProp : dbProps) {
            this.exportProperty(out, dbProp, indent);
        }
    }

    protected boolean canExportInBase64(DBObjModel dbModel) {
        if (dbModel.getNature().equals("image")) {
            return true;
        }
        if (dbModel.getNature().startsWith("associated.file")) {
            return true;
        }
        if (dbModel.getID() == -1L) {
            return false;
        }
        String format = dbModel.getFormat();
        if ("ZIP".equals(format)) {
            if (this._lExportZipLimit < 0L) {
                return true;
            }
            long size = dbModel.getSize();
            return size <= this._lExportZipLimit;
        }
        return false;
    }

    protected void exportModel(Writer out, DBObjModel dbModel, DBFolder dbFolder, String indent) throws IOException {
        if (dbModel.getFormat().equals("ZML") || dbModel.getFormat().equals("XML")) {
            if (dbModel.getNature().equals("logs") && !this._bExportLogs) {
                return;
            }
            this.exportModel_Header(out, dbModel, indent, "XML", "UTF-8");
            this.exportModel_ZML(out, dbModel, indent, dbModel.getFormat().equals("ZML"));
            this.exportModel_Footer(out, indent);
        } else if (this.canExportInBase64(dbModel)) {
            this.exportModel_Header(out, dbModel, indent);
            this.exportModel_ZIP(out, dbModel, indent);
            this.exportModel_Footer(out, indent);
        } else if (dbModel.getNature().equals("tree.dag") && dbFolder.getFamilyFlag() == 5) {
            this.exportModel_Header(out, dbModel, indent);
            this.exportModel_ZIP(out, dbModel, indent);
            this.exportModel_Footer(out, indent);
        }
    }

    private void exportModel_Header(Writer out, DBObjModel dbModel, String indent, String format, String encoding) throws IOException {
        out.append(indent).append("<").append("cec.model");
        out.append(" ").append("nature").append("='").append(dbModel.getNature()).append("'");
        out.append(" ").append("format").append("='").append(format).append("'");
        this.exportCRCModel(out, dbModel);
        if (!encoding.isEmpty()) {
            out.append(" ").append("encoding").append("='").append(dbModel.getEncoding()).append("'");
        }
        out.append(">\n");
    }

    protected void exportCRCModel(Writer out, DBObjModel dbModel) throws IOException {
        if (!dbModel.getCRC().isEmpty()) {
            out.append(" ").append("crc").append("='").append(dbModel.getCRC()).append("'");
        }
    }

    private void exportModel_Header(Writer out, DBObjModel dbModel, String indent) throws IOException {
        this.exportModel_Header(out, dbModel, indent, dbModel.getFormat(), dbModel.getEncoding());
    }

    private void exportModel_Footer(Writer out, String indent) throws IOException {
        out.append(indent).append("</").append("cec.model").append(">\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportModel_ZML(Writer out, DBObjModel dbModel, String indent, boolean inflater) throws IOException {
        InputStream istream = this._daoObjModel.getBinaryStream(dbModel);
        BufferedReader input = null;
        try {
            String line;
            if (inflater) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            input = new BufferedReader(new InputStreamReader(istream, StandardCharsets.UTF_8));
            while ((line = input.readLine()) != null) {
                String trim = line.trim();
                if (trim.startsWith("<?")) continue;
                if (trim.startsWith("<")) {
                    out.append(indent).append("  ");
                }
                out.append(line).append("\n");
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    _LOG.log(Level.FINE, "Exception during close binary stream : " + dbModel);
                }
            }
        }
    }

    protected void exportModel_ZIP(Writer out, DBObjModel dbModel, String indent) throws IOException {
        InputStream istream = this._daoObjModel.getBinaryStream(dbModel);
        if (istream == null) {
            _LOG.log(Level.WARNING, "getBinaryStream(" + dbModel + ") return null");
            return;
        }
        this.exportModel_ZIP(out, istream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportModel_ZIP(Writer out, InputStream istream) throws IOException {
        char[] cbuf = new char[2048];
        Reader input = null;
        try {
            input = new InputStreamReader((InputStream)new Base64.InputStream(istream, 9));
            int len = -1;
            while ((len = input.read(cbuf)) != -1) {
                out.write(cbuf, 0, len);
            }
            out.write("\n");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ioe) {
                    _LOG.log(Level.FINE, "Exception during close binary stream");
                }
            }
        }
    }

    protected void exportProperty(Writer out, DBObjProperty dbProp, String indent) throws IOException {
        out.append(indent).append("<").append("cec.property");
        out.append(" ").append("name").append("='").append(dbProp.getName()).append("'");
        String type = dbProp.getType();
        if (dbProp.getName().equals("object.creator")) {
            type = "String";
        }
        out.append(" ").append("type").append("='").append(type).append("'");
        out.append(" ").append("value").append("='").append(dbProp.getValue()).append("'");
        out.append("/>\n");
    }
}

