/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class CeciliaMenus {
    private static Logger _LOG = Logger.getLogger(CeciliaMenus.class.getPackage().getName());
    DeclareActions _actions;
    Map<String, JMenu> _menus;
    Map<String, JMenuItem> _menuItems;
    boolean _bDebug;

    public CeciliaMenus(DeclareActions actions, boolean debug) {
        this._actions = actions;
        this._menus = new LinkedHashMap<String, JMenu>();
        this._menuItems = new LinkedHashMap<String, JMenuItem>();
        this._bDebug = debug;
    }

    private void addItem(JMenu menu, String keyAction, String name) {
        CeciliaAction action = this._actions.getAction(keyAction);
        if (action == null) {
            _LOG.warning("Action inconnue pour la creation d'un menu : " + keyAction);
        } else {
            JMenuItem item = action.createMenuItem();
            menu.add(item);
            item.setName(name);
            this.putItem(name, item);
        }
    }

    private void putItem(String name, JMenuItem item) {
        if (this._menuItems.put(name, item) != null) {
            _LOG.warning("Nom d'une action deja affecte : " + name);
        }
    }

    private void addMenu(JMenu menu, JMenu subMenu, String name) {
        menu.add(subMenu);
        subMenu.setName(name);
        this.putMenu(name, subMenu);
    }

    private void addMenu(JMenuBar menu, JMenu subMenu, String name) {
        menu.add(subMenu);
        subMenu.setName(name);
        this.putMenu(name, subMenu);
    }

    private void putMenu(String name, JMenu item) {
        if (this._menus.put(name, item) != null) {
            _LOG.warning("Nom d'un menu deja affecte : " + name);
        }
    }

    public JMenu getMenu(String key) {
        return this._menus.get(key);
    }

    public JMenuBar createBar() {
        JMenuBar bar = new JMenuBar();
        this.addMenu(bar, this.createMenuFile(), "File");
        this.addMenu(bar, this.createMenuLibrary(), "Library");
        this.addMenu(bar, this.createMenuEdition(), "Edition");
        this.addMenu(bar, this.createMenuMBSA(), "MBSA");
        this.addMenu(bar, this.createMenuFaultTree(), "FaultTree");
        this.addMenu(bar, this.createMenuTools(), "Tools");
        this.addMenu(bar, this.createMenuHelp(), "Help");
        return bar;
    }

    protected JMenu createMenuFile() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_FILE"));
        this.addMenu(menu, this.createMenuCreate(), "Create");
        menu.add(new JSeparator());
        this.addItem(menu, "SAVE", "Save");
        this.addItem(menu, "CLOSE", "Close");
        menu.add(new JSeparator());
        this.addItem(menu, "EXPORT", "Export");
        JMenu submenu = new JMenu(ResMsgCecilia.getString("MENU_IMPORT"));
        submenu.setIcon(ResIcoCore.getImageIcon("IE_IMPORT"));
        this.addItem(submenu, "IMPORT_XML6", "Import XmlV6");
        submenu.add(new JSeparator());
        this.addItem(submenu, "IMPORT_ARBOR51", "Import Arbor51");
        this.addItem(submenu, "IMPORT_OCAS51", "Import Ocas51");
        submenu.add(new JSeparator());
        this.addItem(submenu, "IMPORT_DAGDEF", "Import DAG");
        this.addItem(submenu, "IMPORT_ARB", "Import ARB");
        submenu.add(new JSeparator());
        this.addItem(submenu, "IMPORT_CAFTA", "Import CAFTA");
        this.addItem(submenu, "IMPORT_FTPLUS", "Import FTP");
        this.addMenu(menu, submenu, "Importer");
        menu.add(new JSeparator());
        this.addItem(menu, "PAGE_FORMAT", "PageFormat");
        this.addItem(menu, "PRINT_PREVIEW", "Preview");
        this.addItem(menu, "PRINT", "Print");
        menu.add(new JSeparator());
        this.addItem(menu, "QUIT", "Quit");
        return menu;
    }

    protected JMenu createMenuCreate() {
        JMenu menu = new JMenu(ResMsgCecilia.getString("MENU_CREATE"));
        this.addItem(menu, "PROJECT_CREATE_PROJECT", "CreateProjet");
        menu.add(new JSeparator());
        this.addItem(menu, "PROJECT_CREATE_MODEL", "CreateMBSA");
        this.addItem(menu, "PROJECT_CREATE_TREE", "CreateTree");
        this.addItem(menu, "PROJECT_CREATE_DSF", "CreateDSF");
        this.addItem(menu, "PROJECT_CREATE_FMEA", "CreateFMEA");
        return menu;
    }

    protected JMenu createMenuLibrary() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_BIBLIO"));
        this.addItem(menu, "FOLDER_CREATE_ROOT", "CreateRoot");
        menu.add(new JSeparator());
        this.addItem(menu, "FOLDER_CREATE", "AddFolder");
        this.addItem(menu, "FOLDER_DELETE", "DelFolder");
        this.addItem(menu, "FOLDER_RENAME", "RenameFolder");
        this.addItem(menu, "FOLDER_EDIT", "EditFolder");
        this.addItem(menu, "PROPERTY", "Property");
        this.addItem(menu, "FREEZE", "Freeze");
        menu.add(new JSeparator());
        this.addItem(menu, "FOLDER_CUT", "CutFolder");
        this.addItem(menu, "FOLDER_COPY", "CopyFolder");
        this.addItem(menu, "FOLDER_PASTE", "PasteFolder");
        menu.add(new JSeparator());
        this.addItem(menu, "ICON_LIBRARY", "ImagLibrary");
        this.addItem(menu, "FOLDER_SEARCH", "Research");
        return menu;
    }

    protected JMenu createMenuEdition() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_EDIT"));
        this.addItem(menu, "UNDO", "Undo");
        this.addItem(menu, "REDO", "Redo");
        this.addItem(menu, "DELETE", "Del");
        menu.add(new JSeparator());
        this.addItem(menu, "CUT", "Cut");
        this.addItem(menu, "COPY", "Copy");
        this.addItem(menu, "PASTE", "Paste");
        menu.add(new JSeparator());
        this.addItem(menu, "SEARCH", "Find");
        menu.add(new JSeparator());
        this.addItem(menu, "SELECTALL", "SelectAll");
        return menu;
    }

    protected JMenu createMenuSimulation() {
        JMenu menu = new JMenu(ResMsgCecilia.getString("MENU_SIMUL"));
        menu.setIcon(ResIcoSimul.getImageIcon("SIMULATION"));
        this.addItem(menu, "SIMUL_GO_START", "SimStart");
        this.addItem(menu, "SIMUL_GO_INIT", "SimInit");
        this.addItem(menu, "SIMUL_GO_BACK", "SimBack");
        this.addItem(menu, "SIMUL_GO_FORW", "SimForw");
        this.addItem(menu, "SIMUL_GO_NEXT", "SimNext");
        this.addItem(menu, "SIMUL_GO_STOP", "SimStop");
        this.addItem(menu, "SIMUL_GO_SAVE", "SimSave");
        this.addItem(menu, "SIMUL_GO_EVENT", "SimEvent");
        this.addItem(menu, "SIMUL_GO_STATE", "SimState");
        if (Boolean.getBoolean("cecilia.core.debug")) {
            this.addItem(menu, "SIMUL_GO_INFO", "SimInfo");
        }
        this.addItem(menu, "SIMUL_GO_DEBUG", "SimDebug");
        menu.setEnabled(false);
        return menu;
    }

    protected JMenu createMenuMBSA() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_MBSA"));
        this.addMenu(menu, this.createMenuSimulation(), "Simulation");
        return menu;
    }

    protected JMenu createMenuFaultTree() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_ARBOR"));
        this.addItem(menu, "CRITICITY_GLOBAL_LIST", "CritGlobalList");
        this.addMenu(menu, this.createMenuArborEGL(), "EGL");
        return menu;
    }

    protected JMenu createMenuArborEGL() {
        JMenu menu = new JMenu(ResMsgObj.getString("EGL_TITLE"));
        menu.setIcon(ResIcoArbor.getImageIcon("EVENT_GLOBAL_LIST"));
        this.addItem(menu, "EGL_GENERATE", "EGLGenerate");
        this.addItem(menu, "EGL_REGENERATE", "EGLGenerateAll");
        menu.add(new JSeparator());
        this.addItem(menu, "EGL_EXTRACT", "EGLExtract");
        return menu;
    }

    protected JMenu createMenuTools() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_TOOLS"));
        this.addItem(menu, "PLUGIN_MANAGER", "PluginsManager");
        this.addItem(menu, "TASK_MANAGER", "TasksManager");
        this.addItem(menu, "DISTRIB_MANAGER", "DistribManager");
        menu.add(new JSeparator());
        this.addItem(menu, "PREFERENCIES", "Perferencies");
        return menu;
    }

    protected JMenu createMenuHelp() {
        JMenu menu = new JMenu(ResMsgVoc.getString("VOC_HELP"));
        this.addItem(menu, "ABOUT", "About");
        menu.add(new JSeparator());
        this.addItem(menu, "DB_VERIFY", "DBVerification");
        JMenu reorganizeMenu = new JMenu(ResMsgCecilia.getString("MENU_REORGANIZE"));
        reorganizeMenu.setToolTipText(ResMsgCecilia.getString("MENU_REORGANIZE_TOOLTIP"));
        this.addItem(reorganizeMenu, "REORGANIZE_CASCADE", "Cascade");
        this.addItem(reorganizeMenu, "REORGANIZE_MOSAICs", "Mosaic");
        menu.add(reorganizeMenu);
        return menu;
    }
}

