/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.dbobj.mbsa.simul.SimulationActionStartWithChoice;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import java.awt.Container;
import java.awt.Insets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class CeciliaToolBars {
    private static Logger _LOG = Logger.getLogger(CeciliaToolBars.class.getPackage().getName());
    DeclareActions _actions;
    Container _container;
    Map<String, JToolBar> _toolbars;
    Map<String, JComponent> _components;

    public CeciliaToolBars(DeclareActions actions) {
        this._actions = actions;
        this._toolbars = new LinkedHashMap<String, JToolBar>();
        this._components = new LinkedHashMap<String, JComponent>();
    }

    public Collection<String> getToolbarsKey() {
        return this._toolbars.keySet();
    }

    public JToolBar getToolBar(String key) {
        return this._toolbars.get(key);
    }

    public JComponent getComponent(String key) {
        return this._components.get(key);
    }

    private AbstractButton addItem(JToolBar bar, String keyAction, boolean noChangeMarge) {
        CeciliaAction action = this._actions.getAction(keyAction);
        if (action != null) {
            AbstractButton item = action.createButton(CeciliaAction.BorderStyle.NORMAL);
            if (!noChangeMarge) {
                item.setMargin(new Insets(1, 1, 1, 1));
            }
            bar.add(item);
            return item;
        }
        _LOG.warning("Action inconnue pour la creation d'un bouton : " + keyAction);
        return null;
    }

    private void addToolBar(JToolBar bar, String name) {
        this._container.add(bar);
        this.putBar(name, bar);
    }

    private void putBar(String name, JToolBar item) {
        if (this._toolbars.put(name, item) != null) {
            _LOG.warning("Nom d'une barre d'outil deja affecte : " + name);
        }
    }

    public void createBar(Container container) {
        this._container = container;
        try {
            this.addToolBar(this.createBarFile(), "Standard toolbar");
            this.addToolBar(this.createBarEdit(), "Edition toolbar");
            this.addToolBar(this.createBarZoom(), "Navigate toolbar");
            this.addToolBar(this.createBarSimul(), "Simulation toolbar");
            this.addToolBar(this.createBarDesign(), "Design toolbar");
            this.addToolBar(this.createBarAlign(), "Alignment toolbar");
            this.addToolBar(this.createBarLink(), "Link toolbar");
        }
        finally {
            this._container = null;
        }
    }

    protected JToolBar createBarFile() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_STANDARD"));
        this.addItem(bar, "CLOSE", false);
        this.addItem(bar, "SAVE", false);
        this.addItem(bar, "PRINT", false);
        return bar;
    }

    protected JToolBar createBarEdit() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_EDITION"));
        this.addItem(bar, "CUT", false);
        this.addItem(bar, "COPY", false);
        this.addItem(bar, "PASTE", false);
        this.addItem(bar, "SEARCH", false);
        this.addItem(bar, "UNDO", false);
        this.addItem(bar, "REDO", false);
        return bar;
    }

    protected JToolBar createBarZoom() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_NAVIGATE"));
        this.addItem(bar, "ZOOM_DEC", false);
        this.addItem(bar, "ZOOM_INC", false);
        JComponent ctrlZoom = this.createCtrlZoom();
        bar.add(ctrlZoom);
        this._components.put("ZOOM_EDITOR", ctrlZoom);
        this.addItem(bar, "OCAS_UP", false);
        this.addItem(bar, "OCAS_DOWN", false);
        this.addItem(bar, "OCAS_DOWN_OTHER", false);
        return bar;
    }

    protected JComponent createCtrlZoom() {
        JComboBox<String> _zoomCombo = new JComboBox<String>();
        _zoomCombo.setToolTipText(ResMsgCecilia.getString("VIEW_ZOOM_DEFINE"));
        _zoomCombo.addItem("20%");
        _zoomCombo.addItem("30%");
        _zoomCombo.addItem("40%");
        _zoomCombo.addItem("50%");
        _zoomCombo.addItem("60%");
        _zoomCombo.addItem("70%");
        _zoomCombo.addItem("80%");
        _zoomCombo.addItem("90%");
        _zoomCombo.addItem("100%");
        _zoomCombo.addItem("125%");
        _zoomCombo.addItem("150%");
        _zoomCombo.addItem("175%");
        _zoomCombo.addItem("200%");
        _zoomCombo.addItem("225%");
        _zoomCombo.addItem("250%");
        _zoomCombo.addItem("300%");
        _zoomCombo.addItem("350%");
        _zoomCombo.addItem("400%");
        _zoomCombo.setSelectedItem("");
        _zoomCombo.setEditable(true);
        _zoomCombo.setEnabled(false);
        return _zoomCombo;
    }

    protected JToolBar createBarSimul() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_SIMUL"));
        AbstractButton butAssociated = this.addItem(bar, "SIMUL_GO_START", true);
        CeciliaAction action = this._actions.getAction("SIMUL_GO_CHOICE");
        if (action == null) {
            _LOG.warning("Action inconnue pour la creation d'un bouton : SIMUL_GO_CHOICE");
        } else {
            AbstractButton item = action.createButton(CeciliaAction.BorderStyle.NORMAL);
            ((SimulationActionStartWithChoice)action).setAssociatedButton(butAssociated);
            bar.add(item);
        }
        this.addItem(bar, "SIMUL_GO_INIT", true);
        this.addItem(bar, "SIMUL_GO_BACK", true);
        this.addItem(bar, "SIMUL_GO_FORW", true);
        this.addItem(bar, "SIMUL_GO_NEXT", true);
        this.addItem(bar, "SIMUL_GO_STOP", true);
        this.addItem(bar, "SIMUL_GO_SAVE", true);
        this.addItem(bar, "SIMUL_GO_EVENT", true);
        this.addItem(bar, "SIMUL_GO_STATE", true);
        if (Boolean.getBoolean("cecilia.core.debug")) {
            this.addItem(bar, "SIMUL_GO_INFO", true);
        }
        this.addItem(bar, "SIMUL_GO_DEBUG", true);
        return bar;
    }

    protected JToolBar createBarDesign() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_FORM"));
        this.addItem(bar, "OCAS_VIEW_LOCK_LOCK", false);
        this.addItem(bar, "OCAS_VIEW_LOCK_UNLOCK", false);
        bar.add(new JToolBar.Separator());
        this.addItem(bar, "OCAS_VIEW_MIRROR_VERTICAL", false);
        this.addItem(bar, "OCAS_VIEW_MIRROR_HORIZONTAL", false);
        this.addItem(bar, "OCAS_VIEW_MIRROR_ROTATE", false);
        bar.add(new JToolBar.Separator());
        this.addItem(bar, "OCAS_VIEW_ORDER_FIRST", false);
        this.addItem(bar, "OCAS_VIEW_ORDER_LAST", false);
        return bar;
    }

    protected JToolBar createBarAlign() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_ALIGN"));
        this.addItem(bar, "OCAS_VIEW_ALIGN_LEFT", false);
        this.addItem(bar, "OCAS_VIEW_ALIGN_VERTICAL", false);
        this.addItem(bar, "OCAS_VIEW_ALIGN_RIGHT", false);
        bar.add(new JToolBar.Separator());
        this.addItem(bar, "OCAS_VIEW_ALIGN_CENTER", false);
        bar.add(new JToolBar.Separator());
        this.addItem(bar, "OCAS_VIEW_ALIGN_TOP", false);
        this.addItem(bar, "OCAS_VIEW_ALIGN_HORIZONTAL", false);
        this.addItem(bar, "OCAS_VIEW_ALIGN_BOTTOM", false);
        return bar;
    }

    protected JToolBar createBarLink() {
        JToolBar bar = new JToolBar(ResMsgCecilia.getString("OPT_TOOLBAR_LINK"));
        this.addItem(bar, "OCAS_VIEW_LINK_DIRECT", false);
        this.addItem(bar, "OCAS_VIEW_LINK_HORIZONTAL", false);
        this.addItem(bar, "OCAS_VIEW_LINK_VERTICAL", false);
        this.addItem(bar, "OCAS_VIEW_LINK_BOTTOM_RIGHT", false);
        this.addItem(bar, "OCAS_VIEW_LINK_BOTTOM_LEFT", false);
        this.addItem(bar, "OCAS_VIEW_LINK_TOP_RIGHT", false);
        this.addItem(bar, "OCAS_VIEW_LINK_TOP_LEFT", false);
        bar.add(new JToolBar.Separator());
        this.addItem(bar, "OCAS_VIEW_LINK_ARROW_DEL", false);
        this.addItem(bar, "OCAS_VIEW_LINK_ARROW_ADD", false);
        bar.add(new JToolBar.Separator());
        this.addItem(bar, "OCAS_VIEW_LINK_BODY_FILL", false);
        this.addItem(bar, "OCAS_VIEW_LINK_BODY_PIPE", false);
        return bar;
    }
}

