/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;

public class OpenFolderList {
    private static Logger _LOG = Logger.getLogger(OpenFolderList.class.getPackage().getName());
    Map<DBFolder, OpenFolder> _mapOpenFolders;
    OpenFolder _selectedFolder = null;
    ArrayList<OpenFoldersListener> _listeners = new ArrayList();

    public OpenFolderList() {
        this._mapOpenFolders = new LinkedHashMap<DBFolder, OpenFolder>();
    }

    public Collection<OpenFolder> getOpenFolders() {
        return this._mapOpenFolders.values();
    }

    public void setSelectedFolder(OpenFolder oFolder, boolean bChangeMasterFrame) {
        if (this._selectedFolder == oFolder) {
            return;
        }
        this._selectedFolder = oFolder;
        if (this._selectedFolder == null) {
            return;
        }
        if (!bChangeMasterFrame) {
            return;
        }
        JInternalFrame iframe = this._selectedFolder.getMasterFrame();
        if (iframe == null) {
            return;
        }
        try {
            iframe.setSelected(true);
        }
        catch (PropertyVetoException e) {
            _LOG.log(Level.INFO, "Impossible de selectionner la master frame de l'objet metier : " + oFolder.getDBFolder().getRefPath(), e);
        }
    }

    public OpenFolder getSelectedFolder() {
        return this._selectedFolder;
    }

    public void addOpenFolder(OpenFolder oFolder) {
        DBFolder dbFolder = oFolder.getDBFolder();
        this._mapOpenFolders.put(dbFolder, oFolder);
        dbFolder.setEdited(true);
        this.fireChanged(new OpenFoldersEvent(oFolder, OpenFoldersAction.INSERT));
    }

    public void removeOpenFolder(DBFolder dbFolder) {
        dbFolder.setEdited(false);
        OpenFolder oFolder = this._mapOpenFolders.remove(dbFolder);
        if (oFolder != null) {
            this.fireChanged(new OpenFoldersEvent(oFolder, OpenFoldersAction.REMOVE));
            for (JInternalFrame frame : oFolder.getFrames()) {
                if (frame.isClosed()) continue;
                try {
                    frame.setClosed(true);
                }
                catch (PropertyVetoException execp) {
                    _LOG.log(Level.WARNING, "JInternalFrame not be closed for DBFolder: " + dbFolder.getRefPath() + " - " + frame.getTitle(), execp);
                }
            }
        }
        if (this._mapOpenFolders.isEmpty()) {
            this.fireChanged(new OpenFoldersEvent(null, OpenFoldersAction.SELECT));
        }
    }

    public void selectOpenFolder(DBFolder dbFolder, Object source) {
        OpenFolder oFolder = this.getOpenFolder(dbFolder);
        if (oFolder != null) {
            this.fireChanged(new OpenFoldersEvent(oFolder, OpenFoldersAction.SELECT).setSource(source));
        }
    }

    public void refreshOpenFolder(DBFolder dbFolder, Object source) {
        OpenFolder oFolder = this.getOpenFolder(dbFolder);
        if (oFolder != null) {
            this.fireChanged(new OpenFoldersEvent(oFolder, OpenFoldersAction.REFRESH).setSource(source));
        }
    }

    public void addOpenFoldersListener(OpenFoldersListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeOpenFoldersListener(OpenFoldersListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireChanged(OpenFoldersEvent event) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).listChanged(event);
        }
    }

    public OpenFolder getOpenFolder(DBFolder dbFolder) {
        return this._mapOpenFolders.get(dbFolder);
    }

    public static interface OpenFoldersListener {
        public void listChanged(OpenFoldersEvent var1);
    }

    public static class OpenFoldersEvent {
        OpenFolder _folder;
        OpenFoldersAction _action;
        Object _source;

        public OpenFoldersEvent(OpenFolder oFolder, OpenFoldersAction action) {
            this._folder = oFolder;
            this._action = action;
        }

        public OpenFoldersEvent setSource(Object source) {
            this._source = source;
            return this;
        }

        public Object getSource() {
            return this._source;
        }

        public OpenFolder getFolder() {
            return this._folder;
        }

        public OpenFoldersAction getAction() {
            return this._action;
        }
    }

    public static enum OpenFoldersAction {
        INSERT,
        REMOVE,
        REFRESH,
        SELECT;

    }
}

