/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CModelessThread;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.actions.search.SearchJListPanel;
import com.dassault.cecilia.main.cecilia.actions.search.SearchPanel;
import com.dassault.cecilia.main.cecilia.gui.CFoldersPanel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.KeyStroke;

public class SearchBiblioPanel
extends SearchJListPanel {
    private CAppl _cAppl;
    private final Logger _LOG = Logger.getLogger(SearchBiblioPanel.class.getPackage().getName());

    public SearchBiblioPanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(dlg, type);
        this._cAppl = dlg.getApplication();
    }

    @Override
    public void doOpenAction() {
        DBFolder folder = (DBFolder)this._listElements.getSelectedValue();
        if (folder == null) {
            return;
        }
        CFoldersPanel foldersPanel = ((CeciliaGUI)this._cAppl.getTopWindow()).getFolders();
        DBFolderTreeActivable treeAct = foldersPanel.getTree(folder.getFamily());
        treeAct.edit(folder, folder.isReadOnly());
    }

    @Override
    public void doLocateAction() {
        DBFolder folder = (DBFolder)this._listElements.getSelectedValue();
        if (folder == null) {
            return;
        }
        CFoldersPanel foldersPanel = ((CeciliaGUI)this._cAppl.getTopWindow()).getFolders();
        DBFolder.Family family = folder.getFamily();
        switch (family) {
            case ATTRIBUTE: 
            case PARAMETER: 
            case CCF_MODEL: 
            case FMEA_MODEL: 
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_MODEL: 
            case BTP_SUBSTANTIATION: {
                family = DBFolder.Family.APPLICATION;
            }
        }
        DBFolderTreeActivable treeAct = foldersPanel.selectDBFolderTree(family);
        if (treeAct == null) {
            Loggeur.log(this.getClass(), Level.SEVERE, "Can not find the Folder's Tree of family " + (Object)((Object)family));
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        treeAct.doSelect(Arrays.asList(folder));
    }

    @Override
    protected void doFillWithData() {
        final DefaultListModel defListModel = (DefaultListModel)this._listElements.getModel();
        this.clearElements();
        final Pattern pattern = this.createPattern();
        if (pattern == null) {
            return;
        }
        final LinkedHashSet currentFolders = new LinkedHashSet();
        final Set<DBFolder> root = Collections.singleton(this._cAppl.getDAOFactory().createFolderDAO().getRootID("ROOT"));
        CModelessThread action = new CModelessThread(this){

            @Override
            protected void firstDo() {
                SearchBiblioPanel.this._LOG.finest("Find/Biblio - Begin");
                SearchPanel.recupAllFolderObject(SearchBiblioPanel.this._cAppl, root, currentFolders, new LinkedHashSet<DBFolder>(), SearchBiblioPanel.this._type);
                SearchBiblioPanel.this._LOG.finest("Find/Biblio - End");
            }

            @Override
            protected void invokeLater() {
                for (DBFolder folder : currentFolders) {
                    String folderName = folder.getRefPath();
                    if (!pattern.matcher(folderName).find()) continue;
                    defListModel.addElement(folder);
                }
            }
        };
        action.createAndStartThread("Search/Biblio");
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.getComponentForResult().getInputMap().put(KeyStroke.getKeyStroke(10, 128), "editProperties");
        this.getComponentForResult().getActionMap().put("editProperties", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder folder = (DBFolder)SearchBiblioPanel.this._listElements.getSelectedValue();
                if (folder == null) {
                    return;
                }
                CFoldersPanel foldersPanel = ((CeciliaGUI)SearchBiblioPanel.this._cAppl.getTopWindow()).getFolders();
                DBFolderTreeActivable treeAct = foldersPanel.getTree(folder.getFamily());
                treeAct.editProperties(folder, folder.isReadOnly());
            }
        });
    }
}

