/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchBiblioPanel;
import com.dassault.cecilia.main.cecilia.actions.search.SearchFTEquationPanel;
import com.dassault.cecilia.main.cecilia.actions.search.SearchImagePanel;
import com.dassault.cecilia.main.cecilia.actions.search.SearchPanel;
import com.dassault.cecilia.main.cecilia.actions.search.SearchSystemPanel;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SearchDlg
extends JDialogCecilia {
    protected final CAppl _cAppl;
    protected CInternalFrame _frame;
    protected JPanel _panel;
    protected SearchPanel _currentPanel;
    protected JButton _locateBtn;
    protected JButton _openBtn;
    protected JButton _closeBtn;
    private static final Map<SearchType, SearchPanel> MAP_TYPE_TO_PANEL = new LinkedHashMap<SearchType, SearchPanel>();
    private static final Map<String, SearchAction.SearchContext> MAP_DATA_TO_CONTEXT = new LinkedHashMap<String, SearchAction.SearchContext>();
    public static final int ID_LOCATE_BTN = 0;
    public static final int ID_OPEN_BTN = 1;
    public static final int ID_EXIT_BTN = 2;

    public SearchDlg(CAppl cAppl, CInternalFrame frame) {
        super(cAppl.getTopWindow(), false);
        this._cAppl = cAppl;
        this._frame = frame;
        this._panel = this.createSearchPanels(frame == null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(false), "South");
        this.init();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(cAppl.getTopWindow()));
    }

    @Override
    public List<Image> getIconImages() {
        return Arrays.asList(ResIcoCore.getImageIcon("BUT_SEARCH").getImage());
    }

    @Override
    public String getTitle() {
        return ResMsgCecilia.getString("DLG_ACTION_SEARCH_TITLE");
    }

    private JPanel createSearchPanels(boolean forSearchFolders) {
        if (!forSearchFolders) {
            JPanel panel = new JPanel(new CardLayout());
            SearchPanel searchPanel = new SearchFTEquationPanel(this, SearchType.EVENTS);
            MAP_TYPE_TO_PANEL.put(SearchType.EVENTS, searchPanel);
            panel.add((Component)searchPanel, SearchType.EVENTS.getID());
            searchPanel = new SearchSystemPanel(this, SearchType.ARCHITECTURE);
            MAP_TYPE_TO_PANEL.put(SearchType.ARCHITECTURE, searchPanel);
            panel.add((Component)searchPanel, SearchType.ARCHITECTURE.getID());
            searchPanel = new SearchSystemPanel(this, SearchType.SIMULATION);
            MAP_TYPE_TO_PANEL.put(SearchType.SIMULATION, searchPanel);
            panel.add((Component)searchPanel, SearchType.SIMULATION.getID());
            searchPanel = new SearchImagePanel(this, SearchType.IMAGE);
            MAP_TYPE_TO_PANEL.put(SearchType.IMAGE, searchPanel);
            panel.add((Component)searchPanel, SearchType.IMAGE.getID());
            return panel;
        }
        this._currentPanel = new SearchBiblioPanel(this, SearchType.BIBLIO);
        return this._currentPanel;
    }

    public final void showPanel(SearchType type) {
        ((CardLayout)this._panel.getLayout()).show(this._panel, type.getID());
        this._currentPanel = MAP_TYPE_TO_PANEL.get((Object)type);
    }

    public void setFrame(CInternalFrame frame) {
        this._frame = frame;
    }

    public CInternalFrame getFrame() {
        return this._frame;
    }

    public CAppl getApplication() {
        return this._cAppl;
    }

    @Override
    protected JComponent createButPanel(boolean withArborLogo) {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        this._locateBtn = new JButton(new AbstractAction(ResMsgCecilia.getString("DLG_ACTION_SEARCH_LOCATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDlg.this._currentPanel.doLocateAction();
            }
        });
        this._openBtn = new JButton(new AbstractAction(ResMsgCecilia.getString("DLG_ACTION_SEARCH_OPEN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDlg.this._currentPanel.doOpenAction();
            }
        });
        this._closeBtn = new JButton(new AbstractAction(ResMsgCecilia.getString("DLG_ACTION_SEARCH_CLOSE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDlg.this.setVisible(false);
            }
        });
        buttonsPanel.add((Component)this._locateBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)this._openBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)this._closeBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return buttonsPanel;
    }

    public final JButton getButton(int id) {
        switch (id) {
            case 0: {
                return this._locateBtn;
            }
            case 1: {
                return this._openBtn;
            }
            case 2: {
                return this._closeBtn;
            }
        }
        assert (false);
        return null;
    }

    public void updateContext(CInternalFrame frame, SearchType type, String name) {
        SearchAction.SearchContext context = MAP_DATA_TO_CONTEXT.get(name);
        SearchPanel panel = MAP_TYPE_TO_PANEL.get((Object)type);
        this.showPanel(type);
        panel.setModelName(name);
        if (context == null) {
            panel.resetContext();
        } else {
            this.update(frame, context);
        }
    }

    public void saveContext(CInternalFrame frame, SearchType type, String name) {
        SearchPanel panel = MAP_TYPE_TO_PANEL.get((Object)type);
        SearchAction.SearchContext context = panel.getContext();
        MAP_DATA_TO_CONTEXT.put(name, context);
        this.exit();
    }

    private final void exit() {
        this.setFrame(null);
        if (this._currentPanel != null) {
            this._currentPanel.exit();
        }
    }

    private final void update(CInternalFrame frame, SearchAction.SearchContext context) {
        this.setFrame(frame);
        if (this._currentPanel != null) {
            this._currentPanel.update(context);
        }
    }

    public void updatePanel(boolean selectable) {
        this._currentPanel.updateEnabled(selectable);
    }

    public static enum SearchType {
        SIMULATION("Simulation"),
        BIBLIO("Biblio"),
        ARCHITECTURE("Architecture"),
        EVENTS("Events"),
        IMAGE("Image");

        private final String _ID;

        private SearchType(String ID) {
            this._ID = ID;
        }

        public String getID() {
            return this._ID;
        }
    }
}

