/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.folders;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeRenderer;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.dsf.gui.DSFEquationCmdEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationCmdEdit;
import com.dassault.cecilia.dbobj.fmea.gui.DBTableFMEACmdEdit;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.mbsa.system.gui.DBSystemCmdEdit;
import com.dassault.cecilia.dbobj.project.DBProjectCmdEdit;
import com.dassault.cecilia.io.imports.CmdImportPrepareFtp;
import com.dassault.cecilia.io.ocas40.CmdExportOCAS4;
import com.dassault.cecilia.io.trees.CmdImportCafta;
import com.dassault.cecilia.io.trees.CmdImportTreeArb;
import com.dassault.cecilia.io.trees.CmdImportTreeDag;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderCmdInsertModel;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderCmdProperty;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class ProjectFolderTree
extends DBFolderTreeActivable {
    protected CeciliaAction _ctrlAddModel;
    protected CeciliaAction _ctrlAddTree;
    protected CeciliaAction _ctrlAddDSF;
    protected CeciliaAction _ctrlAddFMEA;
    AbstractAction _actionImportDAG;
    AbstractAction _actionImportARB;
    AbstractAction _actionImportCAFTA;
    AbstractAction _actionImportFTp;
    CeciliaAction _actionExportOcas4;
    protected JPopupMenu _popupTypes;

    public ProjectFolderTree(CeciliaAppl application, DBFolderTreeModel model) {
        super(application, model, false);
    }

    @Override
    public DBFolderTreeEditable initialize() {
        super.initialize();
        this.setCellRenderer(new DBFolderVirtualTreeRenderer());
        return this;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this._ctrlAddModel = new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_MODEL_"), ResMsgObj.getString("ACTION_ADD_MODEL_MENU"), ResMsgObj.getString("ACTION_ADD_MODEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder subfamily = ProjectFolderTree.this.getCurrentSubFamily();
                if (subfamily != null) {
                    ProjectFolderTree.this.doInsert(subfamily, (short)1);
                }
            }
        };
        this._ctrlAddModel.setEnabled(true);
        this._ctrlAddTree = new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_TREE_"), ResMsgObj.getString("ACTION_ADD_TREE_MENU"), ResMsgObj.getString("ACTION_ADD_TREE_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder subfamily = ProjectFolderTree.this.getCurrentSubFamily();
                if (subfamily != null) {
                    ProjectFolderTree.this.doInsert(subfamily, (short)2);
                }
            }
        };
        this._ctrlAddTree.setEnabled(true);
        this._ctrlAddDSF = new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_DSF_"), ResMsgObj.getString("ACTION_ADD_DSF_MENU"), ResMsgObj.getString("ACTION_ADD_DSF_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder subfamily = ProjectFolderTree.this.getCurrentSubFamily();
                if (subfamily != null) {
                    ProjectFolderTree.this.doInsert(subfamily, (short)3);
                }
            }
        };
        this._ctrlAddDSF.setEnabled(true);
        this._ctrlAddFMEA = new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_FMEA_"), ResMsgObj.getString("ACTION_ADD_FMEA_MENU"), ResMsgObj.getString("ACTION_ADD_FMEA_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder subfamily = ProjectFolderTree.this.getCurrentSubFamily();
                if (subfamily != null) {
                    ProjectFolderTree.this.doInsert(subfamily, (short)4);
                }
            }
        };
        this._ctrlAddFMEA.setEnabled(true);
        this._actionImportDAG = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder folder = ProjectFolderTree.this.getSystemForTreeFolder();
                if (folder != null) {
                    ProjectFolderTree.this.doImport(folder, ImportFormat.DAG);
                }
            }
        };
        this._actionImportARB = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder folder = ProjectFolderTree.this.getSystemForTreeFolder();
                if (folder != null) {
                    ProjectFolderTree.this.doImport(folder, ImportFormat.ARB);
                }
            }
        };
        this._actionImportCAFTA = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder folder = ProjectFolderTree.this.getSystemForTreeFolder();
                if (folder != null) {
                    CmdImportCafta importCaftaCmd = new CmdImportCafta(ProjectFolderTree.this.getAppl(), ProjectFolderTree.this, folder);
                    importCaftaCmd.realiseDo();
                }
            }
        };
        this._actionImportFTp = new CeciliaAction(ResMsgCecilia.getString("MENU_IMPORT_FTP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CmdImportPrepareFtp cmd = new CmdImportPrepareFtp(ProjectFolderTree.this.getAppl(), ProjectFolderTree.this.getAppl().getTopWindow());
                cmd.realiseDo();
            }
        };
        this._actionExportOcas4 = new CeciliaAction(ResMsgVoc.getString("VOC_EXPORT") + " OCAS 4.0"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProjectFolderTree.this.getSelectionCount() == 0) {
                    return;
                }
                TreePath[] selPaths = ProjectFolderTree.this.getSelectionPaths();
                ArrayList<DBFolder> selFolders = ProjectFolderTree.this.convertTreePathsToFolders(selPaths);
                if (selFolders.size() == 0) {
                    return;
                }
                CmdExportOCAS4 cmd = new CmdExportOCAS4(ProjectFolderTree.this.getAppl(), ProjectFolderTree.this, selFolders, ProjectFolderTree.this._model.getDBUser());
                cmd.realiseDo();
            }
        };
    }

    private DBFolder getSystemForTreeFolder() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        if (!(this.getSelectionPath().getLastPathComponent() instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)) {
            return null;
        }
        DBFolderVirtualTreeModel.DBFolderVirtualTreeNode selectNode = (DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectNode == null) {
            return null;
        }
        if (selectNode.isReadOnly()) {
            return null;
        }
        switch (selectNode.getFamilyFlag()) {
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                return null;
            }
        }
        DBFolder folder = selectNode.getSource();
        if (folder.getDepthUntilSystem() == folder.getFamily().getDepthFolder()) {
            return folder;
        }
        return null;
    }

    private DBFolder getCurrentSubFamily() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        if (!(this.getSelectionPath().getLastPathComponent() instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)) {
            return null;
        }
        DBFolderVirtualTreeModel.DBFolderVirtualTreeNode selectNode = (DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectNode == null) {
            return null;
        }
        if (selectNode.isReadOnly()) {
            return null;
        }
        if (selectNode.getFamilyFlag() != 0) {
            return null;
        }
        DBFolder folder = selectNode.getSource();
        if (selectNode.isFolderSystem()) {
            return folder;
        }
        if (folder.getDepthUntilSystem() == folder.getFamily().getDepthFolder()) {
            return folder;
        }
        return null;
    }

    @Override
    protected void createPopupMenu() {
        super.createPopupMenu();
        this._popupTypes = new JPopupMenu();
        this._popupTypes.add(this._ctrlAddFolder);
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlAddModel);
        this._popupTypes.add(this._ctrlAddTree);
        this._popupTypes.add(this._ctrlAddDSF);
        this._popupTypes.add(this._ctrlAddFMEA);
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlProp);
        this._popupTypes.add(this._ctrlRename);
        this._popupTypes.add(this._ctrlCompareObjects);
        this._popupTypes.add(this._ctrlDel);
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlCopy);
        this._popupTypes.add(this._ctrlCut);
        this._popupTypes.add(this._ctrlPaste);
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlExpand);
        this._popupTypes.add(this._ctrlCollapse);
        this._popupTypes.add(this._ctrlRefresh);
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlExport);
        if (this.getAppl().isDebugMode()) {
            this._popupTypes.add(this._actionExportOcas4);
            this._popupTypes.add(this._ctrlAnonymize);
        }
        this._popupTypes.add(this.createImportMenu());
        if (this.getAppl().isDebugMode()) {
            this._popupTypes.addSeparator();
            this._popupTypes.add(this._ctrlDebug);
            this._popupTypes.add(this._ctrlDependDown);
            this._popupTypes.add(this._ctrlDependUp);
        }
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlFreeze);
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlAddFolder);
        popupList.addSeparator();
        popupList.add(this._ctrlAdd);
        popupList.add(this._ctrlEdit);
        popupList.add(this._ctrlProp);
        popupList.add(this._ctrlRename);
        popupList.add(this._ctrlCompareObjects);
        popupList.add(this._ctrlDel);
        popupList.addSeparator();
        popupList.add(this._ctrlCopy);
        popupList.add(this._ctrlCut);
        popupList.add(this._ctrlPaste);
        popupList.addSeparator();
        popupList.add(this._ctrlExpand);
        popupList.add(this._ctrlCollapse);
        popupList.add(this._ctrlRefresh);
        popupList.addSeparator();
        popupList.add(this._ctrlExport);
        if (this.getAppl().isDebugMode()) {
            popupList.add(this._actionExportOcas4);
            popupList.add(this._ctrlAnonymize);
        }
        popupList.add(this.createImportMenu());
        if (this.getAppl().isDebugMode()) {
            popupList.addSeparator();
            popupList.add(this._ctrlEditWithoutCache);
            popupList.add(this._ctrlDebug);
            popupList.add(this._ctrlDependDown);
            popupList.add(this._ctrlDependUp);
        }
        popupList.addSeparator();
        popupList.add(this._ctrlFreeze);
        return popupList;
    }

    private JMenu createImportMenu() {
        JMenu importMenu = new JMenu(ResMsgVoc.getString("VOC_IMPORT"));
        importMenu.setIcon(ResIcoCore.getImageIcon("IE_IMPORT"));
        importMenu.add(this.getAppl().getTopWindow().getDelegateAction("IMPORT_DAGDEF").createMenuItem());
        importMenu.add(this.getAppl().getTopWindow().getDelegateAction("IMPORT_ARB").createMenuItem());
        importMenu.add(this.getAppl().getTopWindow().getDelegateAction("IMPORT_CAFTA").createMenuItem());
        importMenu.add(this._actionImportFTp);
        return importMenu;
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        if (this.getCurrentSubFamily() != null) {
            return this._popupTypes;
        }
        return super.getComponentPopupMenu();
    }

    @Override
    protected void refreshActions() {
        TreePath selPath;
        DBFolderTreeNode selectNode;
        super.refreshActions();
        if (this.getSelectionCount() == 1 && (selectNode = (DBFolderTreeNode)(selPath = this.getSelectionPath()).getLastPathComponent()) instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode) {
            short subFamily = ((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).getFamilyFlag();
            if (subFamily != 0) {
                this._ctrlEdit.setEnabled(false);
                this._ctrlEditWithoutCache.setEnabled(false);
                this._ctrlProp.setEnabled(false);
                this._ctrlRename.setEnabled(false);
                this._ctrlCopy.setEnabled(false);
                this._ctrlCut.setEnabled(false);
            }
            if (subFamily == 5) {
                this._ctrlAdd.setEnabled(false);
                this.getAppl().getTopWindow().getDelegateAction("FOLDER_CREATE").setEnabled(this._ctrlAdd, this._ctrlAdd.isEnabled());
            }
        }
        boolean isCurrentSystem = this.getCurrentSubFamily() != null;
        this._ctrlAddModel.setEnabled(isCurrentSystem);
        this._ctrlAddTree.setEnabled(isCurrentSystem);
        this._ctrlAddDSF.setEnabled(isCurrentSystem);
        this._ctrlAddFMEA.setEnabled(isCurrentSystem);
        DBFolder dbTree = this.getSystemForTreeFolder();
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_DAGDEF").setEnabled(this._actionImportDAG, dbTree != null);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_ARB").setEnabled(this._actionImportARB, dbTree != null);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_CAFTA").setEnabled(this._actionImportCAFTA, dbTree != null);
        this._actionImportFTp.setEnabled(dbTree != null);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_PROJECT").setEnabled(this._ctrlAddFolder, this._ctrlAddFolder.isEnabled());
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_MODEL").setEnabled(this._ctrlAddModel, this._ctrlAddModel.isEnabled());
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_TREE").setEnabled(this._ctrlAddTree, this._ctrlAddTree.isEnabled());
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_DSF").setEnabled(this._ctrlAddDSF, this._ctrlAddDSF.isEnabled());
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_FMEA").setEnabled(this._ctrlAddFMEA, this._ctrlAddFMEA.isEnabled());
    }

    @Override
    public void toDoWhenActivated() {
        this.getAppl().getTopWindow().getAction("CRITICITY_GLOBAL_LIST").setEnabled(true);
        this.getAppl().getTopWindow().getAction("EGL_EXTRACT").setEnabled(true);
        this.getAppl().getTopWindow().getAction("EGL_GENERATE").setEnabled(true);
        this.getAppl().getTopWindow().getAction("EGL_REGENERATE").setEnabled(true);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_PROJECT").addDelegate(this._ctrlAddFolder).setEnabled(true);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_MODEL").addDelegate(this._ctrlAddModel);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_TREE").addDelegate(this._ctrlAddTree);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_DSF").addDelegate(this._ctrlAddDSF);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_FMEA").addDelegate(this._ctrlAddFMEA);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_DAGDEF").addDelegate(this._actionImportDAG);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_ARB").addDelegate(this._actionImportARB);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_CAFTA").addDelegate(this._actionImportCAFTA);
        super.toDoWhenActivated();
        this.getAppl().getTopWindow().getDelegateAction("FOLDER_CREATE_ROOT").setName(ResMsgCore.getString("MENU_ADD_PROJECT"));
        this._ctrlAddFolder.setName(ResMsgCore.getString("MENU_ADD_PROJECT"));
    }

    @Override
    public void toDoWhenDeActivated() {
        this.getAppl().getTopWindow().getAction("CRITICITY_GLOBAL_LIST").setEnabled(false);
        this.getAppl().getTopWindow().getAction("EGL_EXTRACT").setEnabled(false);
        this.getAppl().getTopWindow().getAction("EGL_GENERATE").setEnabled(false);
        this.getAppl().getTopWindow().getAction("EGL_REGENERATE").setEnabled(false);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_PROJECT").delDelegate(this._ctrlAddFolder).setEnabled(false);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_MODEL").delDelegate(this._ctrlAddModel);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_TREE").delDelegate(this._ctrlAddTree);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_DSF").delDelegate(this._ctrlAddDSF);
        this.getAppl().getTopWindow().getDelegateAction("PROJECT_CREATE_FMEA").delDelegate(this._ctrlAddFMEA);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_DAGDEF").delDelegate(this._actionImportDAG);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_ARB").delDelegate(this._actionImportARB);
        this.getAppl().getTopWindow().getDelegateAction("IMPORT_CAFTA").delDelegate(this._actionImportCAFTA);
        super.toDoWhenDeActivated();
    }

    @Override
    public void doExpand(List<DBFolder> dbFolders, int depth) {
        TreePath[] paths;
        for (TreePath path : paths = this.getSelectionPaths()) {
            DBFolderTreeNode node = (DBFolderTreeNode)path.getLastPathComponent();
            if (!(node instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode) || node.getVirtualFamilyFlag() == 0) continue;
            DBFolder srcFolder = node.getSource();
            dbFolders.remove(srcFolder);
            for (int i = 0; i < node.getChildCount(); ++i) {
                DBFolderTreeNode child = (DBFolderTreeNode)node.getChildAt(i);
                DBFolder childFolder = child.getSource();
                if (dbFolders.contains(childFolder)) continue;
                dbFolders.add(childFolder);
            }
        }
        super.doExpand(dbFolders, depth);
    }

    @Override
    public void doCollapse(List<DBFolder> dbFolders) {
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<TreePath> pathToCollapse = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            DBFolderTreeNode node = (DBFolderTreeNode)path.getLastPathComponent();
            if (!(node instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode) || node.getVirtualFamilyFlag() == 0) continue;
            pathToCollapse.add(path);
            DBFolder srcFolder = node.getSource();
            dbFolders.remove(srcFolder);
            for (int i = 0; i < node.getChildCount(); ++i) {
                DBFolderTreeNode child = (DBFolderTreeNode)node.getChildAt(i);
                DBFolder childFolder = child.getSource();
                if (dbFolders.contains(childFolder)) continue;
                dbFolders.add(childFolder);
            }
        }
        super.doCollapse(dbFolders);
        for (TreePath path : pathToCollapse) {
            if (this.isCollapsed(path)) continue;
            this.collapsePath(path);
        }
    }

    @Override
    protected void doInsert(DBFolderTreeNode selectNode) {
        DBFolder dbFolder = selectNode.getSource();
        if (dbFolder.isVersion()) {
            this.doInsertFile(dbFolder);
            return;
        }
        if (selectNode instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode) {
            short subFamily = ((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).getFamilyFlag();
            if (subFamily != 0) {
                this.doInsert(dbFolder, subFamily);
                return;
            }
            if (((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).isFolderSystem() || dbFolder.getDepthUntilSystem() == dbFolder.getFamily().getDepthFolder()) {
                this.doInsert(dbFolder, (short)1);
                return;
            }
        }
        this.doInsert(dbFolder);
    }

    protected void doInsert(DBFolder dbParent, short subfamily) {
        if (!dbParent.isFolder()) {
            return;
        }
        DBFolder.Family familyFolder = dbParent.getFamily();
        if (familyFolder != DBFolder.Family.PROJECT) {
            return;
        }
        ProjectFolderCmdInsertModel cmd = new ProjectFolderCmdInsertModel((CAppl)this.getAppl(), (DBFolderTreeEditable)this, subfamily);
        cmd.setDBFolder(dbParent).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    @Override
    protected void doInsert(DBFolder dbParent) {
        DBFolder.Family familyFolder = dbParent.getFamily();
        if (familyFolder == DBFolder.Family.APPLICATION) {
            return;
        }
        ProjectFolderCmdProperty cmd = new ProjectFolderCmdProperty(this.getAppl(), this, false);
        cmd.setDBFolder(dbParent).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    @Override
    protected void doDelete(TreePath[] selPaths) {
        LinkedHashSet<DBFolderTreeNode> selFolders = new LinkedHashSet<DBFolderTreeNode>();
        for (int i = 0; i < selPaths.length; ++i) {
            DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            if (selectNode instanceof DBFolderTreeNodeFile) {
                selFolders.add(selectNode);
                continue;
            }
            if (selectNode.getSource().isSystem()) continue;
            if (selectNode instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode) {
                short subFamily = ((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).getFamilyFlag();
                if (subFamily != 0) {
                    Enumeration iter = selectNode.children();
                    while (iter.hasMoreElements()) {
                        selFolders.add((DBFolderTreeNode)iter.nextElement());
                    }
                    continue;
                }
                selFolders.add(selectNode);
                continue;
            }
            selFolders.add(selectNode);
        }
        if (selFolders.size() > 0) {
            this.doDelete(new ArrayList<DBFolderTreeNode>(selFolders));
        }
    }

    @Override
    public ArrayList<DBFolder> convertTreePathsToFolders(TreePath[] selPaths) {
        LinkedHashSet<DBFolder> selFolders = new LinkedHashSet<DBFolder>();
        for (int i = 0; i < selPaths.length; ++i) {
            DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            if (selectNode instanceof DBFolderTreeNodeFile || selectNode.getSource().isSystem()) continue;
            if (selectNode instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode) {
                short subFamily = ((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).getFamilyFlag();
                if (subFamily != 0) {
                    Enumeration iter = selectNode.children();
                    while (iter.hasMoreElements()) {
                        selFolders.add(((DBFolderTreeNode)iter.nextElement()).getSource());
                    }
                    continue;
                }
                selFolders.add(selectNode.getSource());
                continue;
            }
            selFolders.add(selectNode.getSource());
        }
        return new ArrayList<DBFolder>(selFolders);
    }

    @Override
    protected void doEdit(DBFolder folder, boolean readOnly) {
        if (folder.getFamily() != DBFolder.Family.PROJECT) {
            return;
        }
        if (folder.isVersion()) {
            switch (folder.getFamilyFlag()) {
                case 1: {
                    DBSystemCmdEdit cmd = new DBSystemCmdEdit(this.getAppl(), this, folder, readOnly);
                    cmd.realiseDo();
                    break;
                }
                case 2: 
                case 5: {
                    FTEquationCmdEdit cmd = new FTEquationCmdEdit(this.getAppl(), this, folder, readOnly);
                    cmd.realiseDo();
                    break;
                }
                case 3: {
                    DSFEquationCmdEdit cmd = new DSFEquationCmdEdit(this.getAppl(), this, folder, readOnly);
                    cmd.realiseDo();
                    break;
                }
                case 4: {
                    DBTableFMEACmdEdit cmd = new DBTableFMEACmdEdit(this.getAppl(), this, folder, readOnly);
                    cmd.realiseDo();
                }
            }
        } else if (folder.isFolder() && folder.getDepthUntilSystem() == 1) {
            DBProjectCmdEdit cmd = new DBProjectCmdEdit(this.getAppl(), this, folder, readOnly);
            cmd.realiseDo();
        }
    }

    protected void doImport(DBFolder folder, ImportFormat format) {
        switch (format) {
            case DAG: {
                CmdImportTreeDag cmd = new CmdImportTreeDag(this.getAppl(), this, folder);
                cmd.realiseDo();
                break;
            }
            case ARB: {
                CmdImportTreeArb cmd = new CmdImportTreeArb(this.getAppl(), this, folder);
                cmd.realiseDo();
            }
        }
    }

    private static enum ImportFormat {
        DAG,
        ARB;

    }
}

