/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ArborButtonOperator
extends JButton
implements ActionListener {
    private static Logger _LOG = Logger.getLogger(ArborButtonOperator.class.getPackage().getName());
    JPopupMenu _popupMenu;

    public ArborButtonOperator() {
        super(ResIcoArbor.getImageIcon("PAND"));
        this.addActionListener(this);
        this.make();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point barreLocation = this.getLocation();
        Dimension barreSize = this.getPreferredSize();
        Dimension menuSize = this._popupMenu.getPreferredSize();
        int y = barreLocation.y + barreSize.height + 2;
        int x = barreLocation.x + barreSize.width - menuSize.width;
        this._popupMenu.show(this, x, y);
    }

    private void make() {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String parametre = e.getActionCommand();
                String valeur = new String("");
                int position = parametre.indexOf("-");
                if (position != -1) {
                    valeur = parametre.substring(position + 1);
                    parametre = parametre.substring(0, position);
                }
                _LOG.finest("Call ArborButtonCmd [parameter=" + parametre + ", value=" + valeur + "]");
            }
        };
        this._popupMenu = new JPopupMenu();
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PAND"), action, Integer.toString(2));
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PNAND"), action, Integer.toString(3));
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("POR"), action, Integer.toString(1));
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PNOR"), action, Integer.toString(4));
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PXOR"), action, Integer.toString(7));
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PNXOR"), action, Integer.toString(6));
        JMenu menuKofN = new JMenu();
        menuKofN.setIcon(ResIcoArbor.getImageIcon("PN"));
        this.addOperator((Container)menuKofN, "2", action, Integer.toString(5) + "-2");
        this.addOperator((Container)menuKofN, "3", action, Integer.toString(5) + "-3");
        this.addOperator((Container)menuKofN, "4", action, Integer.toString(5) + "-4");
        this.addOperator((Container)menuKofN, "5", action, Integer.toString(5) + "-5");
        this.addOperator((Container)menuKofN, "6", action, Integer.toString(5) + "-6");
        this.addOperator((Container)menuKofN, "7", action, Integer.toString(5) + "-7");
        this.addOperator((Container)menuKofN, "8", action, Integer.toString(5) + "-8");
        this.addOperator((Container)menuKofN, "9", action, Integer.toString(5) + "-9");
        this.addOperator((Container)menuKofN, "10", action, Integer.toString(5) + "-10");
        this.addOperator((Container)menuKofN, ResMsgVoc.getString("VOC_MORE"), action, Integer.toString(5) + "-Plus");
        this._popupMenu.add(menuKofN);
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PNOT"), action, Integer.toString(8));
        this.addOperator((Container)this._popupMenu, ResIcoArbor.getImageIcon("PITE"), action, Integer.toString(9));
    }

    private void addOperator(Container menu, Icon icon, ActionListener action, String cmd) {
        JMenuItem item = new JMenuItem(icon);
        item.setActionCommand(cmd);
        item.addActionListener(action);
        menu.add(item);
    }

    private void addOperator(Container menu, String txt, ActionListener action, String cmd) {
        JMenuItem item = new JMenuItem(txt);
        item.setActionCommand(cmd);
        item.addActionListener(action);
        menu.add(item);
    }

    public static interface ArborOperateur {
        public static final int ss_nop = 0;
        public static final int ss_or = 1;
        public static final int ss_and = 2;
        public static final int ss_nand = 3;
        public static final int ss_nor = 4;
        public static final int ss_n = 5;
        public static final int ss_nxor = 6;
        public static final int ss_xor = 7;
        public static final int ss_not = 8;
        public static final int ss_ite = 9;
        public static final int ss_suite = 10;
        public static final int ss_gsr = 11;
        public static final int ss_subtree = 12;
        public static final int ss_unlinksubtree = 13;
        public static final int ss_normal = 0;
        public static final int ss_vrai = 1;
        public static final int ss_faux = 2;
        public static final int ss_droite = 1;
        public static final int ss_gauche = 2;
        public static final int ss_bas = 3;
        public static final String[] _tabOperateur = new String[]{"SANS", "OU", "AND", "NAND", "NOR", "N", "NXOR", "XOR", "NOT", "ITE", "SUITE", "SUBTREE", "SUBTREE"};
    }
}

