/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CaptureAction;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.main.cecilia.gui.CDesktopPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class CInternalFrame
extends JInternalFrame {
    private static Logger _LOG = Logger.getLogger(CInternalFrame.class.getPackage().getName());
    private JPopupMenu _popupMenu = new JPopupMenu();
    private JMenuItem _itemRestaurer = new JMenuItem(ResMsgVoc.getString("VOC_RESORE"));
    private JMenuItem _itemMinimum = new JMenuItem(ResMsgVoc.getString("VOC_REDUCE"));
    private JMenuItem _itemMaximum = new JMenuItem(ResMsgVoc.getString("VOC_ENLARGE"));
    public JMenuItem _itemFermer = new JMenuItem(ResMsgVoc.getString("VOC_CLOSE"));
    boolean _bActived = false;
    protected CDesktopPane _desktop;
    protected IconeButton _iconeButton;
    protected JButton _ctrlClose;

    public DBFolder getDBFolder() {
        return null;
    }

    public CInternalFrame(ImageIcon icone, String iconeLabel, String str) {
        super(str);
        this.init(iconeLabel);
        this._iconeButton.setIcon(icone);
        this._iconeButton.setText(iconeLabel);
        this._iconeButton.setToolTipText(str);
    }

    public CInternalFrame(ImageIcon icone, String str) {
        super(str);
        this.init(str);
        this._iconeButton.setIcon(icone);
        this._iconeButton.setText(str);
        this._iconeButton.setToolTipText(str);
    }

    public CInternalFrame(String str) {
        super(str);
        this.init(str);
        this._iconeButton.setText(str);
        this._iconeButton.setToolTipText(str);
    }

    public boolean isAtLocation(int x, int y) {
        return x >= this.getLocation().x && x <= this.getLocation().x + this.getSize().width && y >= this.getLocation().y && y <= this.getLocation().y + this.getSize().height;
    }

    public void setButtonIcon(Icon image) {
        if (this._iconeButton != null) {
            this._iconeButton.setIcon(image);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this._desktop != null) {
            if (visible) {
                this.selectThisFrame();
                this._desktop.getIconesBox().addComponent(this._iconeButton);
            } else {
                if (this._desktop.getDesktop().getSelectedFrame() == this) {
                    this._desktop.getDesktop().setSelectedFrame(null);
                }
                if (this._iconeButton != null) {
                    this._desktop.getIconesBox().delComponent(this._iconeButton);
                }
            }
            if (visible) {
                this.moveToFront();
            } else {
                this.moveToBack();
            }
        }
        super.setVisible(visible);
    }

    private void init(String str) {
        this.addInternalFrameListener(new InternalFrameAdapter(){
            boolean _isClosing = false;

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest(this.createTrace("internalFrameOpened     ", e));
                }
                CInternalFrame.this.toDoWhenBeOpened();
                CInternalFrame.this.getDesktopPane().getDesktopManager().openFrame(CInternalFrame.this);
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest(this.createTrace("internalFrameActived    ", e));
                }
                CInternalFrame.this.activated();
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest(this.createTrace("internalFrameClosing    ", e));
                }
                if (this._isClosing) {
                    return;
                }
                this._isClosing = true;
                try {
                    if (!CInternalFrame.this.toDoWhenClosing()) {
                        CInternalFrame.this.setDefaultCloseOperation(0);
                    } else {
                        CInternalFrame.this.setDefaultCloseOperation(1);
                        if (CInternalFrame.this.getDesktopPane() != null) {
                            CInternalFrame.this.getDesktopPane().getDesktopManager().closeFrame(CInternalFrame.this);
                        }
                    }
                }
                finally {
                    this._isClosing = false;
                }
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest(this.createTrace("internalFrameClosed     ", e));
                }
                CInternalFrame.this.toDoWhenBeClosed();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest(this.createTrace("internalFrameDeactivated", e));
                }
                CInternalFrame.this.deactivated();
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
                if (_LOG.isLoggable(Level.FINEST)) {
                    _LOG.finest(this.createTrace("internalFrameIconified  ", e));
                }
                CInternalFrame.this._itemRestaurer.setEnabled(true);
                CInternalFrame.this._itemMinimum.setEnabled(false);
                CInternalFrame.this._itemMaximum.setEnabled(CInternalFrame.this.isMaximizable());
                CInternalFrame.this.iconifyView();
            }

            private String createTrace(String msg, InternalFrameEvent e) {
                JInternalFrame iframe = e.getInternalFrame();
                StringBuilder buffer = new StringBuilder(256);
                buffer.append(msg).append("(");
                buffer.append(iframe.getClass().getSimpleName()).append(":");
                buffer.append("'").append(iframe.getTitle()).append("'");
                return buffer.append(")").toString();
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                CInternalFrame.this.toDoWhenFrameDragged();
            }
        });
        this.setResizable(true);
        this.setIconifiable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this._popupMenu.add(this._itemRestaurer);
        this._itemRestaurer.setEnabled(false);
        this._popupMenu.add(this._itemMinimum);
        this._popupMenu.add(this._itemMaximum);
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._itemFermer);
        this._iconeButton = new IconeButton(str);
        this._iconeButton.setFocusPainted(false);
        this._iconeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CInternalFrame.this.pressIconButton();
            }
        });
        this._iconeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.treatMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.treatMouseEvent(e);
            }

            public void treatMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point screenPoint = e.getPoint();
                    SwingUtilities.convertPointToScreen(screenPoint, CInternalFrame.this._iconeButton);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Point point = e.getPoint();
                    CInternalFrame.this._popupMenu.show(CInternalFrame.this._iconeButton, point.x, point.y);
                    if (screenPoint.x + ((CInternalFrame)CInternalFrame.this)._popupMenu.getSize().width > screenSize.width) {
                        screenPoint.setLocation(screenPoint.x - ((CInternalFrame)CInternalFrame.this)._popupMenu.getSize().width, screenPoint.y);
                    }
                    if (screenPoint.y + ((CInternalFrame)CInternalFrame.this)._popupMenu.getSize().height > screenSize.height) {
                        screenPoint.setLocation(screenPoint.x, screenPoint.y - (((CInternalFrame)CInternalFrame.this)._popupMenu.getSize().height - screenSize.height + screenPoint.y));
                    }
                    CInternalFrame.this._popupMenu.setLocation(screenPoint.x, screenPoint.y);
                }
            }
        });
        this._itemRestaurer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CInternalFrame.this.doRestoreAction();
            }
        });
        this._itemMinimum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CInternalFrame.this.setIcon(true);
                    CInternalFrame.this._desktop.getDesktop().setSelectedFrame(null);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                CInternalFrame.this._itemRestaurer.setEnabled(true);
                CInternalFrame.this._itemMinimum.setEnabled(false);
                CInternalFrame.this._itemMaximum.setEnabled(CInternalFrame.this.isMaximizable());
            }
        });
        this._itemMaximum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (CInternalFrame.this.isIcon()) {
                        CInternalFrame.this.setIcon(false);
                    }
                    CInternalFrame.this.selectThisFrame();
                    CInternalFrame.this.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                CInternalFrame.this._itemRestaurer.setEnabled(true);
                CInternalFrame.this._itemMinimum.setEnabled(true);
                CInternalFrame.this._itemMaximum.setEnabled(false);
            }
        });
        this._itemFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CInternalFrame.this.close();
            }
        });
        this.getActionMap().put("SCREEN_CAPTURE", new CaptureAction(this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift alt F12"), "SCREEN_CAPTURE");
    }

    protected void doRestoreAction() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
                this.selectThisFrame();
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this._itemRestaurer.setEnabled(false);
        this._itemMinimum.setEnabled(true);
        this._itemMaximum.setEnabled(!this.isMaximum());
    }

    private void close() {
        try {
            this.moveToBack();
            this.setClosed(true);
            this.getInputMap(2).remove(KeyStroke.getKeyStroke("ctrl shift alt F12"));
            if (this._desktop.getDesktop().getSelectedFrame() == this) {
                this._desktop.getDesktop().setSelectedFrame(null);
            }
            this._desktop.getIconesBox().delComponent(this._iconeButton);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setMaximum(boolean etat) throws PropertyVetoException {
        super.setMaximum(etat);
        this._itemRestaurer.setEnabled(etat);
        this._itemMinimum.setEnabled(true);
        this._itemMaximum.setEnabled(this.isMaximizable() && !etat);
        this.toDoWhenFrameDragged();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.toDoWhenReshaped();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.toDoWhenReshaped();
    }

    protected void toDoWhenReshaped() {
    }

    private void pressIconButton() {
        if (this.isIcon()) {
            try {
                this.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.selectThisFrame();
            this._itemRestaurer.setEnabled(this.isMaximum());
            this._itemMinimum.setEnabled(true);
            this._itemMaximum.setEnabled(this.isMaximizable() && !this.isMaximum());
        } else if (!this.isSelected()) {
            this.selectThisFrame();
        }
    }

    private void selectThisFrame() {
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void iconifyView() {
        this.getDesktopIcon().setVisible(false);
    }

    public void showView(CDesktopPane desktop) {
        if (this._desktop != null) {
            // empty if block
        }
        this._desktop = desktop;
        int width = Math.min(this.getSize().width, this._desktop.getDesktop().getSize().width);
        int height = Math.min(this.getSize().height, this._desktop.getDesktop().getSize().height);
        this.setSize(width, height);
        try {
            this.setClosed(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this._desktop.getDesktop().add((Component)this, JLayeredPane.DEFAULT_LAYER);
        this.setVisible(true);
        this.toFront();
    }

    public boolean toDoWhenClosing() {
        return true;
    }

    public void toDoWhenFrameDragged() {
    }

    public void activated() {
        this._iconeButton.setBackground(Color.gray);
        if (!this._bActived) {
            this._bActived = true;
            this.toDoWhenActivated();
        }
    }

    protected void toDoWhenActivated() {
    }

    public void deactivated() {
        this._iconeButton.setBackground(this._desktop.getIconesBox().getPanelContainer().getBackground());
        if (this._bActived) {
            this._bActived = false;
            this.toDoWhenDeActivated();
        }
    }

    protected void toDoWhenDeActivated() {
    }

    public void toDoWhenBeOpened() {
    }

    public void toDoWhenBeClosed() {
    }

    public void cut() {
        _LOG.severe("La methode 'cut' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
    }

    public void copy() {
        _LOG.severe("La methode 'copy' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
    }

    public void paste() {
        _LOG.severe("La methode 'paste' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
    }

    public void selectAll() {
        _LOG.severe("La methode 'selectAll' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
    }

    public boolean isModified() {
        return false;
    }

    protected boolean save() {
        _LOG.severe("La methode 'save' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
        return false;
    }

    protected void saveAs() {
        _LOG.severe("La methode 'saveAs' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
    }

    public boolean print() {
        _LOG.severe("La methode 'print' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
        return false;
    }

    public boolean preview() {
        _LOG.severe("La methode 'preview' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
        return false;
    }

    public Object export(String format) {
        _LOG.severe("La methode 'export' n'est pas implementee pour cette fenetre : " + this.getClass().getName());
        if (format.equalsIgnoreCase("DOCBOOK") || format.equalsIgnoreCase("XML")) {
            // empty if block
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    @Override
    public void setTitle(String str) {
        this._iconeButton.setToolTipText(new String(str));
        this._iconeButton.setText(str);
        super.setTitle(str);
    }

    protected void setIconText(String txt) {
        this._iconeButton.setText(txt);
    }

    protected void setIconToolTip(String txt) {
        this._iconeButton.setToolTipText(txt);
    }

    protected Component createClosePanel() {
        this._ctrlClose = new JButton(ResMsgVoc.getString("VOC_CLOSE"));
        this._ctrlClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CInternalFrame.this.doDefaultCloseAction();
            }
        });
        this._ctrlClose.setDefaultCapable(true);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setOpaque(false);
        panel.add(this._ctrlClose);
        return panel;
    }

    public JButton getCloseButton() {
        return this._ctrlClose;
    }

    protected Component createTitlePanel(Component center, String str) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), str), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        panel.add(center, "Center");
        return panel;
    }

    public boolean withMemorizedLocation() {
        return true;
    }

    public boolean withReorganizedFrame() {
        return true;
    }

    protected class IconeButton
    extends JButton {
        public IconeButton(String str) {
            super(str);
            this.setHorizontalAlignment(2);
            this.setMargin(new Insets(2, 1, 2, 3));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension superPref = super.getPreferredSize();
            return new Dimension(Math.max(100, superPref.width), superPref.height);
        }
    }
}

