/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.reader;

import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.db.dao.xml.DAOImportXmlFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsSimpleDlg;
import com.dassault.cecilia.io.xml6.ImportUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.reader.ResIcoReader;
import com.dassault.cecilia.main.reader.ResMsgReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class ReaderAppl
extends CeciliaAppl {
    String[] _args;

    public ReaderAppl(String[] args) {
        super(true);
        this._args = args;
    }

    private boolean openXMLImportConnection(File file) {
        DAOImportXmlFactory daoFactory = new DAOImportXmlFactory();
        this._daoFactory = new CeciliaFactory(this, daoFactory);
        ImportUtility importUtility = new ImportUtility(daoFactory);
        try {
            importUtility.readXml(new FileInputStream(file));
            List<DBLogs.Log> logs = importUtility.getLogs().getLogs(DBLogs.DBLevel.WARNING);
            if (logs.isEmpty()) {
                return true;
            }
            DBLogsSimpleDlg dlg = new DBLogsSimpleDlg(null);
            dlg.setDBLogs(importUtility.getLogs());
            dlg.setVisible(true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean standardDatabaseConnection() {
        if (this._args.length == 1) {
            File file = new File(this._args[0]);
            return this.openXMLImportConnection(file);
        }
        if (this._args.length == 0) {
            JFileChooser dlg = new JFileChooser(".");
            JChooserFileUtility.configureFileFilter(dlg, JChooserFileUtility.Type.XML);
            dlg.setFileSelectionMode(0);
            int result = dlg.showOpenDialog(null);
            if (result == 1) {
                return false;
            }
            return this.openXMLImportConnection(dlg.getSelectedFile());
        }
        return false;
    }

    @Override
    public ImageIcon getSplashIcon() {
        return ResIcoReader.getImageIcon("SPLASH_READER");
    }

    @Override
    public String getTitle() {
        return ResMsgReader.getString("TITLE_READER");
    }

    @Override
    public boolean verifyLicense(StringBuffer msgLicense) {
        return true;
    }

    @Override
    public String getModuleName() {
        return "READER";
    }
}

