/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefArchitecture;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefEquipment;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDomain;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JSheduler;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JSimulStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JValue;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;
import com.dassault.cecilia.lib.util.collection.LinkedStack;
import com.dassault.cecilia.lib.util.collection.Stack;
import com.dassault.cecilia.lib.util.loader.JarClassLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSimulator
implements Stepper {
    JDefNode _main;
    Locale _language;
    private ArrayList<JTrans> _transs;
    private ArrayList<JVariable> _flows;
    private ArrayList<JVariable> _states;
    Stack _stackStep;
    JSimulStep _currentStep;
    HashSet<String> _simulNames;
    private LinkedList<JDefNode> _simulNodes;
    private PrintStream _monitoring;
    private int _levelMonitor;
    JSheduler _sheduler;
    JDefArchitecture _architect;
    private boolean _autoDeterminist = false;
    private static Comparator<JVariable> __JVarComparator = new Comparator<JVariable>(){

        @Override
        public int compare(JVariable o1, JVariable o2) {
            return o1.getPathName().compareTo(o2.getPathName());
        }
    };
    private static Comparator<JTrans> __JTransComparator = new Comparator<JTrans>(){

        @Override
        public int compare(JTrans o1, JTrans o2) {
            return o1.getEvent().getPathName().compareTo(o2.getEvent().getPathName());
        }
    };
    public static final String PROP_JSTEPPER_LOOPMAXCHANGE = "cecilia.mbsa.jstepper.LoopChangeMax";
    public static final String PROP_JSTEPPER_MONITORNIG = "cecilia.mbsa.jstepper.DefaultMonitoring";
    static final String PROP_JSTEPPER_MONITORING_VARIABLE = "cecilia.mbsa.jstepper.MonitoringVariables";
    private static final String PROP_JSTEPPER_INIT_FASTER = "cecilia.mbsa.jstepper.InitFaster";
    long _step;
    int _maxChange;
    boolean _beginLoop;

    public JSimulator(JDefNode main, JDefArchitecture architect) {
        this._main = main;
        this._architect = architect;
        this._transs = new ArrayList(100);
        this._flows = new ArrayList(100);
        this._states = new ArrayList(100);
        this._stackStep = new LinkedStack();
        this._simulNames = new HashSet();
        this._simulNodes = new LinkedList();
        this._step = 0L;
        this._maxChange = Integer.getInteger(PROP_JSTEPPER_LOOPMAXCHANGE, 3);
        this._monitoring = null;
        this._levelMonitor = 0;
        main.compile(this);
        Collections.sort(this._transs, __JTransComparator);
        int cpt = 0;
        for (JTrans trans : this._transs) {
            trans.setIdx(cpt++);
        }
        Collections.sort(this._states, __JVarComparator);
        Collections.sort(this._flows, __JVarComparator);
        this._sheduler = new JSheduler(this);
        String defMonitor = System.getProperty(PROP_JSTEPPER_MONITORNIG);
        if (defMonitor == null || defMonitor.length() == 0) {
            defMonitor = "1 stderr";
        }
        this.defineMonitoring(defMonitor);
    }

    @Override
    public long getUID() {
        return this._architect.getUID();
    }

    @Override
    public boolean withSimul() {
        return true;
    }

    @Override
    public boolean withDomain() {
        return true;
    }

    void addFlow(JVariable var) {
        this._flows.add(var);
    }

    void addState(JVariable var) {
        this._states.add(var);
    }

    void addTrans(JTrans tr) {
        this._transs.add(tr);
    }

    private void incStep() {
        this._step = this._step == Long.MAX_VALUE ? 0L : ++this._step;
        this._beginLoop = false;
    }

    long getCurrentStep() {
        return this._step;
    }

    int getMaxChange() {
        return this._maxChange;
    }

    void setMaxChange(int value) {
        this._maxChange = value;
    }

    void setBeginLoop(boolean b) {
        this._beginLoop = b;
    }

    boolean getBeginLoop() {
        return this._beginLoop;
    }

    void setMonitoring(PrintStream monitor, int level) {
        if (this._monitoring != null && this._monitoring != System.out && this._monitoring != System.err) {
            this._monitoring.close();
        }
        this._monitoring = monitor;
        this._levelMonitor = level;
    }

    boolean withMonitoring(int level) {
        return level <= this._levelMonitor && this._monitoring != null;
    }

    void monitor(String text) {
        if (this._monitoring != null) {
            this._monitoring.print(text);
        }
    }

    @Override
    public int getNbrTransition() {
        return this._transs.size();
    }

    JTrans getTransition(int i) {
        return this._transs.get(i);
    }

    @Override
    public String getNameOfTransition(int i) {
        JTrans tr = this._transs.get(i - 1);
        return tr.getEvent().getPathName();
    }

    @Override
    public String getDescOfTransition(int i) {
        JTrans tr = this._transs.get(i - 1);
        return tr.getDescription();
    }

    @Override
    public int getNbrState() {
        return this._states.size();
    }

    @Override
    public String getNameOfState(int i) {
        JVariable var = this._states.get(i - 1);
        return var.getPathName();
    }

    @Override
    public double getValueOfState(int i) {
        JVariable var = this._states.get(i - 1);
        return var.getValue();
    }

    @Override
    public String getValueStringOfState(int i) {
        JVariable var = this._states.get(i - 1);
        return var.getDomain().toString(var.getValue());
    }

    @Override
    public int getNbrFlow() {
        return this._flows.size();
    }

    @Override
    public String getNameOfFlow(int i) {
        JVariable var = this._flows.get(i - 1);
        return var.getPathName();
    }

    @Override
    public double getValueOfFlow(int i) {
        JVariable var = this._flows.get(i - 1);
        return var.getValue();
    }

    @Override
    public String getValueStringOfFlow(int i) {
        JVariable var = this._flows.get(i - 1);
        return var.getDomain().toString(var.getValue());
    }

    @Override
    public int getDomainOfFlow(int i) {
        JVariable var = this._flows.get(i - 1);
        return var.getDomain().getIdx();
    }

    @Override
    public int getDomainOfState(int i) {
        JVariable var = this._states.get(i - 1);
        return var.getDomain().getIdx();
    }

    @Override
    public List<String> getValuesOfDomain(int i) {
        JDomain dom = this._architect.getDomain(i);
        if (dom == null) {
            return null;
        }
        return dom.getValues();
    }

    @Override
    public List<Double> getDoubleValuesOfDomain(int i) {
        JDomain dom = this._architect.getDomain(i);
        if (dom == null) {
            return null;
        }
        return dom.getDoubleValues();
    }

    @Override
    public double getCurrentTime() {
        return this._sheduler.getCurrentTime();
    }

    @Override
    public int getCurrentCycle() {
        return this._sheduler.getCurrentLoop();
    }

    @Override
    public int[] getSheduler() {
        return this._sheduler.getSheduler();
    }

    @Override
    public boolean setSimulOptions(List<String> args) {
        if (!this._sheduler.setSimulOptions(args)) {
            return false;
        }
        for (String option : args) {
            String optVal;
            String key = JSimulator.getKey(option);
            if (key.equals("monitoring")) {
                optVal = JSimulator.getValue(option);
                this.defineMonitoring(optVal);
                continue;
            }
            if (key.equals("loop.change.max")) {
                optVal = JSimulator.getValue(option);
                int maxChange = Integer.parseInt(optVal);
                if (maxChange < 0) continue;
                this._maxChange = maxChange;
                continue;
            }
            if (!key.equals("determinist.auto")) continue;
            this._autoDeterminist = JSimulator.getValue(option).equals("true");
        }
        return true;
    }

    void defineMonitoring(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        int level = 6;
        Pattern pattern = Pattern.compile("^([0-9]+)");
        Matcher match = pattern.matcher(value);
        if (match.find()) {
            level = Integer.parseInt(match.group(1));
            value = value.substring(match.end(1)).trim();
        }
        if (value.equals("stdout")) {
            this.setMonitoring(System.out, level);
        } else if (value.equals("stderr")) {
            this.setMonitoring(System.err, level);
        } else if (value.equals("null")) {
            this.setMonitoring(null, level);
        } else {
            try {
                FileOutputStream fout = new FileOutputStream(value);
                PrintStream pout = new PrintStream(fout, true);
                this.setMonitoring(pout, level);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void goInitialState_normal() throws StepperException {
        block11: {
            JDefNode _currentNode = null;
            try {
                int verifyCpt = 0;
                while (!this._simulNodes.isEmpty()) {
                    int nbrNaN;
                    _currentNode = this._simulNodes.removeFirst();
                    this._simulNames.remove(_currentNode.getPathName());
                    if (this.withMonitoring(9)) {
                        this.monitor(">> simulStack : " + _currentNode.getPathName() + "\n");
                    }
                    if ((nbrNaN = _currentNode.doInitAssert()) > 0) {
                        if (this.withMonitoring(9)) {
                            this.monitor(">>>> NbrNaN = " + nbrNaN + " >>>> move at end\n");
                        }
                        if (_currentNode._flag == nbrNaN) {
                            if (verifyCpt++ > this._simulNodes.size()) {
                                if (this.withMonitoring(1)) {
                                    this.monitor("Exception : Unvaluable flow in loop\n");
                                }
                                throw new StepperViolatedAssertionException(MsgJStep.getString("EXC_STEP_LOOP_GO_INITIAL_STATE"));
                            }
                        } else {
                            verifyCpt = 0;
                        }
                        this._simulNodes.addLast(_currentNode);
                        this._simulNames.add(_currentNode.getPathName());
                    } else {
                        verifyCpt = 0;
                    }
                    _currentNode._flag = nbrNaN;
                }
            }
            catch (StepperViolatedAssertionException e) {
                if (_currentNode == null) break block11;
                StringBuffer sb = new StringBuffer(128);
                sb.append(e.getMessage());
                sb.append("\n");
                sb.append(MsgJStep.msgFormat("EXC_STEP_EXC_GO_INITIAL_STATE", _currentNode.getPathName(), _currentNode.getNodeName()));
                sb.append("\n");
                throw new StepperViolatedAssertionException(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goInitialState() throws StepperException {
        File initFile;
        MsgJStep.LOG.finer("[JSimulator.goInitialState] Start " + Integer.toHexString(super.hashCode()));
        if (this.withMonitoring(6)) {
            this.monitor("goInitialState()\n");
        }
        this._stackStep.clear();
        this._currentStep = null;
        this.incStep();
        this._main.init(false);
        this._main.propageFlag(0);
        Map<String, Double> mapFlowInit = this._architect.getFlowInit();
        if (mapFlowInit != null && mapFlowInit.size() > 0) {
            HashMap<String, JVariable> mapFlow = new HashMap<String, JVariable>();
            for (int i = 0; i < this.getNbrFlow(); ++i) {
                JVariable var = this._flows.get(i);
                if (var.getSource() != var) continue;
                mapFlow.put(var.getPathName(), var);
            }
            for (Map.Entry<String, Double> init : mapFlowInit.entrySet()) {
                JVariable var = (JVariable)mapFlow.get(init.getKey());
                if (var == null || var.getSource() != var) continue;
                var.setPackageValue(init.getValue());
            }
        } else if (Boolean.getBoolean(PROP_JSTEPPER_INIT_FASTER) && (initFile = new File(System.getProperty("java.io.tmpdir"), this._architect.getIdentify() + ".init")).exists()) {
            HashMap<String, JVariable> mapFlow = new HashMap<String, JVariable>();
            for (int i = 0; i < this.getNbrFlow(); ++i) {
                JVariable var = this._flows.get(i);
                if (var.getSource() != var) continue;
                mapFlow.put(var.getPathName(), var);
            }
            HashMap<String, Double> mapValues = new HashMap<String, Double>();
            boolean error = false;
            Object input = null;
            try {
                input = new DataInputStream(new FileInputStream(initFile));
                try {
                    while (!error) {
                        String string = ((DataInputStream)input).readUTF();
                        double value = ((DataInputStream)input).readDouble();
                        JVariable var = (JVariable)mapFlow.get(string);
                        if (var == null || var.getSource() != var) continue;
                        Double verifyValue = var.getDomain().verify(value);
                        if (verifyValue.isNaN()) {
                            error = true;
                            MsgJStep.LOG.info("InitFaster - outside value for variable " + var + ":" + var.getDomain() + " ! <= " + var.getDomain().toString(value) + "[" + value + "]");
                            continue;
                        }
                        mapValues.put(string, value);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (input != null) {
                    try {
                        ((FilterInputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!error) {
                for (Map.Entry entry : mapValues.entrySet()) {
                    JVariable var = (JVariable)mapFlow.get(entry.getKey());
                    if (var == null || var.getSource() != var) continue;
                    var.setPackageValue((Double)entry.getValue());
                }
            }
        }
        this.goInitialState_normal();
        if (Boolean.getBoolean(PROP_JSTEPPER_INIT_FASTER)) {
            initFile = new File(System.getProperty("java.io.tmpdir"), this._architect.getIdentify() + ".init");
            FileOutputStream stream = null;
            DataOutputStream output = null;
            try {
                stream = new FileOutputStream(initFile);
                output = new DataOutputStream(stream);
                for (int i = 0; i < this.getNbrFlow(); ++i) {
                    JVariable var = this._flows.get(i);
                    if (var.getSource() != var) continue;
                    output.writeUTF(var.getPathName());
                    output.writeDouble(var.getValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this._sheduler.init();
        JTrans tr = this._sheduler.update();
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        if (this.withMonitoring(8)) {
            this.monitor(">> End initiale state\n");
        }
        MsgJStep.LOG.finer("[JSimulator.goInitialState] End " + Integer.toHexString(super.hashCode()));
        return true;
    }

    void addSimulNode(JDefNode node) {
        if (!this._simulNames.contains(node.getPathName())) {
            this._simulNames.add(node.getPathName());
            this._simulNodes.addLast(node);
        } else if (node instanceof JDefEquipment && this._simulNodes.getLast() != node) {
            this._simulNodes.remove(node);
            this._simulNodes.addLast(node);
        }
    }

    private void simulStack() throws StepperViolatedAssertionException {
        while (!this._simulNodes.isEmpty()) {
            JDefNode node = this._simulNodes.removeFirst();
            this._simulNames.remove(node.getPathName());
            if (this.withMonitoring(8)) {
                this.monitor(">> simulStack : " + node.getPathName() + "\n");
            }
            node.doAssert();
        }
    }

    @Override
    public double isValidTransition(int i) throws StepperException {
        JTrans tr = this._transs.get(i - 1);
        if (tr.isValid()) {
            if (this._autoDeterminist && !tr.getEvent().isStochastic() && !this._sheduler.includeInFirst(tr)) {
                return -1.0;
            }
            return tr.getFiringTime();
        }
        return -1.0;
    }

    @Override
    public boolean setValueOfState(int i, String strValue) throws StepperException {
        JVariable var = this._states.get(i - 1);
        double value = var.getDomain().parse(strValue);
        if (Double.isNaN(value)) {
            return false;
        }
        if (this.withMonitoring(6)) {
            this.monitor("setValueOfState(" + var.getPathName() + ", strValue [" + value + "])\n");
        }
        return this.setValueOfState(var, value);
    }

    @Override
    public boolean setValueOfState(int i, double value) throws StepperException {
        JVariable var = this._states.get(i - 1);
        double vvalue = var.getDomain().verify(value);
        if (Double.isNaN(vvalue)) {
            throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_NO_CORRECT", var.getPathName(), "" + value + "/[" + var.getDomain().toString(value) + "]", var.getDomain().displayScale()));
        }
        if (this.withMonitoring(6)) {
            this.monitor("setValueOfState(" + var.getPathName() + ", " + value + "])\n");
        }
        return this.setValueOfState(var, value);
    }

    private boolean setValueOfState(JVariable var, double value) throws StepperException {
        this._currentStep = new JSimulStep(10);
        this.incStep();
        var.setValue(value);
        this.addSimulNode(var.getNode());
        this.simulStack();
        this._stackStep.push(this._currentStep);
        this._currentStep = null;
        JTrans tr = this._sheduler.firing(null, true);
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        return true;
    }

    @Override
    public boolean setInitOfState(int i, String strValue) {
        JVariable var = this._states.get(i - 1);
        double value = var.getDomain().parse(strValue);
        if (Double.isNaN(value)) {
            return false;
        }
        var.setInit(value);
        return true;
    }

    @Override
    public boolean setInitOfState(int i, double value) {
        JVariable var = this._states.get(i - 1);
        double vvalue = var.getDomain().verify(value);
        if (Double.isNaN(vvalue)) {
            return false;
        }
        var.setInit(value);
        return true;
    }

    @Override
    public boolean goForward(int i) throws StepperException {
        JTrans tr = this._transs.get(i - 1);
        if (!tr.isValid()) {
            if (this.withMonitoring(1)) {
                this.monitor("Exception : ");
                this.monitor(MsgJStep.msgFormat("EXC_STEP_TRANSITION_NOT_VALID", tr.getEvent().getPathName()));
                this.monitor("\n");
            }
            throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_TRANSITION_NOT_VALID", tr.getEvent().getPathName()));
        }
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        return true;
    }

    JTrans goForward(JTrans tr, boolean fire) throws StepperException {
        this._sheduler.canFire(tr);
        if (this.withMonitoring(6)) {
            this.monitor("goForward(" + tr.getEvent().getPathName() + ")\n");
        }
        this._currentStep = new JSimulStep(10);
        this.incStep();
        tr.affect();
        tr.addSimul();
        this.simulStack();
        this._stackStep.push(this._currentStep);
        this._currentStep = null;
        return this._sheduler.firing(tr, fire);
    }

    void addBackValue(JValue value, double val) {
        if (this._currentStep != null) {
            this._currentStep.add(value, val);
        }
    }

    @Override
    public boolean goBackward(int nbrTrans) throws StepperViolatedAssertionException, StepperException {
        while (nbrTrans-- > 0 && !this._stackStep.isEmpty()) {
            boolean next = true;
            while (next && !this._stackStep.isEmpty()) {
                this.incStep();
                JSimulStep step = (JSimulStep)this._stackStep.pop();
                step.unplay();
                next = this._sheduler.back();
            }
        }
        return !this._stackStep.isEmpty();
    }

    static JSimulator createFromJar(JarClassLoader loader) throws StepperException {
        try {
            JDefArchitecture arch = JDefArchitecture.createInstance(loader);
            JDefNode node = arch.getInstance(null);
            JSimulator simul = new JSimulator(node, arch);
            return simul;
        }
        catch (JCreateException e) {
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            throw new StepperException(e.getMessage());
        }
    }

    static String getKey(String option) {
        int pos = option.indexOf("=");
        if (pos == -1) {
            return "";
        }
        return option.substring(0, pos);
    }

    static String getOptionValue(List<String> args, String key) {
        for (String option : args) {
            String curKey = JSimulator.getKey(option);
            if (!key.equals(curKey)) continue;
            return JSimulator.getValue(option);
        }
        return null;
    }

    static String getValue(String option) {
        int pos = option.indexOf("=");
        if (pos == -1) {
            return "";
        }
        String value = option.substring(pos + 1);
        if (value.length() > 0 && value.charAt(0) == '\"' && (pos = value.lastIndexOf(34)) > 0) {
            return value.substring(1, pos);
        }
        return value;
    }

    @Override
    public void dispose() {
    }
}

