/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqsMCS;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mcs.AraliaWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class FormatSeqsAralia
implements FormatSeqs {
    Node _node;

    public FormatSeqsAralia(Node node) {
        this._node = node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void printResult(ResultSet set, Writer out, SeqGenTarget tgt, SeqGenerator generator) throws IOException {
        boolean error = false;
        if (generator != null) {
            Iterator<LogGenRecord> iError = generator.getErrorList().iterator();
            if (iError.hasNext()) {
                out.write("/* Errors : \n");
                LogGenLayoutSimple layout2 = new LogGenLayoutSimple();
                layout2.configure(FormatSeqsMCS.__LayoutConfig);
                while (iError.hasNext()) {
                    out.write(layout2.format(iError.next()));
                }
                out.write("*/\n\n");
                error = true;
            }
            if (Boolean.getBoolean("cecilia.mbsa.seqgen.DisplayResultsWithError")) {
                error = false;
            }
        }
        if (error) {
            out.write("'" + tgt + "' := 1;\n");
            return;
        }
        String abstrakt = set.getSeqAbstract();
        if (abstrakt != null && abstrakt.length() > 0) {
            out.write(abstrakt);
            out.write("\n");
        }
        IdentityHashMap<Event, Event> leaves = new IdentityHashMap<Event, Event>();
        LinkedHashSet<String> params = new LinkedHashSet<String>();
        AraliaWriter arlOut = new AraliaWriter(out);
        arlOut.setTop("'" + tgt + "'");
        Iterator iTrs = set.getSeqIterator();
        while (iTrs.hasNext()) {
            ModelTrans[] cut = (ModelTrans[])iTrs.next();
            for (int j = 0; j < cut.length; ++j) {
                Event evt = this._node.getEvent(cut[j].getName());
                if (evt == null) {
                    throw new GenerateException(MessageFormat.format(MsgStepUser.getString("ERR_NO_EVT_FIND"), cut[j].getName()));
                }
                leaves.put(evt, evt);
            }
            arlOut.write(Arrays.asList(cut));
        }
        arlOut.close();
        boolean header = false;
        for (int i = 0; i < this._node.getExternCount(); ++i) {
            ArrayList<Event> evts;
            Extern ext = this._node.getExtern(i);
            String type = ext.getTree()._sval;
            if (type.equals("law")) {
                evts = new ArrayList<Event>();
                int nbrEvt = Extern.verifyOnlyEvent(ext.getVar(), evts, true);
                if (nbrEvt <= 0) {
                    throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
                }
                for (Event event : evts) {
                    if (!leaves.containsKey(event)) continue;
                    if (!header) {
                        out.write("\n/* Other data : law, attribute, ... */\n");
                        header = true;
                    }
                    out.write("law '");
                    out.write(event.getName());
                    out.write("' ");
                    ext.printAraliaLaw(out, this._node, params);
                    out.write(";\n");
                }
                continue;
            }
            if (type.equals("attribute")) {
                evts = new ArrayList();
                int nbrEvt = Extern.verifyOnlyEvent(ext.getVar(), evts, false);
                if (nbrEvt <= 0) {
                    throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
                }
                String name = ext.getVar()._sval;
                if (name.length() == 0) {
                    throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
                }
                String value = "true";
                Tree val = ext.getVal();
                if (val != null) {
                    if (val._type == 258) {
                        Expr eval = (Expr)val._son;
                        if (!eval.isConstant()) throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
                        value = this._node.valueToString(eval);
                    } else {
                        if (val._type != 303) throw new GenerateException(MsgStepUser.getString("EXC_GEN_XATTRIB"));
                        value = val._sval;
                    }
                }
                for (Event event : evts) {
                    if (!leaves.containsKey(event)) continue;
                    if (!header) {
                        out.write("\n/* Other data : law, attribute, ... */\n");
                        header = true;
                    }
                    out.write("set attribute ");
                    out.write(name);
                    out.write(" '");
                    out.write(event.getName());
                    out.write("' ");
                    out.write(value);
                    out.write(";\n");
                }
                continue;
            }
            if (!type.equals("parameter")) continue;
            String name = null;
            Tree var = ext.getVar();
            if (var._type == 258) {
                Expr evar = (Expr)var._son;
                if (evar.isConstant() && evar.isSymbolic()) {
                    name = evar.toString();
                }
            } else if (var._type == 267) {
                name = "'" + var._sval + "'";
            }
            if (name == null) {
                throw new GenerateException(MsgStepUser.getString("EXC_GEN_XPARAM"));
            }
            if (!header) {
                out.write("\n/* Other data : law, attribute, ... */\n");
                header = true;
            }
            out.write("set parameter ");
            out.write(name);
            out.write(" ");
            Extern.printAraliaParam(out, this._node, ext.getVal(), params);
            out.write(";\n");
        }
    }
}

