/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderStd;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGamePermIterator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StatUtil;
import java.util.Iterator;
import java.util.List;

public class SeqFinderPermLarge
extends SeqFinderStd {
    int _currentDepth = 1;

    public SeqFinderPermLarge(int order) {
        super(order);
    }

    @Override
    public double init(SeqGenerator simul) {
        super.init(simul);
        this._dspMaxTest = 0.0;
        for (int i = 1; i < this._order; ++i) {
            this._dspMaxTest += StatUtil.Permutation(i, this._trList.size());
        }
        return this._dspMaxTest;
    }

    private void findPermutation(int boucle, int order, boolean next, List<ModelTrans> begin) throws StepperException {
        if (boucle == order) {
            if (this._tgt.addSequence(this._simul, this._cut, boucle)) {
                ++this._addCut;
            }
            this._simul.changeProgress(this._dspNbrTest += 1.0, this._dspMaxTest);
        } else {
            if (this._tgt.isValid(this._simul)) {
                ++this._stopMinCut;
                this._dspMaxTest -= StatUtil.Permutation(order - boucle, this._trList.size() - boucle);
                return;
            }
            boolean playNext = next;
            for (int i = 0; i < this._trList.size(); ++i) {
                boolean valid;
                this._cut[boucle] = (ModelTrans)this._trList.get(i);
                for (int j = 0; j < boucle; ++j) {
                    if (this._cut[j] != this._cut[boucle]) continue;
                    this._cut[boucle] = null;
                    break;
                }
                if (this._cut[boucle] == null) continue;
                if (next) {
                    if (this._cut[boucle] != begin.get(boucle)) continue;
                    next = false;
                    if (boucle == begin.size() - 1) {
                        playNext = false;
                        this._cut[boucle] = null;
                        continue;
                    }
                }
                if (!(valid = this._simul.isValidTransition(this._cut[boucle]))) {
                    ++this._stopNaNCut;
                    this._dspMaxTest -= StatUtil.Permutation(order - (boucle + 1), this._trList.size() - (boucle + 1));
                    continue;
                }
                if (valid) {
                    this._simul.goForward(this._cut[boucle]);
                }
                ++this._stepNbr;
                this.findPermutation(boucle + 1, order, playNext, begin);
                if (valid) {
                    this._simul.goBackward(1);
                }
                playNext = false;
                this._cut[boucle] = null;
            }
        }
    }

    @Override
    protected void playSimul(List<ModelTrans> currentSeq) throws StepperException {
        while (this._currentDepth <= this._order) {
            this.findPermutation(0, this._currentDepth, currentSeq != null, currentSeq);
            ++this._currentDepth;
        }
    }

    @Override
    protected String getKeyHeader() {
        return "MSG_CMD_SEQ_FINDER_PERMUT_TITLE";
    }

    @Override
    public Iterator<SeqGame> getGames(int initSize) {
        if (initSize != 1) {
            throw new IllegalArgumentException();
        }
        return new SeqGamePermIterator(this._simul.getTransIndexes(), 1);
    }

    @Override
    public int getNbGame(int size) {
        if (size != 1) {
            throw new IllegalArgumentException();
        }
        return this._simul.getTransIndexes().size();
    }
}

