/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderStd;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGamePermIterator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StatUtil;
import java.util.Iterator;
import java.util.List;

public class SeqFinderPermLarge2
extends SeqFinderStd {
    int _currentDepth = 1;

    public SeqFinderPermLarge2(int order) {
        super(order);
        MsgStepUser.LOG.finest(SeqFinderPermLarge2.class.getSimpleName() + "::creator()");
    }

    @Override
    public double init(SeqGenerator simul) {
        super.init(simul);
        this._dspMaxTest = 0.0;
        for (int i = 1; i < this._order; ++i) {
            this._dspMaxTest += StatUtil.Permutation(i, this._trList.size());
        }
        return this._dspMaxTest;
    }

    private void findPermutation_old(int boucle, int order) throws StepperException {
        if (boucle == order) {
            if (this._tgt.addSequence(this._simul, this._cut, boucle)) {
                ++this._addCut;
            }
            this._simul.changeProgress(this._dspNbrTest += 1.0, this._dspMaxTest);
        } else {
            if (this._tgt.isValid(this._simul)) {
                ++this._stopMinCut;
                this._dspMaxTest -= StatUtil.Permutation(order - boucle, this._trList.size() - boucle);
                return;
            }
            for (int i = 0; i < this._trList.size(); ++i) {
                this._cut[boucle] = (ModelTrans)this._trList.get(i);
                for (int j = 0; j < boucle; ++j) {
                    if (this._cut[j] != this._cut[boucle]) continue;
                    this._cut[boucle] = null;
                    break;
                }
                if (this._cut[boucle] == null) continue;
                boolean valid = this._simul.isValidTransition(this._cut[boucle]);
                if (!valid) {
                    ++this._stopNaNCut;
                    this._dspMaxTest -= StatUtil.Permutation(order - (boucle + 1), this._trList.size() - (boucle + 1));
                    continue;
                }
                if (valid) {
                    this._simul.goForward(this._cut[boucle]);
                }
                ++this._stepNbr;
                this.findPermutation_old(boucle + 1, order);
                if (valid) {
                    this._simul.goBackward(1);
                }
                this._cut[boucle] = null;
            }
        }
    }

    private void findPermutation(int boucle, int order) throws StepperException {
        for (int i = 0; i < this._trList.size(); ++i) {
            this._cut[boucle] = (ModelTrans)this._trList.get(i);
            if (this._cut[boucle]._flag) continue;
            if (!this._simul.isValidTransition(this._cut[boucle])) {
                ++this._stopNaNCut;
                this._dspMaxTest -= StatUtil.Permutation(order - (boucle + 1), this._trList.size() - (boucle + 1));
                continue;
            }
            this._simul.goForward(this._cut[boucle]);
            this._cut[boucle]._flag = true;
            ++this._stepNbr;
            if (boucle + 1 == order) {
                if (this._tgt.addSequence(this._simul, this._cut, boucle + 1)) {
                    ++this._addCut;
                }
                this._simul.changeProgress(this._dspNbrTest += 1.0, this._dspMaxTest);
            } else if (this._tgt.isValid(this._simul)) {
                ++this._stopMinCut;
                this._dspMaxTest -= StatUtil.Permutation(order - boucle, this._trList.size() - boucle);
            } else {
                this.findPermutation(boucle + 1, order);
            }
            this._simul.goBackward(1);
            this._cut[boucle]._flag = false;
        }
    }

    @Override
    protected void playSimul(List<ModelTrans> currentSeq) throws StepperException {
        if (currentSeq == null) {
            for (int i = 0; i < this._trList.size(); ++i) {
                ((ModelTrans)this._trList.get((int)i))._flag = false;
            }
            while (this._currentDepth <= this._order) {
                this.findPermutation_old(0, this._currentDepth);
                ++this._currentDepth;
            }
        }
    }

    @Override
    protected String getKeyHeader() {
        return "MSG_CMD_SEQ_FINDER_PERMUT_TITLE";
    }

    @Override
    public Iterator<SeqGame> getGames(int initSize) {
        if (initSize != 1) {
            throw new IllegalArgumentException();
        }
        return new SeqGamePermIterator(this._simul.getTransIndexes(), 1);
    }

    @Override
    public int getNbGame(int size) {
        if (size != 1) {
            throw new IllegalArgumentException();
        }
        return this._simul.getTransIndexes().size();
    }
}

