/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinder;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StepperInterruptInternalException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class SeqFinderStd
extends SeqFinder {
    ModelTrans[] _cut;
    int _order;
    long _timer;
    long _addCut;
    long _stepNbr;
    long _stopMinCut;
    long _stopNaNCut;
    double _dspNbrTest;
    double _dspMaxTest;

    public SeqFinderStd(int order) {
        this._order = order;
    }

    protected int calibrateOrder() {
        return Math.min(this._order, this._trList.size());
    }

    @Override
    public double init(SeqGenerator simul) {
        super.init(simul);
        this._order = this.calibrateOrder();
        this._cut = new ModelTrans[this._order];
        this._stopNaNCut = 0L;
        this._stopMinCut = 0L;
        this._stepNbr = 0L;
        this._addCut = 0L;
        this._dspNbrTest = 0.0;
        return -1.0;
    }

    protected List<ModelTrans> getCurrentSeq() {
        ArrayList<ModelTrans> result = new ArrayList<ModelTrans>(this._order + 1);
        for (int i = 0; i < this._order && this._cut[i] != null; ++i) {
            result.add(this._cut[i]);
        }
        return result;
    }

    protected boolean requestStop() {
        return this._simul.getNbrError() >= this._simul.getMaxError();
    }

    protected abstract void playSimul(List<ModelTrans> var1) throws StepperException;

    @Override
    public int playSimul() throws StepperException {
        long timer = new Date().getTime();
        int initResult = this._simul.goInitialState();
        if (initResult > 0) {
            return 1;
        }
        if (initResult < 0) {
            return 0;
        }
        if (this._tgt.addSequence(this._simul, this._cut, 0)) {
            return 0;
        }
        int nbrError = 0;
        boolean finishRecupException = false;
        List<ModelTrans> currentSeq = null;
        while (!finishRecupException && !this.requestStop()) {
            try {
                this.playSimul(currentSeq);
                finishRecupException = true;
            }
            catch (StepperInterruptInternalException siie) {
                finishRecupException = true;
            }
            catch (StepperInterruptException sie) {
                throw sie;
            }
            catch (StepperException se) {
                currentSeq = this.getCurrentSeq();
                for (int j = 0; j < this._order; ++j) {
                    this._cut[j] = null;
                }
                try {
                    ++nbrError;
                    this.displayException(se, currentSeq);
                    if (this.requestStop()) continue;
                    this._simul.goInitialState();
                }
                catch (StepperInterruptInternalException sie) {
                    MsgStepUser.LOG.severe("Stop because number of exception exceed max error");
                    finishRecupException = true;
                }
            }
        }
        this._timer = new Date().getTime() - timer;
        return nbrError;
    }

    protected abstract String getKeyHeader();

    @Override
    public void printHeader() {
        this._simul.addRecord(new LogGenRecord(this.getKeyHeader(), this._order));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRTRANS", this._trList.size()));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRMAXSEQ", this.toString(this._dspMaxTest)));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_BEGINAT", new Date()));
    }

    @Override
    public void printFooter() {
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_ENDAT", new Date()));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRSEQ", this.toString(this._dspNbrTest)));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRSTEP", this.toString(this._stepNbr)));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_STOPMINCUT", this.toString(this._stopMinCut)));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_STOPNANCUT", this.toString(this._stopNaNCut)));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_ADDCUT", this.toString(this._addCut)));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRMAXSEQ", this.toString(this._dspMaxTest)));
        this._simul.printNbrTransUsed();
        this._simul.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE", new Object[0]));
        SeqFinderStd.displayTime(this._timer, "MSG_CMD_SEQ_FINDER_DELAY", this._simul);
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
    }
}

