/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqverif;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.HelperStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.SeqManager;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetFlow;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetState;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqGenFilePlayer;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqSetDefine;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqSetPlayer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXParseException;

public class SeqVerifManager
extends SeqManager {
    int _changeCheck;
    int _nbrError;
    int _errorCheck;
    double _maxSeq;
    double _curSeq;
    HelperStepper _stepper;
    Map<String, String> _inits = null;
    List<SeqSetPlayer> _sequences = new ArrayList<SeqSetPlayer>();
    LinkedList<HelperStepper.Event> _trace = new LinkedList();

    public SeqVerifManager(Stepper stepper) throws StepperException {
        this._stepper = new HelperStepper(stepper);
        this._changeCheck = 1000;
        this._errorCheck = 10;
        this._nbrError = 0;
    }

    public void setInits(Map<String, String> inits) {
        this._inits = inits;
    }

    public SeqSetDefine createSeqSet(Map<String, String> verify, Map<String, String> locker) throws StepperException {
        SeqSetDefine set = new SeqSetDefine(this);
        if (verify != null) {
            this.addTargetToSet(verify, set, false);
        }
        if (locker != null) {
            this.addTargetToSet(locker, set, true);
        }
        this._sequences.add(set);
        return set;
    }

    public void addSeqGenFile(File file) throws StepperException, SAXParseException {
        SeqGenFilePlayer set = new SeqGenFilePlayer(this);
        set.prepareInfo(file, this._stepper);
        this._sequences.add(set);
    }

    private void addTargetToSet(Map<String, String> tgts, SeqSetDefine set, boolean locker) {
        for (Map.Entry<String, String> tgt : tgts.entrySet()) {
            HelperStepper.Var var = this._stepper.getVar(tgt.getKey());
            if (var != null) {
                ModelTargetVar mtgt = null;
                mtgt = var.isState() ? new ModelTargetState(tgt.getKey(), var.getIdx()) : new ModelTargetFlow(tgt.getKey(), var.getIdx());
                mtgt.setStrValue(tgt.getValue());
                try {
                    mtgt.verifyValue(this._stepper);
                    if (locker) {
                        set.addLockerTarget(mtgt);
                        continue;
                    }
                    set.addTarget(mtgt);
                }
                catch (StepperException e) {
                    this.addRecord(new LogGenRecord(e));
                    ++this._nbrError;
                }
                continue;
            }
            this.addRecord(new LogGenRecord(true, "ERR_NO_VAR_FIND", tgt.getKey()));
            ++this._nbrError;
        }
    }

    public void addSequenceToSet(List<String> seq, SeqSetDefine set) {
        if (!set.addSequence(seq, this._stepper)) {
            ++this._nbrError;
        }
    }

    public int getNbrError() {
        return this._nbrError;
    }

    public int run() throws StepperException, IOException {
        try {
            this.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_START", new Object[0]));
            for (SeqSetPlayer def : this._sequences) {
                if (def.playSequences()) continue;
                ++this._nbrError;
            }
            this.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_END", new Object[0]));
            this.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_ERROR", Integer.toString(this._nbrError)));
        }
        finally {
            this.close();
        }
        return this._nbrError;
    }

    String displayTrace(HelperStepper.Event last) {
        StringBuffer sb = new StringBuffer(128);
        for (HelperStepper.Event evt : this._trace) {
            sb.append("\t\t").append(evt.getName()).append("\n");
        }
        if (last != null) {
            sb.append("\t\t").append(last.getName()).append("\n");
        }
        return sb.toString();
    }

    void goInitialState(SeqSetPlayer player) throws StepperException {
        Map<String, String> inits = player.getInitState();
        if (inits == null) {
            inits = this._inits;
        }
        if (inits != null) {
            for (Map.Entry<String, String> entry : inits.entrySet()) {
                HelperStepper.Var var = this._stepper.getVar(entry.getKey());
                if (var.isState()) {
                    boolean result = this._stepper.setInitOfState(var.getIdx(), entry.getValue());
                    if (result) continue;
                    this.verifyRecord(new LogGenRecord(true, "ERR_STATE_AFFECT_INIT", entry.getKey(), entry.getValue()));
                    continue;
                }
                this.verifyRecord(new LogGenRecord(true, "ERR_STATE_FIND", entry.getKey()));
            }
        }
        this._stepper.goInitialState();
        this._trace.clear();
        try {
            this._stepper.goInitialState();
            this._trace.clear();
        }
        catch (StepperException e) {
            this.verifyRecord(new LogGenRecord(e, "MSG_CMD_SEQ_ERROR", this._nbrError, e.getMessage(), this.displayTrace(null)));
            throw e;
        }
    }

    boolean goForward(HelperStepper.Event evt) throws StepperException {
        int idx = -1;
        for (int i = 0; i < evt.getNbrTrans(); ++i) {
            int cur = evt.getTrans(i);
            if (!(this._stepper.isValidTransition(cur) >= 0.0)) continue;
            if (idx == -1) {
                idx = cur;
                continue;
            }
            this.verifyRecord(new LogGenRecord(true, "ERR_UNDETERMINED_TRANS", this.displayTrace(evt), evt.getName()));
            return false;
        }
        if (idx != -1) {
            try {
                this._stepper.goForward(idx);
                this._trace.addLast(evt);
                return true;
            }
            catch (StepperException e) {
                this.verifyRecord(new LogGenRecord(e, "MSG_CMD_SEQ_ERROR", this._nbrError, e.getMessage(), this.displayTrace(evt)));
            }
        } else {
            this.verifyRecord(new LogGenRecord(true, "ERR_NOVALID_TRANS", this.displayTrace(evt), evt.getName()));
        }
        return false;
    }

    void goBeginState() throws StepperException {
        if (this._trace.size() > 0) {
            this._stepper.goBackward(this._trace.size());
            this._trace.clear();
        }
    }

    void verifyTarget(ModelTargetVar var, boolean locker) throws StepperException {
        boolean valid = var.isActive(this._stepper);
        if (locker && valid) {
            this.verifyRecord(new LogGenRecord(true, "ERR_VALID_LOCKER_TARGET", this.displayTrace(null), var.getName(), var.getStrValue()));
        }
        if (!locker && !valid) {
            this.verifyRecord(new LogGenRecord(true, "ERR_NOVALID_TARGET", this.displayTrace(null), var.getName(), var.getStrValue(), var.getCurStrValue(this._stepper)));
        }
    }

    public void verifyRecord(LogGenRecord record) throws StepperException {
        this.addRecord(record);
        switch (record.getType()) {
            case ERR: 
            case EXC: {
                ++this._nbrError;
                if (this._nbrError < this._errorCheck) break;
                throw new StepperInterruptException();
            }
        }
    }

    public void changeProgress(double cur, double max) throws StepperException {
        if (cur % (double)this._changeCheck != 0.0) {
            return;
        }
        this._curSeq = cur;
        if (!Double.isNaN(max)) {
            this._maxSeq = max;
        }
        if (this._maxSeq < this._curSeq) {
            this._maxSeq = this._curSeq;
        }
        if (this.checkStopped()) {
            throw new StepperInterruptException();
        }
        try {
            this.checkSuspended();
        }
        catch (InterruptedException e) {
            throw new StepperInterruptException(e);
        }
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg.high")) {
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._curSeq >= this._maxSeq ? this._maxSeq : this._curSeq + 1.0);
            msg.append("/");
            msg.append(this._maxSeq);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString(this._curSeq < 0.0 ? 0 : (int)(this._curSeq / this._maxSeq * 1000.0));
        }
        return super.getInfo(key);
    }
}

