/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.error;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.util.destination.Record;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class VerifyItem
implements Record {
    String _key;
    Data _src;
    String _keyMsg;
    Object[] _arguments;

    VerifyItem(String key, Data src, String keyMsg, Object ... arguments) {
        this._key = key;
        this._src = src;
        this._keyMsg = keyMsg;
        this._arguments = arguments;
    }

    protected String endKey(String key) {
        int pos = key.lastIndexOf(35);
        if (pos != -1) {
            return key.substring(pos + 1);
        }
        return key;
    }

    public int getLine() {
        StringBuffer path = new StringBuffer(32);
        Data orig = this._src.findOrigin(path);
        return orig.getStart();
    }

    public String getPath() {
        StringBuffer path = new StringBuffer(32);
        this._src.findOrigin(path);
        return path.toString();
    }

    public String getBaseName() {
        if (this._key == null) {
            return "AltaRica";
        }
        return this._key;
    }

    public String getCodeMsg() {
        return this._keyMsg;
    }

    public Object[] getArgsMsg() {
        return this._arguments;
    }

    public String getMessage() {
        try {
            return MessageFormat.format(MsgTrans.getString(this._keyMsg), this._arguments);
        }
        catch (IllegalArgumentException e) {
            MsgTrans.LOG.log(Level.SEVERE, "IllegalArgumentException from MessageFormat\nCode : " + this._keyMsg + "\nMsg : " + MsgTrans.getString(this._keyMsg), e);
            return MsgTrans.getString(this._keyMsg);
        }
    }

    public String getDataToString() {
        StringBuffer sb = new StringBuffer(32);
        IndentWriter out = new IndentWriter(sb, "    ");
        this.printDataSource(out);
        return sb.toString();
    }

    public void print(StringBuffer sb) {
        StringBuffer path = new StringBuffer(32);
        Data orig = this._src.findOrigin(path);
        sb.append(this._key == null ? "[warning]" : this._key);
        sb.append(" : ");
        sb.append(orig.getStart());
        sb.append(" : ");
        sb.append(path);
        sb.append(" : ");
        try {
            sb.append(MessageFormat.format(MsgTrans.getString(this._keyMsg), this._arguments));
        }
        catch (IllegalArgumentException e) {
            MsgTrans.LOG.log(Level.SEVERE, "IllegalArgumentException from MessageFormat\nCode : " + this._keyMsg + "\nMsg : " + MsgTrans.getString(this._keyMsg), e);
            sb.append(MsgTrans.getString(this._keyMsg));
        }
        sb.append("\n => ");
        IndentWriter out = new IndentWriter(sb, "    ");
        out.addIndent(1);
        this.printDataSource(out);
    }

    private void printDataSource(IndentWriter out) {
        try {
            if (this._src instanceof Node) {
                out.write("node ");
                out.write(((Node)this._src).getName());
                out.write("\n");
                out.addIndent(1);
                out.write("...\n");
                out.addIndent(-1);
                out.write("edon\n");
            } else if (this._src instanceof Model) {
                out.write("...\n");
            } else {
                this._src.printOTools(out, 0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

