/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import java.io.IOException;

class BoolDomain
extends Domain {
    protected static final Domain _instance = new BoolDomain();

    private BoolDomain() {
        this.setName("bool");
    }

    public static Domain getInstance() {
        return _instance;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean verifyValueOf(Expr expr) {
        return expr.getScale() == Expr.Scale.Boolean;
    }

    @Override
    public boolean verifyValueOf(double value) {
        return value == 0.0 || value == 1.0;
    }

    @Override
    public void printDefLL(IndentWriter out, int frm) throws IOException {
        assert (false);
    }

    public String toString() {
        return "bool";
    }

    @Override
    public void printDefJava(IndentWriter out) throws IOException {
        out.write("JDomain.JBool()");
    }

    @Override
    public void printJava(IndentWriter out) throws IOException {
        out.write("JDomain.JBool()");
    }

    @Override
    public void printDefaultValue(IndentWriter out) throws IOException {
        out.write("0");
    }

    @Override
    public int getNbrValue() {
        return 2;
    }

    @Override
    public double getDouble(int idx) {
        return idx;
    }

    @Override
    public String toString(double value) {
        return value == 0.0 ? "false" : "true";
    }

    @Override
    public double parse(String strValue) {
        if (strValue.equals("false")) {
            return 0.0;
        }
        if (strValue.equals("true")) {
            return 1.0;
        }
        return Double.NaN;
    }
}

