/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprFct;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Link;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExprOp
extends Expr {
    private static final String PROP_EXPR_NOSIMPLIFYEQUAL = "cecilia.mbsa.translator.expr.NotSimplifyEqual";
    private static final boolean EXPR_NOSIMPLIFYEQUAL = Boolean.getBoolean("cecilia.mbsa.translator.expr.NotSimplifyEqual");
    private Type _type;
    protected Expr[] _args;

    public ExprOp() {
        this(Type.UNDEF);
    }

    public ExprOp(Type type) {
        this._type = type;
        this._args = null;
    }

    public ExprOp(Type type, Expr expr1) {
        this._type = type;
        this._args = new Expr[1];
        this._args[0] = expr1;
    }

    public ExprOp(Type type, Expr expr1, Expr expr2) {
        this._type = type;
        this._args = new Expr[2];
        this._args[0] = expr1;
        this._args[1] = expr2;
    }

    public ExprOp(Type type, Expr expr1, Expr expr2, Expr expr3) {
        this._type = type;
        this._args = new Expr[3];
        this._args[0] = expr1;
        this._args[1] = expr2;
        this._args[2] = expr3;
    }

    public ExprOp(Type type, List<Expr> args) {
        this._type = type;
        this.setArgs(args);
    }

    protected void setArgs(List<Expr> args) {
        this._args = new Expr[args.size()];
        Iterator<Expr> i = args.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            this._args[cpt] = i.next();
            ++cpt;
        }
    }

    @Override
    protected void copy(Data src) {
        super.copy(src);
        ExprOp Src = (ExprOp)src;
        this._args = new Expr[Src._args.length];
        for (int i = 0; i < Src._args.length; ++i) {
            this._args[i] = (Expr)Src._args[i].clone();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ExprOp oth = (ExprOp)obj;
        if (this._type != oth._type) {
            return false;
        }
        if (this._args.length != oth._args.length) {
            return false;
        }
        for (int i = 0; i < this._args.length; ++i) {
            if (this.getArg(i).equals(oth.getArg(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = 37 * result + this._type.getIndex();
        for (int i = 0; i < this._args.length; ++i) {
            result = 37 * result + this.getArg(i).hashCode();
        }
        return result;
    }

    @Override
    public int getArgCount() {
        return this._args.length;
    }

    @Override
    public Expr getArg(int i) {
        return this._args[i];
    }

    @Override
    public void setArg(int i, Expr expr) {
        this._args[i] = expr;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._type.getIndex());
        out.writeShort(this._scale.getIndex());
        out.writeDouble(this._double);
        int size = this._args == null ? 0 : this._args.length;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this._args[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._type = Type.valueOf(in.readInt());
        this._scale = Expr.Scale.valueOf(in.readShort());
        this._double = in.readDouble();
        int size = in.readInt();
        if (size > 0) {
            this._args = new Expr[size];
            for (int i = 0; i < size; ++i) {
                this._args[i] = (Expr)in.readObject();
            }
        } else {
            this._args = null;
        }
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        switch (this._type) {
            case NOT: {
                sb.append("not");
                break;
            }
            case NEG: {
                sb.append("neg");
                break;
            }
            case OR: {
                sb.append("or");
                break;
            }
            case AND: {
                sb.append("and");
                break;
            }
            case IMPLY: {
                sb.append("imply");
                break;
            }
            case ADD: {
                sb.append("add");
                break;
            }
            case SUB: {
                sb.append("sub");
                break;
            }
            case MUL: {
                sb.append("mul");
                break;
            }
            case DIV: {
                sb.append("div");
                break;
            }
            case MOD: {
                sb.append("mod");
                break;
            }
            case EQ: {
                sb.append("eq");
                break;
            }
            case NEQ: {
                sb.append("neq");
                break;
            }
            case LEQ: {
                sb.append("leq");
                break;
            }
            case GEQ: {
                sb.append("geq");
                break;
            }
            case LT: {
                sb.append("lt");
                break;
            }
            case GT: {
                sb.append("gt");
                break;
            }
            case MIN: {
                sb.append("min");
                break;
            }
            case MAX: {
                sb.append("max");
                break;
            }
            case CRD: {
                sb.append("crd");
                break;
            }
            case ITE: {
                sb.append("ite");
                break;
            }
            case CASE: {
                sb.append("case");
                break;
            }
            case XCASE: {
                sb.append("xcase");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public Type getType() {
        return this._type;
    }

    public static boolean isType(Expr expr, Type type) {
        if (expr.getClass() != ExprOp.class) {
            return false;
        }
        return ((ExprOp)expr).getType() == type;
    }

    @Override
    Expr.Scale defineScale() {
        switch (this._type) {
            case NOT: 
            case OR: 
            case AND: 
            case IMPLY: 
            case EQ: 
            case NEQ: 
            case LEQ: 
            case GEQ: 
            case LT: 
            case GT: {
                this._scale = Expr.Scale.Boolean;
                return this._scale;
            }
            case MOD: 
            case CRD: {
                this._scale = Expr.Scale.Integer;
                return this._scale;
            }
            case NEG: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MIN: 
            case MAX: {
                this._scale = this._args[0].getScale();
                for (int i = 1; i < this._args.length; ++i) {
                    Expr.Scale argScale = this._args[i].getScale();
                    if (this._scale.getIndex() >= argScale.getIndex()) continue;
                    this._scale = argScale;
                }
                return this._scale;
            }
            case ITE: {
                this._scale = this._args[1].getScale();
                return this._scale;
            }
            case CASE: 
            case XCASE: {
                this._scale = this._args[this._args.length - 1].getScale();
                return this._scale;
            }
            case UNDEF: {
                return Expr.Scale.Undef;
            }
        }
        return Expr.Scale.Undef;
    }

    @Override
    public Expr verify(Node node, boolean affect) throws TranslateException {
        int i;
        boolean bChange = false;
        Expr[] argsChange = new Expr[this._args.length];
        for (i = 0; i < this.getArgCount(); ++i) {
            boolean argAffect = false;
            switch (this._type) {
                case IMPLY: 
                case ITE: {
                    argAffect = i != 0;
                    break;
                }
                case CASE: 
                case XCASE: {
                    argAffect = i == this.getArgCount() - 1 || i % 2 == 1;
                    break;
                }
                case AND: {
                    argAffect = affect;
                }
            }
            Expr arg = this.getArg(i);
            argsChange[i] = arg.verify(node, argAffect);
            if (arg == argsChange[i]) continue;
            bChange = true;
        }
        switch (this._type) {
            case UNDEF: {
                break;
            }
            case NOT: 
            case OR: 
            case AND: 
            case IMPLY: 
            case CRD: {
                for (i = 0; i < this.getArgCount(); ++i) {
                    if (argsChange[i].isBoolean()) continue;
                    throw new TranslateException(this, "EXC_EXPR_NOBOOL", argsChange[i].toLL());
                }
                break;
            }
            case NEG: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case LEQ: 
            case GEQ: 
            case LT: 
            case GT: 
            case MIN: 
            case MAX: {
                for (i = 0; i < this.getArgCount(); ++i) {
                    if (argsChange[i].isNumeric()) continue;
                    throw new TranslateException(this, "EXC_EXPR_NONUMERIC", argsChange[i].toLL());
                }
                break;
            }
            case NEQ: {
                if (argsChange[0].isStructured()) {
                    throw new TranslateException(this, "EXC_EXPR_NOSTRUCT", argsChange[0].toLL());
                }
                if (argsChange[1].isStructured()) {
                    throw new TranslateException(this, "EXC_EXPR_NOSTRUCT", argsChange[1].toLL());
                }
                if (argsChange[0].getScale() != argsChange[1].getScale()) {
                    throw new TranslateException(this, "EXC_EXPR_EQUALITY", new Object[0]);
                }
                if (!argsChange[0].isSymbolic()) break;
                this.verifySymbolic(argsChange[0], argsChange[1]);
                break;
            }
            case EQ: {
                Expr arg1;
                if (argsChange[0].getScale() != argsChange[1].getScale()) {
                    throw new TranslateException(this, "EXC_EXPR_EQUALITY", new Object[0]);
                }
                if (argsChange[0].isStructured()) {
                    if (argsChange[0].getDomain() != argsChange[1].getDomain()) {
                        throw new TranslateException(this, "EXC_EXPR_EQUALITY", new Object[0]);
                    }
                } else if (argsChange[0].isSymbolic()) {
                    this.verifySymbolic(argsChange[0], argsChange[1]);
                }
                if (!affect) break;
                Expr arg0 = argsChange[0];
                int nbrVar = (arg0 instanceof ExprVar ? 1 : 0) + ((arg1 = argsChange[1]) instanceof ExprVar ? 1 : 0);
                if (nbrVar == 2) {
                    if (!(arg0 instanceof ExprVar) || !((ExprVar)arg0).isFlowIn(node)) break;
                    if (arg1 instanceof ExprVar && ((ExprVar)arg1).isFlowIn(node)) {
                        throw new TranslateException(this, "EXC_EXPR_AFFECT_ININ", new Object[0]);
                    }
                    Expr tmp = argsChange[0];
                    argsChange[0] = argsChange[1];
                    argsChange[1] = tmp;
                    bChange = true;
                    break;
                }
                if (nbrVar == 1) {
                    if (!(argsChange[1] instanceof ExprVar)) break;
                    Expr tmp = argsChange[0];
                    argsChange[0] = argsChange[1];
                    argsChange[1] = tmp;
                    bChange = true;
                    break;
                }
                if (!argsChange[0].isConstant() || !argsChange[1].isConstant()) break;
                throw new TranslateException(this, "EXC_EXPR_AFFECT_CSTS", new Object[0]);
            }
            case ITE: {
                if (!argsChange[0].isBoolean()) {
                    throw new TranslateException(this, "EXC_EXPR_NOBOOL", argsChange[0].toLL());
                }
                if (argsChange[1].isStructured()) {
                    throw new TranslateException(this, "EXC_EXPR_NOSTRUCT", argsChange[1].toLL());
                }
                if (argsChange[1].getScale() == argsChange[2].getScale()) break;
                throw new TranslateException(this, "EXC_EXPR_EQUALITY", new Object[0]);
            }
            case CASE: 
            case XCASE: {
                assert (this.getArgCount() % 2 == 1);
                Expr.Scale scale = argsChange[this.getArgCount() - 1].getScale();
                if (scale == Expr.Scale.Undef) {
                    throw new TranslateException(this, "EXC_EXPR_NOSTRUCT", argsChange[this.getArgCount() - 1].toLL());
                }
                for (int i2 = 0; i2 < this.getArgCount() - 1; ++i2) {
                    if (i2 % 2 == 0 && !argsChange[i2].isBoolean()) {
                        throw new TranslateException(this, "EXC_EXPR_NOBOOL", argsChange[i2].toLL());
                    }
                    if (i2 % 2 != 1 || scale == argsChange[i2].getScale()) continue;
                    throw new TranslateException(this, "EXC_EXPR_EQUALITY", new Object[0]);
                }
                break;
            }
        }
        Expr result = this;
        if (bChange) {
            result = new ExprOp(this._type);
            result._args = argsChange;
            result = node.addUniqueExpr(result);
        }
        return ((Expr)result).simplify(node, affect);
    }

    public void verifyRange(Expr e1, Expr e2) throws TranslateException {
        if (e1 instanceof ExprVar || e1 instanceof ExprFct) {
            if (e2 instanceof ExprVar || e2 instanceof ExprFct) {
                if (!e1.getDomain().equals(e2.getDomain())) {
                    throw new TranslateException(this, "EXC_EXPR_AFFECT_RANGE", new Object[0]);
                }
                return;
            }
            if (e2 instanceof ExprCst && e2.isNumeric()) {
                if (!e1.getDomain().verifyValueOf(e2)) {
                    throw new TranslateException(this, "EXC_EXPR_AFFECT_RANGE", new Object[0]);
                }
                return;
            }
            if (e2 instanceof ExprOp) {
                switch (((ExprOp)e2).getType()) {
                    case CASE: 
                    case XCASE: {
                        for (int i = 1; i < e2.getArgCount(); i += 2) {
                            this.verifyRange(e1, e2.getArg(i));
                        }
                        this.verifyRange(e1, e2.getArg(e2.getArgCount() - 1));
                        return;
                    }
                    case ITE: {
                        this.verifyRange(e1, e2.getArg(1));
                        this.verifyRange(e1, e2.getArg(2));
                        return;
                    }
                }
            }
        } else if (e1 instanceof ExprCst && e1.isNumeric()) {
            if (e2 instanceof ExprVar || e2 instanceof ExprFct) {
                if (!e2.getDomain().verifyValueOf(e1)) {
                    throw new TranslateException(this, "EXC_EXPR_AFFECT_RANGE", new Object[0]);
                }
                return;
            }
            if (e2 instanceof ExprCst && e2.isNumeric()) {
                return;
            }
            if (e2 instanceof ExprOp) {
                switch (((ExprOp)e2).getType()) {
                    case CASE: 
                    case XCASE: {
                        for (int i = 1; i < e2.getArgCount(); i += 2) {
                            this.verifyRange(e1, e2.getArg(i));
                        }
                        this.verifyRange(e1, e2.getArg(e2.getArgCount() - 1));
                        return;
                    }
                    case ITE: {
                        this.verifyRange(e1, e2.getArg(1));
                        this.verifyRange(e1, e2.getArg(2));
                        return;
                    }
                }
            }
        } else if (e1 instanceof ExprOp) {
            switch (((ExprOp)e2).getType()) {
                case CASE: 
                case XCASE: {
                    for (int i = 1; i < e1.getArgCount(); i += 2) {
                        this.verifyRange(e1.getArg(i), e2);
                    }
                    this.verifyRange(e1.getArg(e1.getArgCount() - 1), e2);
                    return;
                }
                case ITE: {
                    this.verifyRange(e1.getArg(1), e2);
                    this.verifyRange(e1.getArg(2), e2);
                    return;
                }
            }
        }
        throw new TranslateException(this, "EXC_IERROR", new Object[0]);
    }

    public void verifySymbolic(Expr e1, Expr e2) throws TranslateException {
        if (e1 instanceof ExprVar || e1 instanceof ExprFct) {
            if (e2 instanceof ExprVar || e2 instanceof ExprFct) {
                if (!e1.getDomain().equals(e2.getDomain())) {
                    throw new TranslateException(this, "EXC_EXPR_AFFECT_ENUM", new Object[0]);
                }
                return;
            }
            if (e2 instanceof ExprCst && e2.isSymbolic()) {
                if (!e1.getDomain().verifyValueOf(e2)) {
                    throw new TranslateException(this, "EXC_EXPR_AFFECT_ENUM", new Object[0]);
                }
                return;
            }
            if (e2 instanceof ExprOp) {
                switch (((ExprOp)e2).getType()) {
                    case CASE: 
                    case XCASE: {
                        for (int i = 1; i < e2.getArgCount(); i += 2) {
                            this.verifySymbolic(e1, e2.getArg(i));
                        }
                        this.verifySymbolic(e1, e2.getArg(e2.getArgCount() - 1));
                        return;
                    }
                    case ITE: {
                        this.verifySymbolic(e1, e2.getArg(1));
                        this.verifySymbolic(e1, e2.getArg(2));
                        return;
                    }
                }
            }
        } else if (e1 instanceof ExprCst && e1.isSymbolic()) {
            if (e2 instanceof ExprVar || e2 instanceof ExprFct) {
                if (!e2.getDomain().verifyValueOf(e1)) {
                    throw new TranslateException(this, "EXC_EXPR_AFFECT_ENUM", new Object[0]);
                }
                return;
            }
            if (e2 instanceof ExprCst && e2.isSymbolic()) {
                return;
            }
            if (e2 instanceof ExprOp) {
                switch (((ExprOp)e2).getType()) {
                    case CASE: 
                    case XCASE: {
                        for (int i = 1; i < e2.getArgCount(); i += 2) {
                            this.verifySymbolic(e1, e2.getArg(i));
                        }
                        this.verifySymbolic(e1, e2.getArg(e2.getArgCount() - 1));
                        return;
                    }
                    case ITE: {
                        this.verifySymbolic(e1, e2.getArg(1));
                        this.verifySymbolic(e1, e2.getArg(2));
                        return;
                    }
                }
            }
        } else if (e1 instanceof ExprOp) {
            switch (((ExprOp)e2).getType()) {
                case CASE: 
                case XCASE: {
                    for (int i = 1; i < e1.getArgCount(); i += 2) {
                        this.verifySymbolic(e1.getArg(i), e2);
                    }
                    this.verifySymbolic(e1.getArg(e1.getArgCount() - 1), e2);
                    return;
                }
                case ITE: {
                    this.verifySymbolic(e1.getArg(1), e2);
                    this.verifySymbolic(e1.getArg(2), e2);
                    return;
                }
            }
        }
        throw new TranslateException(this, "EXC_IERROR", new Object[0]);
    }

    @Override
    Expr simplify(Node node, boolean affect) throws TranslateException {
        switch (this._type) {
            case NOT: {
                if (!(this.getArg(0) instanceof ExprOp)) break;
                ExprOp arg = (ExprOp)this.getArg(0);
                if (arg.getType() == Type.NOT) {
                    return arg.getArg(0);
                }
                if (arg.getType() == Type.EQ) {
                    return new ExprOp(Type.NEQ, arg.getArg(0), arg.getArg(1));
                }
                if (arg.getType() != Type.NEQ) break;
                return new ExprOp(Type.EQ, arg.getArg(0), arg.getArg(1));
            }
            case OR: {
                for (int i = 0; i < this.getArgCount(); ++i) {
                    if (!this.getArg(i).isConstant() || !this.getArg(i).getBool()) continue;
                    return node.getModel().getBooleanExpr(true);
                }
                break;
            }
            case AND: {
                for (int i = 0; i < this.getArgCount(); ++i) {
                    if (!this.getArg(i).isConstant() || this.getArg(i).getBool()) continue;
                    return node.getModel().getBooleanExpr(false);
                }
                break;
            }
            case IMPLY: {
                if (!this.getArg(0).isConstant()) break;
                if (this.getArg(0).getBool()) {
                    return this.getArg(1);
                }
                return node.getModel().getBooleanExpr(true);
            }
            case NEG: {
                if (!(this.getArg(0) instanceof ExprOp) || ((ExprOp)this.getArg(0)).getType() != Type.NEG) break;
                return this.getArg(0).getArg(0);
            }
            case MUL: {
                for (int i = 0; i < this.getArgCount(); ++i) {
                    if (!this.getArg(i).isConstant() || this.getArg(i).getFloat() != 0.0) continue;
                    return this.getArg(i);
                }
                break;
            }
            case DIV: {
                if (this.getArg(1).isConstant()) {
                    if (this.getArg(1).getFloat() == 0.0) {
                        throw new TranslateException(this, "EXC_EXPR_DIV0", new Object[0]);
                    }
                    if (this.getArg(1).getFloat() == 1.0) {
                        return this.getArg(0);
                    }
                }
                if (!this.getArg(0).isConstant() || this.getArg(0).getFloat() != 0.0) break;
                return this.getArg(0);
            }
            case ADD: {
                if (!(this.getArg(1) instanceof ExprOp) || ((ExprOp)this.getArg(1)).getType() != Type.NEG) break;
                return node.addUniqueExpr(new ExprOp(Type.SUB, this.getArg(0), this.getArg(1)));
            }
            case SUB: {
                if (!(this.getArg(1) instanceof ExprOp) || ((ExprOp)this.getArg(1)).getType() != Type.NEG) break;
                return node.addUniqueExpr(new ExprOp(Type.ADD, this.getArg(0), this.getArg(1)));
            }
            case EQ: {
                if (EXPR_NOSIMPLIFYEQUAL || !this.getArg(0).isBoolean() || !this.getArg(1).isBoolean() || affect) break;
                if (this.getArg(0).isConstant()) {
                    if (this.getArg(1).isConstant()) {
                        if (this.getArg(0).getBool() == this.getArg(1).getBool()) {
                            return node.getModel().getBooleanExpr(true);
                        }
                        return node.getModel().getBooleanExpr(false);
                    }
                    if (this.getArg(0).getBool()) {
                        return this.getArg(1);
                    }
                    return node.addUniqueExpr(new ExprOp(Type.NOT, this.getArg(1)).simplify(node, affect));
                }
                if (!this.getArg(1).isConstant()) break;
                if (this.getArg(1).getBool()) {
                    return this.getArg(0);
                }
                return node.addUniqueExpr(new ExprOp(Type.NOT, this.getArg(0)).simplify(node, affect));
            }
            case NEQ: {
                if (EXPR_NOSIMPLIFYEQUAL || !this.getArg(0).isBoolean() || !this.getArg(1).isBoolean()) break;
                if (this.getArg(0).isConstant()) {
                    if (this.getArg(1).isConstant()) {
                        if (this.getArg(0).getBool() == this.getArg(1).getBool()) {
                            return node.getModel().getBooleanExpr(false);
                        }
                        return node.getModel().getBooleanExpr(true);
                    }
                    if (this.getArg(0).getBool()) {
                        return node.addUniqueExpr(new ExprOp(Type.NOT, this.getArg(1)).simplify(node, affect));
                    }
                    return this.getArg(1);
                }
                if (!this.getArg(1).isConstant()) break;
                if (this.getArg(1).getBool()) {
                    return node.addUniqueExpr(new ExprOp(Type.NOT, this.getArg(0)).simplify(node, affect));
                }
                return this.getArg(0);
            }
            case ITE: {
                if (this.getArg(0).isConstant()) {
                    if (this.getArg(0).getBool()) {
                        return this.getArg(1);
                    }
                    return this.getArg(2);
                }
                if (!this.getArg(1).isConstant() || !this.getArg(2).isConstant() || !this.getArg(1).isBoolean() || !this.getArg(2).isBoolean()) break;
                if (this.getArg(1).getBool()) {
                    if (this.getArg(2).getBool()) {
                        return this.getArg(1);
                    }
                    return this.getArg(0);
                }
                if (this.getArg(2).getBool()) {
                    return node.addUniqueExpr(new ExprOp(Type.NOT, this.getArg(0)));
                }
                return this.getArg(1);
            }
            case CASE: {
                if (!this.getArg(0).isConstant() || !this.getArg(0).getBool()) break;
                return this.getArg(1);
            }
        }
        return this.simplifyConstant(node);
    }

    @Override
    public void evaluate() throws TranslateException {
        for (int i = 0; i < this.getArgCount(); ++i) {
            this.getArg(i).evaluate();
        }
        switch (this._type) {
            case XCASE: {
                boolean find = false;
                for (int i = 0; i < this.getArgCount() - 1; ++i) {
                    if (!this.getArg(i++).getBool()) continue;
                    if (find && this.getDouble() != this._args[i].getDouble()) {
                        throw new TranslateException(MsgTrans.msgFormat("EXC_EXPR_CASE_EXCLUSIF", this.toString()), new Object[0]);
                    }
                    this.setDouble(this.getArg(i).getDouble());
                    find = true;
                }
                if (find) break;
                this.setDouble(this.getArg(this.getArgCount() - 1).getDouble());
                break;
            }
            case CASE: {
                boolean find = false;
                for (int i = 0; !find && i < this.getArgCount() - 1; ++i) {
                    if (!this.getArg(i++).getBool()) continue;
                    this.setDouble(this.getArg(i).getDouble());
                    find = true;
                }
                if (find) break;
                this.setDouble(this.getArg(this.getArgCount() - 1).getDouble());
                break;
            }
            case ITE: {
                this.setDouble(this._args[this._args[0].getBool() ? 1 : 2].getDouble());
                break;
            }
            case EQ: {
                switch (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex())) {
                    case 1: {
                        this.setBool(this._args[0].getBool() == this._args[1].getBool());
                        break;
                    }
                    case 2: {
                        this.setBool(this._args[0].getInt() == this._args[1].getInt());
                        break;
                    }
                    case 3: {
                        this.setBool(this._args[0].getFloat() == this._args[1].getFloat());
                        break;
                    }
                    case 4: {
                        this.setBool(this._args[0].getSymbol() == this._args[1].getSymbol());
                    }
                }
                break;
            }
            case NEQ: {
                switch (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex())) {
                    case 2: {
                        this.setBool(this._args[0].getInt() != this._args[1].getInt());
                        break;
                    }
                    case 1: {
                        this.setBool(this._args[0].getBool() != this._args[1].getBool());
                        break;
                    }
                    case 3: {
                        this.setBool(this._args[0].getFloat() != this._args[1].getFloat());
                        break;
                    }
                    case 4: {
                        this.setBool(this._args[0].getSymbol() != this._args[1].getSymbol());
                    }
                }
                break;
            }
            case LEQ: {
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() <= this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() <= this._args[1].getFloat());
                break;
            }
            case GEQ: {
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() >= this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() >= this._args[1].getFloat());
                break;
            }
            case LT: {
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() < this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() < this._args[1].getFloat());
                break;
            }
            case GT: {
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() > this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() > this._args[1].getFloat());
                break;
            }
            case CRD: {
                long ival = 0L;
                for (int i = 0; i < this.getArgCount(); ++i) {
                    if (!this.getArg(i).getBool()) continue;
                    ++ival;
                }
                this.setDouble(ival);
                break;
            }
            case NOT: {
                this.setBool(!this._args[0].getBool());
                break;
            }
            case NEG: {
                if (this.getScale() == Expr.Scale.Integer) {
                    this.setDouble(-this._args[0].getInt());
                    break;
                }
                this.setDouble(-this._args[0].getFloat());
                break;
            }
            case OR: 
            case AND: 
            case IMPLY: {
                boolean result = this._args[0].getBool();
                block53: for (int i = 1; i < this.getArgCount(); ++i) {
                    Expr expr = this.getArg(i);
                    switch (this._type) {
                        case OR: {
                            result |= expr.getBool();
                            continue block53;
                        }
                        case AND: {
                            result &= expr.getBool();
                            continue block53;
                        }
                        case IMPLY: {
                            result = !result | expr.getBool();
                        }
                    }
                }
                this.setBool(result);
                break;
            }
            default: {
                if (this.getScale() == Expr.Scale.Integer) {
                    long result = this._args[0].getInt();
                    block54: for (int i = 1; i < this.getArgCount(); ++i) {
                        Expr expr = this.getArg(i);
                        switch (this._type) {
                            case ADD: {
                                result += expr.getInt();
                                continue block54;
                            }
                            case SUB: {
                                result -= expr.getInt();
                                continue block54;
                            }
                            case MUL: {
                                result *= expr.getInt();
                                continue block54;
                            }
                            case DIV: {
                                if (expr.getInt() == 0L) {
                                    throw new TranslateException(this, "EXC_EXPR_DIV0", new Object[0]);
                                }
                                result /= expr.getInt();
                                continue block54;
                            }
                            case MOD: {
                                if (expr.getInt() == 0L) {
                                    throw new TranslateException(this, "EXC_EXPR_DIV0", new Object[0]);
                                }
                                result %= expr.getInt();
                                continue block54;
                            }
                            case MIN: {
                                result = Math.min(result, expr.getInt());
                                continue block54;
                            }
                            case MAX: {
                                result = Math.max(result, expr.getInt());
                            }
                        }
                    }
                    this.setDouble(result);
                    break;
                }
                if (this.getScale() != Expr.Scale.Float) break;
                double result = this._args[0].getFloat();
                block55: for (int i = 1; i < this.getArgCount(); ++i) {
                    Expr expr = this.getArg(i);
                    switch (this._type) {
                        case ADD: {
                            result += expr.getFloat();
                            continue block55;
                        }
                        case SUB: {
                            result -= expr.getFloat();
                            continue block55;
                        }
                        case MUL: {
                            result *= expr.getFloat();
                            continue block55;
                        }
                        case DIV: {
                            if (expr.getFloat() == 0.0) {
                                throw new TranslateException(this, "EXC_EXPR_DIV0", new Object[0]);
                            }
                            result /= expr.getFloat();
                            continue block55;
                        }
                        case MIN: {
                            result = Math.min(result, expr.getFloat());
                            continue block55;
                        }
                        case MAX: {
                            result = Math.max(result, expr.getFloat());
                        }
                    }
                }
                this.setDouble(result);
            }
        }
    }

    @Override
    protected Expr instance(Node owner, String inst) {
        ExprOp res = new ExprOp(this._type);
        res.instance(this);
        res._args = new Expr[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            res._args[i] = this._args[i].instance(owner, inst);
        }
        return owner.addUniqueExpr(res);
    }

    @Override
    public boolean exchangeChild(Expr oldChild, Expr newChild) {
        boolean result = false;
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i] != oldChild) continue;
            this._args[i] = newChild;
            result = true;
        }
        return result;
    }

    @Override
    public Expr translateLink(Node node) {
        super.translateLink(node);
        if (this._type == Type.EQ && this.getArg(0).isStructured()) {
            Link lk = (Link)this.getArg(0).getDomain();
            assert (this.getArg(0) instanceof ExprVar);
            assert (this.getArg(1) instanceof ExprVar);
            if (((ExprVar)this.getArg(1)).isOrientationFlow('\u0001')) {
                return lk.instanceDirect(this.getArg(0).toString(), this.getArg(1).toString(), 1, node);
            }
            if (((ExprVar)this.getArg(0)).isOrientationFlow('\u0002')) {
                return lk.instanceDirect(this.getArg(0).toString(), this.getArg(1).toString(), 2, node);
            }
            return lk.instance(this.getArg(0).toString(), this.getArg(1).toString(), node);
        }
        return null;
    }

    @Override
    public void verifyExpr(VerifyManager mng) {
        String opMess = null;
        String type = null;
        switch (this._type) {
            case NEG: {
                opMess = "-";
                type = "ExprAddSou";
                break;
            }
            case ADD: {
                opMess = "+";
                type = "ExprAddSou";
                break;
            }
            case SUB: {
                opMess = "-";
                type = "ExprAddSou";
                break;
            }
            case MUL: {
                opMess = "*";
                type = "ExprMulDiv";
                break;
            }
            case DIV: {
                opMess = "/";
                type = "ExprMulDiv";
                break;
            }
            case MOD: {
                opMess = "%";
                type = "ExprMod";
                break;
            }
            case MIN: {
                opMess = "min(...)";
                type = "ExprMinMax";
                break;
            }
            case MAX: {
                opMess = "max(...)";
                type = "ExprMinMax";
                break;
            }
            case CRD: {
                opMess = "#(...)";
                type = "ExprCrd";
            }
        }
        if (type != null && mng.withWarning(type)) {
            mng.addError(type, this, "WRN_EXPR_OPERATOR", opMess);
        }
        super.verifyExpr(mng);
    }

    @Override
    public Expr verifySymbolic(Var var) {
        Expr result = null;
        switch (this.getType()) {
            case ITE: {
                result = this.getArg(1).verifySymbolic(var);
                if (result != null) break;
                result = this.getArg(2).verifySymbolic(var);
                break;
            }
            case CASE: 
            case XCASE: {
                for (int i = 1; i < this.getArgCount() - 1 && result == null; i += 2) {
                    result = this.getArg(i).verifySymbolic(var);
                }
                if (result != null) break;
                result = this.getArg(this.getArgCount() - 1).verifySymbolic(var);
            }
        }
        return result;
    }

    @Override
    public boolean printAssertJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        out.addData(this);
        if (this._type != Type.EQ) {
            return false;
        }
        if (!(this.getArg(0) instanceof ExprVar)) {
            return false;
        }
        String name = this.getArg(0).toString();
        out.write(Expr.toIDJava(name));
        out.write(".setValue(");
        this._args[1].printJava(out, outs, csts);
        out.write(");\n");
        return true;
    }

    @Override
    public boolean printDeclarationJava(IndentWriter out, Set<String> vars, Set<String> outs, Map<String, Expr> csts, Map<String, Expr> links) throws IOException {
        out.addData(this);
        if (this._type == Type.EQ && this.getArg(0) instanceof ExprVar) {
            if (this.getArg(1) instanceof ExprVar) {
                return false;
            }
            this.printVarDeclarationJava(out, vars, outs, csts, links);
            return true;
        }
        throw new IOException("No Dataflow assertion");
    }

    @Override
    public boolean isLink() {
        if (this.getType() != Type.EQ) {
            return false;
        }
        if (!(this.getArg(0) instanceof ExprVar)) {
            return false;
        }
        if (this.getArg(1) instanceof ExprVar) {
            return true;
        }
        return this.getArg(1).isConstant();
    }

    @Override
    public boolean isAliasAssert() {
        if (this.getType() != Type.EQ) {
            return false;
        }
        if (!(this.getArg(0) instanceof ExprVar)) {
            return false;
        }
        return this.getArg(1) instanceof ExprVar;
    }

    @Override
    public void printLinkJava(IndentWriter out) throws IOException {
        assert (this.isLink());
        out.addData(this);
        out.write("getVariable(\"");
        Expr expr = this.getArg(0);
        out.write(expr.toString());
        out.write("\")");
        if (this.getArg(1) instanceof ExprVar) {
            out.write(".isAliasOf(getVariable(\"");
            expr = this.getArg(1);
            out.write(expr.toString());
            out.write("\"));\n");
        } else {
            out.write(".setInit(");
            this.getArg(1).printJava(out, null, null);
            out.write(");\n");
        }
    }

    @Override
    public void printJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        out.addData(this);
        switch (this._type) {
            case NOT: {
                out.write("(1. - ");
                this._args[0].printJava(out, outs, csts);
                out.write(")");
                break;
            }
            case NEG: {
                out.write("(-");
                this._args[0].printJava(out, outs, csts);
                out.write(")");
                break;
            }
            case OR: {
                out.write("((");
                this.printJavaArgs(out, " + ", outs, csts);
                out.write(" > 0.) ? 1. : 0.)");
                break;
            }
            case AND: {
                out.write("((");
                this.printJavaArgs(out, " * ", outs, csts);
                out.write(" > 0.) ? 1. : 0.)");
                break;
            }
            case IMPLY: {
                out.write("( (");
                this._args[0].printJava(out, outs, csts);
                out.write(">0 && ");
                this._args[1].printJava(out, outs, csts);
                out.write("==0) ? 0. : 1.)");
                break;
            }
            case ADD: 
            case CRD: {
                this.printJavaArgs(out, " + ", outs, csts);
                break;
            }
            case SUB: {
                this.printJavaArgs(out, " - ", outs, csts);
                break;
            }
            case MUL: {
                this.printJavaArgs(out, " * ", outs, csts);
                break;
            }
            case DIV: {
                out.write("Div");
                this.printJavaArgs(out, ", ", outs, csts);
                break;
            }
            case MOD: {
                out.write("Mod(");
                for (int i = 0; i < this._args.length; ++i) {
                    if (i > 0) {
                        out.write(", ");
                    }
                    out.write("((long)");
                    this._args[i].printJava(out, outs, csts);
                    out.write(")");
                }
                out.write(")");
                break;
            }
            case EQ: {
                out.write("(");
                this.printJavaArgs(out, " == ", outs, csts);
                out.write("?1.:0.)");
                break;
            }
            case NEQ: {
                out.write("(");
                this.printJavaArgs(out, " != ", outs, csts);
                out.write("?1.:0.)");
                break;
            }
            case LEQ: {
                out.write("(");
                this.printJavaArgs(out, " <= ", outs, csts);
                out.write("?1.:0.)");
                break;
            }
            case GEQ: {
                out.write("(");
                this.printJavaArgs(out, " >= ", outs, csts);
                out.write("?1.:0.)");
                break;
            }
            case LT: {
                out.write("(");
                this.printJavaArgs(out, " < ", outs, csts);
                out.write("?1.:0.)");
                break;
            }
            case GT: {
                out.write("(");
                this.printJavaArgs(out, " > ", outs, csts);
                out.write("?1.:0.)");
                break;
            }
            case MIN: 
            case MAX: {
                int i = 0;
                while (i < this.getArgCount() - 1) {
                    out.write(this._type == Type.MAX ? "Math.max(" : "Math.min(");
                    this.getArg(i++).printJava(out, outs, csts);
                    out.write(", ");
                }
                this.getArg(i).printJava(out, outs, csts);
                while (i-- > 0) {
                    out.write(")");
                }
                break;
            }
            case ITE: {
                out.write("((");
                this._args[0].printJava(out, outs, csts);
                out.write(">0) ? ");
                this._args[1].printJava(out, outs, csts);
                out.write(" : ");
                this._args[2].printJava(out, outs, csts);
                out.write(")");
                break;
            }
            case CASE: 
            case XCASE: {
                int i = 0;
                int cpt = 0;
                while (i < this.getArgCount() - 1) {
                    out.write("((");
                    this.getArg(i++).printJava(out, outs, csts);
                    out.write(">0) ? ");
                    this.getArg(i++).printJava(out, outs, csts);
                    out.write(" : ");
                    ++cpt;
                }
                this.getArg(i).printJava(out, outs, csts);
                while (cpt-- > 0) {
                    out.write(")");
                }
                break;
            }
            default: {
                throw new IOException("Internal Error - Error translate [" + this.getNamedType() + "] to Java simulator");
            }
        }
    }

    @Override
    public void printNaNJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        switch (this._type) {
            case NOT: {
                out.write("not(");
                this._args[0].printNaNJava(out, outs, csts);
                out.write(")");
                break;
            }
            case NEG: {
                out.write("neg(");
                this._args[0].printNaNJava(out, outs, csts);
                out.write(")");
                break;
            }
            case OR: {
                this.printNaNJavaArgs(out, outs, "or", csts);
                break;
            }
            case AND: {
                this.printNaNJavaArgs(out, outs, "and", csts);
                break;
            }
            case IMPLY: {
                this.printNaNJavaArgs(out, outs, "imply", csts);
                break;
            }
            case ADD: 
            case CRD: {
                this.printNaNJavaArgs(out, outs, "add", csts);
                break;
            }
            case SUB: {
                this.printNaNJavaArgs(out, outs, "sub", csts);
                break;
            }
            case MUL: {
                this.printNaNJavaArgs(out, outs, "mul", csts);
                break;
            }
            case DIV: {
                this.printNaNJavaArgs(out, outs, "div", csts);
                break;
            }
            case MOD: {
                this.printNaNJavaArgs(out, outs, "mod", csts);
                break;
            }
            case EQ: {
                this.printNaNJavaArgs(out, outs, "eq", csts);
                break;
            }
            case NEQ: {
                this.printNaNJavaArgs(out, outs, "neq", csts);
                break;
            }
            case LEQ: {
                this.printNaNJavaArgs(out, outs, "leq", csts);
                break;
            }
            case GEQ: {
                this.printNaNJavaArgs(out, outs, "geq", csts);
                break;
            }
            case LT: {
                this.printNaNJavaArgs(out, outs, "lt", csts);
                break;
            }
            case GT: {
                this.printNaNJavaArgs(out, outs, "gt", csts);
                break;
            }
            case MIN: {
                this.printNaNJavaArgs(out, outs, "min", csts);
                break;
            }
            case MAX: {
                this.printNaNJavaArgs(out, outs, "max", csts);
                break;
            }
            case ITE: {
                out.write("ite(");
                this._args[0].printNaNJava(out, outs, csts);
                out.write(", ");
                this._args[1].printNaNJava(out, outs, csts);
                out.write(", ");
                this._args[2].printNaNJava(out, outs, csts);
                out.write(")");
                break;
            }
            case CASE: 
            case XCASE: {
                int cpt = 0;
                int i = 0;
                while (i < this.getArgCount() - 1) {
                    out.write("ite(");
                    this.getArg(i++).printNaNJava(out, outs, csts);
                    out.write(", ");
                    this.getArg(i++).printNaNJava(out, outs, csts);
                    out.write(", ");
                    ++cpt;
                }
                this.getArg(i).printNaNJava(out, outs, csts);
                while (cpt-- > 0) {
                    out.write(")");
                }
                break;
            }
            default: {
                throw new IOException("Internal Error - Error translate [" + this.getNamedType() + "] to Java simulator");
            }
        }
    }

    @Override
    public void printMoca(IndentWriter out) throws IOException {
        out.addData(this);
        switch (this._type) {
            case NOT: {
                out.write("(! ");
                this._args[0].printMoca(out);
                out.write(")");
                break;
            }
            case NEG: {
                out.write("(-");
                this._args[0].printMoca(out);
                out.write(")");
                break;
            }
            case IMPLY: {
                out.write("((! ");
                this._args[0].printMoca(out);
                out.write(") | ");
                this._args[1].printMoca(out);
                out.write(")");
                break;
            }
            case OR: {
                this.printMocaArgs(out, " | ");
                break;
            }
            case AND: {
                this.printMocaArgs(out, " & ");
                break;
            }
            case ADD: {
                this.printMocaArgs(out, " + ");
                break;
            }
            case SUB: {
                this.printMocaArgs(out, " - ");
                break;
            }
            case MUL: {
                this.printMocaArgs(out, " * ");
                break;
            }
            case DIV: {
                this.printMocaArgs(out, " / ");
                break;
            }
            case MOD: {
                this.printMocaArgs(out, " % ");
                break;
            }
            case EQ: {
                this.printMocaArgs(out, " == ");
                break;
            }
            case NEQ: {
                this.printMocaArgs(out, " != ");
                break;
            }
            case LEQ: {
                this.printMocaArgs(out, " <= ");
                break;
            }
            case GEQ: {
                this.printMocaArgs(out, " >= ");
                break;
            }
            case LT: {
                this.printMocaArgs(out, " < ");
                break;
            }
            case GT: {
                this.printMocaArgs(out, " > ");
                break;
            }
            case MIN: {
                out.write("min");
                this.printMocaArgs(out, ", ");
                break;
            }
            case MAX: {
                out.write("max");
                this.printMocaArgs(out, ", ");
                break;
            }
            case CRD: {
                out.write("@()");
                this.printMocaArgs(out, ", ");
                break;
            }
            case ITE: {
                out.write("ite(");
                this._args[0].printMoca(out);
                out.write(", ");
                this._args[1].printMoca(out);
                out.write(", ");
                this._args[2].printMoca(out);
                out.write(")");
                break;
            }
            case CASE: 
            case XCASE: {
                int cpt = 0;
                for (int i = 0; i < this.getArgCount() - 1; ++i) {
                    if (i % 2 == 0) {
                        if (i > 0) {
                            out.write(", ");
                        }
                        out.write(" ite(");
                        ++cpt;
                    } else {
                        out.write(", ");
                    }
                    this.getArg(i).printMoca(out);
                }
                out.write(", ");
                this.getArg(this.getArgCount() - 1).printMoca(out);
                while (cpt-- > 0) {
                    out.write(") ");
                }
                break;
            }
        }
    }

    @Override
    public void printAssertLL(IndentWriter out, int frm) throws IOException {
        if (this._type == Type.EQ) {
            out.addData(this);
            for (int i = 0; i < this._args.length; ++i) {
                if (i > 0) {
                    out.write(" = ");
                }
                this._args[i].printOTools(out, frm);
            }
        } else {
            super.printAssertLL(out, frm);
        }
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        switch (this._type) {
            case NOT: {
                out.write("(not ");
                this._args[0].printOTools(out, frm);
                out.write(")");
                break;
            }
            case NEG: {
                out.write("(-");
                this._args[0].printOTools(out, frm);
                out.write(")");
                break;
            }
            case OR: {
                this.printOToolsArgs(out, " or ", frm);
                break;
            }
            case AND: {
                this.printOToolsArgs(out, " and ", frm);
                break;
            }
            case IMPLY: {
                this.printOToolsArgs(out, " => ", frm);
                break;
            }
            case ADD: {
                this.printOToolsArgs(out, " + ", frm);
                break;
            }
            case SUB: {
                this.printOToolsArgs(out, " - ", frm);
                break;
            }
            case MUL: {
                this.printOToolsArgs(out, " * ", frm);
                break;
            }
            case DIV: {
                this.printOToolsArgs(out, " / ", frm);
                break;
            }
            case MOD: {
                this.printOToolsArgs(out, " % ", frm);
                break;
            }
            case EQ: {
                this.printOToolsArgs(out, " = ", frm);
                break;
            }
            case NEQ: {
                this.printOToolsArgs(out, frm == 4 ? " != " : " # ", frm);
                break;
            }
            case LEQ: {
                this.printOToolsArgs(out, " <= ", frm);
                break;
            }
            case GEQ: {
                this.printOToolsArgs(out, " >= ", frm);
                break;
            }
            case LT: {
                this.printOToolsArgs(out, " < ", frm);
                break;
            }
            case GT: {
                this.printOToolsArgs(out, " > ", frm);
                break;
            }
            case MIN: {
                out.write("min");
                this.printOToolsArgs(out, ", ", frm);
                break;
            }
            case MAX: {
                out.write("max");
                this.printOToolsArgs(out, ", ", frm);
                break;
            }
            case CRD: {
                out.write("#");
                this.printOToolsArgs(out, ", ", frm);
                break;
            }
            case ITE: {
                out.write("(if ");
                this._args[0].printOTools(out, frm);
                out.write(" then ");
                this._args[1].printOTools(out, frm);
                out.write(" else ");
                this._args[2].printOTools(out, frm);
                out.write(")");
                break;
            }
            case CASE: 
            case XCASE: {
                if (frm == 4) {
                    out.write("( ");
                }
                out.write("case { \n");
                out.addIndent(1);
                for (int i = 0; i < this.getArgCount() - 1; ++i) {
                    this.getArg(i).printOTools(out, frm);
                    out.write(i % 2 == 0 ? " : " : ",\n");
                }
                out.write("else ");
                this.getArg(this.getArgCount() - 1).printOTools(out, frm);
                out.addIndent(-1);
                out.write("\n}");
                if (frm != 4) break;
                out.write(" )");
            }
        }
    }

    @Override
    public void evaluateIfNecessary() throws StepperException {
        if (this._flag == '\u0000') {
            return;
        }
        switch (this._type) {
            case XCASE: {
                boolean find = false;
                for (int i = 0; i < this._args.length - 1; ++i) {
                    this._args[i].evaluateIfNecessary();
                    if (!this._args[i++].getBool()) continue;
                    this._args[i].evaluateIfNecessary();
                    if (find && this.getDouble() != this._args[i].getDouble()) {
                        throw new StepperException(MsgTrans.msgFormat("EXC_EXPR_CASE_EXCLUSIF", this.toString()));
                    }
                    this.setDouble(this._args[i].getDouble());
                    find = true;
                }
                if (find) break;
                this._args[this._args.length - 1].evaluateIfNecessary();
                this.setDouble(this._args[this._args.length - 1].getDouble());
                break;
            }
            case CASE: {
                boolean find = false;
                for (int i = 0; !find && i < this._args.length - 1; ++i) {
                    this._args[i].evaluateIfNecessary();
                    if (!this._args[i++].getBool()) continue;
                    this._args[i].evaluateIfNecessary();
                    this.setDouble(this._args[i].getDouble());
                    find = true;
                }
                if (find) break;
                this._args[this._args.length - 1].evaluateIfNecessary();
                this.setDouble(this._args[this._args.length - 1].getDouble());
                break;
            }
            case ITE: {
                this._args[0].evaluateIfNecessary();
                if (this._args[0].getBool()) {
                    this._args[1].evaluateIfNecessary();
                    this.setDouble(this._args[1].getDouble());
                    break;
                }
                this._args[2].evaluateIfNecessary();
                this.setDouble(this._args[2].getDouble());
                break;
            }
            case EQ: {
                this._args[0].evaluateIfNecessary();
                this._args[1].evaluateIfNecessary();
                switch (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex())) {
                    case 1: {
                        this.setBool(this._args[0].getBool() == this._args[1].getBool());
                        break;
                    }
                    case 2: {
                        this.setBool(this._args[0].getInt() == this._args[1].getInt());
                        break;
                    }
                    case 3: {
                        this.setBool(this._args[0].getFloat() == this._args[1].getFloat());
                        break;
                    }
                    case 4: {
                        this.setBool(this._args[0].getSymbol() == this._args[1].getSymbol());
                    }
                }
                break;
            }
            case NEQ: {
                this._args[0].evaluateIfNecessary();
                this._args[1].evaluateIfNecessary();
                switch (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex())) {
                    case 1: {
                        this.setBool(this._args[0].getBool() != this._args[1].getBool());
                        break;
                    }
                    case 2: {
                        this.setBool(this._args[0].getInt() != this._args[1].getInt());
                        break;
                    }
                    case 3: {
                        this.setBool(this._args[0].getFloat() != this._args[1].getFloat());
                        break;
                    }
                    case 4: {
                        this.setBool(this._args[0].getSymbol() != this._args[1].getSymbol());
                    }
                }
                break;
            }
            case LEQ: {
                this._args[0].evaluateIfNecessary();
                this._args[1].evaluateIfNecessary();
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() <= this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() <= this._args[1].getFloat());
                break;
            }
            case GEQ: {
                this._args[0].evaluateIfNecessary();
                this._args[1].evaluateIfNecessary();
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() >= this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() >= this._args[1].getFloat());
                break;
            }
            case LT: {
                this._args[0].evaluateIfNecessary();
                this._args[1].evaluateIfNecessary();
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() < this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() < this._args[1].getFloat());
                break;
            }
            case GT: {
                this._args[0].evaluateIfNecessary();
                this._args[1].evaluateIfNecessary();
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() > this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() > this._args[1].getFloat());
                break;
            }
            case CRD: {
                long ival = 0L;
                for (int i = 0; i < this._args.length; ++i) {
                    this._args[i].evaluateIfNecessary();
                    if (!this._args[i].getBool()) continue;
                    ++ival;
                }
                this.setDouble(ival);
                break;
            }
            case NOT: {
                this._args[0].evaluateIfNecessary();
                this.setBool(!this._args[0].getBool());
                break;
            }
            case NEG: {
                this._args[0].evaluateIfNecessary();
                if (this.getScale() == Expr.Scale.Integer) {
                    this.setDouble(-this._args[0].getInt());
                    break;
                }
                this.setDouble(-this._args[0].getFloat());
                break;
            }
            case OR: {
                Expr expr;
                this._args[0].evaluateIfNecessary();
                boolean result = this._args[0].getBool();
                for (int i = 1; !result && i < this._args.length; result |= expr.getBool(), ++i) {
                    expr = this._args[i];
                    expr.evaluateIfNecessary();
                }
                this.setBool(result);
                break;
            }
            case AND: {
                Expr expr;
                this._args[0].evaluateIfNecessary();
                boolean result = this._args[0].getBool();
                for (int i = 1; result && i < this._args.length; result &= expr.getBool(), ++i) {
                    expr = this._args[i];
                    expr.evaluateIfNecessary();
                }
                this.setBool(result);
                break;
            }
            case IMPLY: {
                this._args[0].evaluateIfNecessary();
                boolean result = this._args[0].getBool();
                for (int i = 1; i < this._args.length; ++i) {
                    Expr expr = this._args[i];
                    expr.evaluateIfNecessary();
                    result = !result | expr.getBool();
                }
                this.setBool(result);
                break;
            }
            default: {
                if (this.getScale() == Expr.Scale.Integer) {
                    this._args[0].evaluateIfNecessary();
                    long result = this._args[0].getInt();
                    block52: for (int i = 1; i < this._args.length; ++i) {
                        Expr expr = this._args[i];
                        expr.evaluateIfNecessary();
                        switch (this._type) {
                            case ADD: {
                                result += expr.getInt();
                                continue block52;
                            }
                            case SUB: {
                                result -= expr.getInt();
                                continue block52;
                            }
                            case MUL: {
                                result *= expr.getInt();
                                continue block52;
                            }
                            case DIV: {
                                if (expr.getInt() == 0L) {
                                    throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
                                }
                                result /= expr.getInt();
                                continue block52;
                            }
                            case MOD: {
                                if (expr.getInt() == 0L) {
                                    throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
                                }
                                result %= expr.getInt();
                                continue block52;
                            }
                            case MIN: {
                                result = Math.min(result, expr.getInt());
                                continue block52;
                            }
                            case MAX: {
                                result = Math.max(result, expr.getInt());
                            }
                        }
                    }
                    this.setDouble(result);
                    break;
                }
                this._args[0].evaluateIfNecessary();
                double result = this._args[0].getFloat();
                block53: for (int i = 1; i < this._args.length; ++i) {
                    Expr expr = this._args[i];
                    expr.evaluateIfNecessary();
                    switch (this._type) {
                        case ADD: {
                            result += expr.getFloat();
                            continue block53;
                        }
                        case SUB: {
                            result -= expr.getFloat();
                            continue block53;
                        }
                        case MUL: {
                            result *= expr.getFloat();
                            continue block53;
                        }
                        case DIV: {
                            if (expr.getFloat() == 0.0) {
                                throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
                            }
                            result /= expr.getFloat();
                            continue block53;
                        }
                        case MIN: {
                            result = Math.min(result, expr.getFloat());
                            continue block53;
                        }
                        case MAX: {
                            result = Math.max(result, expr.getFloat());
                        }
                    }
                }
                this.setDouble(result);
            }
        }
        this._flag = '\u0000';
    }

    @Override
    public boolean evaluateWithNaN() throws StepperException {
        if (this._flag == '\u0000') {
            return true;
        }
        switch (this._type) {
            case XCASE: {
                boolean find = false;
                for (int i = 0; i < this._args.length - 1; ++i) {
                    if (!this._args[i].evaluateWithNaN()) {
                        return false;
                    }
                    if (!this._args[i++].getBool()) continue;
                    if (!this._args[i].evaluateWithNaN()) {
                        return false;
                    }
                    if (find && this.getDouble() != this._args[i].getDouble()) {
                        throw new StepperException(MsgTrans.msgFormat("EXC_EXPR_CASE_EXCLUSIF", this.toString()));
                    }
                    this.setDouble(this._args[i].getDouble());
                    find = true;
                }
                if (find) break;
                if (!this._args[this._args.length - 1].evaluateWithNaN()) {
                    return false;
                }
                this.setDouble(this._args[this._args.length - 1].getDouble());
                break;
            }
            case CASE: {
                boolean find = false;
                for (int i = 0; !find && i < this._args.length - 1; ++i) {
                    if (!this._args[i].evaluateWithNaN()) {
                        return false;
                    }
                    if (!this._args[i++].getBool()) continue;
                    if (!this._args[i].evaluateWithNaN()) {
                        return false;
                    }
                    this.setDouble(this._args[i].getDouble());
                    find = true;
                }
                if (find) break;
                if (!this._args[this._args.length - 1].evaluateWithNaN()) {
                    return false;
                }
                this.setDouble(this._args[this._args.length - 1].getDouble());
                break;
            }
            case ITE: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (this._args[0].getBool()) {
                    if (!this._args[1].evaluateWithNaN()) {
                        return false;
                    }
                    this.setDouble(this._args[1].getDouble());
                    break;
                }
                if (!this._args[2].evaluateWithNaN()) {
                    return false;
                }
                this.setDouble(this._args[2].getDouble());
                break;
            }
            case EQ: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (!this._args[1].evaluateWithNaN()) {
                    return false;
                }
                switch (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex())) {
                    case 1: {
                        this.setBool(this._args[0].getBool() == this._args[1].getBool());
                        break;
                    }
                    case 2: {
                        this.setBool(this._args[0].getInt() == this._args[1].getInt());
                        break;
                    }
                    case 3: {
                        this.setBool(this._args[0].getFloat() == this._args[1].getFloat());
                        break;
                    }
                    case 4: {
                        this.setBool(this._args[0].getSymbol() == this._args[1].getSymbol());
                    }
                }
                break;
            }
            case NEQ: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (!this._args[1].evaluateWithNaN()) {
                    return false;
                }
                switch (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex())) {
                    case 1: {
                        this.setBool(this._args[0].getBool() != this._args[1].getBool());
                        break;
                    }
                    case 2: {
                        this.setBool(this._args[0].getInt() != this._args[1].getInt());
                        break;
                    }
                    case 3: {
                        this.setBool(this._args[0].getFloat() != this._args[1].getFloat());
                        break;
                    }
                    case 4: {
                        this.setBool(this._args[0].getSymbol() != this._args[1].getSymbol());
                    }
                }
                break;
            }
            case LEQ: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (!this._args[1].evaluateWithNaN()) {
                    return false;
                }
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() <= this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() <= this._args[1].getFloat());
                break;
            }
            case GEQ: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (!this._args[1].evaluateWithNaN()) {
                    return false;
                }
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() >= this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() >= this._args[1].getFloat());
                break;
            }
            case LT: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (!this._args[1].evaluateWithNaN()) {
                    return false;
                }
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() < this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() < this._args[1].getFloat());
                break;
            }
            case GT: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (!this._args[1].evaluateWithNaN()) {
                    return false;
                }
                if (Math.max(this._args[0].getScale().getIndex(), this._args[1].getScale().getIndex()) == 2) {
                    this.setBool(this._args[0].getInt() > this._args[1].getInt());
                    break;
                }
                this.setBool(this._args[0].getFloat() > this._args[1].getFloat());
                break;
            }
            case CRD: {
                long ival = 0L;
                for (int i = 0; i < this._args.length; ++i) {
                    if (!this._args[i].evaluateWithNaN()) {
                        return false;
                    }
                    if (!this._args[i].getBool()) continue;
                    ++ival;
                }
                this.setDouble(ival);
                break;
            }
            case NOT: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                this.setBool(!this._args[0].getBool());
                break;
            }
            case NEG: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                if (this.getScale() == Expr.Scale.Integer) {
                    this.setDouble(-this._args[0].getInt());
                    break;
                }
                this.setDouble(-this._args[0].getFloat());
                break;
            }
            case OR: {
                int nbrNaN = 0;
                boolean result = false;
                for (int i = 0; i < this._args.length; ++i) {
                    Expr expr = this._args[i];
                    if (!expr.evaluateWithNaN()) {
                        ++nbrNaN;
                        continue;
                    }
                    if (!(result |= expr.getBool())) continue;
                    nbrNaN = 0;
                    break;
                }
                if (nbrNaN > 0) {
                    return false;
                }
                this.setBool(result);
                break;
            }
            case AND: {
                int nbrNaN = 0;
                boolean result = true;
                for (int i = 0; i < this._args.length; ++i) {
                    Expr expr = this._args[i];
                    if (!expr.evaluateWithNaN()) {
                        ++nbrNaN;
                        continue;
                    }
                    if (result &= expr.getBool()) continue;
                    nbrNaN = 0;
                    break;
                }
                if (nbrNaN > 0) {
                    return false;
                }
                this.setBool(result);
                break;
            }
            case IMPLY: {
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                boolean result = this._args[0].getBool();
                for (int i = 1; i < this._args.length; ++i) {
                    Expr expr = this._args[i];
                    if (!expr.evaluateWithNaN()) {
                        return false;
                    }
                    result = !result | expr.getBool();
                }
                this.setBool(result);
                break;
            }
            default: {
                if (this.getScale() == Expr.Scale.Integer) {
                    if (!this._args[0].evaluateWithNaN()) {
                        return false;
                    }
                    long result = this._args[0].getInt();
                    block52: for (int i = 1; i < this._args.length; ++i) {
                        Expr expr = this._args[i];
                        if (!expr.evaluateWithNaN()) {
                            return false;
                        }
                        switch (this._type) {
                            case ADD: {
                                result += expr.getInt();
                                continue block52;
                            }
                            case SUB: {
                                result -= expr.getInt();
                                continue block52;
                            }
                            case MUL: {
                                result *= expr.getInt();
                                continue block52;
                            }
                            case DIV: {
                                if (expr.getInt() == 0L) {
                                    throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
                                }
                                result /= expr.getInt();
                                continue block52;
                            }
                            case MOD: {
                                if (expr.getInt() == 0L) {
                                    throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
                                }
                                result %= expr.getInt();
                                continue block52;
                            }
                            case MIN: {
                                result = Math.min(result, expr.getInt());
                                continue block52;
                            }
                            case MAX: {
                                result = Math.max(result, expr.getInt());
                            }
                        }
                    }
                    this.setDouble(result);
                    break;
                }
                if (!this._args[0].evaluateWithNaN()) {
                    return false;
                }
                double result = this._args[0].getFloat();
                block53: for (int i = 1; i < this._args.length; ++i) {
                    Expr expr = this._args[i];
                    if (!expr.evaluateWithNaN()) {
                        return false;
                    }
                    switch (this._type) {
                        case ADD: {
                            result += expr.getFloat();
                            continue block53;
                        }
                        case SUB: {
                            result -= expr.getFloat();
                            continue block53;
                        }
                        case MUL: {
                            result *= expr.getFloat();
                            continue block53;
                        }
                        case DIV: {
                            if (expr.getFloat() == 0.0) {
                                throw new StepperException(MsgTrans.getString("EXC_EXPR_DIV0"));
                            }
                            result /= expr.getFloat();
                            continue block53;
                        }
                        case MIN: {
                            result = Math.min(result, expr.getFloat());
                            continue block53;
                        }
                        case MAX: {
                            result = Math.max(result, expr.getFloat());
                        }
                    }
                }
                this.setDouble(result);
            }
        }
        this._flag = '\u0000';
        return true;
    }

    public static enum Type {
        UNDEF(0),
        NOT(6),
        OR(7),
        AND(8),
        IMPLY(9),
        NEG(10),
        ADD(11),
        SUB(12),
        MUL(13),
        DIV(14),
        MOD(15),
        EQ(16),
        NEQ(17),
        LEQ(18),
        GEQ(19),
        LT(20),
        GT(21),
        ITE(22),
        MIN(23),
        MAX(24),
        CRD(25),
        CASE(27),
        XCASE(28);

        int _index;
        private static Map<Integer, Type> __indexToType;

        public int getIndex() {
            return this._index;
        }

        private Type(int idx) {
            this._index = idx;
        }

        public static Type valueOf(int idx) {
            Type result;
            if (__indexToType == null) {
                __indexToType = new HashMap<Integer, Type>();
                Type[] types = Type.values();
                for (int i = types.length - 1; i >= 0; --i) {
                    __indexToType.put(types[i].getIndex(), types[i]);
                }
            }
            if ((result = __indexToType.get(idx)) == null) {
                result = UNDEF;
            }
            return result;
        }

        static {
            __indexToType = null;
        }
    }
}

