/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.ModelReader;
import com.dassault.cecilia.lib.mbsa.StepperInstantaneousLoopException;
import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefArchitecture;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefComponent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefEquipment;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDomain;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JEvent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JFlowIn;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JFlowOut;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JState;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainDefine;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.Fct;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.LineCorrespondence;
import com.dassault.cecilia.lib.mbsa.translator.model.Link;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Sub;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class Model
extends Data
implements ModelReader {
    private Date _DateAtCreateModel = new Date();
    long _uid = -1L;
    private DomainDefine _domainDefine;
    private ArrayList<Domain> _domainLst;
    private HashMap<String, Domain> _domainMap;
    private ExprCst TRUE = new ExprCst(true);
    private ExprCst FALSE = new ExprCst(false);
    private ArrayList<Node> _nodeLst;
    private HashMap<String, Node> _nodeMap;
    private String _defaultNode = null;
    private ArrayList<Fct> _fctLst;
    private HashMap<String, Fct> _fctMap;
    private static final String PROP_MODEL_DEBUG_WRITERJAVA = "cecilia.mbsa.translator.model.DebugWriterJava";

    public Model(long key) {
        this._domainDefine = new DomainDefine();
        this._domainLst = new ArrayList();
        this._domainMap = new HashMap();
        this._nodeLst = new ArrayList();
        this._nodeMap = new HashMap();
        this._fctLst = new ArrayList();
        this._fctMap = new HashMap();
        this.addDefaultDomain();
    }

    public void setUID(long uid) {
        this._uid = uid;
    }

    public long getUID() {
        return this._uid;
    }

    protected Domain addPrivateDomain(String name, Domain domain) {
        assert (!this._domainMap.containsKey(name));
        for (Domain search : this._domainLst) {
            if (!search.equals(domain)) continue;
            this._domainMap.put(name, search);
            return search;
        }
        if (domain.getName() == null) {
            domain.setName(name);
        }
        this._domainLst.add(domain);
        this._domainMap.put(name, domain);
        return domain;
    }

    public int getDomainCount() {
        return this._domainLst.size();
    }

    public Domain getDomain(int i) {
        return this._domainLst.get(i);
    }

    public Domain getDomain(String name) {
        return this._domainMap.get(name);
    }

    public DomainDefine getDomainDefine() {
        return this._domainDefine;
    }

    public ExprCst getBooleanExpr(boolean value) {
        return value ? this.TRUE : this.FALSE;
    }

    protected void addPrivateNode(Node node) {
        this._nodeLst.add(node);
        assert (!this._nodeMap.containsKey(node.getName()));
        this._nodeMap.put(node.getName(), node);
    }

    @Override
    public int getNodeCount() {
        return this._nodeLst.size();
    }

    @Override
    public Node getNode(int i) {
        return this._nodeLst.get(i);
    }

    public Node getNode(String name) {
        Node result = this._nodeMap.get(name);
        return result;
    }

    public void setDefaultNode(String name) {
        this._defaultNode = name;
    }

    public String getDefaultNode() {
        return this._defaultNode;
    }

    protected void addPrivateFct(Fct fct) {
        this._fctLst.add(fct);
        assert (!this._fctMap.containsKey(fct.getName()));
        this._fctMap.put(fct.getName(), fct);
    }

    @Override
    public int getFctCount() {
        return this._fctLst.size();
    }

    @Override
    public Fct getFct(int i) {
        return this._fctLst.get(i);
    }

    public Fct getFct(String name) {
        return this._fctMap.get(name);
    }

    private void addDefaultDomain() {
        this.addPrivateDomain("bool", this._domainDefine.getBool());
        this.addPrivateDomain("int", this._domainDefine.getInt());
        this.addPrivateDomain("float", this._domainDefine.getFloat());
    }

    public Domain addNamedDomain(String name, Domain res) throws TranslateException {
        if (this._domainMap.containsKey(name)) {
            throw new TranslateException(res, "EXC_DOMAIN_NAME_USED", name);
        }
        return this.addPrivateDomain(name, res);
    }

    public void addNode(Node add) {
        assert (!this._nodeMap.containsKey(add.getName())) : "Name already used for another node";
        this.addPrivateNode(add);
    }

    public void addFct(Fct add) {
        assert (!this._fctMap.containsKey(add.getName())) : "Name already used for another fonction";
        this.addPrivateFct(add);
    }

    private static final long getMemoryUsed() {
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        }
        return -1L;
    }

    private void traceOperation(String op, long beginTime, long beginMem) {
        if (!MsgTrans.LOG.isLoggable(Level.FINER)) {
            return;
        }
        long delay = System.nanoTime() - beginTime;
        MsgTrans.LOG.finer(new StringBuffer(64).append("Model.").append(op).append(".Delay.ms=").append(delay / 1000000L).toString());
        long usedMem = Model.getMemoryUsed() - beginMem;
        MsgTrans.LOG.finer(new StringBuffer(64).append("Model.").append(op).append(".MUsed.ko=").append(usedMem / 1024L).toString());
    }

    public void rename(String opt) {
        String newName;
        int i;
        ArrayList<Data> lst;
        RenameHelper helper;
        long beginTime;
        long beginMem;
        block7: {
            beginMem = Model.getMemoryUsed();
            beginTime = System.nanoTime();
            helper = new RenameHelper(opt);
            lst = this._domainLst;
            this._domainLst = new ArrayList();
            this._domainMap = new HashMap();
            this.addDefaultDomain();
            try {
                for (i = 3; i < lst.size(); ++i) {
                    Domain dom = lst.get(i);
                    newName = "domain" + helper.format(i - 2);
                    helper.appendTrace("\ndomain : " + dom.getName() + " -> " + newName + "\n");
                    this.addNamedDomain(newName, dom);
                    dom.rename(newName);
                }
            }
            catch (TranslateException exc) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)exc.getMessage());
            }
        }
        this._domainDefine.rename(helper);
        lst = this._fctLst;
        this._fctLst = new ArrayList();
        this._fctMap = new HashMap();
        for (i = 0; i < lst.size(); ++i) {
            Fct fct = (Fct)lst.get(i);
            newName = "funct" + helper.format(i + 1);
            helper.appendTrace("\nfunc : " + fct.getName() + " -> " + newName + "\n");
            fct.rename(helper, newName);
            this.addFct(fct);
        }
        lst = this._nodeLst;
        this._nodeLst = new ArrayList();
        this._nodeMap = new HashMap();
        for (i = 0; i < lst.size(); ++i) {
            Node node = (Node)lst.get(i);
            newName = "node" + helper.format(i + 1);
            if (node.getName().equalsIgnoreCase("main")) {
                newName = node.getName();
            }
            helper.appendTrace("\nnode : " + node.getName() + " -> " + newName + "\n");
            node.rename(helper, newName);
            this.addNode(node);
        }
        helper.close();
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            this.traceOperation("Rename", beginTime, beginMem);
        }
    }

    public void statistics(Writer write, String name) throws IOException, TranslateException {
        if (this.getNodeCount() == 1) {
            this.statisticsAfterFlatness(write, name);
        } else {
            this.statisticsBeforeTranslate(write, name);
        }
    }

    public void statisticsBeforeTranslate(Writer write, String name) throws IOException, TranslateException {
        Node node;
        write.append("Before translate");
        write.append("\n  Define domain : ");
        write.append(Integer.toString(this.getDomainCount() - 3));
        write.append("\n  Define function : ");
        write.append(Integer.toString(this.getFctCount()));
        write.append("\n  Define node : ");
        write.append(Integer.toString(this.getNodeCount()));
        int nbrEquip = 0;
        for (int i = this.getNodeCount() - 1; i >= 0; --i) {
            if (this.getNode(i).getSubCount() <= 0) continue;
            ++nbrEquip;
        }
        if (nbrEquip > 0) {
            write.append(" (hierarchical : ");
            write.append(Integer.toString(nbrEquip));
            write.append(")");
        }
        if (name == null || name.length() == 0) {
            name = "main";
        }
        if ((node = this.getNode("main")) == null) {
            throw new TranslateException("EXC_NODE_UNKNOW", name);
        }
        IdentityHashMap<Node, Map<String, Integer>> map = new IdentityHashMap<Node, Map<String, Integer>>();
        Map<String, Integer> stats = node.statistics(map);
        write.append("\n  Node instance : ");
        write.append(Integer.toString(stats.get("sub")));
        write.append("\n  Hierarchical node instance : ");
        write.append(Integer.toString(stats.get("sub.equipment")));
        write.append("\n");
    }

    public void statisticsAfterFlatness(Writer write, String name) throws IOException, TranslateException {
        Node node;
        if (name == null || name.length() == 0) {
            name = "main";
        }
        if ((node = this.getNode("main")) == null) {
            throw new TranslateException("EXC_NODE_UNKNOW", name);
        }
        IdentityHashMap<Node, Map<String, Integer>> map = new IdentityHashMap<Node, Map<String, Integer>>();
        Map<String, Integer> stats = node.statistics(map);
        write.append("After flatness");
        write.append("\n  Flow : ");
        write.append(Integer.toString(stats.get("flow")));
        write.append(" (alias : ");
        write.append(Integer.toString(stats.get("flow.alias")));
        write.append(")");
        write.append("\n  State : ");
        write.append(Integer.toString(stats.get("state")));
        write.append("\n  Event : ");
        write.append(Integer.toString(stats.get("event")));
        write.append("\n  Trans : ");
        write.append(Integer.toString(stats.get("trans")));
        write.append("\n  Extern clause : ");
        write.append(Integer.toString(stats.get("extern")));
        write.append("\n  Expression : ");
        write.append(Integer.toString(stats.get("expression")));
        write.append("\n");
    }

    public void translate(boolean withoutCCF) throws TranslateException {
        long beginMem = Model.getMemoryUsed();
        long beginTime = System.nanoTime();
        try {
            int i;
            for (i = 0; i < this.getFctCount(); ++i) {
                this.getFct(i).translateAssert();
            }
            for (i = 0; i < this.getNodeCount(); ++i) {
                this.getNode(i).translateAssert();
                this.getNode(i).translateFlow();
            }
            for (i = this.getNodeCount() - 1; i >= 0; --i) {
                this.getNode(i).translateCCF(withoutCCF);
            }
            this._fctLst = new ArrayList();
            this._fctMap = new HashMap();
            Iterator<Domain> iter = this._domainLst.iterator();
            while (iter.hasNext()) {
                Domain dom = iter.next();
                if (!(dom instanceof Link)) continue;
                iter.remove();
                this._domainMap.remove(dom.getName());
            }
        }
        catch (OutOfMemoryError e) {
            throw new TranslateException("EXC_OUTOFMEMORY", "translate", e.getMessage());
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            this.traceOperation("Translate", beginTime, beginMem);
        }
    }

    public void dataflow(String name, boolean simul) throws TranslateException {
        block9: {
            long beginMem = Model.getMemoryUsed();
            long beginTime = System.nanoTime();
            try {
                Node node;
                for (int i = 0; i < this.getFctCount(); ++i) {
                    this.getFct(i).dataflow(simul);
                }
                if (name == null || name.length() == 0) {
                    name = "main";
                }
                if ((node = this.getNode(name)) != null) {
                    node.dataflow(simul);
                    break block9;
                }
                throw new TranslateException("EXC_NODE_UNKNOW", name);
            }
            catch (OutOfMemoryError e) {
                throw new TranslateException("EXC_OUTOFMEMORY", "dataflow", e.getMessage());
            }
            finally {
                if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                    this.traceOperation("Dataflow", beginTime, beginMem);
                }
            }
        }
    }

    public Model flatness(String name) throws TranslateException {
        long beginMem = Model.getMemoryUsed();
        long beginTime = System.nanoTime();
        try {
            Node node;
            Model res = new Model(new Date().getTime());
            res._uid = this._uid;
            res._domainDefine = this._domainDefine;
            for (int i = 0; i < this.getDomainCount(); ++i) {
                Domain dom = this.getDomain(i);
                if (res._domainMap.containsKey(dom.getName())) continue;
                res.addPrivateDomain(dom.getName(), dom);
            }
            if (name == null || name.length() == 0) {
                name = "main";
            }
            if ((node = this.getNode(name)) == null) {
                throw new TranslateException("EXC_NODE_UNKNOW", name);
            }
            Node fnode = node.flatness(res);
            res.addNode(fnode);
            Model model = res;
            return model;
        }
        catch (OutOfMemoryError e) {
            throw new TranslateException("EXC_OUTOFMEMORY", "flatness", e.getMessage());
        }
        finally {
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                this.traceOperation("Flatness", beginTime, beginMem);
            }
        }
    }

    public void localSimul() throws TranslateException {
        long beginMem = Model.getMemoryUsed();
        long beginTime = System.nanoTime();
        try {
            for (int i = 0; i < this.getNodeCount(); ++i) {
                this.getNode(i).localSimul();
            }
        }
        catch (OutOfMemoryError e) {
            throw new TranslateException("EXC_OUTOFMEMORY", "local-simul", e.getMessage());
        }
        finally {
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                this.traceOperation("LocalSimul", beginTime, beginMem);
            }
        }
    }

    public void verifyWarning(VerifyManager mng, int filter) {
        JavaCompiler compiler;
        long beginMem = Model.getMemoryUsed();
        long beginTime = System.nanoTime();
        if (mng.withWarning("GenerateJava1") && filter == 1 && (compiler = ToolProvider.getSystemJavaCompiler()) == null) {
            mng.addError("GenerateJava1", this, "WRN_GENERATE_JAVA1_COMPILER", new Object[0]);
            mng.setOption("GenerateJava1", 0);
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.getNode(i).verifyWarning(mng, filter);
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            this.traceOperation("Verify", beginTime, beginMem);
        }
    }

    public boolean withInstantaneousEvent() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!this.getNode(i).withInstantaneousEvent()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineCorrespondence printOTools(Writer write, String frm) throws IOException {
        long beginMem = Model.getMemoryUsed();
        long beginTime = System.nanoTime();
        try {
            if (frm.equals("Extended")) {
                LineCorrespondence lineCorrespondence = this.printOTools(write, 1);
                return lineCorrespondence;
            }
            if (frm.equals("DataFlow")) {
                LineCorrespondence lineCorrespondence = this.printOTools(write, 2);
                return lineCorrespondence;
            }
            if (frm.equals("OTools")) {
                LineCorrespondence lineCorrespondence = this.printOTools(write, 0);
                return lineCorrespondence;
            }
            if (frm.equals("OToolsFlatness")) {
                LineCorrespondence lineCorrespondence = this.printOTools(write, 0);
                return lineCorrespondence;
            }
            if (frm.equals("MocaRP")) {
                LineCorrespondence lineCorrespondence = this.printOTools(write, 5);
                return lineCorrespondence;
            }
            if (frm.equals("Mec5")) {
                LineCorrespondence lineCorrespondence = this.printOTools(write, 4);
                return lineCorrespondence;
            }
        }
        finally {
            if (MsgTrans.LOG.isLoggable(Level.FINER)) {
                this.traceOperation("Print." + frm, beginTime, beginMem);
            }
        }
        throw new GenerateException(MsgTrans.getString("EXC_GEN_FORMAT"));
    }

    public LineCorrespondence printOTools(Writer write, int frm) throws IOException {
        Node node;
        int i;
        if (frm == 5) {
            return this.printMoca(write, frm);
        }
        IndentWriter out = new IndentWriter(write);
        out.write("/* Date : ");
        out.write(DateFormat.getDateInstance().format(this._DateAtCreateModel));
        out.write(" */\n");
        switch (frm) {
            case 0: {
                out.write("/* OTools format */\n\n");
                break;
            }
            case 1: {
                out.write("/* ");
                out.write("Extended");
                out.write(" format */\n\n");
                break;
            }
            case 2: {
                out.write("/* DataFlow format */\n\n");
                break;
            }
            case 4: {
                out.write("/* Mec5 format */\n\n");
                break;
            }
            default: {
                out.write("/* Unknow format => Use OTools format */\n\n");
                frm = 0;
            }
        }
        for (i = 0; i < this.getDomainCount(); ++i) {
            Domain obj = this.getDomain(i);
            if (!obj.isDefLL()) continue;
            out.addData(obj);
            out.write("domain ");
            out.write(obj.getName());
            out.write(" = ");
            obj.printDefLL(out, frm);
            out.write(";\n\n");
        }
        if (frm == 1) {
            for (i = 0; i < this.getFctCount(); ++i) {
                node = this.getFct(i);
                out.addData(node);
                out.write("func ");
                node.printOTools(out, frm);
                out.addData(node);
                out.write("cnuf\n");
                out.write("\n");
            }
        }
        for (i = 0; i < this.getNodeCount(); ++i) {
            node = this.getNode(i);
            out.addData(node);
            out.write("node ");
            node.printOTools(out, frm);
            out.addData(node);
            out.write("edon\n");
            out.write("\n");
        }
        out.close(false);
        return out;
    }

    public LineCorrespondence printMoca(Writer write, int frm) throws IOException {
        if (this.getNodeCount() != 1) {
            throw new GenerateException(MsgTrans.getString("EXC_GEN_NOFLATNESS"));
        }
        IndentWriter out = new IndentWriter(write);
        out.write("/* Date : ");
        out.write(DateFormat.getDateInstance().format(this._DateAtCreateModel));
        out.write(" */\n");
        Node node = this.getNode(0);
        out.addData(node);
        out.write("net 'Alta.net' {\n\n/* Description des options */\n");
        out.addIndent(1);
        out.write("OPT: title \"Reseau de Petri genere a partir de AltaLib");
        out.write("\"; \n");
        out.write("OPT: duration 1234; \n");
        out.addIndent(-1);
        if (this._domainDefine.getEnumSize() > 0) {
            out.write("\n/*Constantes : Valeurs enumerees*/\n");
            out.addIndent(1);
            for (int i = 0; i < this._domainDefine.getEnumSize(); ++i) {
                out.write("const int 'e..");
                out.write(this._domainDefine.getEnumStr(i));
                out.write("' = ");
                out.write(Integer.toString(i));
                out.write(" ;\n");
            }
            out.addIndent(-1);
        }
        node.printMoca(out, frm);
        out.write("\n};\n\n");
        out.close(false);
        return out;
    }

    private Writer recupData(final Writer delegate) throws IOException {
        if (!Boolean.getBoolean(PROP_MODEL_DEBUG_WRITERJAVA)) {
            return delegate;
        }
        final BufferedWriter otherWriter = new BufferedWriter(new FileWriter("AltaRica.java"));
        class SpyWriter
        extends Writer {
            SpyWriter() {
            }

            @Override
            public void close() throws IOException {
                delegate.close();
                otherWriter.close();
            }

            @Override
            public void flush() throws IOException {
                delegate.flush();
                otherWriter.flush();
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                delegate.write(cbuf, off, len);
                otherWriter.write(cbuf, off, len);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                delegate.write(cbuf);
                otherWriter.write(cbuf);
            }

            @Override
            public void write(int c) throws IOException {
                delegate.write(c);
                otherWriter.write(c);
            }

            @Override
            public void write(String str) throws IOException {
                delegate.write(str);
                otherWriter.write(str);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                delegate.write(str, off, len);
                otherWriter.write(str, off, len);
            }
        }
        return new SpyWriter();
    }

    private String getMainIdentify() {
        Node node = this.getNode("main");
        if (node != null) {
            String idConfig = null;
            String idVersion = null;
            String idName = null;
            for (int i = 0; i < node.getExternCount(); ++i) {
                Extern xTern = node.getExtern(i);
                if (!xTern.getName().equals("nodeproperty")) continue;
                Tree tVar = xTern.getVar();
                if (tVar._type != 258) continue;
                Tree tVal = xTern.getVal();
                if (tVal._type != 303) continue;
                String property = tVar._son.toString();
                String value = tVal._sval;
                if (value.length() == 0) continue;
                if (value.charAt(0) == '\"') {
                    if (value.length() < 3) continue;
                    value = value.substring(1, value.length() - 1);
                }
                if (property.equals("projectName")) {
                    idName = value;
                    continue;
                }
                if (property.equals("projectVersion")) {
                    idVersion = value;
                    continue;
                }
                if (!property.equals("projectConfig")) continue;
                idConfig = value;
            }
            if (idName != null && idVersion != null) {
                return idName.replace('/', '#') + "#" + idVersion;
            }
        }
        return null;
    }

    public LineCorrespondence printJava(Writer write, String name) throws IOException {
        long beginMem = Model.getMemoryUsed();
        long beginTime = System.nanoTime();
        IndentWriter out = new IndentWriter(this.recupData(write));
        out.write("/* Date : ");
        out.write(DateFormat.getDateInstance().format(this._DateAtCreateModel));
        out.write(" */\n");
        Model.printJavaImport(out);
        out.write("\n");
        out.write("public class ");
        out.write(name);
        out.write(" extends JDefArchitecture {\n");
        out.addIndent(1);
        out.write("\n");
        out.write("protected long getUID() {\n");
        out.addIndent(1);
        out.write("return ");
        out.write(Long.toString(this._uid));
        out.write(";\n");
        out.addIndent(-1);
        out.write("}\n\n");
        out.write("protected void defineDomain() {\n");
        out.addIndent(1);
        for (Map.Entry<String, Domain> entry : this._domainMap.entrySet()) {
            String key = entry.getKey();
            Domain obj = entry.getValue();
            if (!obj.isDefLL()) continue;
            out.addData(obj);
            out.write("createNamed(\"");
            out.write(key);
            out.write("\", ");
            obj.printDefJava(out);
            out.write(");\n");
        }
        out.addIndent(-1);
        out.write("}\n\n");
        for (int i = 0; i < this.getNodeCount(); ++i) {
            Node node = this.getNode(i);
            out.addData(node);
            node.printJava(out);
            out.write("\n");
        }
        out.write("protected void defineModel() {\n");
        out.addIndent(1);
        String mainIdentify = this.getMainIdentify();
        if (mainIdentify != null) {
            out.write("setIdentify(\"");
            out.write(mainIdentify);
            out.write("\");\n");
        }
        out.write("setClassParent(");
        out.write(name);
        out.write(".class);\n");
        for (int i = 0; i < this.getNodeCount(); ++i) {
            Node node = this.getNode(i);
            out.addData(node);
            out.write("addClassModel(\"");
            out.write(node.getName());
            out.write("\", ");
            out.write(node.getName());
            out.write(".class);\n");
        }
        out.addIndent(-1);
        out.write("}\n\n");
        out.write("public ");
        out.write(name);
        out.write("() {\n");
        out.addIndent(1);
        out.write("super();\n");
        out.addIndent(-1);
        out.write("}\n");
        out.addIndent(-1);
        out.write("}\n\n");
        out.close(false);
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            this.traceOperation("Print.Java1", beginTime, beginMem);
        }
        return out;
    }

    private static void printJavaImport(IndentWriter out, Class<? extends Object> importCl) throws IOException {
        out.write("import ");
        out.write(importCl.getName());
        out.write(";\n");
    }

    static void printJavaImport(IndentWriter out) throws IOException {
        Model.printJavaImport(out, StepperViolatedAssertionException.class);
        Model.printJavaImport(out, StepperInstantaneousLoopException.class);
        Model.printJavaImport(out, JCreateException.class);
        Model.printJavaImport(out, JDefArchitecture.class);
        Model.printJavaImport(out, JDefComponent.class);
        Model.printJavaImport(out, JDefEquipment.class);
        Model.printJavaImport(out, JDomain.class);
        Model.printJavaImport(out, JEvent.class);
        Model.printJavaImport(out, JFlowIn.class);
        Model.printJavaImport(out, JFlowOut.class);
        Model.printJavaImport(out, JState.class);
        Model.printJavaImport(out, JTrans.class);
        Model.printJavaImport(out, JVariable.class);
    }

    class RenameHelper {
        BufferedWriter _trace = null;
        HashMap<Node, rnode> _nodes = new HashMap();
        HashMap<String, String> _enums = new HashMap();
        int _cptEnum = 1;
        DecimalFormat form = new DecimalFormat("#00");

        public RenameHelper(String opt) {
            opt = opt.trim();
            boolean trace = true;
            if (trace) {
                if (opt.length() > 7 && opt.substring(0, 7).equalsIgnoreCase("-trace=")) {
                    opt = opt.substring(7);
                    opt = opt.trim();
                } else {
                    trace = false;
                }
            }
            if (trace) {
                if (opt.length() < 3) {
                    trace = false;
                } else if (opt.charAt(0) != '\"') {
                    trace = false;
                } else if ((opt = opt.substring(1, opt.length() - 1).trim()).length() < 1) {
                    trace = false;
                }
                if (!trace) {
                    trace = true;
                    opt = "rename-default.txt";
                    MsgTrans.LOG.info("Trace of rename not possible : " + opt + "\nFormat : rename -trace=\"<file>\"");
                }
            }
            if (trace) {
                try {
                    this._trace = new BufferedWriter(new FileWriter(opt));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void appendTrace(String str) {
            if (this._trace != null) {
                try {
                    this._trace.write(str);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            if (this._trace != null) {
                try {
                    this._trace.flush();
                    this._trace.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void putNode(Node src, String on) {
            rnode rn = new rnode(on, src);
            this._nodes.put(src, rn);
        }

        public void putSub(Node src, Sub sub, String on) {
            rnode rn = this._nodes.get(src);
            rn._subs.put(on, sub);
        }

        public void putVar(Node src, Var var, String on) {
            rnode rn = this._nodes.get(src);
            rn._vars.put(on, var);
        }

        private Sub getSub(Node cur, String id) {
            rnode rn = this._nodes.get(cur);
            assert (rn != null);
            Sub data = rn._subs.get(id);
            assert (data != null);
            return data;
        }

        private Var getVar(Node cur, String id) {
            rnode rn = this._nodes.get(cur);
            assert (rn != null);
            Var data = rn._vars.get(id);
            assert (data != null);
            return data;
        }

        public String convertPath(String name, Node current) {
            String id;
            StringBuffer sb = new StringBuffer();
            int pos = name.indexOf(46);
            while (pos != -1) {
                id = name.substring(0, pos);
                Sub sub = this.getSub(current, id);
                if (sub == null) {
                    return null;
                }
                sb.append(sub.getName());
                sb.append('.');
                current = sub.getType();
                name = name.substring(pos + 1);
                pos = name.indexOf(46);
            }
            pos = name.indexOf(94);
            if (pos != -1) {
                id = name.substring(0, pos);
                Var var = this.getVar(current, id);
                if (var == null) {
                    return null;
                }
                sb.append(var.getName());
                sb.append('^');
                name = name.substring(pos + 1);
            }
            assert (name.length() == 0);
            return sb.toString();
        }

        public String putEnum(Node src, String on) {
            String nn = this.getEnum(on, src);
            if (nn == null) {
                nn = "Enum" + this.format(this._cptEnum++);
                if (src == null) {
                    this._enums.put(on, nn);
                    this.appendTrace("\tEnum : " + on + " -> " + nn + "\n");
                } else {
                    rnode rn = this._nodes.get(src);
                    rn._localEnums.put(on, nn);
                    this.appendTrace("\t\tEnum : " + on + " -> " + nn + "\n");
                }
            }
            return nn;
        }

        public String getEnum(String name, Node cur) {
            String res = this._enums.get(name);
            if (res == null && cur != null) {
                rnode rn = this._nodes.get(cur);
                res = rn._localEnums.get(name);
            }
            return res;
        }

        public String format(long nbr) {
            return this.form.format(nbr);
        }

        class rnode {
            String _old;
            Map<String, Sub> _subs = new HashMap<String, Sub>();
            Map<String, Var> _vars = new HashMap<String, Var>();
            Map<String, String> _localEnums = new HashMap<String, String>();
            Node _src;

            rnode(String on, Node src) {
                this._old = on;
                this._src = src;
            }
        }
    }
}

