/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class ImageUtility {
    private static Logger _LOG = Logger.getLogger(ImageUtility.class.getPackage().getName());
    static SAXSVGDocumentFactory _SVGFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());

    public static Image getImageFromSVG(URL url, int width, int height) {
        DefaultTranscoder transcoder = new DefaultTranscoder();
        TranscodingHints hints = transcoder.getTranscodingHints();
        hints.put((Object)SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        hints.put((Object)SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        transcoder.setTranscodingHints(hints);
        try {
            TranscoderInput input = new TranscoderInput(url.openStream());
            input.setURI(url.toURI().toString());
            transcoder.transcode(input, null);
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Transcodage SVG KO", e);
            return null;
        }
        return transcoder.getImage();
    }

    public static BufferedImage toBufferedImage(Image img, Dimension size) {
        BufferedImage bimg;
        if (img instanceof BufferedImage && (double)(bimg = (BufferedImage)img).getWidth() == size.getWidth() && (double)bimg.getHeight() == size.getHeight()) {
            return bimg;
        }
        BufferedImage bimage = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 2);
        Graphics2D bGr = bimage.createGraphics();
        new ImageIcon(img.getScaledInstance((int)size.getWidth(), (int)size.getHeight(), 4)).paintIcon(null, bGr, 0, 0);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image img, int size) {
        if (img instanceof BufferedImage && ((BufferedImage)img).getWidth() == size) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(size, size, 2);
        Graphics2D bGr = bimage.createGraphics();
        new ImageIcon(img.getScaledInstance(size, size, 4)).paintIcon(null, bGr, 0, 0);
        bGr.dispose();
        return bimage;
    }

    public static double getImageSVGRatio(URL url) throws IOException {
        return ImageUtility.doGetImageSVGRatio(url);
    }

    private static double doGetImageSVGRatioAlternative(URL url) throws IOException {
        InputStream is = url.openStream();
        Document document = _SVGFactory.createDocument(url.toString(), is);
        UserAgentAdapter agent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)agent);
        BridgeContext context = new BridgeContext((UserAgent)agent, loader);
        context.setDynamic(true);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode root = builder.build(context, document);
        return root.getPrimitiveBounds().getWidth() / root.getPrimitiveBounds().getHeight();
    }

    private static double doGetImageSVGRatio(URL url) throws IOException {
        InputStream is = url.openStream();
        SVGDocument doc = (SVGDocument)_SVGFactory.createDocument(null, is);
        if (doc != null) {
            SVGSVGElement el = doc.getRootElement();
            String viewBoxStr = el.getAttributeNS(null, "viewBox");
            float[] rect = ViewBox.parseViewBoxAttribute((Element)el, (String)viewBoxStr, null);
            return rect[2] / rect[3];
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageDimension(URL url) throws IOException {
        InputStream stream = url.openStream();
        ImageInputStream in = ImageIO.createImageInputStream(stream);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                reader.setInput(in);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                return dimension;
            }
            finally {
                reader.dispose();
            }
        }
        throw new IOException("Fail to get image dimension " + url.toString());
    }

    static class DefaultTranscoder
    extends ImageTranscoder {
        private BufferedImage image = null;

        DefaultTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput out) {
            this.image = img;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

