/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;

public class TreeRank
extends AbstractSet
implements SortedSet,
List,
Cloneable,
Serializable {
    private Comparator _comparator = null;
    private transient RankEntry _root = null;
    private transient int _size = 0;
    private transient int _modCount = 0;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    static final long serialVersionUID = -3964312849577655389L;

    private void incrementSize() {
        ++this._modCount;
        ++this._size;
    }

    private void decrementSize() {
        ++this._modCount;
        --this._size;
    }

    public TreeRank() {
    }

    public TreeRank(Comparator c) {
        this._comparator = c;
    }

    public TreeRank(Set s) {
        this.addAll((Collection)s);
    }

    public TreeRank(SortedSet s) {
        this._comparator = s.comparator();
        try {
            this.buildFromSorted(s.size(), s.iterator(), null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Comparator comparator() {
        return this._comparator;
    }

    @Override
    public int size() {
        return this._size;
    }

    public Object first() {
        RankEntry entry = this.firstEntry();
        if (entry == null) {
            return null;
        }
        return TreeRank.key(entry);
    }

    public Object last() {
        RankEntry entry = this.lastEntry();
        if (entry == null) {
            return null;
        }
        return TreeRank.key(entry);
    }

    @Override
    public Iterator iterator() {
        return new KeyIterator();
    }

    @Override
    public boolean addAll(Collection collect) {
        Comparator c;
        int cSize = collect.size();
        if (this._size == 0 && cSize != 0 && collect instanceof SortedSet && ((c = ((SortedSet)collect).comparator()) == this._comparator || c != null && c.equals(this._comparator))) {
            ++this._modCount;
            try {
                this.buildFromSorted(cSize, collect.iterator(), null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return true;
        }
        return super.addAll(collect);
    }

    private RankEntry getCeilEntry(Object key) {
        RankEntry p = this._root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p._key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p._left != null) {
                    p = p._left;
                    continue;
                }
                return p;
            }
            if (p._right == null) break;
            p = p._right;
        }
        RankEntry parent = p._parent;
        RankEntry ch = p;
        while (parent != null && ch == parent._right) {
            ch = parent;
            parent = parent._parent;
        }
        return parent;
    }

    private RankEntry getPrecedingEntry(Object key) {
        RankEntry p = this._root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p._key)) > 0) {
                if (p._right != null) {
                    p = p._right;
                    continue;
                }
                return p;
            }
            if (p._left == null) break;
            p = p._left;
        }
        RankEntry parent = p._parent;
        RankEntry ch = p;
        while (parent != null && ch == parent._left) {
            ch = parent;
            parent = parent._parent;
        }
        return parent;
    }

    private RankEntry getEntry(Object key) {
        RankEntry p = this._root;
        while (p != null) {
            int cmp = this.compare(key, p._key);
            if (cmp == 0) {
                return p;
            }
            if (cmp < 0) {
                p = p._left;
                continue;
            }
            p = p._right;
        }
        return null;
    }

    @Override
    public boolean contains(Object obj) {
        return this.getEntry(obj) != null;
    }

    @Override
    public boolean add(Object key) {
        RankEntry t = this._root;
        if (t == null) {
            this.incrementSize();
            this._root = new RankEntry(key, null);
            return true;
        }
        while (true) {
            ++t._size;
            int cmp = this.compare(key, t._key);
            if (cmp == 0) {
                while (t != null) {
                    --t._size;
                    t = t._parent;
                }
                assert (this.verifySize(this._root));
                return false;
            }
            if (cmp < 0) {
                if (t._left != null) {
                    t = t._left;
                    continue;
                }
                this.incrementSize();
                t._left = new RankEntry(key, t);
                this.fixAfterInsertion(t._left);
                assert (this.verifySize(this._root));
                return true;
            }
            if (t._right == null) break;
            t = t._right;
        }
        this.incrementSize();
        t._right = new RankEntry(key, t);
        this.fixAfterInsertion(t._right);
        assert (this.verifySize(this._root));
        return true;
    }

    @Override
    public boolean remove(Object key) {
        RankEntry p = this._root;
        while (p != null) {
            int cmp = this.compare(key, p._key);
            if (cmp == 0) {
                RankEntry d = p;
                while (p != null) {
                    --p._size;
                    p = p._parent;
                }
                this.deleteEntry(d);
                assert (this.verifySize(this._root));
                return true;
            }
            if (cmp < 0) {
                p = p._left;
                continue;
            }
            p = p._right;
        }
        assert (this.verifySize(this._root));
        return false;
    }

    private boolean verifySize(RankEntry p) {
        if (p != null) {
            int size = TreeRank.sizeOf(TreeRank.leftOf(p)) + TreeRank.sizeOf(TreeRank.rightOf(p)) + 1;
            if (TreeRank.sizeOf(p) != size) {
                return false;
            }
            if (!this.verifySize(TreeRank.leftOf(p))) {
                return false;
            }
            if (!this.verifySize(TreeRank.rightOf(p))) {
                return false;
            }
        }
        return true;
    }

    private RankEntry getRankEntry(RankEntry p, int idx) {
        int s = TreeRank.sizeOf(TreeRank.leftOf(p)) + 1;
        if (s == idx) {
            return p;
        }
        if (idx < s) {
            return this.getRankEntry(TreeRank.leftOf(p), idx);
        }
        return this.getRankEntry(TreeRank.rightOf(p), idx - s);
    }

    private RankEntry getRankEntry(int idx) {
        return this.getRankEntry(this._root, idx + 1);
    }

    public Object get(int idx) {
        if (idx < 0 || idx >= this._size) {
            System.err.println("erreeeeeeeeeee");
        }
        assert (idx >= 0 && idx < this._size) : idx + ">=" + this._size;
        assert (this.verifySize(this._root)) : "idx=" + idx + " size=" + this._size;
        return TreeRank.key(this.getRankEntry(idx));
    }

    private int indiceEntry(RankEntry x) {
        int result = TreeRank.sizeOf(TreeRank.leftOf(x)) + 1;
        while (x != this._root) {
            if (x == TreeRank.rightOf(TreeRank.parentOf(x))) {
                result += TreeRank.sizeOf(TreeRank.leftOf(TreeRank.parentOf(x))) + 1;
            }
            x = TreeRank.parentOf(x);
        }
        return result - 1;
    }

    public int indice(Object key) {
        assert (this.verifySize(this._root));
        RankEntry x = this.getEntry(key);
        if (x == null) {
            return -1;
        }
        return this.indiceEntry(x);
    }

    @Override
    public void clear() {
        ++this._modCount;
        this._size = 0;
        this._root = null;
    }

    public Object clone() {
        TreeRank clone = null;
        try {
            clone = (TreeRank)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._root = null;
        clone._size = 0;
        clone._modCount = 0;
        try {
            clone.buildFromSorted(this._size, this.iterator(), null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    public SortedSet subSet(Object fromKey, Object toKey) {
        return new SubSet(fromKey, toKey);
    }

    public SortedSet headSet(Object toKey) {
        return new SubSet(toKey, true);
    }

    public SortedSet tailSet(Object fromKey) {
        return new SubSet(fromKey, false);
    }

    private int compare(Object k1, Object k2) {
        return this._comparator == null ? ((Comparable)k1).compareTo(k2) : this._comparator.compare(k1, k2);
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public void printDebug() {
        StringBuffer sb = new StringBuffer(this.size() * 32);
        if (this._root == null) {
            sb.append("empty\n");
        } else {
            this._root.printDebug(sb, 1, "  ");
        }
        System.out.print(sb.toString());
    }

    private static Object key(RankEntry e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e._key;
    }

    private static boolean colorOf(RankEntry p) {
        return p == null ? true : p._color;
    }

    private static RankEntry parentOf(RankEntry p) {
        return p == null ? null : p._parent;
    }

    private static void setColor(RankEntry p, boolean c) {
        if (p != null) {
            p._color = c;
        }
    }

    private static RankEntry leftOf(RankEntry p) {
        return p == null ? null : p._left;
    }

    private static RankEntry rightOf(RankEntry p) {
        return p == null ? null : p._right;
    }

    private static int sizeOf(RankEntry p) {
        return p == null ? 0 : p._size;
    }

    private RankEntry firstEntry() {
        RankEntry p = this._root;
        if (p != null) {
            while (p._left != null) {
                p = p._left;
            }
        }
        return p;
    }

    private RankEntry lastEntry() {
        RankEntry p = this._root;
        if (p != null) {
            while (p._right != null) {
                p = p._right;
            }
        }
        return p;
    }

    private RankEntry successor(RankEntry t) {
        if (t == null) {
            return null;
        }
        if (t._right != null) {
            RankEntry p = t._right;
            while (p._left != null) {
                p = p._left;
            }
            return p;
        }
        RankEntry p = t._parent;
        RankEntry ch = t;
        while (p != null && ch == p._right) {
            ch = p;
            p = p._parent;
        }
        return p;
    }

    private RankEntry predecessor(RankEntry t) {
        if (t == null) {
            return null;
        }
        if (t._left != null) {
            RankEntry p = t._left;
            while (p._right != null) {
                p = p._right;
            }
            return p;
        }
        RankEntry p = t._parent;
        RankEntry ch = t;
        while (p != null && ch == p._left) {
            ch = p;
            p = p._parent;
        }
        return p;
    }

    private void rotateLeft(RankEntry p) {
        RankEntry r = p._right;
        p._right = r._left;
        if (r._left != null) {
            r._left._parent = p;
        }
        r._parent = p._parent;
        if (p._parent == null) {
            this._root = r;
        } else if (p._parent._left == p) {
            p._parent._left = r;
        } else {
            p._parent._right = r;
        }
        r._left = p;
        p._parent = r;
        r._size = p._size;
        p._size = TreeRank.sizeOf(p._left) + TreeRank.sizeOf(p._right) + 1;
    }

    private void rotateRight(RankEntry p) {
        RankEntry l = p._left;
        p._left = l._right;
        if (l._right != null) {
            l._right._parent = p;
        }
        l._parent = p._parent;
        if (p._parent == null) {
            this._root = l;
        } else if (p._parent._right == p) {
            p._parent._right = l;
        } else {
            p._parent._left = l;
        }
        l._right = p;
        p._parent = l;
        l._size = p._size;
        p._size = TreeRank.sizeOf(p._left) + TreeRank.sizeOf(p._right) + 1;
    }

    private void fixAfterInsertion(RankEntry x) {
        x._color = false;
        while (x != null && x != this._root && !x._parent._color) {
            RankEntry y;
            if (TreeRank.parentOf(x) == TreeRank.leftOf(TreeRank.parentOf(TreeRank.parentOf(x)))) {
                y = TreeRank.rightOf(TreeRank.parentOf(TreeRank.parentOf(x)));
                if (!TreeRank.colorOf(y)) {
                    TreeRank.setColor(TreeRank.parentOf(x), true);
                    TreeRank.setColor(y, true);
                    TreeRank.setColor(TreeRank.parentOf(TreeRank.parentOf(x)), false);
                    x = TreeRank.parentOf(TreeRank.parentOf(x));
                    continue;
                }
                if (x == TreeRank.rightOf(TreeRank.parentOf(x))) {
                    x = TreeRank.parentOf(x);
                    this.rotateLeft(x);
                }
                TreeRank.setColor(TreeRank.parentOf(x), true);
                TreeRank.setColor(TreeRank.parentOf(TreeRank.parentOf(x)), false);
                if (TreeRank.parentOf(TreeRank.parentOf(x)) == null) continue;
                this.rotateRight(TreeRank.parentOf(TreeRank.parentOf(x)));
                continue;
            }
            y = TreeRank.leftOf(TreeRank.parentOf(TreeRank.parentOf(x)));
            if (!TreeRank.colorOf(y)) {
                TreeRank.setColor(TreeRank.parentOf(x), true);
                TreeRank.setColor(y, true);
                TreeRank.setColor(TreeRank.parentOf(TreeRank.parentOf(x)), false);
                x = TreeRank.parentOf(TreeRank.parentOf(x));
                continue;
            }
            if (x == TreeRank.leftOf(TreeRank.parentOf(x))) {
                x = TreeRank.parentOf(x);
                this.rotateRight(x);
            }
            TreeRank.setColor(TreeRank.parentOf(x), true);
            TreeRank.setColor(TreeRank.parentOf(TreeRank.parentOf(x)), false);
            if (TreeRank.parentOf(TreeRank.parentOf(x)) == null) continue;
            this.rotateLeft(TreeRank.parentOf(TreeRank.parentOf(x)));
        }
        this._root._color = true;
    }

    private void deleteEntry(RankEntry p) {
        RankEntry replacement;
        this.decrementSize();
        if (p._left != null && p._right != null) {
            RankEntry s = this.successor(p);
            p._key = s._key;
            RankEntry t = s;
            while (t != p) {
                --t._size;
                t = t._parent;
            }
            p = s;
        }
        RankEntry rankEntry = replacement = p._left != null ? p._left : p._right;
        if (replacement != null) {
            replacement._parent = p._parent;
            if (p._parent == null) {
                this._root = replacement;
            } else if (p == p._parent._left) {
                p._parent._left = replacement;
            } else {
                p._parent._right = replacement;
            }
            p._parent = null;
            p._right = null;
            p._left = null;
            if (p._color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p._parent == null) {
            this._root = null;
        } else {
            if (p._color) {
                this.fixAfterDeletion(p);
            }
            if (p._parent != null) {
                if (p == p._parent._left) {
                    p._parent._left = null;
                } else if (p == p._parent._right) {
                    p._parent._right = null;
                }
                p._parent = null;
            }
        }
    }

    private void fixAfterDeletion(RankEntry x) {
        while (x != this._root && TreeRank.colorOf(x)) {
            RankEntry sib;
            if (x == TreeRank.leftOf(TreeRank.parentOf(x))) {
                sib = TreeRank.rightOf(TreeRank.parentOf(x));
                if (!TreeRank.colorOf(sib)) {
                    TreeRank.setColor(sib, true);
                    TreeRank.setColor(TreeRank.parentOf(x), false);
                    this.rotateLeft(TreeRank.parentOf(x));
                    sib = TreeRank.rightOf(TreeRank.parentOf(x));
                }
                if (TreeRank.colorOf(TreeRank.leftOf(sib)) && TreeRank.colorOf(TreeRank.rightOf(sib))) {
                    TreeRank.setColor(sib, false);
                    x = TreeRank.parentOf(x);
                    continue;
                }
                if (TreeRank.colorOf(TreeRank.rightOf(sib))) {
                    TreeRank.setColor(TreeRank.leftOf(sib), true);
                    TreeRank.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TreeRank.rightOf(TreeRank.parentOf(x));
                }
                TreeRank.setColor(sib, TreeRank.colorOf(TreeRank.parentOf(x)));
                TreeRank.setColor(TreeRank.parentOf(x), true);
                TreeRank.setColor(TreeRank.rightOf(sib), true);
                this.rotateLeft(TreeRank.parentOf(x));
                x = this._root;
                continue;
            }
            sib = TreeRank.leftOf(TreeRank.parentOf(x));
            if (!TreeRank.colorOf(sib)) {
                TreeRank.setColor(sib, true);
                TreeRank.setColor(TreeRank.parentOf(x), false);
                this.rotateRight(TreeRank.parentOf(x));
                sib = TreeRank.leftOf(TreeRank.parentOf(x));
            }
            if (TreeRank.colorOf(TreeRank.rightOf(sib)) && TreeRank.colorOf(TreeRank.leftOf(sib))) {
                TreeRank.setColor(sib, false);
                x = TreeRank.parentOf(x);
                continue;
            }
            if (TreeRank.colorOf(TreeRank.leftOf(sib))) {
                TreeRank.setColor(TreeRank.rightOf(sib), true);
                TreeRank.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TreeRank.leftOf(TreeRank.parentOf(x));
            }
            TreeRank.setColor(sib, TreeRank.colorOf(TreeRank.parentOf(x)));
            TreeRank.setColor(TreeRank.parentOf(x), true);
            TreeRank.setColor(TreeRank.leftOf(sib), true);
            this.rotateRight(TreeRank.parentOf(x));
            x = this._root;
        }
        TreeRank.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this._size);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s);
    }

    private void buildFromSorted(int size, Iterator it, ObjectInputStream str) throws IOException, ClassNotFoundException {
        this._size = size;
        this._root = TreeRank.buildFromSorted(0, 0, size - 1, TreeRank.computeRedLevel(size), it, str);
    }

    private static RankEntry buildFromSorted(int level, int lo, int hi, int redLevel, Iterator it, ObjectInputStream str) throws IOException, ClassNotFoundException {
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        RankEntry left = null;
        if (lo < mid) {
            left = TreeRank.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str);
        }
        Object key = it != null ? it.next() : str.readObject();
        RankEntry middle = new RankEntry(key, null);
        if (level == redLevel) {
            middle._color = false;
        }
        if (left != null) {
            middle._left = left;
            left._parent = middle;
            middle._size += left._size;
        }
        if (mid < hi) {
            RankEntry right;
            middle._right = right = TreeRank.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str);
            right._parent = middle;
            middle._size += right._size;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.indice(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indice(o);
    }

    public ListIterator listIterator() {
        return new KeyListIterator();
    }

    public ListIterator listIterator(int index) {
        return new KeyListIterator(this.getRankEntry(index));
    }

    public Object remove(int index) {
        Object result = this.get(index);
        this.remove(result);
        return result;
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator spliterator() {
        return SortedSet.super.spliterator();
    }

    static class RankEntry {
        Object _key;
        RankEntry _left = null;
        RankEntry _right = null;
        RankEntry _parent;
        boolean _color = true;
        int _size = 1;

        RankEntry(Object key, RankEntry parent) {
            this._key = key;
            this._parent = parent;
        }

        public Object getKey() {
            return this._key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RankEntry)) {
                return false;
            }
            RankEntry e = (RankEntry)o;
            return TreeRank.valEquals(this._key, e.getKey());
        }

        public int hashCode() {
            int keyHash = this._key == null ? 0 : this._key.hashCode();
            return keyHash;
        }

        public String toString() {
            return this._key.toString();
        }

        public void printDebug(StringBuffer sb, int nbr, String indent) {
            int i;
            sb.append("[");
            sb.append(this._color ? "B" : "R");
            sb.append(",");
            sb.append(this._size);
            sb.append(",");
            sb.append(this._key.toString());
            sb.append("]\n");
            if (this._left != null) {
                for (i = 0; i < nbr; ++i) {
                    sb.append(indent);
                }
                sb.append("< ");
                this._left.printDebug(sb, nbr + 1, indent);
            }
            if (this._right != null) {
                for (i = 0; i < nbr; ++i) {
                    sb.append(indent);
                }
                sb.append("> ");
                this._right.printDebug(sb, nbr + 1, indent);
            }
        }
    }

    private class SubMapEntryIterator
    extends RankEntryIterator {
        private final Object firstExcludedKey;

        SubMapEntryIterator(RankEntry first, RankEntry firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? firstExcluded : firstExcluded._key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next._key != this.firstExcludedKey;
        }

        @Override
        public Object next() {
            if (this.next == null || this.next._key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class KeyListIterator
    extends RankEntryListIterator {
        KeyListIterator() {
        }

        KeyListIterator(RankEntry first) {
            super(first);
        }

        @Override
        public Object next() {
            return this.nextEntry()._key;
        }

        @Override
        public Object previous() {
            return this.previousEntry()._key;
        }
    }

    private class KeyIterator
    extends RankEntryIterator {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry()._key;
        }
    }

    private class RankEntryListIterator
    extends RankEntryIterator
    implements ListIterator {
        RankEntryListIterator() {
        }

        RankEntryListIterator(RankEntry first) {
            super(first);
        }

        final RankEntry previousEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeRank.this._modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next = TreeRank.this.predecessor(this.next);
            return this.lastReturned;
        }

        @Override
        public boolean hasPrevious() {
            return TreeRank.this.predecessor(this.next) != null;
        }

        @Override
        public int nextIndex() {
            return TreeRank.this.indiceEntry(this.next);
        }

        public Object previous() {
            return this.previousEntry();
        }

        @Override
        public int previousIndex() {
            return TreeRank.this.indiceEntry(TreeRank.this.predecessor(this.next));
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private class RankEntryIterator
    implements Iterator {
        int expectedModCount;
        RankEntry lastReturned;
        RankEntry next;

        RankEntryIterator() {
            this.expectedModCount = TreeRank.this._modCount;
            this.lastReturned = null;
            this.next = TreeRank.this.firstEntry();
        }

        RankEntryIterator(RankEntry first) {
            this.expectedModCount = TreeRank.this._modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        final RankEntry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeRank.this._modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeRank.this.successor(this.next);
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeRank.this._modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned._left != null && this.lastReturned._right != null) {
                this.next = this.lastReturned;
            }
            TreeRank.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubSet
    extends AbstractSet
    implements SortedSet,
    Serializable {
        private boolean _fromStart = false;
        private boolean _toEnd = false;
        private Object _fromKey;
        private Object _toKey;

        SubSet(Object fromKey, Object toKey) {
            if (TreeRank.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this._fromKey = fromKey;
            this._toKey = toKey;
        }

        SubSet(Object key, boolean headMap) {
            TreeRank.this.compare(key, key);
            if (headMap) {
                this._fromStart = true;
                this._toKey = key;
            } else {
                this._toEnd = true;
                this._fromKey = key;
            }
        }

        SubSet(boolean fromStart, Object fromKey, boolean toEnd, Object toKey) {
            this._fromStart = fromStart;
            this._fromKey = fromKey;
            this._toEnd = toEnd;
            this._toKey = toKey;
        }

        @Override
        public boolean isEmpty() {
            return TreeRank.this.isEmpty();
        }

        @Override
        public boolean contains(Object key) {
            return this.inRange(key) && TreeRank.this.contains(key);
        }

        @Override
        public boolean add(Object key) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return TreeRank.this.add(key);
        }

        public Comparator comparator() {
            return TreeRank.this._comparator;
        }

        public Object first() {
            Object first = TreeRank.key(this._fromStart ? TreeRank.this.firstEntry() : TreeRank.this.getCeilEntry(this._fromKey));
            if (!this._toEnd && TreeRank.this.compare(first, this._toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        public Object last() {
            Object last = TreeRank.key(this._toEnd ? TreeRank.this.lastEntry() : TreeRank.this.getPrecedingEntry(this._toKey));
            if (!this._fromStart && TreeRank.this.compare(last, this._fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        public SortedSet subSet(Object fromKey, Object toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubSet(fromKey, toKey);
        }

        public SortedSet headSet(Object toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubSet(this._fromStart, this._fromKey, false, toKey);
        }

        public SortedSet tailSet(Object fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubSet(false, fromKey, this._toEnd, this._toKey);
        }

        private boolean inRange(Object key) {
            return !(!this._fromStart && TreeRank.this.compare(key, this._fromKey) < 0 || !this._toEnd && TreeRank.this.compare(key, this._toKey) >= 0);
        }

        private boolean inRange2(Object key) {
            return !(!this._fromStart && TreeRank.this.compare(key, this._fromKey) < 0 || !this._toEnd && TreeRank.this.compare(key, this._toKey) > 0);
        }

        @Override
        public int size() {
            return TreeRank.this.size();
        }

        @Override
        public Iterator iterator() {
            return new SubMapEntryIterator(this._fromStart ? TreeRank.this.firstEntry() : TreeRank.this.getCeilEntry(this._fromKey), this._toEnd ? TreeRank.this.lastEntry() : TreeRank.this.getPrecedingEntry(this._toKey));
        }
    }
}

