/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.destination;

import com.dassault.cecilia.lib.util.destination.DestinationStream;
import com.dassault.cecilia.lib.util.destination.Failure;
import com.dassault.cecilia.lib.util.destination.Layout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class DestinationFile
extends DestinationStream {
    public DestinationFile() {
    }

    public DestinationFile(File file, boolean append) {
        this.setOutputStream(file, append);
    }

    private void setOutputStream(File file, boolean append) {
        try {
            FileOutputStream output = new FileOutputStream(file, append);
            this.setOutputStream(output);
        }
        catch (IOException e) {
            Failure.OPEN.report(e);
        }
    }

    @Override
    public void configure(Map<String, Object> params, Layout layout) {
        boolean append = false;
        append = Boolean.parseBoolean((String)params.get("Append"));
        String filepath = (String)params.get("File");
        if (filepath == null || filepath.trim().length() == 0) {
            Failure.OPEN.report(new IOException("Not File define for DestinationFile"));
        }
        this.setOutputStream(new File(filepath), append);
        this.setLayout(layout);
    }
}

