/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.loader;

import java.util.Hashtable;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable _classes = new Hashtable();
    private char _replacementChar;
    private static final boolean __monitorOn = false;

    protected MultiClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this._classes.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                return super.loadClass(className, resolveIt);
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this._classes.put(className, result);
            return result;
        }
    }

    public void setClassNameReplacementChar(char replacement) {
        this._replacementChar = replacement;
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected String formatClassName(String className) {
        if (this._replacementChar == '\u0000') {
            return className.replace('.', '/') + ".class";
        }
        return className.replace('.', this._replacementChar) + ".class";
    }

    protected void monitor(String text) {
        System.out.println(text);
    }
}

