/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginCmdGenFMEA;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginDlgGenFMEA;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PluginCmdPropagate
extends PluginCmdGenFMEA
implements PluginMAction {
    public static final String OPT_POST_PROCESS_PROPAGATE = PluginCmdPropagate.class.getName() + "#PostProcess";
    public static final String OPT_DELAY_MAX = PluginCmdPropagate.class.getName() + "#DelayMax";
    public static final String OPT_RANK_MAX = PluginCmdPropagate.class.getName() + "#RankMax";
    PropagateOptsPanel _opts = null;

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResSeqGen.getString("PLUG_CMD_PROPAGATE_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResSeqGen.getString("PLUG_CMD_PROPAGATE_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-03.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new PropagateOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    @Override
    protected PluginDlgGenFMEA createDialog(Plugable launcher) {
        PluginDlgGenFMEA dlg = super.createDialog(launcher);
        dlg.defineTitle(this.getInfo("plugin.name"));
        dlg.defineProcessKey("Propagate");
        return dlg;
    }

    @Override
    protected String getTaskName() {
        return "Propagate";
    }

    @Override
    protected String getOptProcess() {
        return OPT_POST_PROCESS_PROPAGATE;
    }

    @Override
    protected InputStream getBanCanevaStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptPropagate.xml");
    }

    @Override
    protected BanEntry createBanEntry(Plugable launcher, PluginDlgGenFMEA dlg, BanEntry previous) {
        int rankmax;
        BanEntry entry = null;
        try {
            entry = new BanEntry(previous);
        }
        catch (BanLicenseException e) {
            Logger.getLogger(PluginCmdPropagate.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return null;
        }
        entry.setUserProperty("propagate.onlychange", Boolean.toString(dlg.isChangeValue()));
        entry.setUserProperty("propagate.select.event", dlg.getSelectEvent());
        entry.setUserProperty("propagate.select.state", dlg.getSelectState());
        entry.setUserProperty("propagate.select.flow", dlg.getSelectFlow());
        double delaymax = PlugableUtility.getDoubleOpt((Plugable)launcher, (String)OPT_DELAY_MAX, (double)1.0);
        if (delaymax > 0.0) {
            entry.setUserProperty("propagate.limit.delay", Double.toString(delaymax));
        }
        if ((rankmax = PlugableUtility.getIntOpt((Plugable)launcher, (String)OPT_RANK_MAX, (int)100)) > 0) {
            entry.setUserProperty("propagate.limit.rank", Integer.toString(rankmax));
        }
        entry.setUserProperty("propagate.output", dlg.getFileResult().getAbsolutePath());
        return entry;
    }

    class PropagateOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JComboBox _ctrlRankMax;
        JComboBox _ctrlDelayMax;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlDelayMax.setSelectedItem(Double.toString(PlugableUtility.getDoubleOpt((Plugable)this._launcher, (String)OPT_DELAY_MAX, (double)1.0)));
            this._ctrlRankMax.setSelectedItem(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)OPT_RANK_MAX, (int)100)));
        }

        public PropagateOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResSeqGen.getString("DLG_OPT_PROPAGATE")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            JCRLabel lbl = new JCRLabel(ResSeqGen.getString("DLG_OPT_PROPAGATE_DELAY_MAX"));
            root.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlDelayMax = new JComboBox<String>(new String[]{"1", "2", "5", "10"});
            this._ctrlDelayMax.setEditable(true);
            this._ctrlDelayMax.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chgMax = PropagateOptsPanel.this._ctrlDelayMax.getSelectedItem().toString();
                    try {
                        double val = Double.parseDouble(chgMax);
                        if (val > 0.0) {
                            PropagateOptsPanel.this._launcher.setOption(OPT_DELAY_MAX, chgMax);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)PropagateOptsPanel.this), ResSeqGen.getString("DLG_OPT_PROPAGATE_DELAY_ERR"), ResSeqGen.getString("DLG_OPT_PROPAGATE"), 0);
                    PropagateOptsPanel.this._ctrlDelayMax.requestFocus();
                }
            });
            root.add((Component)this._ctrlDelayMax, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            lbl = new JCRLabel(ResSeqGen.getString("DLG_OPT_PROPAGATE_RANK_MAX"));
            root.add((Component)lbl, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlRankMax = new JComboBox<String>(new String[]{"10", "50", "100", "200"});
            this._ctrlRankMax.setEditable(true);
            this._ctrlRankMax.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chgMax = PropagateOptsPanel.this._ctrlRankMax.getSelectedItem().toString();
                    try {
                        int val = Integer.parseInt(chgMax);
                        if (val > 0) {
                            PropagateOptsPanel.this._launcher.setOption(OPT_RANK_MAX, chgMax);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)PropagateOptsPanel.this), ResSeqGen.getString("DLG_OPT_PROPAGATE_RANK_ERR"), ResSeqGen.getString("DLG_OPT_PROPAGATE"), 0);
                    PropagateOptsPanel.this._ctrlRankMax.requestFocus();
                }
            });
            root.add((Component)this._ctrlRankMax, new GridBagConstraints(1, 1, 1, 1, 100.0, 100.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            JButton defVal = new JButton(ResSeqGen.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropagateOptsPanel.this._ctrlDelayMax.setSelectedItem("1");
                    PropagateOptsPanel.this._launcher.setOption(OPT_DELAY_MAX, "1");
                    PropagateOptsPanel.this._ctrlRankMax.setSelectedItem("100");
                    PropagateOptsPanel.this._launcher.setOption(OPT_RANK_MAX, "100");
                }
            });
            root.add((Component)defVal, new GridBagConstraints(1, 2, 1, 1, 100.0, 100.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdPropagate.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

