/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class DlgTargetsSelection
extends JDialogCecilia {
    protected TargetsPanel _tgts;
    protected boolean _create = false;
    private String _title;

    public DlgTargetsSelection(Window win) {
        this(win, "");
    }

    public DlgTargetsSelection(Window win, String title) {
        super(win, true);
        this._title = title;
        this.setTitle(title);
    }

    public void create(TargetModel def) {
        this.init();
        this._create = true;
        JPanel data = new JPanel(new BorderLayout());
        data.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._tgts = this.createTargetPanel(def, this._title);
        data.add((Component)this._tgts, "Center");
        this.getContentPane().add((Component)data, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.pack();
        Dimension size = this.getSize();
        Dimension pSize = this.getParent().getSize();
        Point pLocal = this.getParent().getLocation();
        this.setLocation(pLocal.x + (pSize.width - size.width) / 2, pLocal.y + (pSize.height - size.height) / 2);
    }

    protected TargetsPanel createTargetPanel(TargetModel def, String title) {
        return new TargetsPanel(def, title);
    }

    public List<TargetModel> getTargets() {
        return this._tgts.getTargets();
    }

    protected boolean verifyParameters() {
        return this._tgts.verifyParameters();
    }

    public void refreshFileFilter(DefaultFileFilter newFilter) {
        this._tgts.getModelTable().refreshFileFilter(newFilter);
    }

    public void enableDbOutput(boolean set) {
        this._tgts.enableDbOutput(set);
    }

    public boolean isDbOutput() {
        return this._tgts.getOutputType() == 1;
    }

    public String getDbOutputSelection() {
        if (this.isDbOutput()) {
            return this._tgts.getDbSelectedOpt();
        }
        return null;
    }

    public boolean doModal(Plugable launcher) {
        if (!this._create) {
            return false;
        }
        this._tgts.copyToCtrl(launcher);
        this.setVisible(true);
        if (!this.getResult()) {
            return false;
        }
        this._tgts.copyFromCtrl(launcher);
        return true;
    }
}

