/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.EditorDBasePath;
import com.dassault.cecilia.plugin.mbsa.viewer.EditorFilePath;
import com.dassault.cecilia.plugin.mbsa.viewer.EditorVariableViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetValue;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.table.TableCellEditor;
import org.w3c.dom.Element;

public class TargetModel
implements Cloneable {
    public static final int TGT = 0;
    public static final int FILE = 1;
    public static final int END = 1;
    protected TargetValue _target = new TargetValue();
    protected boolean _tgtError = true;
    protected String _pathResult;
    protected String _pathTreeName;
    protected boolean _pathError = true;
    protected DefaultFileFilter _filter;
    protected ViewStepper _stepper;
    protected Plugable _plugable;
    protected int _outputType = 0;

    public DefaultFileFilter getFilter() {
        return this._filter;
    }

    public ViewStepper getStepper() {
        return this._stepper;
    }

    public Plugable getPlugable() {
        return this._plugable;
    }

    public void defineDefault(Plugable plugable, ViewStepper stepper, DefaultFileFilter filter) {
        this._plugable = plugable;
        this._stepper = stepper;
        this._filter = filter == null ? new DefaultFileFilter(){

            @Override
            public boolean accept(File f) {
                String fname = f.getName().toLowerCase();
                return fname.endsWith(".res") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Result File(*.res)";
            }

            @Override
            public String getDefaultExtension() {
                return ".res";
            }
        } : filter;
        if (this._filter.getDefaultAccessory() == null) {
            JLabel lbl = new JLabel(ResViewer.getString("DLG_TGT_SEL_GEN_FILTER"));
            this._filter.setDefaultAccessory(lbl);
        }
    }

    public boolean refreshFileFilter(DefaultFileFilter oldFilter, DefaultFileFilter newFilter) {
        boolean change = false;
        if (!this._pathError && this._pathResult != null && oldFilter.accept(new File(this._pathResult)) && this._pathResult.toLowerCase().endsWith(oldFilter.getDefaultExtension())) {
            this._pathResult = this._pathResult.substring(0, this._pathResult.length() - oldFilter.getDefaultExtension().length()) + newFilter.getDefaultExtension();
            change = true;
        }
        if (this._filter != null) {
            assert (this._filter == oldFilter);
            this._filter = newFilter;
            if (this._filter.getDefaultAccessory() == null) {
                this._filter.setDefaultAccessory(oldFilter.getDefaultAccessory());
            }
        }
        return change;
    }

    public String getVarTarget() {
        return this._target.getPath();
    }

    public String getValTarget() {
        return this._target.getValue();
    }

    public String getFilePath() {
        return this._pathResult.replace('\\', '/');
    }

    public Object clone() {
        TargetModel clone = new TargetModel();
        clone.copy(this);
        return clone;
    }

    protected void copy(TargetModel model) {
        this._plugable = model.getPlugable();
        this._target = new TargetValue(model._target.getPath(), model._target.getValue());
        this._tgtError = model._tgtError;
        this._pathResult = model._pathResult;
        this._pathTreeName = model._pathTreeName;
        this._pathError = model._pathError;
        this._outputType = model._outputType;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getDefaultWidth(int c) {
        switch (c) {
            case 0: {
                return 500;
            }
            case 1: {
                return 1000;
            }
        }
        return 250;
    }

    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return ResViewer.getString("DLG_TGT_SEL_TARGET");
            }
            case 1: {
                return ResViewer.getString("DLG_TGT_SEL_FILE");
            }
        }
        return "<Error>";
    }

    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return TargetValue.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public TableCellEditor getEditor(int c) {
        switch (c) {
            case 0: {
                if (this._stepper != null) {
                    return new EditorVariableViewer(this._stepper);
                }
                return null;
            }
            case 1: {
                if (this._outputType == 1) {
                    return new EditorDBasePath(this);
                }
                return new EditorFilePath(this);
            }
        }
        return null;
    }

    public Object getValueAt(int c) {
        switch (c) {
            case 0: {
                return this._target;
            }
            case 1: {
                if (this._outputType == 1) {
                    return this._pathTreeName;
                }
                return this._pathResult;
            }
        }
        return null;
    }

    public boolean setValueAt(Object item, int c) {
        switch (c) {
            case 0: {
                if (!(item instanceof TargetValue)) break;
                this._tgtError = false;
                this._target = (TargetValue)item;
                return true;
            }
            case 1: {
                if (this._outputType == 1) {
                    this._pathTreeName = item.toString();
                    this._pathError = this.verifyPath(this._pathTreeName);
                    return true;
                }
                this._pathResult = item instanceof File ? ((File)item).getAbsolutePath() : item.toString();
                this._pathError = this.verifyPath(this._pathResult);
                return true;
            }
        }
        return false;
    }

    public void setOutputType(int type, boolean clearPath) {
        this._outputType = type;
        if (clearPath) {
            this._pathResult = "";
        }
    }

    public void setPathTreeName(String path) {
        this._pathTreeName = path;
    }

    public String getPathTreeName() {
        return this._pathTreeName;
    }

    protected boolean verifyPath(String value) {
        File file;
        File parent;
        boolean error = true;
        if (value == null) {
            value = "";
        } else if (value.length() != 0 && !(this._outputType == 0 ? (parent = (file = new File(value)).getParentFile()) == null || !parent.exists() || !parent.isDirectory() : this._outputType == 1 && !this.isDBPath(value))) {
            error = false;
        }
        return error;
    }

    protected boolean isDBPath(String value) {
        StringTokenizer st = new StringTokenizer(value, "/");
        if (!st.hasMoreTokens()) {
            return false;
        }
        String projectName = st.nextToken();
        if (!st.hasMoreTokens()) {
            return false;
        }
        String systemName = st.nextToken();
        if (!st.hasMoreTokens()) {
            return false;
        }
        st.nextToken();
        if (st.hasMoreTokens()) {
            return false;
        }
        if (this.getPlugable() != null) {
            PlugableAppl appl = this.getPlugable().getAppl();
            if (appl == null) {
                return false;
            }
            DAOFolder daoFolder = appl.getDAOFactory().createFolderDAO();
            DBFolder dbFolder = daoFolder.getRootID("PROJECTS");
            if (dbFolder == null) {
                return false;
            }
            if ((dbFolder = dbFolder.findChild(projectName)) == null) {
                return false;
            }
            if (dbFolder.getChildren() == null) {
                daoFolder.findChildren(dbFolder);
            }
            if ((dbFolder = dbFolder.findChild(systemName)) == null) {
                return false;
            }
        }
        return true;
    }

    public boolean isCellEditable(int c) {
        return true;
    }

    public boolean withError(int c) {
        switch (c) {
            case 0: {
                return this._tgtError;
            }
            case 1: {
                return this._pathError;
            }
        }
        return false;
    }

    public boolean withError() {
        return this._pathError || this._tgtError;
    }

    public void saveProperties(IndentWriter out) throws IOException {
        out.write(" var=\"");
        out.write(this._target.getPath());
        out.write("\"");
        out.write(" val=\"");
        out.write(this._target.getValue());
        out.write("\"");
        out.write(" path=\"");
        out.write(this.getValueAt(1).toString());
        out.write("\"");
    }

    public void save(IndentWriter out) throws IOException {
        out.write("<");
        out.write("target");
        this.saveProperties(out);
        out.write("/>\n");
    }

    public void load(Element xmlTgt, TargetModel defTgt, int outputType) {
        String var = xmlTgt.getAttribute("var");
        String val = xmlTgt.getAttribute("val");
        String path = xmlTgt.getAttribute("path");
        this._target = new TargetValue(var, val);
        this._outputType = outputType;
        boolean bl = defTgt != null && defTgt.getStepper() != null ? !this._target.verify(defTgt.getStepper()) : (this._tgtError = false);
        if (outputType == 1) {
            this._pathTreeName = path;
        } else {
            this._pathResult = path;
        }
        if (defTgt != null) {
            defTgt._outputType = this._outputType;
            this._pathError = defTgt.verifyPath(path);
        }
    }

    public String replaceTgt(String tgtPath) {
        tgtPath = tgtPath.replaceAll("%tgt%", this._target.getPath() + " = " + this._target.getValue());
        tgtPath = tgtPath.replaceAll("%var%", this._target.getPath());
        tgtPath = tgtPath.replaceAll("%val%", this._target.getValue());
        return tgtPath;
    }
}

