/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.cecilia.export.DBKWriter;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMProcess;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public abstract class UtilityPluginTargets {
    protected static final String DEFINE_POST_PROCESS = "<!-- DEFINE POST PROCESS -->";
    PluginMProcess _process = null;

    protected abstract File createFile(Plugable var1, String var2, String var3);

    protected abstract String getTitle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BanInputStream createBanScript(Plugable launcher, List<TargetModel> tgts, String type, InputStream headerSrc, File logFile) {
        File xmlFile = this.createFile(launcher, type, ".xml");
        if (xmlFile == null) {
            return null;
        }
        PluginMProcess process = null;
        IOException ioe = null;
        try {
            BufferedWriter headerWriter = null;
            try {
                headerWriter = new BufferedWriter(new FileWriter(xmlFile));
                BufferedReader headerReader = new BufferedReader(new InputStreamReader(headerSrc));
                String line = null;
                while ((line = headerReader.readLine()) != null) {
                    if (DEFINE_POST_PROCESS.equals(line.trim())) {
                        if (process != null || (process = this.getPostProcess(launcher)) == null) continue;
                        this.writePostProcessFunction(launcher, process, headerWriter);
                        continue;
                    }
                    headerWriter.write(line);
                    headerWriter.newLine();
                }
            }
            catch (IOException e) {
                ioe = e;
                if (headerWriter != null) {
                    try {
                        headerWriter.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                BanInputStream e1 = null;
                if (ioe != null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ioe.getMessage(), this.getTitle(), 0);
                    if (!xmlFile.delete()) {
                        xmlFile.deleteOnExit();
                    }
                }
                return e1;
            }
            DBKWriter writer = null;
            try {
                writer = new DBKWriter((Writer)headerWriter, " ");
                writer.addIndent(1);
                this.writeTargets(writer, process, launcher, tgts, logFile);
                writer.addIndent(-1);
                writer.write("</process>\n", false);
                writer.close(true);
            }
            catch (IOException e) {
                ioe = e;
                if (writer != null) {
                    try {
                        writer.close(true);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                BanInputStream e1 = null;
                if (ioe != null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ioe.getMessage(), this.getTitle(), 0);
                    if (!xmlFile.delete()) {
                        xmlFile.deleteOnExit();
                    }
                }
                return e1;
            }
            BanInputStream script = null;
            try {
                script = new BanInputStream(xmlFile);
            }
            catch (IOException e) {
                ioe = e;
                Logger.getLogger(UtilityPluginTargets.class.getPackage().getName()).log(Level.SEVERE, "Don't create BanInputStream for ban script file", e);
                BanInputStream banInputStream = null;
                if (ioe != null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ioe.getMessage(), this.getTitle(), 0);
                    if (!xmlFile.delete()) {
                        xmlFile.deleteOnExit();
                    }
                }
                return banInputStream;
            }
            BanInputStream banInputStream = script;
            return banInputStream;
        }
        finally {
            if (ioe != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ioe.getMessage(), this.getTitle(), 0);
                if (!xmlFile.delete()) {
                    xmlFile.deleteOnExit();
                }
            }
        }
    }

    protected void writeTargets(DBKWriter writer, PluginMProcess process, Plugable launcher, List<TargetModel> tgts, File logFile) throws IOException {
        int nbr = tgts.size();
        Iterator<TargetModel> i = tgts.iterator();
        int cpt = 1;
        while (i.hasNext()) {
            TargetModel tgt = i.next();
            this.writeTargetToBanScript(writer, tgt, cpt, nbr);
            if (process != null) {
                this.writeTargetFromPostProcess(writer, tgt, launcher, logFile, process, cpt, nbr);
            }
            ++cpt;
        }
    }

    protected String getPostProcessKey(Plugable launcher) {
        return null;
    }

    protected PluginMProcess getPostProcess(Plugable launcher) {
        if (this._process != null) {
            return this._process;
        }
        String key = this.getPostProcessKey(launcher);
        if (key == null || key.length() == 0) {
            return null;
        }
        PluginModel plugin = launcher.getPlugin(key);
        if (plugin == null || !(plugin instanceof PluginMProcess)) {
            return null;
        }
        this._process = (PluginMProcess)plugin;
        return this._process;
    }

    protected void writePostProcessFunction(Plugable launcher, PluginMProcess process, Writer writer) throws IOException {
        String append = process.writeDefine(launcher);
        if (append != null && append.length() > 0) {
            writer.write(append);
        }
    }

    protected void writeProgressToBanScript(DBKWriter writer, TargetModel tgt, int cpt, int nbr) throws IOException {
        writer.write("<progress message=\"", false);
        if (nbr > 1) {
            writer.write(Integer.toString(cpt), false);
            writer.write("/", true);
            writer.write(Integer.toString(nbr), false);
            writer.write(" : ", true);
        }
        writer.write(tgt.getVarTarget(), true);
        writer.write("=", true);
        writer.write(tgt.getValTarget(), true);
        writer.write("\"/>\n", false);
    }

    protected abstract void writeTargetToBanScript(DBKWriter var1, TargetModel var2, int var3, int var4) throws IOException;

    protected void writeTargetFromPostProcess(DBKWriter writer, TargetModel tgt, Plugable launcher, File logFile, PluginMProcess process, int cpt, int nbr) throws IOException {
        String append = process.writeCommand(launcher, tgt.getFilePath(), logFile.getAbsolutePath());
        if (append != null && append.length() > 0) {
            writer.write(append, false);
        }
    }

    public BanEntry createBanEntry(Plugable launcher, BanEntry previous) {
        BanEntry entry = null;
        try {
            entry = previous != null ? new BanEntry(previous) : new BanEntry();
        }
        catch (BanLicenseException e) {
            Logger.getLogger(UtilityPluginTargets.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return null;
        }
        this.defineUserProperties(launcher, entry);
        return entry;
    }

    protected abstract void defineUserProperties(Plugable var1, BanEntry var2);
}

