/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.plugin.mbsa.aralia.EnumFormat;
import com.dassault.cecilia.plugin.mbsa.aralia.MCSAlgo;
import com.dassault.cecilia.plugin.mbsa.aralia.PluginCmdAralia;
import com.dassault.cecilia.plugin.mbsa.aralia.ResAralia;
import java.util.LinkedHashMap;
import java.util.Map;

public class AraliaOptions {
    boolean _proba;
    String _probaTimes;
    boolean _probaLeaves;
    boolean _cuts;
    MCSAlgo _cutsAlgo;
    boolean _cutsTrunc;
    int _cutsTruncOrder;
    boolean _cutsOrders;
    boolean _cutsProducts;
    boolean _cutsProductsOrder;
    boolean _cutsProductsProba;
    double _cutsProductsTime;
    EnumFormat _format;

    public AraliaOptions() {
        this._proba = true;
        this._probaTimes = "at 1";
        this._probaLeaves = false;
        this._cuts = true;
        this._cutsAlgo = MCSAlgo.ZQC;
        this._cutsTrunc = false;
        this._cutsTruncOrder = 4;
        this._cutsOrders = true;
        this._cutsProducts = true;
        this._cutsProductsOrder = false;
        this._cutsProductsProba = true;
        this._cutsProductsTime = 1.0;
        this._format = EnumFormat.Aralia;
    }

    public AraliaOptions(AraliaOptions src) {
        this._proba = src._proba;
        this._probaTimes = src._probaTimes;
        this._probaLeaves = src._probaLeaves;
        this._cuts = src._cuts;
        this._cutsAlgo = src._cutsAlgo;
        this._cutsTrunc = src._cutsTrunc;
        this._cutsTruncOrder = src._cutsTruncOrder;
        this._cutsOrders = src._cutsOrders;
        this._cutsProducts = src._cutsProducts;
        this._cutsProductsOrder = src._cutsProductsOrder;
        this._cutsProductsProba = src._cutsProductsProba;
        this._cutsProductsTime = src._cutsProductsTime;
        this._format = src._format;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        if (this._proba) {
            sb.append(ResAralia.getString("DLG_PROBABILITY")).append("\n");
            sb.append("\t").append(ResAralia.getString("DLG_PROBABILITY_TIME"));
            sb.append(" : ").append(this._probaTimes).append("\n");
            if (this._probaLeaves) {
                sb.append("\t");
                sb.append(ResAralia.getString("DLG_PROBABILITY_LEAVES"));
                sb.append("\n");
            }
        }
        if (this._cuts) {
            sb.append(ResAralia.getString("DLG_CUTS")).append("\n");
            sb.append("\t").append(ResAralia.getString("DLG_CUTS_ALGO"));
            sb.append(" : ").append((Object)this._cutsAlgo).append("\n");
            if (this._cutsTrunc) {
                sb.append("\t").append(ResAralia.getString("DLG_CUTS_TRUNCATED"));
                sb.append(" : ").append(this._cutsTruncOrder).append("\n");
            }
            if (this._cutsOrders) {
                sb.append("\t").append(ResAralia.getString("DLG_CUTS_ORDERS")).append("\n");
            }
            if (this._cutsProducts) {
                sb.append("\t").append(ResAralia.getString("DLG_CUTS_PRODUCTS")).append("\n");
                if (this._cutsProductsOrder) {
                    sb.append("\t\t").append(ResAralia.getString("DLG_CUTS_PRODUCTS_ORDER")).append("\n");
                }
                if (this._cutsProductsProba) {
                    sb.append("\t\t").append(ResAralia.getString("DLG_CUTS_PRODUCTS_PROBA")).append("\n");
                    sb.append("\t\t").append(ResAralia.getString("DLG_CUTS_PRODUCTS_TIME"));
                    sb.append(" : ").append(this._cutsProductsTime).append("\n");
                }
            }
        }
        sb.append(ResAralia.getString("DLG_FORMAT_LBL"));
        sb.append(" : ").append((Object)this._format).append("\n");
        return sb.toString();
    }

    private static boolean getBoolOpt(SourceWrapper src, String key, boolean def) {
        String value = src.getValue(key);
        if (value == null || value.length() == 0) {
            return def;
        }
        return value.equalsIgnoreCase("true");
    }

    private static String getStrOpt(SourceWrapper src, String key, String def) {
        String value = src.getValue(key);
        if (value == null || value.length() == 0) {
            return def;
        }
        return value;
    }

    private void loadData(SourceWrapper src) {
        int i;
        this._proba = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_PROBA, this._proba);
        this._probaTimes = AraliaOptions.getStrOpt(src, PluginCmdAralia.OPT_PROBA_TIME, this._probaTimes);
        this._probaLeaves = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_PROBA_LEAVES, this._probaLeaves);
        this._cuts = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_CUTS, this._cuts);
        String algo = src.getValue(PluginCmdAralia.OPT_CUTS_ALGO);
        if (algo != null) {
            MCSAlgo[] values = MCSAlgo.values();
            for (i = 0; i < values.length; ++i) {
                if (!algo.equals(values[i].getCode())) continue;
                this._cutsAlgo = values[i];
                break;
            }
        }
        this._cutsTrunc = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_CUTS_TRUNC, this._cutsTrunc);
        String trunc = AraliaOptions.getStrOpt(src, PluginCmdAralia.OPT_CUTS_TRUNC_ORDER, Integer.toString(this._cutsTruncOrder));
        try {
            int i2 = Integer.parseInt(trunc);
            if (i2 <= 0) {
                throw new NumberFormatException();
            }
            this._cutsTruncOrder = i2;
        }
        catch (NumberFormatException e) {
            this._cutsTruncOrder = 4;
        }
        this._cutsOrders = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_CUTS_ORDERS, this._cutsOrders);
        this._cutsProducts = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_CUTS_DISPLAY, this._cutsProducts);
        this._cutsProductsOrder = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_CUTS_DISPLAY_ORDER, this._cutsProductsOrder);
        this._cutsProductsProba = AraliaOptions.getBoolOpt(src, PluginCmdAralia.OPT_CUTS_DISPLAY_PROBA, this._cutsProductsProba);
        String time = AraliaOptions.getStrOpt(src, PluginCmdAralia.OPT_CUTS_DISPLAY_PROBA_TIME, Double.toString(this._cutsProductsTime));
        try {
            double d = Double.parseDouble(time);
            if (d < 0.0) {
                throw new NumberFormatException();
            }
            this._cutsProductsTime = d;
        }
        catch (NumberFormatException e) {
            this._cutsProductsTime = 1.0;
        }
        String set = src.getValue(PluginCmdAralia.OPT_ARALIA_FORMAT);
        if (set != null) {
            EnumFormat[] values = EnumFormat.values();
            for (i = 0; i < values.length; ++i) {
                if (!set.equals(values[i].getCode())) continue;
                this._format = values[i];
                break;
            }
        }
    }

    public void loadPreferences(final Plugable _launcher) {
        SourceWrapper wrapperPlugable = new SourceWrapper(){

            @Override
            public String getValue(String key) {
                return _launcher.getOption(key);
            }
        };
        this.loadData(wrapperPlugable);
    }

    public void loadParameters(final Map<String, String> params) {
        SourceWrapper wrapperPlugable = new SourceWrapper(){

            @Override
            public String getValue(String key) {
                return (String)params.get(key);
            }
        };
        this.loadData(wrapperPlugable);
    }

    public void savePreferences(Plugable _launcher) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        this.saveParameters(params);
        for (Map.Entry entry : params.entrySet()) {
            _launcher.setOption((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void saveParameters(Map<String, String> params) {
        params.put(PluginCmdAralia.OPT_PROBA, Boolean.toString(this._proba));
        params.put(PluginCmdAralia.OPT_PROBA_TIME, this._probaTimes);
        params.put(PluginCmdAralia.OPT_PROBA_LEAVES, Boolean.toString(this._probaLeaves));
        params.put(PluginCmdAralia.OPT_CUTS, Boolean.toString(this._cuts));
        params.put(PluginCmdAralia.OPT_CUTS_ALGO, this._cutsAlgo.getCode());
        params.put(PluginCmdAralia.OPT_CUTS_TRUNC, Boolean.toString(this._cutsTrunc));
        params.put(PluginCmdAralia.OPT_CUTS_TRUNC_ORDER, Integer.toString(this._cutsTruncOrder));
        params.put(PluginCmdAralia.OPT_CUTS_ORDERS, Boolean.toString(this._cutsOrders));
        params.put(PluginCmdAralia.OPT_CUTS_DISPLAY, Boolean.toString(this._cutsProducts));
        params.put(PluginCmdAralia.OPT_CUTS_DISPLAY_ORDER, Boolean.toString(this._cutsProductsOrder));
        params.put(PluginCmdAralia.OPT_CUTS_DISPLAY_PROBA, Boolean.toString(this._cutsProductsProba));
        params.put(PluginCmdAralia.OPT_CUTS_DISPLAY_PROBA_TIME, Double.toString(this._cutsProductsTime));
        params.put(PluginCmdAralia.OPT_ARALIA_FORMAT, this._format.getCode());
    }

    public String writeAraliaCompute(String baseLine) {
        StringBuffer sb = new StringBuffer(512);
        if (this._proba) {
            sb.append(baseLine).append("<pr>");
            sb.append(baseLine).append("  ");
            sb.append(this.convertTimeToXMLTime(this._probaTimes));
            sb.append("</pr>\n");
        }
        if (this._cuts) {
            sb.append(baseLine).append("<mcs algo='");
            sb.append(this._cutsAlgo.getCode());
            if (this._cutsTrunc) {
                sb.append("' truncated='");
                sb.append(this._cutsTruncOrder);
            }
            sb.append("'>\n");
            sb.append(baseLine).append("  <param name='orders' value='");
            sb.append(this._cutsOrders);
            sb.append("'/>\n");
            if (this._cutsProducts) {
                sb.append(baseLine).append("  <filter>\n");
                sb.append(baseLine).append("    <property name='order' value='");
                sb.append(this._cutsProductsOrder);
                sb.append("'/>\n");
                sb.append(baseLine).append("    <property name='probability' value='");
                sb.append(this._cutsProductsProba);
                sb.append("'/>\n");
                sb.append(baseLine).append("  </filter>\n");
            } else {
                sb.append(baseLine).append("  <param name='products' value='false'/>\n");
            }
            sb.append(baseLine).append("</mcs>\n");
        }
        if (this._proba && this._probaLeaves) {
            sb.append(baseLine).append("<pr> <param name='leaves' value='true'/>\n");
            sb.append(baseLine).append("  ");
            sb.append(this.convertTimeToXMLTime(this._probaTimes));
            sb.append("</pr>\n");
        }
        return sb.toString();
    }

    protected String convertTimeToXMLTime(String time) {
        StringBuffer result = new StringBuffer(time.length() * 3 / 2 + 10);
        try {
            if (time.contains("at")) {
                result.append("<times at='");
                result.append(time.replace("at", "").trim());
                result.append("'/>");
            } else {
                int iTo = time.indexOf("to");
                int iStep = time.indexOf("step");
                result.append("<times from='");
                result.append(time.substring(5, iTo).trim());
                result.append("' to='");
                result.append(time.substring(iTo + 2, iStep).trim());
                result.append("' step='");
                result.append(time.substring(iStep + 5).trim());
                result.append("'/>");
            }
        }
        catch (Exception e) {
            return "";
        }
        return result.toString();
    }

    static interface SourceWrapper {
        public String getValue(String var1);
    }
}

