/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaParameters;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AraliaParametersIO
implements IOParameters {
    protected static final String KEY_ARALIA_PARAMS = "aralia-treatment";
    protected static final String KEY_INPUT = "input";
    protected static final String KEY_OUTPUT = "output";
    protected static final String KEY_PARAM = "parameter";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_VALUE = "value";
    private static final Logger __logger = Logger.getLogger(AraliaParametersIO.class.getPackage().getName());

    AraliaParametersIO() {
    }

    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (parameters instanceof AraliaParameters) {
            AraliaParameters aralia = (AraliaParameters)parameters;
            out.write("      <");
            out.write(KEY_ARALIA_PARAMS);
            out.write(" ");
            out.write(KEY_INPUT);
            out.write("=\"");
            out.write(aralia.getInput());
            out.write("\"");
            out.write(" ");
            out.write(KEY_OUTPUT);
            out.write("=\"");
            out.write(aralia.getOutput());
            out.write("\"");
            out.write(">\n");
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            aralia.getAraliaOptions().saveParameters(params);
            for (Map.Entry param : params.entrySet()) {
                out.write("        <");
                out.write(KEY_PARAM);
                out.write(" ");
                out.write(KEY_NAME);
                out.write("=\"");
                out.write((String)param.getKey());
                out.write("\"");
                out.write(" ");
                out.write(KEY_VALUE);
                out.write("=\"");
                out.write((String)param.getValue());
                out.write("\"");
                out.write("/>\n");
            }
        } else {
            throw new IOException("Unsupported object for AraliaParametersIO");
        }
        out.write("      </");
        out.write(KEY_ARALIA_PARAMS);
        out.write(">\n");
    }

    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_ARALIA_PARAMS)) {
            return null;
        }
        AraliaParameters res = new AraliaParameters();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Node attr = root.getAttributes().getNamedItem(KEY_INPUT);
        if (attr != null) {
            res._inputKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_OUTPUT)) != null) {
            res._outputKey = attr.getNodeValue();
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childName;
            if (child.getNodeType() != 1 || !(childName = child.getNodeName()).equals(KEY_PARAM)) continue;
            attr = child.getAttributes().getNamedItem(KEY_NAME);
            if (attr == null || attr.getNodeValue().length() == 0) {
                __logger.warning("Parsing error : 'parameter' without 'name' attribute");
                continue;
            }
            String key = attr.getNodeValue();
            attr = child.getAttributes().getNamedItem(KEY_VALUE);
            if (attr == null || attr.getNodeValue().length() == 0) {
                __logger.warning("Parsing error : 'parameter' without 'value' attribute");
                continue;
            }
            params.put(key, attr.getNodeValue());
        }
        res.getAraliaOptions().loadParameters(params);
        return res;
    }
}

