/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.plugin.seqconvert.Event;
import com.dassault.cecilia.plugin.seqconvert.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class SequenceFile {
    private String name = null;
    private Event dreadedEvent = null;
    private int nbSequences = 0;
    private Sequence[] sequences = null;
    private String type = null;
    private boolean valid = false;

    public SequenceFile(File seqFile) {
        this.extractNameAndType(seqFile);
        this.sequences = this.extractDreadedEventAndSequence(seqFile);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getName() {
        return this.name;
    }

    public Event getDreadedEvent() {
        return this.dreadedEvent;
    }

    public int getNbSequences() {
        return this.nbSequences;
    }

    public String getType() {
        return this.type;
    }

    public Sequence getSequence(int index) {
        try {
            return this.sequences[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Sequence[] getSequences() {
        return this.sequences;
    }

    public Sequence getFilteredSequence(int index, Event[] eventsToFilter) {
        try {
            Sequence retSequence = new Sequence(this.sequences[index].filter(eventsToFilter));
            return retSequence;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Sequence[] getFilteredSequences(Event[] eventsToFilter) {
        ArrayList<Sequence> listSeq = new ArrayList<Sequence>();
        for (int i = 0; i < this.nbSequences; ++i) {
            listSeq.add(new Sequence(this.sequences[i].filter(eventsToFilter)));
        }
        Sequence[] retSequences = listSeq.toArray(new Sequence[listSeq.size()]);
        return retSequences;
    }

    public Event[] getEvents() {
        int i;
        ArrayList<Event> unsortedEvents = new ArrayList<Event>();
        ArrayList<Event> sortedEvents = new ArrayList<Event>();
        for (i = 0; i < this.nbSequences; ++i) {
            for (int j = 0; j < this.sequences[i].getNbEvents(); ++j) {
                unsortedEvents.add(this.sequences[i].getEvent(j));
            }
        }
        for (i = 0; i < unsortedEvents.size(); ++i) {
            Event evt = (Event)unsortedEvents.get(i);
            if (sortedEvents.contains(evt)) continue;
            sortedEvents.add(evt);
        }
        Event[] retEvents = sortedEvents.toArray(new Event[sortedEvents.size()]);
        return retEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractNameAndType(File seqFile) {
        BufferedReader reader = null;
        try {
            String line;
            this.name = seqFile.getName();
            reader = new LineNumberReader(new FileReader(seqFile));
            boolean state = false;
            while (state < true && (line = ((LineNumberReader)reader).readLine()) != null) {
                if ((line = line.trim()).startsWith("products(")) {
                    this.type = "JAVA";
                    state = true;
                    continue;
                }
                if (line.startsWith("/* Generate by CStepper")) {
                    this.type = "C";
                    state = true;
                    continue;
                }
                state = false;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (0 != this.name.length() && 0 != this.type.length()) {
            this.valid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence[] extractDreadedEventAndSequence(File seqFile) {
        int nbSeq = 0;
        ArrayList<Sequence> listSeq = new ArrayList<Sequence>(0);
        BufferedReader reader = null;
        try {
            int endDreadedEvent;
            int beginDreadedEvent;
            String line;
            reader = new LineNumberReader(new FileReader(seqFile));
            int state = 0;
            if (this.type.equals("JAVA")) {
                while (state < 3 && (line = ((LineNumberReader)reader).readLine()) != null) {
                    line = line.trim();
                    switch (state) {
                        case 0: {
                            if (!line.startsWith("products(")) break;
                            beginDreadedEvent = line.indexOf(39);
                            endDreadedEvent = line.indexOf(39, beginDreadedEvent + 1);
                            this.dreadedEvent = new Event(line.substring(beginDreadedEvent + 1, endDreadedEvent));
                            state = 1;
                        }
                        case 1: {
                            if (!line.endsWith("=")) break;
                            state = 2;
                            break;
                        }
                        case 2: {
                            if (line.equals("end")) {
                                state = 3;
                                break;
                            }
                            listSeq.add(nbSeq, new Sequence(this.extractEvents(line)));
                            ++nbSeq;
                        }
                    }
                }
            } else if (this.type.equals("C")) {
                while (state < 2 && (line = ((LineNumberReader)reader).readLine()) != null) {
                    line = line.trim();
                    switch (state) {
                        case 0: {
                            if (!line.startsWith("/*Targeted event :")) break;
                            beginDreadedEvent = line.indexOf(39);
                            endDreadedEvent = line.indexOf(39, beginDreadedEvent + 1);
                            this.dreadedEvent = new Event(line.substring(beginDreadedEvent + 1, endDreadedEvent));
                            state = 1;
                        }
                        case 1: {
                            if (line.startsWith("/* #")) {
                                state = 2;
                                break;
                            }
                            if (!line.startsWith("MIN_") && !line.startsWith("SEQ_")) break;
                            listSeq.add(nbSeq, new Sequence(this.extractEvents(line)));
                            ++nbSeq;
                        }
                    }
                }
            }
            if (0 != nbSeq) {
                Sequence[] retSeq;
                this.valid &= true;
                this.nbSequences = nbSeq;
                Sequence[] endDreadedEvent2 = retSeq = listSeq.toArray(new Sequence[nbSeq]);
                return endDreadedEvent2;
            }
            this.valid = false;
            Sequence[] retSeq = null;
            return retSeq;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.valid = false;
            Sequence[] sequenceArray = null;
            return sequenceArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Event[] extractEvents(String line) {
        int beginEvent = -1;
        int endEvent = -1;
        ArrayList<Event> listEvents = new ArrayList<Event>(0);
        boolean endLine = false;
        while (endLine < true) {
            beginEvent = line.indexOf(39, endEvent + 1);
            endEvent = line.indexOf(39, beginEvent + 1);
            if (-1 != beginEvent && -1 != endEvent) {
                listEvents.add(new Event(line.substring(beginEvent + 1, endEvent)));
                continue;
            }
            endLine = true;
        }
        Event[] retEvents = listEvents.toArray(new Event[listEvents.size()]);
        return retEvents;
    }
}

