/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBan;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mcs.MCS2DagOptionsPanel;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PluginCmdMCS2Dag
extends AbstractPluginModel
implements PluginMAction {
    protected static final String PREF_SIZE = PluginCmdMCS2Dag.class.getName() + "#Size";
    protected static final String PREF_SEP = PluginCmdMCS2Dag.class.getName() + "#Sep";

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResMCS.getString("PLUG_CMD_MCS2DAG_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResMCS.getString("PLUG_CMD_MCS2DAG_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-04.svg"));
        }
        return super.getIcon(key);
    }

    public void createSession(Plugable launcher, Object parameters) {
        InputStream script = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptMCS2Dag.xml");
        if (script == null) {
            Logger.getLogger(PluginCmdMCS2Dag.class.getPackage().getName()).severe("Resource script not found : BanScriptMCS2Dag.xml");
            return;
        }
        DlgLaunch dlg = new DlgLaunch(launcher, launcher.getWindow());
        dlg._ctrlOptions.setGroupSize(PlugableUtility.getIntOpt((Plugable)launcher, (String)PREF_SIZE, (int)100));
        dlg._ctrlOptions.setSeparator(PlugableUtility.getCharOpt((Plugable)launcher, (String)PREF_SEP, (char)'.'));
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        launcher.setOption(PREF_SIZE, Integer.toString(dlg._ctrlOptions.getGroupSize()));
        launcher.setOption(PREF_SEP, Character.toString(dlg._ctrlOptions.getSeparator()));
        BanEntry entry = null;
        try {
            entry = new BanEntry();
        }
        catch (BanLicenseException e) {
            Logger.getLogger(PluginCmdMCS2Dag.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return;
        }
        entry.setUserProperty("mcs2dag.src", dlg._inFile);
        entry.setUserProperty("mcs2dag.dest", dlg._outFile);
        entry.setUserProperty("mcs2dag.size", Integer.toString(dlg._ctrlOptions.getGroupSize()));
        entry.setUserProperty("mcs2dag.sep", Character.toString(dlg._ctrlOptions.getSeparator()));
        AbstractPlugTaskBan task = new AbstractPlugTaskBan(-1L, launcher, entry, new BanInputStream(script, "MCS2Ara")){

            protected String getDesc() {
                return this.getInfo("plugin.name");
            }

            protected String getName() {
                return "MCS2Ara";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-04.svg"));
                }
                return super.getIcon(key);
            }

            protected void displayResult() {
            }
        };
        launcher.addTask((PlugTask)task, -1L);
    }

    class DlgLaunch
    extends JDialogCecilia {
        JTextField _ctrlInFile;
        JTextField _ctrlOutFile;
        MCS2DagOptionsPanel _ctrlOptions;
        Plugable _launcher;
        public String _inFile;
        public String _outFile;

        public DlgLaunch(Plugable launcher, Window win) {
            super(win, true);
            this._launcher = launcher;
            this.init();
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            int line = 0;
            rPanel.add((Component)new JLabel(ResMCS.getString("DLG_MCS2DAG_INFILE")), new GridBagConstraints(0, line++, 4, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this._ctrlInFile = new JTextField(30);
            rPanel.add((Component)this._ctrlInFile, new GridBagConstraints(0, line, 3, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            JButton bPath = new JButton("...");
            rPanel.add((Component)bPath, new GridBagConstraints(3, line++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            bPath.addActionListener(new ActionListener(){
                JFileChooser _fileChooser;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this._fileChooser == null) {
                        this._fileChooser = new JFileChooser();
                        FileFilterExtention defaultFilter = new FileFilterExtention("MCS file (*.mcs,*.seq,*.xml)", ".mcs;.seq;.xml").verifyRead(true);
                        this._fileChooser.addChoosableFileFilter((FileFilter)defaultFilter);
                        this._fileChooser.addChoosableFileFilter((FileFilter)new FileFilterExtention("Export Text file (*.txt)", ".txt").verifyRead(true));
                        this._fileChooser.addChoosableFileFilter((FileFilter)new FileFilterExtention("Export Xml file (*.xml)", ".xml").verifyRead(true));
                        this._fileChooser.setFileFilter((FileFilter)defaultFilter);
                    }
                    this._fileChooser.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)DlgLaunch.this._launcher, (String)"plugable.option.path", (String)".")));
                    if (this._fileChooser.showOpenDialog(DlgLaunch.this._ctrlInFile) == 0) {
                        File f = this._fileChooser.getSelectedFile();
                        DlgLaunch.this._launcher.setOption("plugable.option.path", f.getParent());
                        DlgLaunch.this._ctrlInFile.setText(f.getPath());
                    }
                }
            });
            rPanel.add((Component)new JLabel(ResMCS.getString("DLG_MCS2DAG_OUTFILE")), new GridBagConstraints(0, line++, 4, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this._ctrlOutFile = new JTextField(30);
            rPanel.add((Component)this._ctrlOutFile, new GridBagConstraints(0, line, 3, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            bPath = new JButton("...");
            rPanel.add((Component)bPath, new GridBagConstraints(3, line++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            bPath.addActionListener(new ActionListener(){
                JFileChooser _fileChooser;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this._fileChooser == null) {
                        this._fileChooser = new JFileChooser();
                        FileFilterExtention defaultFilter = new FileFilterExtention("CeciliaBDD/Aralia2 file (*.dag)", ".dag").verifyWrite(true);
                        this._fileChooser.addChoosableFileFilter((FileFilter)defaultFilter);
                        this._fileChooser.addChoosableFileFilter((FileFilter)new FileFilterExtention("Aralia4 file (*.ara)", ".ara").verifyWrite(true));
                        this._fileChooser.setFileFilter((FileFilter)defaultFilter);
                    }
                    this._fileChooser.setCurrentDirectory(new File(PlugableUtility.getStrOpt((Plugable)DlgLaunch.this._launcher, (String)"plugable.option.path", (String)".")));
                    if (this._fileChooser.showOpenDialog(DlgLaunch.this._ctrlOutFile) == 0) {
                        DlgLaunch.this._launcher.setOption("plugable.option.path", this._fileChooser.getSelectedFile().getParent());
                        DlgLaunch.this._ctrlOutFile.setText(FileFilterExtention.addDefaultExtention((JFileChooser)this._fileChooser).getPath());
                    }
                }
            });
            this._ctrlOptions = new MCS2DagOptionsPanel();
            rPanel.add((Component)this._ctrlOptions, new GridBagConstraints(0, line++, 4, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, line++, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setResizable(false);
            this.setTitle(ResMCS.getString("PLUG_CMD_MCS2DAG_NAME"));
        }

        protected boolean verifyParameters() {
            String title = ResMCS.getString("PLUG_CMD_MCS2DAG_NAME");
            this._inFile = this._ctrlInFile.getText();
            if (!FileUtility.verifyPath((String)this._inFile, (boolean)false, (Component)this._ctrlInFile, (String)title)) {
                return false;
            }
            this._outFile = this._ctrlOutFile.getText();
            if (!FileUtility.verifyPath((String)this._outFile, (boolean)true, (Component)this._ctrlOutFile, (String)title)) {
                return false;
            }
            return this._ctrlOptions.verify();
        }
    }
}

