/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

public abstract class MessengerState {
    private static final Action Connect = new Action(){

        public void doIt(MessengerState messengerState) {
            messengerState.connectAction();
        }
    };
    private static final Action Closein = new Action(){

        public void doIt(MessengerState s) {
            s.closeInputAction();
        }
    };
    private static final Action Start = new Action(){

        public void doIt(MessengerState s) {
            s.startAction();
        }
    };
    private static final Action Closeout = new Action(){

        public void doIt(MessengerState messengerState) {
            messengerState.closeOutputAction();
        }
    };
    private static final Action Failall = new Action(){

        public void doIt(MessengerState messengerState) {
            messengerState.failAllAction();
        }
    };
    private static final Action Closeio = new Action(){

        public void doIt(MessengerState s) {
            s.closeInputAction();
            s.closeOutputAction();
        }
    };
    private static final Action Closefail = new Action(){

        public void doIt(MessengerState messengerState) {
            messengerState.closeInputAction();
            messengerState.failAllAction();
        }
    };
    private static final Action Nop = new Action(){

        public void doIt(MessengerState messengerState) {
        }
    };
    private volatile State state = null;

    protected MessengerState(boolean connected) {
        this.state = connected ? TransitionMap.Connected : TransitionMap.Unresolved;
    }

    public int getState() {
        return this.state.number;
    }

    public void resolveEvent() {
        Action a = this.state.acResolve;
        this.state = this.state.stResolve;
        a.doIt(this);
    }

    public void msgsEvent() {
        Action a = this.state.acMsgs;
        this.state = this.state.stMsgs;
        a.doIt(this);
    }

    public void saturatedEvent() {
        Action a = this.state.acSaturated;
        this.state = this.state.stSaturated;
        a.doIt(this);
    }

    public void closeEvent() {
        Action a = this.state.acClose;
        this.state = this.state.stClose;
        a.doIt(this);
    }

    public void shutdownEvent() {
        Action a = this.state.acShutdown;
        this.state = this.state.stShutdown;
        a.doIt(this);
    }

    public void upEvent() {
        Action a = this.state.acUp;
        this.state = this.state.stUp;
        a.doIt(this);
    }

    public void downEvent() {
        Action a = this.state.acDown;
        this.state = this.state.stDown;
        a.doIt(this);
    }

    public void idleEvent() {
        Action a = this.state.acIdle;
        this.state = this.state.stIdle;
        a.doIt(this);
    }

    protected abstract void connectAction();

    protected abstract void startAction();

    protected abstract void closeInputAction();

    protected abstract void failAllAction();

    protected abstract void closeOutputAction();

    static /* synthetic */ Action access$000() {
        return Connect;
    }

    static /* synthetic */ Action access$100() {
        return Closein;
    }

    static /* synthetic */ Action access$200() {
        return Nop;
    }

    static /* synthetic */ Action access$300() {
        return Closefail;
    }

    static /* synthetic */ Action access$400() {
        return Start;
    }

    static /* synthetic */ Action access$500() {
        return Closeio;
    }

    static /* synthetic */ Action access$600() {
        return Failall;
    }

    static /* synthetic */ Action access$700() {
        return Closeout;
    }

    private static class TransitionMap {
        private static final State Unresolved = new State(1);
        private static final State ResPending = new State(16);
        private static final State Resolving = new State(2);
        private static final State ResolSat = new State(32);
        private static final State Connected = new State(4);
        private static final State Disconned = new State(8);
        private static final State Reconning = new State(256);
        private static final State ReconSat = new State(512);
        private static final State Sending = new State(64);
        private static final State SendingSat = new State(128);
        private static final State ResClosing = new State(1024);
        private static final State ReconClosing = new State(4096);
        private static final State Closing = new State(2048);
        private static final State Disconning = new State(32768);
        private static final State Unresable = new State(65536);
        private static final State Closed = new State(262144);
        private static final State Broken = new State(131072);
        private static final Object[][] INIT_TRANSITION_MAP = new Object[][]{{Resolving, MessengerState.access$000(), ResPending, MessengerState.access$000(), ResolSat, MessengerState.access$000(), Closed, MessengerState.access$100(), Broken, MessengerState.access$100(), Connected, MessengerState.access$200(), Unresolved, MessengerState.access$200(), Unresolved, MessengerState.access$200()}, {ResPending, MessengerState.access$200(), ResPending, MessengerState.access$200(), ResolSat, MessengerState.access$200(), ResClosing, MessengerState.access$100(), Broken, MessengerState.access$300(), Sending, MessengerState.access$400(), Unresable, MessengerState.access$300(), Resolving, MessengerState.access$200()}, {Resolving, MessengerState.access$200(), ResPending, MessengerState.access$200(), ResolSat, MessengerState.access$200(), Closed, MessengerState.access$100(), Broken, MessengerState.access$100(), Connected, MessengerState.access$200(), Unresable, MessengerState.access$100(), Resolving, MessengerState.access$200()}, {ResolSat, MessengerState.access$200(), ResPending, MessengerState.access$200(), ResolSat, MessengerState.access$200(), ResClosing, MessengerState.access$100(), Broken, MessengerState.access$300(), SendingSat, MessengerState.access$400(), Unresable, MessengerState.access$300(), Resolving, MessengerState.access$200()}, {Connected, MessengerState.access$200(), Sending, MessengerState.access$400(), SendingSat, MessengerState.access$400(), Closed, MessengerState.access$500(), Broken, MessengerState.access$500(), Connected, MessengerState.access$200(), Disconned, MessengerState.access$200(), Connected, MessengerState.access$200()}, {Disconned, MessengerState.access$200(), Reconning, MessengerState.access$000(), ReconSat, MessengerState.access$000(), Closed, MessengerState.access$100(), Broken, MessengerState.access$100(), Connected, MessengerState.access$200(), Disconned, MessengerState.access$200(), Disconned, MessengerState.access$200()}, {Reconning, MessengerState.access$200(), Reconning, MessengerState.access$200(), ReconSat, MessengerState.access$200(), ReconClosing, MessengerState.access$100(), Broken, MessengerState.access$300(), Sending, MessengerState.access$400(), Broken, MessengerState.access$300(), Disconned, MessengerState.access$200()}, {ReconSat, MessengerState.access$200(), Reconning, MessengerState.access$200(), ReconSat, MessengerState.access$200(), ReconClosing, MessengerState.access$100(), Broken, MessengerState.access$300(), SendingSat, MessengerState.access$400(), Broken, MessengerState.access$300(), Disconned, MessengerState.access$200()}, {Sending, MessengerState.access$200(), Sending, MessengerState.access$200(), SendingSat, MessengerState.access$200(), Closing, MessengerState.access$100(), Disconning, MessengerState.access$500(), Sending, MessengerState.access$200(), Reconning, MessengerState.access$000(), Connected, MessengerState.access$200()}, {SendingSat, MessengerState.access$200(), Sending, MessengerState.access$200(), SendingSat, MessengerState.access$200(), Closing, MessengerState.access$100(), Disconning, MessengerState.access$500(), SendingSat, MessengerState.access$200(), ReconSat, MessengerState.access$000(), Connected, MessengerState.access$200()}, {ResClosing, MessengerState.access$200(), ResClosing, MessengerState.access$200(), ResClosing, MessengerState.access$200(), ResClosing, MessengerState.access$200(), Broken, MessengerState.access$600(), Closing, MessengerState.access$400(), Unresable, MessengerState.access$600(), ResClosing, MessengerState.access$200()}, {ReconClosing, MessengerState.access$200(), ReconClosing, MessengerState.access$200(), ReconClosing, MessengerState.access$200(), ReconClosing, MessengerState.access$200(), Broken, MessengerState.access$600(), Closing, MessengerState.access$400(), Broken, MessengerState.access$600(), ReconClosing, MessengerState.access$200()}, {Closing, MessengerState.access$200(), Closing, MessengerState.access$200(), Closing, MessengerState.access$200(), Closing, MessengerState.access$200(), Disconning, MessengerState.access$700(), Closing, MessengerState.access$200(), ReconClosing, MessengerState.access$000(), Closed, MessengerState.access$700()}, {Disconning, MessengerState.access$200(), Disconning, MessengerState.access$200(), Disconning, MessengerState.access$200(), Disconning, MessengerState.access$200(), Disconning, MessengerState.access$200(), Disconning, MessengerState.access$200(), Broken, MessengerState.access$600(), Broken, MessengerState.access$200()}, {Unresable, MessengerState.access$200(), Unresable, MessengerState.access$200(), Unresable, MessengerState.access$200(), Unresable, MessengerState.access$200(), Unresable, MessengerState.access$200(), Unresable, MessengerState.access$700(), Unresable, MessengerState.access$200(), Unresable, MessengerState.access$200()}, {Closed, MessengerState.access$200(), Closed, MessengerState.access$200(), Closed, MessengerState.access$200(), Closed, MessengerState.access$200(), Closed, MessengerState.access$200(), Closed, MessengerState.access$700(), Closed, MessengerState.access$200(), Closed, MessengerState.access$200()}, {Broken, MessengerState.access$200(), Broken, MessengerState.access$200(), Broken, MessengerState.access$200(), Broken, MessengerState.access$200(), Broken, MessengerState.access$200(), Broken, MessengerState.access$700(), Broken, MessengerState.access$200(), Broken, MessengerState.access$200()}};

        private TransitionMap() {
        }

        static {
            Unresolved.init(INIT_TRANSITION_MAP[0]);
            ResPending.init(INIT_TRANSITION_MAP[1]);
            Resolving.init(INIT_TRANSITION_MAP[2]);
            ResolSat.init(INIT_TRANSITION_MAP[3]);
            Connected.init(INIT_TRANSITION_MAP[4]);
            Disconned.init(INIT_TRANSITION_MAP[5]);
            Reconning.init(INIT_TRANSITION_MAP[6]);
            ReconSat.init(INIT_TRANSITION_MAP[7]);
            Sending.init(INIT_TRANSITION_MAP[8]);
            SendingSat.init(INIT_TRANSITION_MAP[9]);
            ResClosing.init(INIT_TRANSITION_MAP[10]);
            ReconClosing.init(INIT_TRANSITION_MAP[11]);
            Closing.init(INIT_TRANSITION_MAP[12]);
            Disconning.init(INIT_TRANSITION_MAP[13]);
            Unresable.init(INIT_TRANSITION_MAP[14]);
            Closed.init(INIT_TRANSITION_MAP[15]);
            Broken.init(INIT_TRANSITION_MAP[16]);
        }
    }

    private static class State {
        private final int number;
        private State stResolve;
        private Action acResolve;
        private State stMsgs;
        private Action acMsgs;
        private State stSaturated;
        private Action acSaturated;
        private State stClose;
        private Action acClose;
        private State stShutdown;
        private Action acShutdown;
        private State stUp;
        private Action acUp;
        private State stDown;
        private Action acDown;
        private State stIdle;
        private Action acIdle;

        State(int stateNum) {
            this.number = stateNum;
        }

        void init(Object[] data) {
            this.stResolve = (State)data[0];
            this.acResolve = (Action)data[1];
            this.stMsgs = (State)data[2];
            this.acMsgs = (Action)data[3];
            this.stSaturated = (State)data[4];
            this.acSaturated = (Action)data[5];
            this.stClose = (State)data[6];
            this.acClose = (Action)data[7];
            this.stShutdown = (State)data[8];
            this.acShutdown = (Action)data[9];
            this.stUp = (State)data[10];
            this.acUp = (Action)data[11];
            this.stDown = (State)data[12];
            this.acDown = (Action)data[13];
            this.stIdle = (State)data[14];
            this.acIdle = (Action)data[15];
        }
    }

    private static interface Action {
        public void doIt(MessengerState var1);
    }
}

