/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.impl.resolver.resolverMeter.SrdiDestinationMetric;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class SrdiHandlerMetric
implements DocumentSerializable {
    private String handlerName;
    private boolean registered = true;
    private int numProcessed = 0;
    private int numErrorsWhileProcessing = 0;
    private int numToUnregisteredHandler = 0;
    private long totalProcessTime = 0L;
    private int numMessagesSentViaWalker = 0;
    private int numMessagesSentViaUnicast = 0;
    private int numErrorsSendingMessages = 0;
    private int numErrorsPropagatingMessages = 0;
    private HashMap destinationMetrics = new HashMap();

    public SrdiHandlerMetric(String handlerName) {
        this.handlerName = handlerName;
    }

    public SrdiHandlerMetric() {
    }

    public SrdiHandlerMetric(SrdiHandlerMetric prototype) {
        this.handlerName = prototype.handlerName;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public boolean getRegistered() {
        return this.registered;
    }

    public int getNumProcessed() {
        return this.numProcessed;
    }

    public int getNumErrorsWhileProcessing() {
        return this.numErrorsWhileProcessing;
    }

    public long getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getNumMessagesSentViaWalker() {
        return this.numMessagesSentViaWalker;
    }

    public int getNumMessagesSentViaUnicast() {
        return this.numMessagesSentViaUnicast;
    }

    public int getNumErrorsSendingMessages() {
        return this.numErrorsSendingMessages;
    }

    public int getNumErrorsPropagatingMessages() {
        return this.numErrorsPropagatingMessages;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SrdiHandlerMetric) {
            SrdiHandlerMetric otherSrdiHandlerMetric = (SrdiHandlerMetric)obj;
            return this.handlerName.equals(otherSrdiHandlerMetric.handlerName);
        }
        return false;
    }

    public int hashCode() {
        return this.handlerName.hashCode();
    }

    public void messageProcessed(long processTime) {
        ++this.numProcessed;
        this.totalProcessTime += processTime;
    }

    public void errorWhileProcessing() {
        ++this.numErrorsWhileProcessing;
    }

    public void srdiToUnregisteredHandler() {
        ++this.numToUnregisteredHandler;
    }

    public void messageSentViaWalker() {
        ++this.numMessagesSentViaWalker;
    }

    public void messageSentViaUnicast() {
        ++this.numMessagesSentViaUnicast;
    }

    public void errorSendingMessage() {
        ++this.numErrorsSendingMessages;
    }

    public void errorPropagatingMessage() {
        ++this.numErrorsPropagatingMessages;
    }

    SrdiDestinationMetric getSrdiDestinationMetric(EndpointAddress endpointAddress) {
        PeerID peerID = MetricUtilities.getPeerIdFromEndpointAddress(endpointAddress);
        return this.getSrdiDestinationMetric(peerID);
    }

    SrdiDestinationMetric getSrdiDestinationMetric(PeerID peerID) {
        SrdiDestinationMetric destinationMetric = (SrdiDestinationMetric)this.destinationMetrics.get(peerID);
        if (destinationMetric == null) {
            destinationMetric = new SrdiDestinationMetric(peerID);
            this.destinationMetrics.put(peerID, destinationMetric);
        }
        return destinationMetric;
    }

    public Iterator getDestinationMetrics() {
        return this.destinationMetrics.values().iterator();
    }

    public void addSrdiDestinationMetric(SrdiDestinationMetric srdiDestinationMetric) {
        this.destinationMetrics.put(srdiDestinationMetric.getPeerID(), srdiDestinationMetric);
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.handlerName != null) {
            DocumentSerializableUtilities.addString(element2, "handlerName", this.handlerName);
        }
        DocumentSerializableUtilities.addBoolean(element2, "registered", this.registered);
        if (this.numProcessed != 0) {
            DocumentSerializableUtilities.addInt(element2, "numProcessed", this.numProcessed);
        }
        if (this.numErrorsWhileProcessing != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsWhileProcessing", this.numErrorsWhileProcessing);
        }
        if (this.numToUnregisteredHandler != 0) {
            DocumentSerializableUtilities.addInt(element2, "numToUnregisteredHandler", this.numToUnregisteredHandler);
        }
        if (this.totalProcessTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "totalProcessTime", this.totalProcessTime);
        }
        if (this.numMessagesSentViaWalker != 0) {
            DocumentSerializableUtilities.addInt(element2, "numMessagesSentViaWalker", this.numMessagesSentViaWalker);
        }
        if (this.numMessagesSentViaUnicast != 0) {
            DocumentSerializableUtilities.addInt(element2, "numMessagesSentViaUnicast", this.numMessagesSentViaUnicast);
        }
        if (this.numErrorsSendingMessages != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsSendingMessages", this.numErrorsSendingMessages);
        }
        if (this.numErrorsPropagatingMessages != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsPropagatingMessages", this.numErrorsPropagatingMessages);
        }
        Iterator i = this.destinationMetrics.values().iterator();
        while (i.hasNext()) {
            Element srdiDestinationElement = DocumentSerializableUtilities.createChildElement(element2, "destination");
            SrdiDestinationMetric srdiDestinationMetric = (SrdiDestinationMetric)i.next();
            srdiDestinationMetric.serializeTo(srdiDestinationElement);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("handlerName")) {
                this.handlerName = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("registered")) {
                this.registered = DocumentSerializableUtilities.getBoolean(childElement);
                continue;
            }
            if (tagName.equals("numProcessed")) {
                this.numProcessed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsWhileProcessing")) {
                this.numErrorsWhileProcessing = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numToUnregisteredHandler")) {
                this.numToUnregisteredHandler = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("totalProcessTime")) {
                this.totalProcessTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numMessagesSentViaWalker")) {
                this.numMessagesSentViaWalker = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numMessagesSentViaUnicast")) {
                this.numMessagesSentViaUnicast = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsSendingMessages")) {
                this.numErrorsSendingMessages = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsPropagatingMessages")) {
                this.numErrorsPropagatingMessages = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("destination")) continue;
            SrdiDestinationMetric srdiDestinationMetric = new SrdiDestinationMetric();
            srdiDestinationMetric.initializeFrom(childElement);
            this.addSrdiDestinationMetric(srdiDestinationMetric);
        }
    }

    public void mergeMetrics(SrdiHandlerMetric otherSrdiHandlerMetric) {
        this.numProcessed += otherSrdiHandlerMetric.numProcessed;
        this.numErrorsWhileProcessing += otherSrdiHandlerMetric.numErrorsWhileProcessing;
        this.totalProcessTime += otherSrdiHandlerMetric.totalProcessTime;
        this.numMessagesSentViaWalker += otherSrdiHandlerMetric.numMessagesSentViaWalker;
        this.numMessagesSentViaUnicast += otherSrdiHandlerMetric.numMessagesSentViaUnicast;
        this.numErrorsSendingMessages += otherSrdiHandlerMetric.numErrorsSendingMessages;
        this.numErrorsPropagatingMessages += otherSrdiHandlerMetric.numErrorsPropagatingMessages;
        Iterator i = otherSrdiHandlerMetric.getDestinationMetrics();
        while (i.hasNext()) {
            SrdiDestinationMetric otherSrdiDestinationMetric = (SrdiDestinationMetric)i.next();
            SrdiDestinationMetric ourSrdiDestinationMetric = this.getSrdiDestinationMetric(otherSrdiDestinationMetric.getPeerID());
            if (ourSrdiDestinationMetric == null) {
                ourSrdiDestinationMetric = new SrdiDestinationMetric(otherSrdiDestinationMetric);
                this.addSrdiDestinationMetric(ourSrdiDestinationMetric);
            }
            ourSrdiDestinationMetric.mergeMetrics(otherSrdiDestinationMetric);
        }
    }
}

